;; this script creates aliases with replace the following commands:
;; LU, LCh and LG, finger, version, time, userinfo, clientinfo.
;; /lu - list people in current channel
;; /lg - list channels on all servers
;; /lch - list all channels on the window (just the names)
;; finger, version, time, userinfo, clientinfo
(gs-exec "/alias lu (_lu $_)")
(define (_lu w)
  (define ch (gs-current-channel w))
  (gs-echo 
    (if ch
       (let loop ((i 0)(u (gs-channel-users ch w))
                (res (string-append "@v@fUsers on " ch "@!v")))
            (if(null? u)
              res
              (loop (1+ i) (cdr u) (display2string res "\n@f" i ". "
                  (caar u) "\t\t@$" (cadr (car u))
                    " @!$@\t@$"  (caddr (car u)) "@!$"))))
       "@C1@f***@!C lch: No channel on this window")
       w))

(gs-exec "/alias lg (_lg $_)")
(define (_lg w)
  (gs-echo
    (let loop ((i 0)(ch (gs-server-channels))
              (res (string-append "@v@fGlobal channel list@!v")))
      (if(null? ch)
        res
        (loop (1+ i) (cdr ch)
              (display2string res "\n@f" i ". " (caar ch) "\t\t@!v" (cadr(car ch))
              "\t[" (caddr(car ch)) "]"))))
    w))

(gs-exec "/alias lch (_lch $_)")
(define (_lch w)
  (gs-echo
    (let loop ((i 0)(ch (gs-window-channels w))
              (res (string-append "@v@fChannels on this window@!v")))
      (if(null? ch)
        res
        (loop (1+ i) (cdr ch)
              (display2string res "\n@f" i ". " (cadr(car ch)))))) w))
(gs-exec "/alias version /ctcp $1 VERSION")
(gs-exec "/alias finger /ctcp $1 FINGER")
(gs-exec "/alias clientinfo /ctcp $1 CLIENTINFO")
(gs-exec "/alias userinfo /ctcp $1 USERINFO")
(gs-exec "/alias time /ctcp $1 TIME")

