#!
A fast and Smart AutoReplAcement, soon to be Spellchecker/...
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
(c) Tano Fotang 1999
No warranty, none none. See the GNU GPL as always.

This script tries to replace words as you type them with other
words stored in a dictionary which is a hash table. It is very fast.
This is the first stage. Type /help replace for some help.

See doc/skriptx.html for iedas about a graphical setup and other cool things.
The key bindings listed below are employed.
NOTE: I am using a keyboard with german layout and need the shift-key to get right
perenthesis, semicolon and left parenthesis. Please remove the 'shift' 
key from the key bindings if your keyboard doesnt require it.

(bind-key "space" look-up-word)
(bind-key "period" look-up-word)            '.'
(bind-key "shift+parenleft" look-up-word)   '('
(bind-key "shift+parenright" look-up-word)  ')'
(bind-key "shift+semicolon" look-up-word)   ';'
(bind-key "shift+question" look-up-word)    '?'
(bind-key "shift+exclam" look-up-word)      '!'
(bind-key "comma" look-up-word)             ','

(bind-key "Return" (lambda(w k s)....))
(bind-key "BackSpace" look-up-deleted)
(bind-key "Delete" look-up-erased)

fotang@techie.com.
!#

; the dictonary. Let it be global so we can use
; hash functions on it from outside.
(define _RDict (make-vector 2))
(let*((active? #t)(char-test? (lambda(c) (or(char-whitespace? c)
        (member c '(#\. #\, #\; #\( #\) #\?)))))
      (left-start (lambda(inp cur)  (let loop((i cur))
         (cond
               ((= 0 i) i)
               ((char-test? (string-ref inp (1- i))) i)
               (else (loop (1- i)))))))
      (right-stop(lambda(inp start len) (let loop((i start))
        (cond
          ((= i len) i)
          ((char-test? (string-ref inp i)) i)
          (else (loop (1+ i)))))))
      (look-up-word (lambda(w k s)
        (if(not active?)
          #f
          (call-with-current-continuation(lambda(return)
            (let((cur (gs-get-input-cursorpos w))(inp #f))
            (if(= 0 cur)(return #f))
            (set! inp (gs-get-input w))
            (if(not(char-test? (string-ref inp (1- cur))))  (let*
              ((start (left-start inp cur));; left start pos
              (end (right-stop inp cur (string-length inp))); right end pos (if cursor not at EOL)
              (word1 (make-shared-substring inp start cur))
              (word2 #f)
              (got1 #f)(got2 #f))
              (if(not(string-null? word1)) (set! got1 (hash-ref _RDict word1)))
              (set! word2 (make-shared-substring inp cur end))
              (if(not(string-null? word2)) (set! got2 (hash-ref _RDict word2)))
              (if(or got1 got2); if we got a replacement
                (let((result (string-append
                                (make-shared-substring inp 0 start)
                                (if got1  got1 word1)
                                (if got2 got2 word2)
                                (make-shared-substring inp end))))
                   (set! cur (+ start  (string-length (if got1 got1 word1))))
                   (gs-set-input result w)
                   (gs-set-input-cursorpos cur w))))))
             (return #f))))))

      (look-up-deleted (lambda(w k s)
        (if(not active?)
          #f
          (call-with-current-continuation(lambda(return)
            (let((cur (gs-get-input-cursorpos w))(inp #f))
            (if(= 0 cur)(return #f))
            (set! inp (gs-get-input w))
            (if(not(char-test? (string-ref inp (1- cur))))  (let*
              ((start (left-start inp (1- cur)))
              (end (right-stop inp cur (string-length inp)))
              (word (string-append (make-shared-substring inp start (1- cur))
                                   (make-shared-substring inp cur end)))
              (got1 #f))
              (if(not(string-null? word)) (set! got1 (hash-ref _RDict word)))
              (if got1
                (let((result (string-append (make-shared-substring inp 0 start)
                        got1 (make-shared-substring inp end))))
                  (gs-set-input result w)
                  (gs-set-input-cursorpos (+ start  (string-length got1)) w)
                  (return #t)))))
              (return #f)))))))
      (look-up-erased (lambda(w k s)
        (if(not active?) #f
          (call-with-current-continuation(lambda(return)
            (let*((cur (gs-get-input-cursorpos w))
            (inp (gs-get-input w))
            (len (string-length inp)))
            (if(or(= len cur) (char-test? (string-ref inp cur)))
              (return #f)
              (let*((start (left-start inp cur))(word1 (make-shared-substring inp start cur))
                (end (right-stop inp (1+ cur) len))(word2 (make-shared-substring inp (1+ cur) end))
                (word (string-append word1 word2))(got1 #f))
                (if(not(string-null? word)) (set! got1 (hash-ref _RDict word)))
                (if got1
                  (let((result (string-append
                        (make-shared-substring inp 0 start)
                        got1
                        (make-shared-substring inp end))))
                    (set! cur (+ start  (string-length got1)))
                    (gs-set-input result w)
                    (gs-set-input-cursorpos cur w)
                    (return #t)))))
             (return #f))))))))

;;The command REPLACE
  (gs-new-command "replace" "add new entry to SARA" (lambda(m w)
    (let((key (next-word m 1)))
      (cond
        ((string-null? key) #f)
        ((string-ci=? "-help" key)(_say w
"@C6@m@f_____________________________________________@!f
\tUsage:
\t@b@D15/replace@!b @iword @!i[@isubstitute@!i]@!D
\twhere @isubstitute@!i will replace @iword@!i whenever the latter occurs.
\tIf @isubstitute@!i is not given then @iword@!i will always be removed.
\t@b@D15/replace@!b -@iword@!i@!D
\tremoves @iword@!i from the dictionary.
\t@b@D15/set sara@!b [@ion@!i|@ioff@!i|@itoggle@!i]@!D
\tenables or disables autoreplacement.

\tYou may also add entries using Guile hash table routines.
\tThat is of course recommended. The name of the hash table is
\t@b@f_RDict@!f@!b. So, to add a new entry or to remove one, use
\t(@f@bhash-set! _RDict@!b@!f @iword replacement@!i)
\t(@f@bhash-remove! _RDict@!b@!f @iword@!i)
\trespectively.
@f---------------------------------------------"))

        ((equal? (string-ref key 0) #\-)
          (if(> (string-length key) 1)(hash-remove! _RDict (substring key 1))))
        (else(hash-set! _RDict key (string-rest m 2)))))))

  (gs-new-variable 'boolean "sara" (lambda(foo val bar)(set! active? val)))
  (gs-set! "sara" active?)
  ; put some common values in the dictionary:
  (for-each (lambda(v) (hash-set! _RDict (car v) (cadr v)))
    (list '("r" "are") '("u" "you") '("teh" "the") '("tis" "it is")
         '("prog" "program") '("rh" "Red Hat") '("distro" "distribution")
         '("slack" "Slackware") '("deb" "Debian") '("spx" "Sula PrimeriX")))

  (bind-key "space" look-up-word)
  (bind-key "period" look-up-word)
  (bind-key "shift+parenright" look-up-word)
  (bind-key "shift+parenleft" look-up-word)
  (bind-key "shift+semicolon" look-up-word)
  (bind-key "comma" look-up-word)
  (bind-key "shift+question" look-up-word)
  (bind-key "shift+exclam" look-up-word)
  (bind-key "Return" (lambda(w k s)
    (define len (string-length(gs-get-input w)))
    (if(not(= len (gs-get-input-cursorpos w)))
      (gs-set-input-cursorpos len w))
    (look-up-word w k s))
    #f)
  (bind-key "BackSpace" look-up-deleted)
  (bind-key "Delete" look-up-erased)
  (if(> 10 (modulo (gs-srandom) 200))(sx-dialog-new #f #f #f SX_TITLE "SPX II Smart AutoReplAcer"
  SX_PIXMAP "!(:-)"
  SX_LABEL"(C) Tano Fotang 1999\nScript has been successfully loaded. Feel free to extend.
Type '/help replace' for info.
Edit script to prevent this window from appearing.")))

;EOF
