#!
Last corrected 24Aug99 for Guile 1.3.3.
Modified to display list using SkriptX: /addnick -list.
(This script was inspired by a tabkey script from ircii. However,
the power of Scheme is in effect.)

This keeps track of the nicks of people who send certain kinds
of messages to you, or to whom you send such messages. By default
senders or receipiants(sp) of the following message types are saved:
  -private messages
  -dcc chat messages
  -notices (receive only).
You can then just hit the tab key to flip through the list of nick-
names.
The list is stored in the global variable Tab-names.

====================================================
Ctrl-r navigates thru the list backwards
Ctrl-x removes the currently displayed name from the list.
/addnick <nick> adds nick to list
/help addnick displays help on usage (however terse!)
/addnick -list displays the names currently in the tab list
====================================================
!#

(define Tab-names '());; the global list holding the nicks
;; -- create command /addnick. Alternatively, use an alias. --
(gs-new-command "addnick" "add a name to the TAB list" (lambda(str window)
  (define nick (next-word str 1))
  (if (not(string-null? nick))
    (cond
      ((string-ci=? "-help" nick)
        (gs-echo "Usage:
@f        /addnick <nick>  - add nick to the tablist
@f        /addnick -l   - display list" window))
      ((string-ci=? "-l" nick)
      ;popup a window with the list
        (sx-dialog-new #f (lambda(d l)(let loop((n l))
              (if(not(null? n))(begin
                 (set! Tab-names (delete (car n) Tab-names))
                 (loop (cdr n))))))
          #f
          SX_TITLE (string-append (gs-client-name) ": TAB names")
          SX_LABEL "The following names are currently in the tablist.
Choose to remove.\n"
          SX_SLIST "" Tab-names 50 20))
      (else (gs-echo (string-append nick (if(add-to-tab-nicks nick)
          " has been added to nick list" " is already in the list")) window 1)))
    (gs-echo "addnick uh?" window 1))));; fall-through
;; -- End of command /addnick ---
;; -- Procedure to add a nick to the Tab list --
(define (add-to-tab-nicks nick)
  (define (in_list? name List) ;if name is already in the list. O(n). hash table?
    (let repeat ((l List))
      (if(null? l) #f
        (if (string-ci=? name (car l)) (car l)
          (repeat (cdr l))))))
  ;;new names are added to the start of the list.
  ;;if the first name in the list is the one we want to add, quit.
  ;;if name is soemwhere else in the list, just move it to the head.
  (if(and(not(null? Tab-names))(string=? nick (car Tab-names)))
    #f
    (let((old_name (in_list? nick Tab-names)))
      (if old_name (set! Tab-names (delete old_name Tab-names)))
      (set! Tab-names (cons nick Tab-names))
      #t)));
;; -- End of add-to-tab-nicks --      
;; -- set hooks and key bindings;also display some intro text
(let* ((current-nick-pos 0)
  (grab-nick (lambda (str w)
    (add-to-tab-nicks (sender2nick (next-word str 1)))))
  (tab.get-nick (lambda(win forward?)
    (define cmd " msg ")
    (string-set! cmd 0 (gs-set? 'cmdchar)) ;; append command character, usually '/'
    (if(null? Tab-names)
      (gs-set-input cmd win)
      (begin
        (gs-set-input (string-append cmd (list-ref Tab-names
             current-nick-pos) " ") win)
        (set! current-nick-pos (+ current-nick-pos (if forward? 1 -1)))
        (if (>= current-nick-pos (length Tab-names))
          (set! current-nick-pos 0))
        (if (< current-nick-pos 0)
          (set! current-nick-pos (- (length Tab-names) 1)))
        ))
     #t)))
  ; Catch outgoing and incoming nicknames
  (gs-add-hook "#private_msg" 500 "*" grab-nick);
  (gs-add-hook "#private_notice" 500 '* grab-nick);
  (gs-add-hook "#SEND_PRIVATE_MSG" 500 '* (lambda(str w)
    (set! current-nick-pos 0)
    (add-to-tab-nicks (next-word str 1))))
  (gs-add-hook "#DCC_CHAT_MSG" 500 '* (lambda(str w)
    (add-to-tab-nicks (string-append "=" (next-word str 1)))))
  (gs-add-hook "#send_chatmsg" 500 '* (lambda(str w)
    (set! current-nick-pos 0)
    (add-to-tab-nicks (string-append "=" (next-word str 1)))))

  ; Bind key sequences
  (bind-key "Tab" (lambda(win key state)
    (tab.get-nick win #t)))
  (bind-key "Ctrl+r" (lambda(win key state)
    (tab.get-nick win #f)))
  (bind-key "Ctrl+x" (lambda(win key state)
    ;; input line contains /msg foo ..., /msg =foo blabla, /notice foo  ...
    ;; ctrl-x removes the nick from the Tablist.
    (call-with-current-continuation (lambda(return)
      (define name (gs-get-input win))
      (if(= 0 (string-length name)) (return #t))
      (if(not(equal? (gs-set? 'cmdchar) (string-ref name 0)))
        (begin (gs-bell 50)(return #t)));;must be /cmd <nick>
      (set! name (next-word name 1))
      (if(= 0 (string-length name)) (begin (gs-bell)(return #t)))
      (set! Tab-names (delete name Tab-names))
      (if(> current-nick-pos 0)(set! current-nick-pos (1- current-nick-pos)))
      (return #t)))))
  (gs-echo
"@f@C6@D4Tabkey script loaded. 99/08/24. Type '/help addnick' for info.
  @C5TAB@C7\t\tflips thru nick list.
  @C5Ctrl+r@C7\tnavigate thru list in reverse.
  @C5Ctrl+x@C7\tdeletes currently displayed nick from the list.
  @b/addnick@!b @!f@inick@!i@f adds @!f@inick@!i@f to tablist. Or (add-to-tab-nicks <nick>).
  @b/addnick@!b -l displays the list"))
;EOF
