;;last changed 25aug99
;; Command /WHEN
;; tells you when you connected to a server

(gs-new-command "when" "say when you connected to a server" (lambda(m w)
  (call-with-current-continuation (lambda(return)
    (define server (gs-window-server w))
    (define arg (next-word m 1))
    (if(and (not(string-null? arg)) (string-ci=? "-help" arg)) ;; /help when
      (begin
        (gs-echo "No help available for WHEN" w 1)
        (return #t)))
    (if(or (null? server) (not(server:connected? server)))
      (begin
        (gs-bell)
        (gs-echo "WHEN: no server connection" w 1)
        (return #f)))
    (gs-echo (string-append "@iYou connected to " (server:alias server) " on "
       (strftime "%a %b %d %H:%M:%S %Y." (localtime (server:start-time server))))
       w 1)
    (_say2 w "@iThat was " (- (current-time) (server:start-time
        server)) " seconds ago.")))))  
  
    
