
#!
These are examples of how to define items that appear when the
3rd mouse button is pressed in a channel window.
!#
;; Examples

(sx-submit "/My Box/Server/Request MOTD" "_motd")
(define (_motd window p) (gs-exec "/motd" window))
; mark us away...
(sx-submit
  "/My Box/Mark away"
  "_away"
  SX_STRING "Away message: " "be right back..")
(define (_away w p msg) (gs-execute w  "/away " msg))

; change channel topic. current channel if none given.
(sx-submit "/My Box/Channel/change topic" "_topic"
  SX_TITLE (string-append (gs-client-name) ": Channel topic")
  SX_STRING "Channel " "*"
  SX_STRING "New topic " "")  
(define (_topic w p channel new_topic)
  (if(null? (gs-window-server2 w))
    (gs-bell)
    (begin
      (if(string-null? channel)
        (set! channel (gs-current-channel w)))
      (if channel
        (gs-execute w "/TOPIC " channel " " new_topic)))))

(sx-submit
  "/My Box/Server/Signoff"
  "_signoff"
	SX_TITLE "SPX II: Quit IRC"
  SX_STRING "Signoff\nmessage:" "$X signing off")
(define (_signoff w p msg)
	(gs-execute w "/quit " msg))
;this next oone for spxII 0.9.2+ (option  -reconnect)
(sx-submit
  "/My Box/Server/Reconnect to server" "_reconnect")
(define (_reconnect w p)(gs-execute w "/server -reconnect"))

(sx-submit "/My Box/User modes" "_my_mode"
  SX_TOGGLE "Invisible"       #t
  SX_TOGGLE "Server messages" #t
  SX_TOGGLE "Restricted"      #t
  SX_TOGGLE "Receive wallops"  #f
  SX_TOGGLE "IRC Oper"         #f
  )
(define (_my_mode win path i s r w o)
  (let((mode ""))
    (set! mode (string-append mode (if i "+i" "-i")))
    (set! mode (string-append mode (if s "+s" "-s")))
    (set! mode (string-append mode (if r "+r" "-r")))
    (set! mode (string-append mode (if i "+w" "-w")))
    (set! mode (string-append mode (if o "+o" "-o")))
    (gs-execute win "/eval /mode $N " mode)))

(sx-submit "/My Box/Channel/Set limit"
   "_limit"
   SX_STRING "Channel name:" "*"
   SX_NUMBER "Limit" 32)
(define (_limit w path channel n)
  (if(null? (gs-window-server2 w));;not connected to a server
    (gs-bell)
    (begin
      (if(string-null? channel);; no channel name given
        (set! channel (gs-current-channel w)));; use current channel
      (if channel
        (gs-execute w "/mode " channel " +l " n)))))
;EOF
