/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


// Config.c	-preliminary config file for sula


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/utsname.h>
#include <pwd.h>
#include <errno.h>

#define CONFIG		"../include/config.h"

int
main (int argc, char **argv)
{
  struct utsname ut;
  struct passwd *pwd;
  FILE *fp;
  char *config = CONFIG;
  char *buf;
  char *p_utmp[] =
  {"/var/run/utmp", "/var/adm/utmp", "/var/log/utmp", "/etc/utmp", NULL};


  if (access (config, F_OK) > -1)
    {
      char buf[256];
      if (access (config, W_OK) < 0)
	{
	  fprintf (stderr, "[config error] %s: %s\n", config, strerror (errno));
	  exit (-1);
	}
      sprintf (buf, "%s.bak", config);
      rename (config, buf);
    }

  fp = fopen (config, "w");
  if (fp == NULL)
    {
      fprintf (stderr, "[config error] %s: %s\n", config, strerror (errno));
      exit (-1);
    }
  fprintf (fp, "\n/*	%s for sula.\n\tgenerated on %s, %s\n*/\n\n", config, __DATE__, __TIME__);
  fputs ("#ifndef _sula_config_h\n", fp);
  fputs ("#define _sula_config_h\n", fp);
  fputs ("\n\n", fp);
  pwd = getpwuid (getuid ());
  if (pwd)
    fprintf (fp, "#define sula_COMPILED\t\t\"%s (%s)\"\n", pwd->pw_name, pwd->pw_gecos);
  else
    fprintf (fp, "#define sula_COMPILED\t\t\"<unknown>(<unknown>)\"\n");
  buf = getenv ("HOSTNAME");
  fprintf (fp, "#define sula_HOST\t\t\"%s\"\n", buf ? buf : "<unknown host>");
  if (!uname (&ut))
    fprintf (fp, "#define sula_OS		\t\"%s %s\"\n", ut.sysname, ut.release);
  else
    fprintf (fp, "#define sula_OS	\t\t\"<unknown OS>\"\n");

  buf = *p_utmp;
  while (buf)
    if (access (buf, F_OK) > -1)
      {
	fprintf (fp, "#define UTMP	\t\t\"%s\"\n", buf);
	break;
      }
    else
      buf++;

  fputs ("\n#define DEFAULT_PORT            6667\n\n", fp);
  fputs ("#define P_IGNORE                \"sula_ignore\"\n", fp);
  fputs ("#define P_HISTORY               \".sula_history\"\n", fp);
  fputs ("#define P_CONSOLE_HISTORY       \".sula_console_history\"\n", fp);
  fputs ("#define P_SERVERS               \"sula_servers\"\n", fp);
  fputs ("#define P_NICKNAMES             \"sula_nicknames\"\n",fp);
  fputs ("#define P_NOTIFY                \"sula_notify\"\n",fp);

  fputs ("\n\n", fp);
  fputs ("#endif", fp);
  fclose (fp);
  return 0;
}
