/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


#ifndef _SULA_c
#define _SULA_c
extern void AddTomainHistory(const char *s)
{
  static char *cur_text = NULL;

  if (!cur_text || strcmp(cur_text, s))
  {

    History *p = (History *) my_malloc(sizeof(History));

    free(cur_text);
    cur_text = strdup(s);
    p->line = strdup(s);
    p->left = mainhistCur;
    p->right = mainhistCur->right;
    mainhistCur->right->left = p;
    mainhistCur->right = p;

//  mainHistSize += ;
  }
}

static void quit_main(int yes
#if USE_GTK
                      ,void *junk
#endif
)
{
  static char exiting = 0;

  if (exiting)
    return;

#if USE_XFORMS
  if (fl_mouse_button() == FL_MIDDLEMOUSE)
  {
    exiting = 1;
    if (!check_msg_hook(EXIT, -1, ""))
    {
      fl_finish();
      exit(0);
    }
    else
      exiting = 0;
  }
  else
#endif
  {
#if USE_XFORMS
    fl_deactivate_all_forms();
    if (!confirm(servFdTree ? "Quit IRC?" : "Shut down client?",
                 sula_NAME " " sula_VERSION ": Confirm exit", 7))
    {
      /* 7 seconds to comply */
      fl_activate_all_forms();
      return;
    }
    else
#else
    if (yes)
#endif
    {
      int res;

      exiting = 1;              /* prevents infinite loop. we may back in */
      res = check_msg_hook(EXIT, -1, "");
      if (!res)
      {
        cleanup();
        exit(0);
      }
      else
      {
        exiting = 0;
#if USE_XFORMS
        fl_activate_all_forms();
#endif
      }
    }
  }
}

static void main_input_cb(SPX_OBJ(ob), SPX_DATA(data))
{
  char *s = (char *) spx_get_input(ob);
#if _GUILE
  if (*s == 0)
    return;
#endif
  AddTomainHistory(s);
#if USE_XFORMS
  main_window->FwdHist->u_ldata = (long) 0;
#else
  gtk_object_set_user_data(GTK_OBJECT(main_window->FwdHist), 0);
#endif
#if _GUILE
  {
    static char *tmp_buf = 0;
    static int n = 0;
    register char *p = s;

    while (*p)
    {
      if (*p == '(')
        n++;
      else if (*p == ')')
        n--;
      p++;
    }
    if (tmp_buf || n > 0)
    {
      if (tmp_buf)
      {
        if (n > 0)
          spx_write0(main_window->browser, "\n\t");
        else
          spx_write0(main_window->browser, "\n");
      }
      else
        spx_write0(main_window->browser, "\n" PROMPT);
      if (tmp_buf)
      {
        size_t ll = strlen(tmp_buf) - 1;
        tmp_buf = my_realloc(tmp_buf, (sizeof(char) * (ll + (p - s) + 3)));

        if (tmp_buf[ll] != ')' && tmp_buf[ll] != '(' &&
            !(isspace(tmp_buf[ll])))
          strcat(tmp_buf, " ");
      }
      else
      {
        tmp_buf = my_malloc(sizeof(char) * (p - s + 2));
        *tmp_buf = 0;
      }
      strcat(tmp_buf, s);
      spx_write0(main_window->browser, s);
      if (n > 0)
      {
        spx_set_input(ob, "");
        return;
      }
    }
    n = 0;
    spx_set_input(ob, "");
    if (tmp_buf)
    {
      parse_scheme(tmp_buf, -1);
      free(tmp_buf);
      tmp_buf = 0;
    }
    else
    {
      char *buf = strdup(s);
      if (sflags & sECHO_INPUT)
      {
        spx_write0(main_window->browser, "\n" PROMPT);
        spx_write0(main_window->browser, buf);
      }
      parse_scheme(buf, -1);
      free(buf);
    }
  }
#else
#if !USE_XFORMS
  spx_write(main_window->browser, "\n");
#endif
  spx_write(main_window->browser, s);
  spx_set_input(ob, "");
#endif

}

static void main_History_cb(SPX_OBJ(ob), SPX_DATA(data))
{
  History *hist = (History *)
#if USE_XFORMS
  main_window->FwdHist->u_ldata;

#else
  gtk_object_get_user_data(GTK_OBJECT(main_window->FwdHist));

#endif
  if ((long) data == 31)
  {                             /* HistRew */
    if (hist == NULL)
      hist = mainhistCur;
    else
      hist = hist->left;
    if (hist == mainhistStart)
      hist = hist->left;
#if USE_XFORMS
    main_window->FwdHist->u_ldata = (long) hist;
#else
    gtk_object_set_user_data(GTK_OBJECT(main_window->FwdHist), hist);
#endif
    if (hist != mainhistStart)
      spx_set_input(main_window->main_input, hist->line);
  }
  else
  {
    if (hist == NULL)
      hist = mainhistCur;
    else
      hist = hist->right;
    if (hist == mainhistStart)
      hist = hist->right;
#if USE_XFORMS
    main_window->FwdHist->u_ldata = (long) hist;
#else
    gtk_object_set_user_data(GTK_OBJECT(main_window->FwdHist), hist);
#endif
    if (hist != mainhistStart)
      spx_set_input(main_window->main_input, hist->line);
  }
}
#endif
