/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/

/*
 *   cmd.c  - client commands. more in cmd_defs.c
 *
 *  Author: Tano Fotang, 1997-1999
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free 
 *  Software Foundation; either version 2 of the License , or (at your option) 
 *  any later version.
 *  See the file COPYING for details.
 *
 */
#include "config.h"
#include "spx.h"
#include <ctype.h>
// some of the included files should go. cant figure out which
#include "parser.h"
#include "nicks.h"
#include "server.h"
#include "setting.h"
#include "dcc.h"
#include "cmd.h"
#include "cmd_def.h"
#include "help.h"
#include "flood.h"
#include "timer.h"
#include "nc.h"
#include "hooks.h"
#include "userhost.h"
#include "ignore.h"
#include "notify.h"
CmdOnCon *cmdonconStart, *cmdonconEnd;
char cmdchar;
char *line_break;
extern Script_control *script_form;
Cmd *bi_cmdTree = NULL,
   *fd_cmdTree = NULL, *scm_cmdTree = NULL, *alias_cmdTree = NULL;
short count_bi_cmds = 0,

   count_fd_cmds = 0, count_scm_cmds = 0, count_alias = 0;
Cmd *ctcp_cmdTree = NULL;
short count_ctcp_cmds = 0;
extern void set_variable(const char *, Winstruct *);

#define connected(win) ((win) && (win)->server && (win)->server->fd >-1)
#define iconnected(_w) (!win_invalid(_w) && winstruct[_w].server && winstruct[_w].server->fd>-1)
static int argc;

/*
 *      The EXEC command.
 *      Usage:
 *              exec [-cmd arg --] syscmd
 *      E.g.
 *      exec -msg xtr -- ls -l *.scm
 *      exec -notice * -- w
 *      exec who
 */

typedef struct
{
  int fd;
  short w;                      /* window */
  char *action;
} Exec_info;

#if USE_XFORMS
static void exec_cb(int fd, void *data)
#else
static void exec_cb(gpointer data, gint fd, GdkInputCondition junk)
#endif
{
  int n;

#define EXEC_RD_BUF 1024
  char buf[EXEC_RD_BUF + 1];
  Exec_info *xi = (Exec_info *) data;

  n = read(fd, buf, EXEC_RD_BUF);
  if (n <= 0)
  {
    if (n < 0 && errno == EAGAIN)
      return;
    spx_remove_io_callback(fd, SPX_READ, exec_cb);
    close(fd);
    if (xi->action)
      free(xi->action);
    free(data);
    return;
  }
  else
  {
    buf[n--] = 0;
    if (buf[n] == '\n')
      buf[n] = 0;
    if (!xi->action)
    {
      say0(buf, xi->w, 0);
    }
    else
    {
      char *str;

      if (gflags & QUOTE_EXEC)
      {
        char *tmp = ctcp_quote_it(buf, n);
        str = my_malloc(sizeof(char) * (strlen(xi->action) +

                                        strlen(tmp) + 3));

        sprintf(str, "%s %s", xi->action, tmp);
        free(tmp);
        new_process_cmd(str, xi->w);
        free(str);
      }
      else
      {
        char *s, *ptr = &buf[0];

        s = strsep(&ptr, "\n");
        while (s)
        {
          str = my_malloc(sizeof(char) * (strlen(xi->action) +

                                          strlen(s) + 3));

          sprintf(str, "%s %s", xi->action, s);
          new_process_cmd(str, xi->w);
          free(str);
          s = strsep(&ptr, "\n");
        }
      }
    }
  }
}
#define exec_usage(w) \
do{say0 ("EXEC: /help exec for info.",(w),1); return;}while(0)

static void exec_cmd(CmdStruct * cs)
{
  char *args, *syscmd, *action;
  int fd[2], pid;

  args = alloca(sizeof(char) * strlen(cs->args));

#if 1
  strcpy(args, cs->args + find_pos(cs->args, 1));
  if (*args == 0)
#else
  if (sscanf(cs->args, "%*s %[^\n]", args) != 1)
#endif
    exec_usage(cs->w);
  action = NULL;
  if (*args == '-')
  {
    char *ptr;

    ptr = strstr(args, " -- ");
    if (ptr == NULL)
    {
      if (gflags & BEEP_ERR)
        spx_bell(0);
      exec_usage(cs->w);
    }
    syscmd = alloca(sizeof(char) * strlen(args));

    if (sscanf(ptr + 4, "%[^\n]", syscmd) < 1)
    {
      say0(PROMPT "EXEC: missing shell command", cs->w, -1);
      if (gflags & BEEP_ERR)
        spx_bell(0);
      return;
    }
    else
    {
      int n = ptr - args;
      action = alloca(sizeof(char) * (n + 1));

      strncpy(action, args, n);
      while (action[--n] == ' ')
        action[n] = 0;
      action[n + 1] = 0;
      strshift(action, 1);      // skip '-'

      if (*action == 0)
        action = NULL;
    }
  }
  else
    syscmd = args;
  if (socketpair(AF_UNIX, SOCK_STREAM, 0, fd) < 0)
  {
    error(ERR_SYS, "EXEC: socketpair error");
    return;
  }
  if ((pid = fork()) < 0)
  {
    error(ERR_SYS, "fork error");
    close(fd[0]);
    close(fd[1]);
    return;
  }
  if (pid > 0)
  {
    Exec_info *xi = malloc(sizeof(Exec_info));

    xi->action = action ? strdup(action) : NULL;
    xi->w = cs->w;
    close(fd[1]);
    spx_add_io_callback(fd[0], SPX_READ, exec_cb, xi);
  }
  else
  {
    char *argv[4];

    close(fd[0]);
    if (fd[1] != STDOUT_FILENO)
      if (dup2(fd[1], STDOUT_FILENO) != STDOUT_FILENO)
        goto cry;
    if (fd[1] != STDERR_FILENO)
      if (dup2(fd[1], STDERR_FILENO) != STDERR_FILENO)
        goto cry;

    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = syscmd;
    argv[3] = 0;
    execvp("/bin/sh", argv);
  cry:
    fprintf(stderr, "%s: %s\n", *argv, strerror(errno));
    _exit(-1);
  }
}

/* The ALIAS cmd */
static void list_alias(Cmd * p, short w)
{
  if (p)
  {
    list_alias(p->left, w);
    say2(1, w, 0, "@f@v@$%s\t:@!$@!v@.%s", p->name, p->cmd.text);
    list_alias(p->right, w);
  }
}
static void alias_cmd(CmdStruct * cs)
{
  char *args;

  args = alloca(sizeof(char) * strlen(cs->args));

  if (sscanf(cs->args, "%*s %[^\n]", args) != 1)
  {

    if (alias_cmdTree == NULL)
      say0(PROMPT "No aliases defined.", cs->w, 1);
    else
    {
      say(" @f@bAliases:", cs->w, 0);
      list_alias(alias_cmdTree, cs->w);
    }
    return;
  }
  else
  {
    char *name = nextword(args, 0);

    if (*name == '-')
    {
      strshift(name, 1);
      if (*name == 0)
      {
        if (gflags & BEEP_ERR)
          spx_bell(0);
        say0(PROMPT "ALIAS - : missing name", cs->w, 1);
      }
      else if (remove_alias(name))
        say2(0, cs->w, 1, PROMPT "%s: no such alias", name);
      free(name);
      return;
    }
    strcpy(args, cs->args + find_pos(cs->args, 2));
    if (*args == 0)
    {
      Cmd *a = find_alias(name, 0);

      if (a)
        say2(1, cs->w, 0, "alias @b@$%s:@!$@!b@. %s", a->name, a->cmd.text);
      else
        say2(0, cs->w, 1, PROMPT "%s: No such alias", name);
    }
    else
    {
      Cmd a;

      a.name = strdup(name);
      a.type = CMD_ALIAS;
      a.cmd.text = strdup(args);
      a.help = NULL;
      insert_alias(&a);
    }
    free(name);
  }
}

/*
   The EVAL command
   /eval /msg xtr Hello from $N using $X version $V!
   Bug:
     In "/alias omsg /eval /msg $C $1-", eval should *not* interprete
     $1-. It currently does.  As a result, "/omsg I got $200 here"
     sends the wrong text.
 */
static void eval_cmd(CmdStruct * cs)
{

  char *args;

  args = alloca(sizeof(char) * strlen(cs->args));

  strcpy(args, cs->args + find_pos(cs->args, 1));
  if (*args == 0)
    return;
  else
  {
    char *buf;

    buf = expand_quote(args, "", cs->w);
    if (buf)
    {
      new_process_cmd(buf, cs->w);
      free(buf);
    }
  }
}
/*
   The NOTIFY command
 */
static void notify_cmd(CmdStruct * cs)
{
  notify(cs->args, cs->w);
}

static void history_cmd(CmdStruct * cs)
{

  char *argv[12];

  new_str2args(cs->args, &argc, argv, 12);
  history(argc, argv, cs->w);
}
static void ignore_cmd(CmdStruct * cs)
{

  char *argv[MAXARGC];

  new_str2args(cs->args, &argc, argv, MAXARGC);
  ignore(argc, argv, cs->w);
}

static void invite_cmd(CmdStruct * cs)
{
  char *argv[MAXARGC];

  if (win_invalid(cs->w))
    return;
  new_str2args(cs->args, &argc, argv, MAXARGC);
  invite(argc, argv, cs->w);
}
static void part_cmd(CmdStruct * cs)
{

  char *argv[3];

  if (win_invalid(cs->w))
    return;
  new_str2args(cs->args, &argc, argv, 3);
  part(argc, argv, cs->w + winstruct);
}

static void topic_cmd(CmdStruct * cs)
{
/*
 * /topic -c[lear]  channel       - remove topic
 * /topic channel newtopic - set topic /topic
 * /topic - request for topic. * := current channel */
  char *channame = NULL, *buf;
  char *opt;
  Winstruct *win;
  char clear;

  if (!iconnected(cs->w))
    return;
  win = winstruct + cs->w;
  opt = nextword(cs->args, 1);
  clear=0;
  if (*opt == 0)
  {                             //  /topic 
    if (win->chanCur != win->chanStart)
    {
      buf = alloca(sizeof(char) *(strlen(win->chanCur->name) + 10));

      sprintf(buf, "TOPIC %s\n", win->chanCur->name);
      sendto_server(win, buf);
    }
    return;
  }
  if (!strcasecmp(opt, "-clear"))
  {
    channame = nextword(cs->args, 2);

    if (!(*channame))
    {
      if (win->chanCur == win->chanStart)
      {
        free(opt);
        return;
      }
      else
        channame = strdup(win->chanCur->name);
    }
    clear=1;
  }
  else channame=strdup(opt);
  free(opt);
  if (*channame == '*' && channame[1] == 0)
  {
    free(channame);
    if (win->chanCur == win->chanStart)
      return;
    channame = strdup(win->chanCur->name);
  }
  else if (*channame != '#' && *channame != '&')
  {
    opt = malloc(sizeof(char) * (strlen(channame) + 3));

    sprintf(opt, "#%s", channame);
    free(channame);
    channame=strdup(opt);
    free(opt);
  }
  if(clear){
     buf = alloca(sizeof(char) * (strlen(channame) + 12));
     sprintf(buf, "TOPIC %s :\n", channame);
  }
  else{
    opt= cs->args + find_pos(cs->args, 2);
    buf = alloca(sizeof(char) * (strlen(opt) + strlen(channame) + 12));
    if(*opt)
     sprintf(buf, "TOPIC %s :%s\n", channame,opt );
    else
     sprintf(buf, "TOPIC %s\n", channame);
  }
  sendto_server(win, buf);
  free(channame);
}

static void quit_cmd(CmdStruct * cs)
{
/*
 * /quit       :close connecton to server. /quit [<reason>]
 * /quit -f    :ignore all hooks set on SIGNOFF
 */

  if (!iconnected(cs->w))
  {
    if (gflags & BEEP_ERR)
      spx_bell(0);
    return;
  }
  else
  {
    char force = 0;
    int done;
    char *arg = nextword(cs->args, 1);
    Winstruct *win = winstruct + cs->w;

    done = 0;
    if (*arg)                   //  use </quit -f to really quit

      if (*arg == '-' && (arg[1] == 'f' || arg[1] == 'F') && arg[2] == 0)
      {
        done = 1;
        force = 1;
      }
    if (!done)
    {
      if (win->server->flag & QUITTING)
      {
        free(arg);
        return;
      }
      win->server->flag |= QUITTING;	// stop endless loop from hook handler

      done = !check_msg_hook(SIGNOFF, cs->w,
                             "%s,%d %s",
                             win->server->name,
                             win->server->port, win->server->nick);
    }
    free(arg);
    if (done)
    {
      char *tt;
      WinList *p;

      if (force)
        arg = cs->args + find_pos(cs->args, 2);
      else
        arg = cs->args + find_pos(cs->args, 1);
      if (*arg == 0)
        arg = quit_text;
      tt = expand_quote(arg, "", cs->w);
      if (tt)
      {
        char *buf = malloc(sizeof(char) * (12 + strlen(tt)));

        sprintf(buf, "QUIT :%s\n", tt);
        sendto_server(win, buf);
        free(buf);
        say2(1, cs->w, 0, "*** Signoff: %s", tt);
        free(tt);
      }
      else
        sendto_server(win, "QUIT\n");
      build_winlistbyfd(win->server->fd);
      p = servWin;
      while (p)
      {
        ClearWinChanList(winstruct + p->w);
        UpdateStatus(winstruct + p->w);
        p = p->next;
      }
      close_server_connection(win->server->g, &win->server->fd);
    }
    win->server->flag &= ~QUITTING;
  }
}
static void window_cmd(CmdStruct * cs)
{

  char *argv[MAXARGC];

  if (win_invalid(cs->w))
    return;
  new_str2args(cs->args, &argc, argv, MAXARGC);
  window(argc, argv, cs->w + winstruct);
}
static void empty_cmd(CmdStruct * cs)
{
  return;
}
/*
 * The quoted ON command
 */
static void on_cmd(CmdStruct * cs)
{
  char *cmd, *junk;

  junk = nextword(cs->args, 1);

  if (!*junk)
  {
    //hook_list(cs->win?cs->win->chanwin->browser:main_window->browser,
    //0,1);
    say0(PROMPT "currently can't list hooks", cs->w, 1);
    free(junk);
    return;
  }
  else
  {
    cmd = alloca(sizeof(char) * (1 + strlen(junk)));

    strcpy(cmd, junk);
  }
  free(junk);
  if (!strncasecmp(cmd, "-del", 4))
  {
    del_hook(cs->args + find_pos(cs->args, 2));
    return;
  }
  else
  {
    On w;
    char *tt, *tmp, *args = NULL, *str;
    int num = -1, pos = 3, n;

    str = cs->args;
    w.ser_number = 0;
#define s_error() \
		say("Unterminated \" or missing pattern or numeric", \
		cs->w,1)
    if (*cmd == '#')
    {
      pos = 4;
      n = sscanf(str, "%*s %*s %d", &w.ser_number);
      if (n < 1 || (*++cmd == '\0'))
      {
        s_error();
        return;
      }
    };
    w.flag = HK_IN;
    tmp = nextword(cs->args, 0);
    uppercase2(tmp);
    /* ONX, ONIX, ON */
#if REGEX_HOOKS
    /*ONX, ONIX */
    if ((tmp[2] == 'X' && tmp[3] == 0)
        || (tmp[2] == 'I' && tmp[3] == 'X' && tmp[4] == 0))
      w.flag |= HK_REGEX;
#endif
    if (tmp[2] == 0             /* ON */
#if REGEX_HOOKS
        || (tmp[2] == 'I' && tmp[3] == 'X' && tmp[4] == 0)	/*ONIX */
#endif
       )
      w.flag |= HK_ICASE;
    free(tmp);
    w.cmd.cmd = NULL;
    w.pattern = NULL;
    w.id = -1;
    tt = nextword(str, pos - 1);
    if (!*tt)
    {
      s_error();
      free(tt);
      return;
    }
    tmp = alloca(sizeof(char) * strlen(cs->args));
    args = alloca(sizeof(char) * strlen(cs->args));

    if (*tt == '"')
    {
      if (pos == 4)
        n = sscanf(str, "%*s %*s %*s \"%[^\"]\" %[^\n]\n", tmp, args);
      else
        n = sscanf(str, "%*s %*s \"%[^\"]\" %[^\n]\n", tmp, args);
    }
    else
    {

      if (pos == 4)
        n = sscanf(str, "%*s %*s %*s %s %[^\n]\n", tmp, args);
      else
        n = sscanf(str, "%*s %*s %s %[^\n]\n", tmp, args);

    }
    free(tt);
    if (n < 2)
    {
      s_error();
      return;
    }
    w.pattern = strdup(tmp);
    w.cmd.cmd = strdup(args);
    num = strtol(cmd, &tt, 0);
    if (*tt)
    {
      MsgNr type;

      type = get_type(cmd);
      if (type != INVALID)
      {
        add_hook(type, &w);
        if (script_form)
          list_hooks(1);
      }
      else
        say2(0, cs->w, 1, "Unknown message type:%s", cmd);
    }
    else if (!invalid_server_numeric(num))
    {
      add_numhook(num, &w);
      if (script_form)
        list_hooks(1);
    }
    else
      say2(0, cs->w, 1, "invalid numeric (%d)?", num);
    free(w.pattern);
    free(w.cmd.cmd);
  }
}

static void bell_cmd(CmdStruct * cs)
{
  char *arg = nextword(cs->args, 1);

  spx_bell(*arg ? atoi(arg) : 0);
  free(arg);
}
static void exit_cmd(CmdStruct * cs)
{
  char *arg;

  arg = nextword(cs->args, 1);
  if (*arg == 0)
  {
    if (main_window)
      TRIGGER_OBJECT(main_window->quit);
  }
  else if (*arg == '-' && (arg[1] == 'f' || arg[1] == 'F') && arg[2] == 0)
  {
#if USE_XFORMS
    fl_finish();
#endif
    exit(0);
  }
  free(arg);
}
static void lag_cmd(CmdStruct * cs)
{
  if (!win_invalid(cs->w))
    TRIGGER_OBJECT(winstruct[cs->w].chanwin->lag);
}
static void set_cmd(CmdStruct * cs)
{
  set_variable(cs->args, win_invalid(cs->w) ? NULL : winstruct + cs->w);
}
static void whatis_cmd(CmdStruct * cs)
{

  if (!win_invalid(cs->w))
  {
    char *argv[3];

    new_str2args(cs->args, &argc, argv, 3);
    whatis(argc, argv, cs->w);
  }
}
static void encrypt_cmd(CmdStruct * cs)
{

  if (!win_invalid(cs->w))
  {
    char *argv[MAXARGC];

    new_str2args(cs->args, &argc, argv, MAXARGC);
    do_encrypt(argc, argv, cs->w);
  }
}
static void apropos_cmd(CmdStruct * cs)
{
  /*
     static void apropos(int argc, char **argv, Winstruct *win);
   */

  if (!win_invalid(cs->w))
  {
    char *argv[3];

    new_str2args(cs->args, &argc, argv, 3);
    apropos2(argc, argv, winstruct + cs->w);
  }
}

static void shell_cmd(CmdStruct * cs)
{
/*
   /!ls -l or /! ls -l        
 */
#if USE_XFORMS
  rmstr(cs->args, 0);
  if (cs->args && *(cs->args))
  {
    fl_show_command_log(FL_FULLBORDER);
    fl_exe_command(cs->args, 0);
  }
#endif
}

extern void remove_dcc_by_id(int id);

static void fwdcr_cmd(CmdStruct * cs)
{
/*
   forward a chat req received. only to be called via DCC.
   fwdcr <id> <nick>      
 */
  if (!win_invalid(cs->w))
  {
    DCC *q = dccStart;
    int id;
    char *nick;

    rmstr(cs->args, 0);
    if (*cs->args == 0)
      return;
    nick = (char *) alloca(sizeof(char) * strlen(cs->args));

    if (sscanf(cs->args, "%u %s", &id, nick) < 2)
      return;
    while (q != dccEnd)
    {
      if (q->id == id)
      {
        if (q->type & ((DCC_CHAT | DCC_RECV) & ~DCC_ACTIVE))
        {
          char *buf = alloca(sizeof(char) * (strlen(nick) + 60));

          sprintf(buf, "PRIVMSG %s :%cDCC CHAT chat %lu %hu%c\n",
                  nick, 0x01, q->inetaddr, q->rport, 0x01);
          if (!sendto_server(cs->w + winstruct, buf))
            q->type |= DCC_FWD;
          return;
        }
        break;
      }
      q = q->next;
    }
    say2(0, cs->w, 1, PROMPT "FWDCR: bad id");
  }
}

static void fwdfr_cmd(CmdStruct * cs)
{
/*
   forward a file request received.  only to be called via DCC.
   fwdfr <id> <nick> [<new filename>]      
 */

  DCC *q = dccStart;
  int id;
  char *nick, *newname;

  if (win_invalid(cs->w))
    return;
  rmstr(cs->args, 0);
  if (*cs->args == 0)
    return;
  nick = alloca(sizeof(char) * strlen(cs->args));
  newname = alloca(sizeof(char) * strlen(cs->args));

  if (sscanf(cs->args, "%u %s", &id, nick) < 2)
    return;
  if (sscanf(cs->args, "%*d %*s %s", newname) < 1)
    newname = NULL;
  while (q != dccEnd)
  {
    if (q->id == id)
    {
      if (q->type & ((DCC_FILE | DCC_RECV) & ~DCC_ACTIVE))
      {
        char *buf = alloca(sizeof(char) * (strlen(nick) +
                                           strlen(newname ? newname : q->
                                                  dcc.file->name) + 70));

        sprintf(buf, "PRIVMSG %s :%cDCC SEND %s %lu %hu %lu %lu%c\n", nick,
                0x01, newname ? newname : q->dcc.file->name, q->inetaddr,
                q->rport, q->dcc.file->size,q->dcc.file->checksum, 0x01);
        if (!sendto_server(cs->w + winstruct, buf))
          q->type |= DCC_FWD;
        return;
      }
      break;
    }
    q = q->next;
  }
  say2(0, cs->w, 1, PROMPT "FWDFR: bad id");
}

static void query_cmd(CmdStruct * cs)
{

  if (!iconnected(cs->w))
    say0("Not connected", cs->w, 1);
  else
  {
    char *nick;
    Winstruct *win = cs->w + winstruct;

    nick = nextword(cs->args, 1);
    if (*nick == 0)
    {
      if (win->query_nick)
      {
        say2(0, cs->w, 1,
             PROMPT "Ending conversation with %s", win->query_nick);
        free(win->query_nick);
        win->query_nick = NULL;
        if (TO_QUERY(win))
          SET_BUTTON(win->chanwin->r_quote, 1);
        UpdateStatus(win);
      }
      else
        say0(PROMPT "You aren't querying anyone", cs->w, 1);
    }
    else
    {
      if (win->query_nick)
        free(win->query_nick);
      win->query_nick = strdup(nick);
      SET_BUTTON(win->chanwin->r_query, 1);
      UpdateStatus(win);
      say2(0, cs->w, 1, PROMPT "Starting conversation with %s", nick);
    }
    free(nick);
  }
}

static void msg_cmd(CmdStruct * cs)
{
/*
 *  /msg <nick or channnel or *> <msg>
 *  /notice <nick or channnel or *> <msg> 
 *
 *  * = current channel, query or DCC chat       
 */
  char type[10];                //msg or notice
  char *msg, *buf, *dest;
  char *fmt = NULL;
  char *to;
  u_char isnotice = 0, is_public = 0;
  Winstruct *win;

#define XX 1                    // debuggin this procedure if XX==0
#if XX
  if (win_invalid(cs->w))
    return;
#endif
  to = nextword(cs->args, 1);
#if  XX
  win = cs->w + winstruct;
  if (*to != '=')
  {
    if (!win->server)
    {
      say0("No server connection", cs->w, 1);
      if (gflags & BEEP_ERR)
        spx_bell(0);
      free(to);
      return;
    }
    if (win->server->flag & DOING_NOTICE)
    {
      // you shouldn't reply to a NOTICE.
      say("@C1@vWarning--can't reply to a NOTICE", cs->w, 1);
      free(to);
      return;
    }
  }
  if (*to == 0)
  {
    free(to);
    return;
  }
  dest = NULL;
  if (*to == '*' && *(to + 1) == 0)
  {
    free(to);
    if (win->chanCur == win->chanStart)
    {
      if (win->query_nick != NULL)
        dest = strdup(win->query_nick);
      else if (win->dccCur != win->dccStart)
      {
        dest = malloc(sizeof(char) * (2 + strlen(win->dccCur->nick)));

        *dest = '=';
        strcpy(dest + 1, win->dccCur->nick);
      }
    }
    else
      dest = strdup(win->chanCur->name);
  }
  else
#endif
  {
    dest = strdup(to);
    free(to);
  }
  if (dest == NULL)
  {
    return;
  }
  msg = (char *) alloca(sizeof(char) * strlen(cs->args));

  if (sscanf(cs->args, "%s %*s %[^\n]\n", type, msg) < 2)
    return;
  uppercase2(type);
  isnotice = (type[0] != 'M' || type[1] != 'S' || type[2] != 'G'
              || type[3] != 0);
#if XX
  if (!isnotice && *dest == '=')
  {
    if (win->dccCur == win->dccStart)
    {
      if (gflags & BEEP_ERR)
        spx_bell(0);
      /*say2(0, cs->win - winstruct, 1, PROMPT "No DCC connections"); */
    }
    else
    {
      DCCChat *chat = win->dccStart->left;

      strshift(dest, 1);
      if (*dest == 0)
      {
        free(dest);
        return;
      }
      while (chat != win->dccStart)
        if (!strcasecmp(chat->nick, dest))
          break;
        else
          chat = chat->left;
      if (chat == win->dccStart)
        say2(0, cs->w, 1, PROMPT "No DCC chat with %s", dest);

      buf = (char *) malloc(sizeof(char) * (strlen(msg) + 3));

      sprintf(buf, "%s\n", msg);
      sendto_dcc_chat(win, chat, buf);
      free(buf);
      if (!check_msg_hook
          (SEND_CHATMSG, cs->w, ", %s %s %s", chat->nick,
           chat->email ? chat->email : "unknown", msg))
      {
        fmt_string = "%n%c%h%p$";
        buf = format_msg(fmt_you_dccchat, win->server ?
                         win->server->nick : Name,
                         dest,
                         win->dccCur->email ?
                         win->dccCur->email : win->dccCur->nick, msg);
        if (buf)
        {
          say(buf, cs->w, 0);
          free(buf);
        }
      }
      free(dest);
    }
    return;
  }
#endif
  if ((gflags & ENCRYPT_MSG) && (fmt = have_key(dest, ENCRYPT)))
  {
    int ll = strlen(msg);
    char *tmp;

    encrypt_str(msg, ll, fmt);
    tmp = ctcp_quote_it(msg, ll);
    buf = malloc(sizeof(char) * (strlen(dest) + strlen(tmp) + 50));

    sprintf(buf, "PRIVMSG %s :%cSED %s%c\n", dest, 0x01, tmp, 0x01);
    free(tmp);
    fmt = fmt_sed_your;
  }
  else if (!isnotice)
  {
    buf = (char *) malloc(sizeof(char) * (strlen(cs->args) + 50));

    sprintf(buf, "PRIVMSG %s :%s\n", dest, msg);
    if (*dest == '#' || *dest == '&')
    {
      is_public = 1;
      fmt = fmt_you_pub_msg;
    }
    else
      fmt = fmt_you_priv_msg;
  }
  else
  {
    buf = (char *) malloc(sizeof(char) * (strlen(cs->args) + 50));

    sprintf(buf, "NOTICE %s :%s\n", dest, msg);
    if (*dest == '#' || *dest == '&')
    {
      is_public = 1;
      fmt = fmt_you_pub_notice;
    }
    else
      fmt = fmt_you_priv_notice;
  }
#if XX
  sendto_server(win, buf);
#endif
  free(buf);
#if XX
  if (!check_msg_hook(isnotice ?
                      (is_public ? SEND_PUBLIC_NOTICE :
                       SEND_PRIVATE_NOTICE) : (is_public ?
                                               SEND_PUBLIC_MSG :
                                               SEND_PRIVATE_MSG),
                      cs->w, "%s,%hu %s %s",
                      win->server->name, win->server->port, dest, msg))
#endif
  {
#if XX
    fmt_string = "%n%c%l%h%p%z$";
    sscanf(cs->args, "%*s %*s %[^\n]\n", msg);
    buf = format_msg(fmt, win->server->nick, dest,
                     Name, host, msg, strlen(msg));
#else
    fmt_string = "%c%p%z$";
    sscanf(cs->args, "%*s %*s %[^\n]\n", msg);
    buf = format_msg(fmt, dest, msg, strlen(msg));
#endif
    if (buf)
    {
      isay("OUTGOING", buf, cs->w, 0);
      free(buf);
    }
  }
  free(dest);
}

static void nick_cmd(CmdStruct * cs)
{
  char *argv[5];

  new_str2args(cs->args, &argc, argv, 5);
  nick(argc, argv, win_invalid(cs->w) ? NULL : winstruct + cs->w);
}
static void echo_cmd(CmdStruct * cs)
{
/*
   echo [-2] <txt>
 */

  char *arg = nextword(cs->args, 1);
  int mainbrow;

  rmstr(cs->args, 0);
  mainbrow = !(*arg == '-' && *(arg + 1) == '2' && *(arg + 2) == 0);
  if (!mainbrow)
    rmstr(cs->args, 0);
  if (*cs->args)
    say(cs->args, cs->w, !mainbrow);
  free(arg);
}
static void quote_cmd(CmdStruct * cs)
{
// quote string

  if (!iconnected(cs->w))
  {
    if (gflags & BEEP_ERR)
      spx_bell(0);
    return;
  }
  else
  {
    char *cmd = nextword(cs->args, 1);

    if (*cmd == 0)
    {
      say0(PROMPT "Quote: missing arguments", cs->w, 1);
      return;
    }
    if ((*cmd == 'j' || *cmd == 'J') && !strncasecmp(cmd, "join", 4))
    {
      char *channame = nextword(cs->args, 2);

      if (*channame)
        addto_cmd_sent(cs->w + winstruct, "JOIN", channame);
      free(channame);
    }
    else
    {
      free(cmd);
      cmd = (char *) alloca(sizeof(char) * (strlen(cs->args) + 2));

      sprintf(cmd, "%s\n", cs->args + find_pos(cs->args, 1));
      sendto_server(cs->w + winstruct, cmd);
    }
  }
}

static void motd_cmd(CmdStruct * cs)
{
  if (iconnected(cs->w))
  {
    winstruct[cs->w].server->flag &= ~GOT_MOTD;
    sendto_server(winstruct + cs->w, "MOTD\n");
  }
}

static void userhost_cmd(CmdStruct * cs)
{

  if (!iconnected(cs->w))
    return;
  //say0(PROMPT "USERHOST: not connected", cs->win - winstruct, 1);
  else
    userhost(cs->args, cs->w);
}
static void saved_quoted_cmds(CmdStruct * cs)
{
  if (iconnected(cs->w))
  {
    /*say0(PROMPT "not connected", cs->win - winstruct, 1); */
    {
      char *arg, *arg2, *buf;

      arg = nextword(cs->args, 0);
      arg2 = nextword(cs->args, 1);
      buf = malloc(sizeof(char) * (strlen(cs->args) + 2));

      sprintf(buf, "%s %s\n", arg, arg2);
      sendto_server(cs->w + winstruct, buf);
      uppercase2(arg);
      addto_cmd_sent(cs->w + winstruct, arg, arg2);
      free(arg);
      free(arg2);
      free(buf);
    }
  }
}
static void quoted_cmds(CmdStruct * cs)
{

  if (!iconnected(cs->w))
    return;
  /*say0(PROMPT "not connected", cs->win - winstruct, 1); */
  else
  {
    char *arg;
    arg = (char *) malloc(sizeof(char) * (strlen(cs->args) + 2));

    sprintf(arg, "%s\n", cs->args);
    sendto_server(cs->w + winstruct, arg);
    free(arg);
  }
}
static int str2sp(const char *name)
{
/* name to connection number */
  register int i;
  int ll = strlen(name);

  for (i = 0; i < sp_count; i++)
    if (s_pipe[i].fd > -1 && !strncasecmp(s_pipe[i].name, name, ll))
      return i;
  return -1;
}
static void server_cmd(CmdStruct * cs)
{
  server(cs->args, win_invalid(cs->w) ? NULL : cs->w + winstruct);
}
static void run_cmd(CmdStruct * cs)
{

  char *args;

  args = alloca(sizeof(char) * strlen(cs->args));

  if (sscanf(cs->args, "%*s %*s %[^\n]", args) < 1)
    say0("Usage: run <name> <args>", cs->w, 1);
  else
  {
    char *arg = nextword(cs->args, 1);

    launch_prog(arg, args);
    free(arg);
  }
}
static void connect_cmd(CmdStruct * cs)
{
  /*
     create named connection 
     connect <name> <server> <port> <args>
   */

  S_Pipe *s;
  int ll;
  u_short port;
  char *server, *name, *args;

  ll = strlen(cs->args);
  server = alloca(sizeof(char) * ll);
  name = alloca(sizeof(char) * ll);

  args = alloca(sizeof(char) * ll);

  *args = 0;
  if (sscanf(cs->args, "%*s %s %s %hu %[^\n]", name, server, &port, args) < 3)
  {
    say0("Usage: connect <name> <host> <port> [args]", cs->w, 1);
    return;
  }
  s = make_connection(name, server, port, args);
  if (s == NULL)
  {
    if (tcp_err_msg)
      fprintf(stderr, "%s (port %d): %s\n", server, port, tcp_err_msg);
    else
      error(-1, "Can't create %s to %s(%d)", name, server, port);
    return;
  }
#warning todo: recheck first
  say2(0, cs->w, 1, "created \"%s\" to port %hu of %s",
       s->name, s->to.server.port, s->to.server.name);
}
static void squote_cmd(CmdStruct * cs)
{
/*
   quote to a name connection       
 */
  char *arg;

  arg = alloca(sizeof(char) * (strlen(cs->args) + 2));

  if (sscanf(cs->args, "%*s %s", arg) < 1)
  {
    say0("Usage: squote <connection name> <args>", cs->w, 1);
    return;
  }
  else
  {
    int sp = str2sp(arg);

    if (sp < 0)
      say2(0, cs->w, 1, "No such connection %s", arg);
    else
    {
      char *buf;

      buf = alloca(sizeof(char) * (strlen(cs->args) + 2));

      if (sscanf(cs->args, "%*s %*s %[^\n]", arg) < 1)
        return;
      sprintf(buf, "%s\n", arg);
      write_to_sp(sp, buf);
    }
  }
}

static void who_cmd(CmdStruct * cs)
{

  if (!win_invalid(cs->w))
  {
    char *argv[MAXARGC];

    new_str2args(cs->args, &argc, argv, MAXARGC);
    who(argc, argv, cs->w + winstruct);
  }
}

static void kick_cmd(CmdStruct * cs)
{
  if (!iconnected(cs->w))
    return;
  else
  {
    char *chan, *channame = NULL, *nick, *buf;
    Winstruct *win;

    chan = nextword(cs->args, 1);
    nick = nextword(cs->args, 2);

    if (*chan == 0 || *nick == 0)
    {
      free(chan);
      free(nick);
      return;
    }
    win = winstruct + cs->w;
    if (*chan == '*' && *(chan + 1) == 0)
    {
      if (win->chanCur == win->chanStart)
      {
        say(PROMPT "No channels", cs->w, 1);
        spx_bell(0);
        return;
      }
      channame = strdup(win->chanCur->name);
    }
    else if (*chan != '#' && *chan != '&')
    {
      channame = malloc(sizeof(char) * (strlen(chan) + 3));

      sprintf(channame, "#%s", chan);
    }
    else
      channame = strdup(chan);
    buf = alloca(sizeof(char) * (strlen(cs->args) + strlen(channame) + 12));

    sprintf(buf, "KICK %s %s :%s\n", channame, nick,
            cs->args + find_pos(cs->args, 3));
    free(channame);
    free(nick);
    sendto_server(win, buf);
  }
}
static void mode_cmd(CmdStruct * cs)
{
  char *buf;
  Winstruct *win;

  if (!iconnected(cs->w))
    return;
  buf = nextword(cs->args, 1);
  win = winstruct + cs->w;
  if (!*buf)
  {
    free(buf);
    buf = (char *) malloc(sizeof(char) * (strlen(win->server->nick) + 8));

    sprintf(buf, "MODE %s\n", win->server->nick);
    sendto_server(win, buf);
    free(buf);
    return;
  }
  else
  {
    char *mode = (char *) malloc(sizeof(char) * strlen(cs->args));

    char *nick = nextword(cs->args, 1);

    free(buf);
    buf = (char *) malloc(sizeof(char) * (strlen(cs->args) + 256));

    if (sscanf(cs->args, "%*s %*s %[^\n]\n", mode) < 1)
      *mode = 0;
    sprintf(buf, "MODE %s %s\n",
            (!(*nick == '*' && *(nick + 1) == 0)) ? nick :
#if 1
            win->chanCur != win->chanStart ? win->chanCur->name :
#endif
            win->server->nick, mode);
    if (sendto_server(win, buf) == 0)
      if (!mode && (*nick == '#' || *nick == '&'))
        addto_cmd_sent(win, "MODE", nick);
    free(buf);
    free(mode);
    free(nick);
  }
}
static void away_cmd(CmdStruct * cs)
{
  if (iconnected(cs->w))
  {
    char *msg = NULL;
    char mark_away = 1;

    msg = nextword(cs->args, 1);
    if (*msg == 0)
    {
      free(msg);
      if (!(winstruct[cs->w].server->flag & SET_AWAY))
      {
        msg = my_malloc(sizeof(char) * (strlen(away_text) + 16));

        sprintf(msg, "AWAY :%s\n", away_text);
        mark_away = 1;
      }
      else
      {
        msg = strdup("AWAY\n");
        mark_away = 0;
      }
      sendto_server(&winstruct[cs->w], msg);
      free(msg);
    }
    else
    {
      free(msg);

      msg = my_malloc(sizeof(char) * (strlen(cs->args) + 10));

      sprintf(msg, "AWAY :%s\n", cs->args + find_pos(cs->args, 1));
      sendto_server(&winstruct[cs->w], msg);
      free(msg);
    }
  }
}

static void me_cmd(CmdStruct * cs)
{
  char *buf;

  if (!iconnected(cs->w))
    return;
  buf = nextword(cs->args, 1);
  if (*buf == 0)
  {
    free(buf);
    return;
  }
  else
  {
    char *dest;
    Winstruct *win = winstruct + cs->w;

    free(buf);
    if (TO_QUERY(win) && win->query_nick)
      dest = win->query_nick;
    else if (win->chanCur != win->chanStart)
      dest = win->chanCur->name;
    else
      return;                   //   no channels
    rmstr(cs->args, 0);
    buf = malloc(sizeof(char) * (strlen(cs->args) + strlen(dest) + 50));

    sprintf(buf, "PRIVMSG %s :%cACTION %s%c\n", dest, 0x01, cs->args, 0x01);
    sendto_server(win, buf);
    free(buf);
    if (!check_msg_hook
        (SEND_ACTION, cs->w, "%s,%hu %s %s",
         win->server->name, win->server->port, dest, cs->args))
    {
      fmt_string = "%n%c%l%h%p%z$";
      buf = format_msg(fmt_you_pub_action, win->server->nick,
                       win->chanCur->name, Name, host, cs->args,
                       strlen(cs->args)); if (buf)
      {
        isay("OUTGOING", buf, cs->w, 0);
        free(buf);
      }
    }
  }
}
static void action_cmd(CmdStruct * cs)
{
/*
   /action <to> <msg>
   to == * means current channel

 */
  char *msg;

  if (!iconnected(cs->w))
    return;
  msg = nextword(cs->args, 1);
  if (!*msg)
  {
    free(msg);
    return;
  }
  else
  {
    char *nick, *nnick = 0, *buf;
    Winstruct *win = winstruct + cs->w;

    free(msg);
    msg = (char *) alloca(sizeof(char) * strlen(cs->args));
    nnick = (char *) alloca(sizeof(char) * strlen(cs->args));

    if (sscanf(cs->args, "%*s %s %[^\n]\n", nnick, msg) < 2)
      return;
    if (*nnick == '*' && *(nnick + 1) == 0)
      if (win->chanCur == win->chanStart)
        return;
      else
        nick = win->chanCur->name;
    else
      nick = nnick;
    buf = (char *) malloc(sizeof(char) * (strlen(cs->args) + 50));

    sprintf(buf, "PRIVMSG %s :%cACTION %s%c\n", nick, 0x01, msg, 0x01);
    sendto_server(win, buf);
    free(buf);
    if (!check_msg_hook
        (SEND_ACTION, cs->w, "%s,%hu %s %s",
         win->server->name, win->server->port, nick, msg))
    {
      fmt_string = "%n%c%l%h%p%z$";
      buf = format_msg(fmt_you_priv_action, win->server->nick,
                       nick, Name, host, msg, strlen(msg));
      if (buf)
      {
        isay("OUTGOING", buf, cs->w, 0);
        free(buf);
      }
    }
  }
}

static void chat_cmd(CmdStruct * cs)
{
/*
   send a chat request
   chat <nick!userhost> [<flag>]      
 */
  if (iconnected(cs->w))
  {
    char *nick = nextword(cs->args, 1);

    if (*nick != 0)
    {
      int flag = 0;

      sscanf(cs->args, "%*s %*s %d", &flag);
      if (dcc_sendchatreq
          (cs->w + winstruct, flag ? NULL : cs->w + winstruct, nick))
        say2(0, cs->w, 1, PROMPT "DCC chat to %s failed", nick);
      else
        say2(0, cs->w, 1, PROMPT "chat request sent to %s", nick);
    }
    free(nick);
  }
}
static void send_cmd(CmdStruct * cs)
{
/*
   offer multiple files to someone.
   /send nick!user@host.domain file1 *.c *.h file4 ...MAXFILE_SPEC      
 */
#define MAXFILE_SPEC 10
  if (iconnected(cs->w))
  {
    char *argv[MAXFILE_SPEC + 2];

    new_str2args(cs->args, &argc, argv, MAXFILE_SPEC + 2);
    offer(argc, argv, cs->w);
  }
}
/*************************************
 *  DCC  command                     *
 *                                   *
 *************************************/
#define addtime(_st, _buf, _len) do{\
 struct tm *_t_=localtime(_st);\
 strftime(&(_buf)[0], (_len), "%H:%M %d%b%y",_t_);\
   (_buf)[_len]=0;\
}while(0)

static void list_dcc(int w)
{
/*
   /DCC LIST

   This is a wretched hack. All this should be done through a script.
   See procedure gs-dcc-list.
 */

#define LLEN 14
  char buf[LLEN + 1];
  DCC *p;

#define MAX_LOUT 90
  char s[MAX_LOUT + 1];

  say
     ("@f@C1@._______________________________________________________________",
      w, 0);
  say
     ("@f@D4@C7@.ID  Type Peer       Status Start Date    Wrote   Read    Misc  ",
      w, 0);
  if (dccchatwinStart != dccchatwinEnd)
  {
    DCCChatWin *q = dccchatwinStart;

    while (q != dccchatwinEnd)
    {
      s[MAX_LOUT + 1] = 0;
      addtime(q->starttime, buf, LLEN);
      snprintf(s, MAX_LOUT,
               "@f%-3d @C6CHAT@!C %-10.10s Active %-13.13s %-7d %-7d @!f@s@$%s",
               q->id, q->nick, buf, *q->wrote, *q->read, q->email);
      say(s, w, 0);
      q = q->next;
    }
  }
  p = dccStart;
  while (p != dccEnd)
  {
    s[MAX_LOUT + 1] = 0;
    addtime(&p->starttime, buf, LLEN);
    snprintf(s, MAX_LOUT,
             "@f%-3d @C6%s@!C %-10.10s %s %-13.13s %-7ld %-7ld @!f@s@$%s@!$",
             p->id, p->type & DCC_FILE ? "FILE" : "CHAT", p->nick,
             p->type & DCC_ACTIVE ? "ACTIVE " : p->type & DCC_SENT ?
             "SENT  " : "RECV  ", buf, ((p->type & DCC_FILE)
                                        && (p->type & DCC_SENT)) ? p->
             dcc.file->read : 0, p->type & DCC_FILE ? p->dcc.file->read : 0,
             p->type & DCC_FILE ? p->dcc.file->name : p->peer);
    say(s, w, 0);
    p = p->next;
  }
  say
     ("@f@C1@.---------------------------------------------------------------",
      w, 0); return;
}

typedef struct TDCCCmdType
{
  int cmd;
  char *name;
}
DCCCmdType;

#define dcc_CHAT	(0)
#define dcc_CLOSE 	(1)
#define dcc_GET		(2)
#define dcc_LIST	(3)
#define dcc_SEND	(4)
#define dcc_FWD         (5)
static int lookup_dcc_cmd(const char *name)
{
/* *INDENT-OFF* */
  DCCCmdType cmds[] =
  {
    {dcc_CHAT, "CHAT"},
    {dcc_CLOSE, "CLOSE"},
    { dcc_GET, "GET" },
    {dcc_FWD, "FORWARD"},
    {dcc_LIST, "LIST" },
    { dcc_SEND, "SEND"},
  };
/* *INDENT-ON* */

  DCCCmdType *p = cmds;
  register int low, high, mid, cond;

  low = 0;
  high = sizeof(cmds) / sizeof(DCCCmdType) - 1;
  while (low <= high)
  {
    mid = (low + high) / 2;
    if ((cond = strcmp(name, (p + mid)->name)) < 0)
      high = mid - 1;
    else if (cond > 0)
      low = mid + 1;
    else
      return (p + mid)->cmd;
  }
  return -1;
}
static DCC *locate_dcc(const char *nick, int flag, int flag2,
                       int flag3, const char *file)
{
  DCC *q = dccStart;
  int id;

  id = atoi(nick);
  if (id)
  {
    while (q != dccEnd)
    {
      if ((q->type & flag) && (!flag2 || (q->type & flag2))
          && (!flag3 || (q->type & flag3))
          && q->id == id && (!file || !strcmp(q->dcc.file->name, file)))
        return q;
      q = q->next;
    }
  }
  else
  {
    size_t ll = strlen(nick);

    while (q != dccEnd)
    {
      if ((q->type & flag) && (!flag2 || (q->type & flag2))
          && (!flag3 || (q->type & flag3))
          && !strncasecmp(nick, q->nick, ll) &&
          (!file || !strcmp(q->dcc.file->name, file)))
        return q;
      q = q->next;
    }
  }
  return NULL;
}
static DCCChatWin *locate_active_chat(const char *nick)
{
   DCCChatWin *q = dccchatwinStart;
  int id;
  id = atoi(nick);
  if (id)
    while (q != dccchatwinEnd)
      if (q->id == id)
        break;
      else
        q = q->next;
  else
  {
    size_t ll = strlen(nick);

    while (q != dccchatwinEnd)
      if (!strncasecmp(nick, q->nick, ll))
      {
        id = q->id;
        break;
      }
      else
        q = q->next;
  }
  return q == dccchatwinEnd? NULL:q;
}
static int close_chat(const char *nick, const char *reason)
{
/*   close a chat session   */
  DCCChatWin *q;
  
  q=locate_active_chat(nick);
  if (q )
  {
    char *pp = strdup(q->nick);
    int w = q->w;

    if (*reason == 0)
      reason = NULL;
    if (!remove_dccchat(q->id, (char *) reason))
    {
      free(pp);
      return -1;
    }                           //say0(PROMPT "No dcc chat with that id", w, 1);
    else
    {
      char *buf = malloc(sizeof(char) * (strlen(pp) + 40));

      sprintf(buf, "DCC chat connection to %s closed", pp);
      fit_object_label(winstruct[w].chanwin->WinStatusLine, buf);
      UpdateStatus(winstruct + w);
      say0(buf, w, 1);
      free(buf);
      free(pp);
    }
  }
  return 0;
}

extern void accept_chat(DCC * q, Winstruct *);
extern void accept_file(DCC * q, Winstruct *);
extern void terminate_file_transfer(DCC *, int w);

static void dcc_cmd(CmdStruct * cs)
{

  char *str;

  str = nextword(cs->args, 1);
  if (!*str)
  {
    free(str);
    list_dcc(cs->w);
  }
  else
  {
    int i;

    uppercase2(str);
    i = lookup_dcc_cmd(str);
    if (i < 0)
    {
      say2(0, cs->w, 1, PROMPT "Unknown DCC command: %s", str);
      free(str);
      return;
    }
    free(str);
    switch (i)
    {
       case dcc_CHAT:
         {
           /*   DCC CHAT <nick|id>  */
           DCC *p;
           DCCChatWin *q;

           str = nextword(cs->args, 2);
           if (*str == 0)
           {
             say0(PROMPT "DCC CHAT: not enough args", cs->w, 1);
             break;
           }
           p = locate_dcc(str, DCC_CHAT, DCC_RECV, ~DCC_ACTIVE, 0);
           if (p)
           {
             char *flag = nextword(cs->args, 3);

             accept_chat(p, *flag == '1' ?
                NULL : !win_invalid(cs->w) ? (winstruct +cs->w) :
                         win_invalid(p->w) ? NULL : (winstruct + p->w));
             if (*flag)
               free(flag);
           }
           else
           if((p = locate_dcc(str, DCC_CHAT, 0, 0, 0)))
              say2(0, cs->w, 1,
                   "DCC chat to %s ignored: exists already to %s.", p->nick, p->peer);
           else if((q=locate_active_chat(str)))
              say2(0, cs->w, 1,
                 "DCC chat to %s ignored: already active to %s.", q->nick, q->email);
           else
           {
             char *buf = malloc(sizeof(char) * (strlen(cs->args) + 40));

             sprintf(buf, "/USERHOST %s -cmd /chat $2!$5@$6", str);
             new_process_cmd(buf, cs->w);
             free(buf);
           }
           free(str);
           break;
         }
       case dcc_FWD:
        {
           /* DCC FORWARD id nick */
           char *id=nextword(cs->args, 2);
           char *nick=nextword(cs->args, 3);

           if(*id && *nick)
           {
              DCC *p=locate_dcc(id, DCC_FILE|DCC_CHAT, DCC_RECV, ~DCC_ACTIVE, NULL);
              if(p)
              {
                char *buf = malloc(sizeof(char) * (strlen(id)+strlen(nick)+40));
                sprintf(buf, "/USERHOST %s -cmd %s %s $2", nick,
                  p->type&DCC_FILE? "/fwdfr":"/fwdcr", id);
                new_process_cmd(buf, cs->w);
                free(buf);
              }
              else say2(0, cs->w, 1, "DCC FORWARD: bad id %s",id);
           }
           free(id);
           free(nick);
        }
       case dcc_SEND:
         {
           /*
              DCC SEND <nick> <files>
            */
           char *files = cs->args + find_pos(cs->args, 3);

           if (*files)
           {
             char *buf = malloc(sizeof(char) * (strlen(cs->args) + 40));

             str = nextword(cs->args, 2);
             sprintf(buf, "/USERHOST %s -cmd /send $2!$5@$6 %s", str, files);
             new_process_cmd(buf, cs->w);
             free(buf);
             free(str);
           }
           else
             say0(PROMPT "No files to send?", cs->w, 1);
           break;
         }
       case dcc_GET:
         str = nextword(cs->args, 2);
         if (*str)
         {
           /*
              DCC GET 1
              DCC GET nick
              DCC GET nick file
            */
           char *file = 0;
           DCC *p;

           file = nextword(cs->args, 3);
           if (*file == 0)
             file = NULL;
           p = locate_dcc(str, DCC_FILE, DCC_RECV, ~DCC_ACTIVE, file);
           if (p)
             accept_file(p,
                         !win_invalid(cs->w) ? (winstruct +
                                                cs->w) : win_invalid(p->
                                                                     w) ? NULL
                         : (winstruct + p->w));
           else
             say2(0, cs->w, 1, PROMPT "DCC GET: %s [%s] not found", str,
                  file ? file : "any");
           if (file)
             free(file);
           free(str);
         }
         break;
       case dcc_CLOSE:
         /*
            DCC close chat id|nick
            DCC close send id|<nick [file]>
            DCC close get <id>|<nick [file]>

            This is too silent. Need some diagnotics if command fails.
          */
         {
           char *what = nextword(cs->args, 2);

           if (*what)
           {
             int isget = !strcasecmp(what, "GET");
             int issend = 0;
             int ischat = 0;
             char *nick, *file = 0;
             DCC *p;

             if (!isget)
             {
               issend = !strcasecmp(what, "SEND");
               if (!issend)
                 ischat = !strcasecmp(what, "CHAT");
             }
             if (!isget && !issend && !ischat)
             {
               say2(0, cs->w, 1, PROMPT "DCC CLOSE: invalid type %s", what);
               free(what);
               break;
             }
             nick = nextword(cs->args, 3);
             if (*nick == 0)
             {
               say0(PROMPT "DCC CLOSE: not enough args", cs->w, 1);
               free(what);
               break;
             }
             if (isget || issend)
             {
               file = nextword(cs->args, 4);
               if (*file == 0)
                 file = NULL;
               p = locate_dcc(nick,
                              DCC_FILE, isget ? DCC_RECV : DCC_SENT, 0, file);}
             else
               p = locate_dcc(nick, DCC_CHAT, 0, 0, file);
             if (p)
             {
               if (!ischat)
                 terminate_file_transfer(p, cs->w);	//remove_dcc_by_id(p->id);
               else if (close_chat(nick, cs->args + find_pos(cs->args, 4)))
                 remove_dcc_by_id(p->id);
             }
             else if (ischat)
               close_chat(nick, cs->args + find_pos(cs->args, 4));
             free(nick);
             free(what);
             if (file)
               free(file);
             break;
           }
         }
         break;
       case dcc_LIST:
         list_dcc(cs->w);
         break;
    }
  }
}

/***********************************
 *  c t c p                                                        
 ************************************/
static void ping_cmd(CmdStruct * cs)
{
/*
   /ping nikc1 nick2,nick3 ...       
 */
  char *buf, *ptr, *ptr2;

  if (!iconnected(cs->w))
    return;

  buf = alloca(sizeof(char) * strlen(cs->args));

  if (sscanf(cs->args, "%*s %[^\n]\n", buf) < 1)
    return;
  ptr2 = buf;
  ptr = strsep(&ptr2, ", \t");
  while (ptr)
  {
    if (*ptr)
    {
      char s[128];
      struct timeval t;

      if (gettimeofday(&t, NULL) != EINVAL)
        sprintf(s, "PRIVMSG %s :%cPING %ld %ld%c\n",
                ptr, 0x01, t.tv_sec, t.tv_usec, 0x01);
      else
        sprintf(s, "PRIVMSG %s :%cPING %ld%c\n", ptr, 0x01, time(NULL), 0x01);
      sendto_server(cs->w + winstruct, s);
    }
    ptr = strsep(&ptr2, ", \t");
  }
}

static void other_ctcp(CmdStruct * cs)
{
/*
   /ctcp nick args
   default args="VERSION"
   /reply nick usersinfo bang bang!   
 */

  char *nick;

  if (!iconnected(cs->w))
    return;
  nick = nextword(cs->args, 1);
  if (*nick == 0)
    free(nick);
  else
  {
    char *buf;
    char *bigbuf = NULL;
    Winstruct *win = cs->w + winstruct;
    buf = (char *) malloc(sizeof(char) * (strlen(cs->args)));

    if (sscanf(cs->args, "%*s %*s %[^\n]\n", buf) < 1)
    {
      free(buf);
      buf = strdup("VERSION");
    }
    bigbuf = (char *) malloc(sizeof(char) * (strlen(cs->args) + 128));

    if (!strncasecmp(cs->args, "reply ", 6))
    {
#define MAX_SERV_SEND	400
      sprintf(bigbuf, "NOTICE %s :%c%s%c\n", nick, 0x01, buf, 0x01);
      if (strlen(bigbuf) > MAX_SERV_SEND)
      {
        *(bigbuf + MAX_SERV_SEND - 2) = 0x01;
        *(bigbuf + MAX_SERV_SEND - 1) = '\n';
        *(bigbuf + MAX_SERV_SEND) = '\0';
      }
      sendto_server(win, bigbuf);
    }
    else if (*nick == '*' && nick[1] == 0)
    {
      if (win->chanCur != win->chanStart)
      {
        User *p = win->chanCur->userStart;

        while (p != win->chanCur->userEnd)
        {
          sprintf(bigbuf, "PRIVMSG %s :%c%s%c\n", p->nick, 0x01, buf, 0x01);
          sendto_server(win, bigbuf);
          p = p->next;
        }
      }
      else
        say0(PROMPT "CTCP *: No channels", cs->w, 1);
    }
    else
    {
      sprintf(bigbuf, "PRIVMSG %s :%c%s%c\n", nick, 0x01, buf, 0x01);
      sendto_server(win, bigbuf);
    }
    free(bigbuf);
    free(nick);
  }
}

extern void add_cmdoncon(int type, char *cmd, char *server, u_short port)
{
/*
   command to execute on connection to server      
 */
  CmdOnCon *p;

  if (!cmd)
    return;
  p = cmdonconStart;
  cmdonconStart = (CmdOnCon *) my_malloc(sizeof(CmdOnCon));
  cmdonconStart->type = type;
  cmdonconStart->cmd = strdup(cmd);
  cmdonconStart->server = strdup2(server);	//   NULL-->any server 
  cmdonconStart->port = port;   //   <1-->any port 
  cmdonconStart->next = p;
}
static void lnicks_cmd(CmdStruct * cs)
{
  int n = 0;

  while (n < iNickListCount)
  {
    if (aNickList[n].label)
    {
      Nicks *p = aNickList[n].start->left;

      fprintf(stdout, "\E[4m%s\E[m:\n", aNickList[n].label);
      while (p != aNickList[n].start)
      {
        fprintf(stdout, "\t%s%s\n",
                p == aNickList[n].current ? "*" : "", p->nick);
        p = p->left;
      }
    }
    n++;
  }
}

static void lastlog_cmd(CmdStruct * cs)
{
  // this is a placeholder for a later lastlog command 
#if USE_XFORMS
  char *args;

  args = alloca(strlen(cs->args) * sizeof(char));

  if (sscanf(cs->args, "%*s %[^\n]\n", args) < 1)
    say
       ("Usage: lastlog [ -[[AB] ]num ] [ -[CEFGVBchilnsvwx] ] [ -e ] <pattern>",
        cs->w, 1);
  else
  {
    char *buf =

       malloc((12 + strlen(cs->args) + strlen(log_file)) * (sizeof(char)));
    if ((sflags & LOG) == 0 && (gflags & VERBOSE_CLIENT))
      say("logging is off; using old log", cs->w, 1);
    sprintf(buf, "grep %s \"%s\"", args, log_file);
    fl_exe_command(buf, 0);
    fl_show_command_log(FL_FULLBORDER);
    free(buf);
  }
#endif
}
#if _GUILE
/*
   The LOAD command
 */
static void load_cmd(CmdStruct * cs)
{
// similar to the Scheme procedure (load) but expands tilde ~
  char *name;

  name = nextword(cs->args, 1);
  if (*name)
  {
    if (*name == '~')
    {
      char *file = expand_tilde(name);

      if (file)
      {
        free(name);
        name = strdup(file);
        free(file);
      }
    }
    if (access(name, R_OK) == -1)
    {
      say2(0, cs->w, 1, "%s: %s", name, strerror(errno));
      if (gflags & BEEP_ERR)
        spx_bell(0);
    }
    else
      gh_eval_file_with_catch(name, &exception_handler);
    free(name);
  }
}
#endif

static void list_flood(Flood * p, int w)
{
  if (p)
  {
    list_flood(p->left, w);
    say2(0, w, 0, "- %s\t%d at %lu", p->from, p->count, p->at);
    list_flood(p->right, w);
  }
}
static void flood_print_cmd(CmdStruct * cs)
{

  say("@vpriv Flood list:", cs->w, 0);
  list_flood(floodTree, cs->w);
  say("@vpub Flood list:", cs->w, 0);
  list_flood(publicfloodTree, cs->w);
}
static void alarm_cmd(CmdStruct * cs)
{
  char *args;

  args = nextword(cs->args, 1);
  if (*args == '-' && !strncasecmp(args, "-del", 4))
  {
    char *refs = nextword(cs->args, 2);
    int ref;

    if (*refs == 0 || sscanf(refs, "%d", &ref) < 1)
    {
      if (gflags & BEEP_ERR)
        spx_bell(0);
      say(PROMPT "Usage: alarm -del <ref>", cs->w, 1);
    }
    else
      del_alarm(ref, ALARM_IN);
    free(refs);
    free(args);
    return;
  }
  else
  {
    Timer t;
    int sec;

    free(args);
    t.cmd.cmd = malloc(sizeof(char) * strlen(cs->args));

    if (sscanf
        (cs->args, "%*s %d %d %[^\n]\n", &t.ref, &sec, t.cmd.cmd) < 3
        || sec < 0)
    {
      if (gflags & BEEP_ERR)
        spx_bell(0);
      say0(PROMPT "Usage: alarm <numeric ID> <seconds> <action>", cs->w, 1);
    }
    else
    {
      t.type = ALARM_IN;
      t.flag = TIMER_ALARM;
      if (add_timer(&t, (void *) &sec) == -1)
        error(-2, "malloc error");
    }
    free(t.cmd.cmd);
  }
}

#define CLOCK_USAGE(n) do { \
  if(gflags & BEEP_ERR) spx_bell(0);\
    say0( \
    PROMPT"Usage: clock [-ref|-del <id>] <HH:MM:SS-DD:mm:YYYY> <action>", \
    (n),1); \
    }while(0)

static void clock_cmd(CmdStruct * cs)
{
  char *args;

  args = nextword(cs->args, 1);
  if (*args == 0)
  {
    free(args);
    return;
  }
  if (*args == '-' && !strncasecmp(args, "-del", 4))
  {
    char *refs = nextword(cs->args, 2);
    int ref;

    if (*refs == 0 || sscanf(refs, "%d", &ref) < 1)
      CLOCK_USAGE(cs->w);
    else
      del_clock(ref, ALARM_IN);
    free(refs);
    free(args);
    return;
  }
  else
  {
    Timer t;
    struct tm *when;
    time_t now;
    int year, mon;
    int ref = 0;
    int start = 0;

    if (*args == '-' && !strncasecmp(args, "-ref", 4))
    {
      char *refs = nextword(cs->args, 2);
      int ref;

      if (*refs == 0 || sscanf(refs, "%d", &ref) < 1)
      {
        free(refs);
        free(args);
        CLOCK_USAGE(cs->w);
        return;
      }
      free(refs);
      start = find_pos(cs->args, 0);
      args = nextword(cs->args, 3);
    }
    t.cmd.cmd = malloc(sizeof(char) * strlen(cs->args));

    now = time(NULL);
    when = localtime(&now);
    when->tm_sec = 0;
    year = 1900 + when->tm_year;
    mon = when->tm_mon + 1;
    if (sscanf
        (args, "%d:%d:%d-%d.%d.%d", &when->tm_hour, &when->tm_min,
         &when->tm_sec, &when->tm_mday, &mon, &year) < 2
        || sscanf(cs->args + start, "%*s %*s %[^\n]\n", t.cmd.cmd) < 1)
      CLOCK_USAGE(cs->w);
    else
    {
      if (year < when->tm_year + 1900)
      {
        spx_bell(0);
        fprintf(stderr, "clock- Invalid year given: %d\n", year);
        free(t.cmd.cmd);
        free(args);
        return;
      }
      when->tm_year = year - 1900;
      when->tm_mon = mon + 1;
      t.ref = ref;
      t.type = ALARM_IN;
      t.flag = TIMER_CLOCK;
      if (add_timer(&t, (void *) when) == -1)
        error(-2, "malloc error");
    }
    free(t.cmd.cmd);
  }
  free(args);
}
#if USE_GTK
static void reload_rc_file(CmdStruct * cs)
/* from /home/tano/work/src/2704/gtk+-1.2.3/gtk/testgtk.c */
{
  GList *toplevels;

  if (gtk_rc_reparse_all())
  {
    toplevels = gdk_window_get_toplevels();
    while (toplevels)
    {
      GtkWidget *widget;

      gdk_window_get_user_data(toplevels->data, (gpointer *) & widget);
      if (widget)
        gtk_widget_reset_rc_styles(widget);
      toplevels = toplevels->next;
    }
    g_list_free(toplevels);
  }
}
#endif
/*
   s t o p             s t o p          s t o p         s t o p       
 */

void AddToHistory(const char *s)
{

  static char *cur_text = NULL;

  if (!cur_text || strcmp(cur_text, s))
  {
    History *p;

    free(cur_text);
    cur_text = strdup(s);
    p = (History *) my_malloc(sizeof(History));
    p->line = strdup(s);
    p->left = histCur;
    p->right = histCur->right;
    histCur->right->left = p;
    histCur->right = p;
  }
}
int parse_input(int i, const char *inp, int log)
{
  char *str, *buf;
  int ret;

  str = (char *) inp;
  if (*str == 0)
    return 0;
  if (!win_invalid(i) && log && (gflags & HISTORY))
  {
    AddToHistory(str);
#if USE_XFORMS
    winstruct[i].chanwin->cmd_fwd->u_ldata = (long) 0L;
#else
    gtk_object_set_data(GTK_OBJECT(winstruct[i].chanwin->cmd_fwd), "H", 0);
#endif
  }
  if (*str != cmdchar)
  {
    if (!win_invalid(i))
    {
      Winstruct *win = &winstruct[i];

      if (TO_QUOTE(win))
      {
#if _GUILE
        parse_scheme(str, i);
        return 0;
#else
        char *c, *t = NULL;

        if (*str != 0 && isspace(*str))
          unspace(str);
        if (*str == 0)
          return 0;
        if (!strncasecmp(str, "join", 4))
        {                       //  used by parse_server_output 

          c = nextword(str, 1);
          if (on_channel(win->server, c))
          {
            say2(0, i, 1, PROMPT "already on channel %s", c);
            return 0;
          }
          t = "JOIN";
          free(c);
        }
        else if (!strncasecmp(str, "mode", 4))	//  used by RPL_CHANNELMODEIS alone 
          t = "MODE";
        else if (!strncasecmp(str, "names", 5))
          t = "NAMES";
        if (t)
        {
          c = nextword(str, 1);
          if (!strncasecmp(str, "names", 5))
            addto_cmd_sent(win, t, NULL);
          else if (c && (*c == '#' || *c == '&'))
            addto_cmd_sent(win, t, c);
          free(c);
        }
        buf = (char *) alloca(sizeof(char) * (strlen(str) + 3));

        sprintf(buf, "%s\n", str);
        sendto_server(win, buf);
        return 0;
#endif
      }
      else if (TO_DCC(win))
      {
        if (win->dccCur == win->dccStart)
        {
          if (gflags & BEEP_ERR)
            spx_bell(0);
          say0(PROMPT "No DCC connection", i, 1);
        }
        else
        {
          char *buff;

          buff = (char *) malloc(sizeof(char) * (strlen(str) + 3));

          sprintf(buff, "%s\n", str);
          sendto_dcc_chat(win, win->dccCur, buff);
          free(buff);
          if (!check_msg_hook(SEND_CHATMSG, i,
                              ", %s %s %s", win->dccCur->nick,
                              win->dccCur->email ? win->dccCur->email :
                              "unknown", str))
          {
            fmt_string = "%n%c%h%p$";
            buff = format_msg(fmt_you_dccchat, win->server ?
                              win->server->nick : Name, win->dccCur->nick,
                              win->dccCur->email ? win->dccCur->
                              email : win->dccCur->nick, str);
            if (buff)
            {
              say(buff, i, 0);
              free(buff);
            }
          }
        }
        return 0;
      }
      else if (TO_ECHO(win))
      {
        say(str, i, 0);
        return 0;
      }
      else
      {
        char *cmd = NULL, *dest = 0;

        if (BUTTON_IS_ON(win->chanwin->type))
        {
#if USE_XFORMS
          cmd = (char *) fl_get_choice_text(win->chanwin->action);
          if (!cmd || *cmd == 0)
            return -1;
#else
          GtkWidget *menu;
          char *what;

          menu =
             gtk_option_menu_get_menu(GTK_OPTION_MENU(win->chanwin->action));
          what =
             (char *)
             gtk_object_get_data(GTK_OBJECT
                                 (gtk_menu_get_active(GTK_MENU(menu))),
                                 "cmd"); if (*what == '1')
            cmd = "/notice";
          else if (*what == '2')
            cmd = "/action";
          else
            cmd = "/msg";
#endif
        }
        if (TO_CHANNEL(win))
        {
          if (win->chanCur == win->chanStart)
          {
            if (gflags & BEEP_ERR)
              spx_bell(0);
            say0(PROMPT "Not on any channel", i, 1);
            return -1;
          }
          else
            dest = win->chanCur->name;
        }
        else if (TO_QUERY(win))
        {
          if (win->query_nick)
            dest = win->query_nick;
          else
          {
            if (gflags & BEEP_ERR)
              spx_bell(0);
            return 0;
          }
        }
        if (!cmd)
          cmd = "/msg";
        buf = alloca(sizeof(char) * (strlen(str) +
                                     strlen(cmd) + strlen(dest) + 4));

        sprintf(buf, "%s %s %s", cmd, dest, str);
        str = buf;
      }
    }                           //   !win_invalid(i) 

    else
    {
      say(str, -1, 1);
      return 0;
    }
  }
  else
  {
    if (*++str == 0)
      return 0;
  }
  if (*str == '!')              /* special case: the cmd '!' */
  {
    buf = alloca(sizeof(char) * (strlen(str) + 3));

    sprintf(buf, "! %s", ++str);
    str = buf;
  }
  ret = new_process_cmd(str, i);
  /*
     if str=="?;fooCmd" then ret=3 and cc="fooCmd".
   */
  if (ret--)
  {
    char *cc = nextword(str + ret, 0);

    say2(0, i, 1, PROMPT "%s: no such command", cc);
    free(cc);
    if (gflags & BEEP_ERR)
      spx_bell(0);
  }
  return 0;
}

extern int load_bi_cmds(void)
{
/* *INDENT-OFF* */
  typedef struct
  {
    char *name;
    char *help;
    void (*func) (CmdStruct *);
  } BiCmd;
  BiCmd built_in_cmds[] = {
#if USE_GTK
    {  "rcreload", "-debug- reload GTK rc file", &reload_rc_file},
#endif
    {"whatis", "display brief description of a command", &whatis_cmd},
    {"apropos", "search whatis list", &apropos_cmd} ,
    {"ignore", "specify what to ignore from names users./ig -help", &ignore_cmd},
    {"set", "change client setting", &set_cmd},
    {"history", "manipulate the command history list", &history_cmd},
    {"fwdcr", "forward DCC chat request", &fwdcr_cmd},
    {"fwdfr", "forward DCC file request", &fwdfr_cmd},
    {"server", "manipulate server entries or change server", &server_cmd} ,
    {"send", "Use DCC SEND", &send_cmd},
    {"chat", "Use DCC chat", &chat_cmd},
    {"ping", "send the std unix time to multiple recipients", &ping_cmd},
    {"query", "start a private conversation", &query_cmd},
    {"msg", "send a message to channel or person", &msg_cmd},
    {"notice", "send a notice to channel or person", &msg_cmd},
    {"nick", "change your nickname", &nick_cmd},
    {"help", "show help on a command", &help_cmd},
    {"me", "send a CTCP ACTION to a channel", &me_cmd},
    {"action", "send a CTCP ACTION to a person or channel", &action_cmd},
    {"ctcp", "send a CTCP command", &other_ctcp},
    {"reply", "manually reply to a CTCP command", &other_ctcp},
    { "encrypt", "handle encrypted messages", encrypt_cmd},
    {"motd", "Request for server message of the day", &motd_cmd},
    {"quote", "quote a command to server", &quote_cmd},
    {"who", "list users on irc or upate user list", &who_cmd},
    {"whois", "request info about person using nickname", &saved_quoted_cmds},
    {"on", "set caseless quoted hooks", &on_cmd},
    { "onc", "set quoted hooks, case-sensitive", &on_cmd},
#if REGEX_HOOKS
    {"onx", "set regex quoted hook", &on_cmd},
    {"onix", "set caseless regex quoted hook", &on_cmd},
#endif
    {":", "empty command. Does nothing.", &empty_cmd},
    {"window", "operations on channel window", &window_cmd},
    {"bell", "ring keyboard bell", &bell_cmd},
    {"whowas", "request info about person who used nickname", &saved_quoted_cmds},
    {"userhost", "ask for info about named persons", &userhost_cmd},
    {"ison", "check if persons are currently on irc", &quoted_cmds},
    {"note", "something to do with NOTE service", &quoted_cmds},
    {"away", "(un)mark yourself as being away", &away_cmd},
    {"mode", "change user or channel mode", &mode_cmd},
    {"kick", "eject somebody from a channel", &kick_cmd},
    {"invite", "invite someone to a channel", &invite_cmd},
    {"topic", "change channel topic", topic_cmd},
    {"leave", "leave a channel (see part)", part_cmd},
    {"part", "leave a channel", part_cmd},
    { "join", "join channels", &join_cmd},
    { "!", "run a shell command", &shell_cmd},
    { "lag", "force lag update", &lag_cmd},
    {"echo", "display text", &echo_cmd},
    { "quit", "quit IRC session on a server", &quit_cmd},
    { "exit", "quit irc and shutdown program", &exit_cmd},
    {  "dcc", "DCC commands", &dcc_cmd},
    {  "ln", "-debug- list nickname groups to stdout", &lnicks_cmd},
    { "connect", "create a named server connection", &connect_cmd},
    {  "run", "create a named file connection", &run_cmd},
    {  "squote", "quote to a named connection", &squote_cmd},
    {  "lastlog", "grep output log. see grep(1)", &lastlog_cmd},
    {  "fprint", "-debug- print flood list", &flood_print_cmd},
    {  "alarm", "set an alarm. please use (gs-alarm)", &alarm_cmd},
    {  "clock", "set a clock. please use (gs-clock)", &clock_cmd},
    {  "exec", "execute shell command and use output", &exec_cmd},
    {  "alias", "create substitution text", &alias_cmd},
    {  "eval", "perform subsitution and execute", &eval_cmd},
    {  "notify", "manipulate notify groups", &notify_cmd},
#if _GUILE
    { "load", "load a Guile script:/load filename", &load_cmd},
#endif
  };
/* *INDENT-ON* */

  Cmd cmd;
  int nvars = sizeof(built_in_cmds) / sizeof(BiCmd);
  int i;

  for (i = 0; i < nvars; i++)
  {
    cmd.name = built_in_cmds[i].name;
    cmd.help = built_in_cmds[i].help;
    cmd.type = CMD_BI;
    cmd.cmd.in = built_in_cmds[i].func;
    insert_bi_cmd(&cmd);
  }
  return 0;

}

extern int new_process_cmd(char *str, int i)
{
/*    str maight be trashed when this returns! */
#if _GUILE
  if (*str == '(')
    return (parse_scheme(str, i));
  else
#endif
  {
    Cmd *cmd;
    char *buf;
    int flag = (CMD_BI | CMD_SCM | CMD_ALIAS | CMD_FD);
    u_char done = 0;
    int pos = 0;

    do
    {
      switch (*str)
      {
         case '/':
           if (*(str + 1) && *(str + 1) != ' ')
           {
             flag = CMD_BI;
             str++;
             pos++;
           }
           else
             done = 1;
           break;
         case ';':
           if (*(str + 1) && *(str + 1) != ' ')
           {
             flag &= ~CMD_SCM;
             str++;
             pos++;
           }
           else
             done = 1;
           break;
         case '?':
           if (*(str + 1) && *(str + 1) != ' ')
           {
             flag &= ~CMD_ALIAS;
             str++;
             pos++;
           }
           else
             done = 1;
           break;
         case ',':
           if (*(str + 1) && *(str + 1) != ' ')
           {
             flag &= ~CMD_FD;
             str++;
             pos++;
           }
           else
             done = 1;
           break;
         default:
           done = 1;
           break;
      }
    }
    while (!(done));
    if (*str == 0)
      return 0;
    else
    {                           /* /?,msg => msg, / msg => msg */
      char *ptr = str, *start;
      int n;

      while ((*ptr == ' ' || *ptr == '\t'))
      {
        pos++;
        ptr++;
      }
      start = ptr;
      while (*ptr && (*ptr != ' ' && *ptr != '\t'))
        ptr++;

      n = ptr - start;
      buf = my_malloc(sizeof(char) * (1 + n));

      memcpy(buf, start, n);
      *(buf + n) = 0;
    }
    cmd = _find_cmd(buf, flag, 0);
    free(buf);
    if (!cmd)
      return (++pos);
    else
    {
      if (cmd->type & CMD_BI)
      {
        CmdStruct cs;
        char *tt = str + find_pos(str, 1);

        if (*tt == 0)
          cs.args = strdup(cmd->name);
        else
        {
          cs.args = (char *) my_malloc(sizeof(char) *

                                       (8 + strlen(tt) + strlen(cmd->name)));
          sprintf(cs.args, "%s %s", cmd->name, tt);
        }
        cs.w = i;
        (cmd->cmd.in) (&cs);
        free(cs.args);
      }
#ifdef _GUILE
      else if (cmd->type & CMD_SCM)
      {
#define DAT_SIZE 64
        char data[DAT_SIZE + 1];
        Scm_cmd_arg args;

        args.func = cmd->cmd.scm;
        args.args = gh_list(gh_str02scm((char *) str),
                            gh_long2scm(i), SCM_UNDEFINED);
        if (snprintf(data, DAT_SIZE, "Processing \"%s\"", (char *) str) == -1)
        {
          data[DAT_SIZE] = 0;
          strcpy(&data[DAT_SIZE - 4], "...\"");
        }
        gh_defer_ints();
        gh_catch(SCM_BOOL_T, &call_scm_command, &args,
                 (scm_catch_handler_t) & exception_handler, (void *) &data);
        gh_allow_ints();
      }
#endif
      else if (cmd->type & CMD_ALIAS)
      {
        if (cmd->cmd.text &&
            !(*(cmd->cmd.text) == ':' && *(cmd->cmd.text + 1) == 0))
        {
          buf = expand_quote(cmd->cmd.text, str, i);
          if (buf)
          {
            new_process_cmd(buf, i);
            free(buf);
          }
        }
      }
      else if (cmd->type & CMD_FD)
      {
        char port[8];
        char *name;

        if (!win_invalid(i) && winstruct[i].server
            && winstruct[i].server->fd > -1)
        {
          name = winstruct[i].server->name;
          sprintf(port, "%hu", winstruct[i].server->port);
        }
        else
        {
          name = "";
          port[0] = '\0';
        }
        buf =
           (char *) alloca(sizeof(char) *

                           (strlen(str) + MAXCMDLEN + 64 + strlen(name)));

        if (buf == NULL)
          return 0;
        rmstr((char *) str, 0);
        /*
           <id> <cmd> <server,port> <rest> 
         */
        if (*str)
          sprintf(buf, "%d %s %s,%s %s\n", i, cmd->name, name, port, str);
        else
          sprintf(buf, "%d %s %s,%s\n", i, cmd->name, name, port);
        write_to_sp(cmd->cmd.sp, buf);
        return 0;
      }
      else
      {
        assert(0);
        /*return (-1); */
      }
      return 0;
    }
  }
}

static char *char2val(char c, int w)
{

  switch (c)
  {
     case '_':                 /* window number */
       {
         char tt[20];

         sprintf(tt, "%d", w);
         return strdup(tt);
       }
     case 'N':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         return (win->server ? strdup(win->server->nick) : NULL);
       }
     case 'C':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         return (win->chanCur == win->chanStart ?
                 NULL : strdup(win->chanCur->name));}
     case 'S':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         return (win->server ? strdup(win->server->name) : NULL);
       }
     case 'P':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         if (win->server)
         {
           char tt[8];

           sprintf(tt, "%hu", win->server->port);
           return strdup(tt);
         }
         else
           return NULL;
       }
     case 'R':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         if (win->server)
         {
           char tt[16];

           sprintf(tt, "%u", win->server->read);
           return strdup(tt);
         }
         else
           return NULL;
       }
     case 'W':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         if (win->server)
         {
           char tt[16];

           sprintf(tt, "%u", win->server->wrote);
           return strdup(tt);
         }
         else
           return NULL;
       }
     default:
       return NULL;
     case 'L':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         return (win->lastPart->name ? strdup(win->lastPart->name) : 0);
       }
     case 'J':
       if (win_invalid(w))
         return NULL;
       else
       {
         Winstruct *win = &winstruct[w];

         return (win->lastJoin->name ? strdup(win->lastJoin->name) : 0);
       }
     case 'X':
       return strdup(sula_NAME);	// client name
     case 'V':
       return strdup(sula_VERSION);	// version
     case 'D':
       return strdup(sula_DESCR);	// Description
     case 'I':
       return strdup(sula_INFOSITE);	// Infosite
  }
  return NULL;
}
/*
   This routine needs to be developed into a more powerful parser.
 */
extern char *expand_quote(const char *fmt, const char *str, int w)
{
#define BUFF 1024
  size_t ll, buflen;
  register char *pp, *ptr;
  char *buf;

#define PAD 64
  buflen = BUFF + 1 + strlen(fmt) + PAD;

  buf = my_malloc2(sizeof(char) * buflen);

  if (buf == NULL)
    return NULL;
  pp = (char *) fmt;            //+find_pos((char *)fmt, 1);
  ptr = buf;
#warning Bug here. reallocate buf! buffer overflow.
  while (*pp && (*ptr = *pp) && (ptr - buf) < buflen)
  {
    pp++;
    if (*ptr == '\\' && *pp == '$')
    {
      *ptr++ = '$';
      pp++;
      continue;
    }
    if (*ptr == '$')
    {
      if (isdigit(*pp))
      {
        char t[10];
        u_short pos;

        if (sscanf(pp, "%hu", &pos) < 0)
          continue;
        sprintf(t, "%hu", pos);
        pp += strlen(t);
        if (*pp == '-')
        {
          int n;
          int len = strlen(str);

          if (*pp == '-')
            pp++;
          n = pos ? find_pos((char *) str, pos) : 0;
          if (n == len)
            continue;
          len -= n;
          memcpy(ptr, str + n, len);
          ptr += len;
        }
        else
        {
          char *p = nextword(str, pos);	//   $0=>1st word 

          if (*p)
          {
            ll = strlen(p);
            memcpy(ptr, p, ll);
            ptr += ll;
          }
          free(p);
        }
      }                         // if isdigit

      else
      {
        char name, *res;

        name = *pp;
        if (name)
          pp++;
        else
          continue;
        res = char2val(name, w);
        if (!res)
          continue;
        ll = strlen(res);
        memcpy(ptr, res, ll);
        free(res);
        ptr += ll;
      }
    }                           // if *ptr==$

    else
      ptr++;
  }                             //while

  *ptr = '\0';
  return buf;
}

static Cmd *find_it(Cmd * p, const char *name, int fullname)
{
  int c;

  if (fullname)
    while (p)
    {
      c = strcasecmp(name, p->name);
      if (c == 0)
        return p;
      else if (c < 0)
        p = p->left;
      else
        p = p->right;
    }
  else
  {
    size_t ll;

    ll = strlen(name);
    while (p)
    {
      c = strncasecmp(name, p->name, ll);
      if (c == 0)
        return p;
      else if (c < 0)
        p = p->left;
      else
        p = p->right;
    }
  }
  return NULL;
}

extern Cmd *_find_cmd(const char *name, int type, int use_fullname)
{
  Cmd *ap[] = {
    alias_cmdTree,
#if _GUILE
    scm_cmdTree,
#else
    NULL,
#endif
    fd_cmdTree, bi_cmdTree, NULL
  };
  register int i;

  assert(type & (CMD_BI | CMD_SCM | CMD_ALIAS | CMD_CTCP | CMD_FD));
  assert(!((type & (CMD_BI | CMD_SCM | CMD_ALIAS | CMD_FD)) && (type & CMD_CTCP)));	/* it must either be a CTCP or a
	   mormal command,  but not both */
  if (type & CMD_CTCP)
  {
    ap[4] = ctcp_cmdTree;
    ap[0] = ap[1] = ap[2] = ap[3] = NULL;
  }
  else
  {
    if ((type & CMD_ALIAS) == 0)
      ap[0] = NULL;
#if _GUILE
    if ((type & CMD_SCM) == 0)
      ap[1] = NULL;
#endif
    if ((type & CMD_FD) == 0)
      ap[2] = NULL;
    if ((type & CMD_BI) == 0)
      ap[3] = NULL;
  }
  for (i = 0; i <= 4; i++)
    if (ap[i])
    {
      Cmd *p = find_it(ap[i], name, 1);

      if (p)
        return p;
    }
  if (!use_fullname)
    for (i = 0; i <= 4; i++)
      if (ap[i])
      {
        Cmd *p = find_it(ap[i], name, 0);

        if (p)
          return p;
      }
  return NULL;
}

extern int _remove_cmd(const char *name, int type)
{
  static int del_cmd(pCmd * pp, Cmd * c, short *count);
/* *INDENT-OFF* */
  
  struct
  {
    Cmd **cmd;
    short *count;
  }

  ap[] =
  {
    { &alias_cmdTree, &count_alias },
#if _GUILE
    { &scm_cmdTree, &count_scm_cmds},
#else
    { NULL, 0 },
#endif
    { &fd_cmdTree, &count_fd_cmds},
    { NULL, &count_ctcp_cmds},
  };
/* *INDENT-ON* */

  register int i;

  if (type & CMD_CTCP)
  {
    ap[3].cmd = &ctcp_cmdTree;
    ap[0].cmd = ap[1].cmd = ap[2].cmd = NULL;
  }
  else
  {
    if ((type & CMD_ALIAS) == 0)
      ap[0].cmd = NULL;
#if _GUILE
    if ((type & CMD_SCM) == 0)
      ap[1].cmd = NULL;
#endif
    if ((type & CMD_FD) == 0)
      ap[2].cmd = NULL;
    ap[3].cmd = NULL;
  }
  for (i = 0; i <= 3; i++)
    if (ap[i].cmd)
    {
      Cmd *c = find_it(*(ap[i].cmd), name, 1);

      if (!c)
        continue;
      del_cmd(ap[i].cmd, c, ap[i].count);
      return 0;
    }
  return 1;
}

static void left_rotate(pCmd * pp)
{
  pCmd p = *pp, r;

  *pp = r = p->right;
  p->right = r->left;
  r->left = p;
  p->bf--;
  if (r->bf > 0)
    p->bf -= r->bf;
  r->bf--;
  if (p->bf < 0)
    r->bf += p->bf;
}
static void right_rotate(pCmd * pp)
{
  pCmd p = *pp, l;

  *pp = l = p->left;
  p->left = l->right;
  l->right = p;
  p->bf++;
  if (l->bf < 0)
    p->bf -= l->bf;
  l->bf++;
  if (p->bf > 0)
    l->bf += p->bf;
}
extern int _insert_cmd(pCmd * pp, Cmd * c, short *count)
{
  int dH = 0;
  pCmd p = *pp;
  int tt;

  if (p == NULL)
  {
    *pp = p = (pCmd) my_malloc(sizeof(Cmd));
    memcpy((void *) p, c, sizeof(Cmd));
    p->bf = 0;
    p->left = p->right = NULL;
    dH = 1;
    (*count)++;
  }
  else if ((tt = strcasecmp(c->name, p->name)) > 0)
  {
    if (_insert_cmd(&p->right, c, count))
    {
      p->bf++;
      if (p->bf == 1)
        dH = 1;
      else if (p->bf == 2)
      {
        if (p->right->bf == -1)
          right_rotate(&p->right);
        left_rotate(pp);
      }
    }
  }
  else if (tt < 0)
  {
    if (_insert_cmd(&p->left, c, count))
    {
      p->bf--;
      if (p->bf == -1)
        dH = 1;
      else if (p->bf == -2)
      {
        if (p->left->bf == 1)
          left_rotate(&p->left);
        right_rotate(pp);
      }
    }
  }
  else /*command exists */
   if (!((p->type & CMD_BI) && (p->type & CMD_CTCP) == 0))
  {
    struct TCmd *left = p->left;
    struct TCmd *right = p->right;
    short bf = p->bf;

#if _GUILE
    if (p->type & CMD_SCM)
      remove_func(p->cmd.scm);
#endif
    if (!(p->type & CMD_BI))
    {
      free(p->name);
      free(p->help);
    }
    if (p->type & CMD_ALIAS)
      free(p->cmd.text);
    memcpy((void *) p, c, sizeof(Cmd));
    p->right = right;
    p->left = left;
    p->bf = bf;
  }
  return dH;
}

#define delete_node_data(p) \
do{\
        if((p)->type&CMD_ALIAS)\
            free((p)->cmd.text);\
        if(!((p)->type&CMD_BI)){\
            free((p)->name);\
            if((p)->help) free((p)->help);\
          }\
}while(0)

static int del_cmd(pCmd * pp, Cmd * c, short *count)
{
  pCmd p = *pp, *q;
  int dH = 0;
  int tt;

  if (!p)
    return 0;
  if ((tt = strcasecmp(c->name, p->name)) < 0)
  {
    if (del_cmd(&p->left, c, count))
    {
      p->bf++;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == 2)
      {
        if (p->right->bf == -1)
          right_rotate(&p->right);
        left_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else if (tt > 0)
  {
    if (del_cmd(&p->right, c, count))
    {
      p->bf--;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == -2)
      {
        if (p->left->bf == 1)
          left_rotate(&p->left);
        right_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else
  {
    (*count)--;
    if (p->right == NULL)
    {
      *pp = p->left;
#if _GUILE
      if ((p)->type & CMD_SCM)
        remove_func((p)->cmd.scm);
#endif
      delete_node_data(p);
      free(p);
      p = NULL;
      return 1;
    }
    else if (p->left == NULL)
    {
      *pp = p->right;
#if _GUILE
      if ((p)->type & CMD_SCM)
        remove_func((p)->cmd.scm);
#endif
      delete_node_data(p);
      free(p);
      p = NULL;
      return 1;
    }
    else
    {
      Cmd *foo = my_malloc(sizeof(Cmd));
      struct TCmd *left, *right;

      memcpy((void *) foo, p, sizeof(Cmd));
      (*count)++;
      q = &p->left;
      while ((*q)->right != NULL)
        q = &(*q)->right;
      left = p->left;
      right = p->right;
      memcpy((void *) p, (*q), sizeof(Cmd));
      p->left = left;
      p->right = right;
      left = (*q)->left;
      right = (*q)->right;
      memcpy((void *) (*q), foo, sizeof(Cmd));
      (*q)->left = left;
      (*q)->right = right;
      if (del_cmd(&p->left, foo, count))
      {
        p->bf++;
        if (p->bf == 0)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            right_rotate(&p->right);
          left_rotate(pp);
          dH = 1;
        }
      }
      free(foo);
    }
  }
  return dH;
}
