/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/

/* 
   common-chanwin_cb.c: Main callbacks for channel window.
   Used by all versions of Sula Primerix.
   Author: Tano Fotang 1997, 1998, 1999

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "spx.h"
#include <sys/time.h>
#include <stdarg.h>
#include "server.h"
#include "dcc.h"
#include "ignore.h"
#include "setting.h"
#include "cmd.h"
#include "lag.h"
#include "config.h"
#include "hooks.h"

Winstruct *winstruct = NULL;
short win_count = 0;
char *input_line = NULL;
extern int del_user(pChanUser * pp, const char *nick);

#if USE_XFORMS
extern SPX_font editor_fontstyle;

#include "closed.xpm"
#include "connected.xpm"
#include "info.xpm"
#include "here.xpm"
#include "away.xpm"
#endif
#if 0
void send_blocktxt(int w, const char *text, int flag)
{
/* send text containin newlines. almost like multiline msg except hthat msg * 
   is sent line after line here
   if flag: add to cmd log */
  char *ptr;
  char *buf = (char *) text;

  if (*buf == 0)
    return;
  while (buf)
  {
    ptr = strsep(&buf, "\n");
    parse_input(w, ptr, flag);
  }
}
#endif
extern void update_topic(Winstruct * win,
                         const char *channel, const char *topic)
{

  if (!strcasecmp(channel, win->chanCur->name))
  {
    char *buf = malloc(sizeof(char) * (strlen(channel) + strlen(topic) + 8));

    sprintf(buf, "%s: %s", channel, topic);
    fit_object_label(win->chanwin->WinStatusLine, buf);
    free(buf);
  }
}

void UpdateStatus(Winstruct * win)
{
  if (win->flag & WIN_UPDATING_STATUS)
  {
    if (gflags & VERBOSE_CLIENT)
      say2(0, -1, -1, "Warning: recursive statusline update");
    return;
  }
  if (!check_msg_hook(UPDATE_STATUS, win - winstruct, ""))
  {
    /*
       DO NOT return without setting win->flag &= ~WIN_UPDATING_STATUS
     */
    char *buf;
    int isserverop;

    win->flag |= WIN_UPDATING_STATUS;
    if (win->server)
    {
      int ischanop = 0, cantalk = 0;
      char *chanmode = NULL, *mymode = NULL;
      char *query = NULL;
      char *t = NULL, *s = NULL;
      char has_channels = 0;
      char *dcc_chat = NULL;

      buf = (char *) my_malloc(sizeof(char) * 1024);

      if (MaxNickLen < 1)
        MaxNickLen = 1;
      if (MaxChanLen < 1)
        MaxChanLen = 1;
      isserverop = (win->server->mode
                    && strchr(win->server->mode, 'o')) ? 1 : 0;
      if (win->server->mode)
      {
        char *tt = strdchr(win->server->mode, 'o');
        mymode = malloc(sizeof(char) * (strlen(win->server->mode) + 12));

        if (tt && *tt)
          sprintf(mymode, "  (+%s) ", tt);
        else
          strcpy(mymode, "");
        free(tt);
      }
      else
        mymode = strdup("");
      if (win->chanCur == win->chanStart
          || win->chanStart->left == win->chanStart)
      {
        /*  not on a channel (empty channel list) */
        sprintf(buf, "%s%s%s",
                strcp(win->server->nick, MaxNickLen), (isserverop) ? "*" : "",
                mymode);
      }
      else
      {
        has_channels = 1;
        ischanop = (win->chanCur->modes && strchr(win->chanCur->modes, 'o'));
        cantalk = (win->chanCur->modes && strchr(win->chanCur->modes, 'v'));
        t = (char *) malloc(sizeof(char) * 40);

        if (win->chanCur->limit)
          sprintf(t, " <limit: %d>", win->chanCur->limit);
        else
          strcpy(t, " ");
        if (win->chanCur->key)
        {
          s =

             (char *) malloc(sizeof(char) * (strlen(win->chanCur->key) + 10));

          sprintf(s, " <key: %s>", win->chanCur->key);
        }
        if (win->chanCur->modes)
        {
          char *tmp = strdup(win->chanCur->modes);
          chanmode =
             (char *) malloc(sizeof(char) *

                             (strlen(win->chanCur->modes) + 10));

          if (ischanop)
            tmp = strdchr(tmp, 'o');
          if (cantalk)
            tmp = strdchr(tmp, 'v');
          if (*tmp)
            sprintf(chanmode, " (+%s) ", tmp);
          else
            strcpy(chanmode, "");
          free(tmp);
        }
        if (win->chanCur->topic)
          update_topic(win, win->chanCur->name, win->chanCur->topic);
        else
          update_topic(win, win->chanCur->name,
                       "No topic is set (" sula_NAME " " sula_VERSION ")");
      }
      if (TO_QUERY(win) && win->query_nick)
      {
        query =

           (char *) malloc(sizeof(char) * (strlen(win->query_nick) + 15));

        sprintf(query, " [Query: %s]", win->query_nick);
      }
      else if (                 // fl_get_button(win->chanwin->r_dcc_chat) && 
                win->dccCur != win->dccStart &&
                win->dccStart->left != win->dccStart)
      {
        dcc_chat =

           (char *) malloc(sizeof(char) * (strlen(win->dccCur->nick) + 15));

        sprintf(dcc_chat, " [DCC chat: %s]", win->dccCur->nick);
      }
      if (has_channels)
      {
        char c[4];
        int i = 0;

        if (isserverop)
          c[i++] = serveropChar;
        if (ischanop)
          c[i++] = chanopChar;
        if (cantalk && !ischanop)
          c[i++] = chanvoiceChar;
        c[i] = 0;
        sprintf(buf, "%s%s%s%s%s on %s%s%s%s",
                strcp(win->server->nick, MaxNickLen),
                c[0] != 0 ? c : "", mymode,
                query ? query : "", dcc_chat ? dcc_chat : "",
                strcp(win->chanCur->name, MaxChanLen),
                chanmode ? chanmode : "", t ? t : "", s ? s : "");
      }
      else
      {
        char c[2];

        c[0] = 0;
        c[1] = 0;
        if (isserverop)
          c[0] = serveropChar;
        sprintf(buf, "%s%s%s%s%s%s",
                (!query
                 && !dcc_chat) ? "[" sula_NAME " " sula_VERSION "]  " : "",
                strcp(win->server->nick, MaxNickLen), c[0] ? c : "", mymode,
                query ? query : "", dcc_chat ? dcc_chat : "");
      }
      free(t);
      free(mymode);
      free(dcc_chat);
      free(query);
      free(s);
      free(chanmode);
    }                           /*  if( win->server) */
    else if (TO_DCC(win) && win->dccCur != win->dccStart &&
             win->dccStart->left != win->dccStart)
    {
      buf = (char *) malloc(sizeof(char) * (32 + strlen(win->dccCur->nick)));

      sprintf(buf, " [DCC chat with %s]", win->dccCur->nick);

    }
    else
    {
      srandom(time(NULL));
      buf =
         strdup(random() %
                2 ? "Infoterial: " sula_INFOSITE : "Type /help for help");
    }
    fit_object_label(win->chanwin->status, buf);
    check_msg_hook(UPDATE_STATUS_DONE, win - winstruct, buf);
    free(buf);
    win->flag &= ~WIN_UPDATING_STATUS;
  }
}
#if USE_GTK
static void clear_popup_item(Winstruct * win)
{
  if (win->chanStart->right != win->chanStart)
  {
    Channel *p;
    char *buf;
    GtkItemFactory *ifactory =
       gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin),
                           "popup");

    p = win->chanStart->right;
    while (p != win->chanStart)
    {
      buf = malloc(sizeof(char) * (strlen(p->name) + 9));

      sprintf(buf, "/Part/%s", p->name);
      gtk_item_factory_delete_item(ifactory, buf);
      free(buf);
      p = p->right;
    }
  }
}
#endif
extern void recreate_chanusers_channels(Winstruct *);
void UpdateWindows(int fd, char connected)
{
/* 
 * update windows status displays upon establishing or closing down a
 * connection */
  WinList *p;

  if (fd < 0)
    return;
  build_winlistbyfd(fd);
  p = servWin;
  if (p)
  {
    char *buf2;
    char *title;
    Winstruct *win = winstruct + p->w;
    title = alloca(sizeof(char) * (64 + strlen(win->server->alias) +
                                   strlen(sula_NAME)));

    sprintf(title, "[%d] " sula_NAME ": %s %hu [%s]",
            win - winstruct,
            win->server->alias,
            win->server->port, connected ? "open" : "closed");

    buf2 = alloca(sizeof(char) * (64 + strlen(win->server->alias)));

    if (connected)
      sprintf(buf2, "You are now on IRC (via %s, port %hu).",
              win->server->alias, win->server->port);
    else
      sprintf(buf2, "Connection to server %s (port %hu) closed",
              win->server->alias, win->server->port);

    while (p)
    {
      Winstruct *win = winstruct + p->w;

#if USE_GTK
      GtkItemFactory *ifactory =
         gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin),
                             "popup");

      recreate_chanusers_channels(win);
      load_userlist(win, NULL, 0);
      hide_chanusers_channel(win, 1);
#endif

      SET_WINDOW_TITLE(win->chanwin->chanwin, title);
      if (connected)
      {
        fit_object_label(win->chanwin->WinStatusLine, buf2);
        UpdateStatus(win);
#if USE_GTK
        gtk_widget_set_sensitive(gtk_item_factory_get_item(ifactory, "/Part"),
                                 TRUE);
#endif
#if USE_XFORMS
        fl_set_pixmapbutton_data(win->chanwin->info, info_xpm);
        fl_show_object(win->chanwin->info);
        fl_free_pixmapbutton_pixmap(win->chanwin->close_con);
        fl_set_pixmapbutton_data(win->chanwin->close_con, connected_xpm);
        fl_set_pixmapbutton_data(win->chanwin->away,
                                 win->server->
                                 flag & SET_AWAY ? away_xpm : here_xpm);
        fl_show_object(win->chanwin->away);
#endif

      }
      else
      {
        CmdSent *cc = cmdsentStart;

        fit_object_label(win->chanwin->WinStatusLine, buf2);
#if USE_GTK
        clear_popup_item(win);
        gtk_widget_set_sensitive(gtk_item_factory_get_item(ifactory, "/Part"),
                                 FALSE);
#endif

#if USE_XFORMS
        fl_hide_object(win->chanwin->info);
        fl_free_pixmapbutton_pixmap(win->chanwin->info);

        fl_hide_object(win->chanwin->away);
        fl_free_pixmapbutton_pixmap(win->chanwin->away);

        fl_free_pixmapbutton_pixmap(win->chanwin->close_con);
        fl_set_pixmapbutton_data(win->chanwin->close_con, closed_xpm);
        if (win->server->connecting > 0)
        {
          fl_activate_object(win->chanwin->close_con);
          fl_set_object_color(win->chanwin->close_con, FL_COL1, FL_MCOL);
        }
        if (win->chanwin->chanusers->u_vdata)
        {
          FD_chanusers *f = (FD_chanusers *) win->chanwin->chanusers->u_vdata;

          fl_clear_choice(f->channel);
          fl_clear_browser(f->browser);
        }
#endif
        while (cc != cmdsentEnd)
          if (winstruct + cc->w == win)
          {
            CmdSent *q = cc->next;

            free(cc->cmd);
            if (cc->arg)
              free(cc->arg);
            if (q == cmdsentEnd)
              cmdsentEnd = cc;
            else
              *cc = *q;
            free(q);
          }
          else
            cc = cc->next;
      }
      p = p->next;
    }
  }
}

#if USE_XFORMS
#define free_pups(win) \
do{\
   fl_freepup(*((int *) (win)->chanwin->file_menu->u_ldata));\
   fl_freepup(*((int *) (win)->chanwin->file_menu->u_ldata + 1));\
   fl_freepup(*((int *) (win)->chanwin->file_menu->u_ldata + 2));\
   fl_freepup((int) (win)->chanwin->help_menu->u_ldata);\
   fl_freepup((win)->chanwin->go_menu->u_ldata);\
   fl_freepup((win)->chanwin->bookmark_menu->u_ldata);\
   fl_freepup((win)->chanwin->edit_menu->u_ldata);\
   fl_freepup((win)->chanwin->window_menu->u_ldata);\
}while(0)
#endif
void _destroy_window(Winstruct * win, int force)
{
/* destroy a channel window, removing it from the list. if it's the only 
   window on a server, close connection as well. server isnt removed from
   server list. */
  int stop = 0;

  if (!force)
  {
    if (win->flag & WIN_BEING_DESTROYED)
    {
      if (gflags & VERBOSE_CLIENT)
        say2(0, -1, -1, "Warning: recursive destroy for %p", win - winstruct);
      return;
    }
    win->flag |= WIN_BEING_DESTROYED;
    stop = check_msg_hook(WINDOW_DESTROY, win - winstruct, "");
    win->flag &= ~WIN_BEING_DESTROYED;
  }
  if (!stop)
  {

    Go *p = win->goStart;
    DCCChat *current;
    int flags = gflags;

    win->flag |= WIN_BEING_DESTROYED;
    gflags &= ~SHOW_TIPS;       /* xforms < 0.87.5: disenable post handler */
    if (win->server)
    {
      CmdSent *p = cmdsentStart;
      int x;

      search_winlist_byservname(win->server->name, win->server->port, &x);
      assert(x);                /* this is fatal error since win!=NULL */
      if (x == 1)
      {
        if (win->server->fd > -1)
        {
          new_process_cmd("/quit -f", win - winstruct);
          close_server_connection(win->server->g, &win->server->fd);
        }
        win->server->state = -1;
        win->server->w = -1;
      }
      else if (win->server->fd > -1)
      {
        int zz = 0;
        Channel *chan;

        chan = win->chanStart->left;
        while (chan != win->chanStart && zz == 0)
        {
          char *buf = malloc(sizeof(char) * (10 + strlen(chan->name)));

          sprintf(buf, "PART %s\n", chan->name);
          zz = sendto_server(win, buf);
          free(buf);
          chan = chan->left;
        }
        if (winstruct + win->server->w == win)
          for (zz = 0; zz < win_count; zz++)
            if (winstruct[zz].server && winstruct[zz].server == win->server)
            {
              win->server->w = zz;
              SET_BUTTON(winstruct[zz].chanwin->lead, 1);
              break;
            }
        while (p != cmdsentEnd)
          if (p->w + winstruct == win)
          {
            CmdSent *q = p->next;

            free(p->cmd);
            free(p->arg);
            if (q == cmdsentEnd)
              cmdsentEnd = p;
            else
              *p = *q;
            free(q);
          }
          else
            p = p->next;
      }
    }
#if USE_XFORMS
    if (win->chanwin->minput->u_vdata)
    {
      if (((FD_minput *) win->chanwin->minput->u_vdata)->minput->visible)
        fl_hide_form(((FD_minput *) win->chanwin->minput->u_vdata)->minput);
      fl_free_form(((FD_minput *) win->chanwin->minput->u_vdata)->minput);
    }
    if (win->chanwin->find->u_vdata)
    {
      fl_hide_form(((FD_find *) win->chanwin->find->u_vdata)->find);
      fl_free_form(((FD_find *) win->chanwin->find->u_vdata)->find);
    }
    if (win->chanwin->chanusers->u_vdata)
    {
      fl_hide_form(((FD_chanusers *) win->chanwin->chanusers->u_vdata)->
                   chanusers);
      fl_free_form(((FD_chanusers *) win->chanwin->chanusers->u_vdata)->
                   chanusers);
    }
#endif
    current = win->dccStart->left;
    while (current != win->dccStart)
    {
      remove_dccchat(current->id, NULL);
      current = current->left;
    }
    while (p != win->goEnd)
    {
      Go *q = p->next;

      free(p->name);
      if (p->key)
        free(p->key);
      if (q == win->goEnd)
        win->goEnd = p;
      else
        *p = *q;
      free(q);
    }
    free(p);
    ClearWinChanList(win);
    free(win->chanStart);
#if USE_XFORMS
    free_pups(win);
    fl_hide_form(win->chanwin->chanwin);
    fl_free_form(win->chanwin->chanwin);
#else
    {
      free(gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin),
                               "file_menu_data"));
      gtk_widget_destroy(win->chanwin->chanwin);
    }
#endif
    gflags = flags;
    if (win->query_nick)
      free(win->query_nick);
    winstruct[win - winstruct].chanwin = NULL;
    if (!(gflags & CTRL_WIN_SHOWN))
    {
      /* show control window if this was the last channel window */
      for (flags = 0; flags < win_count; flags++)
        if (winstruct[flags].chanwin)
          break;
      if (flags == win_count)
      {
#if USE_XFORMS
        fl_show_form(main_window->main_form, FL_PLACE_FREE, FL_FULLBORDER,
                     sula_NAME " " sula_VERSION ": Control");
#else
        gtk_widget_show(main_window->main_window);
#endif
        gflags |= CTRL_WIN_SHOWN;
      }
    }
    win->flag &= ~WIN_BEING_DESTROYED;
  }
}

void ClearWinChanList(Winstruct * win)
{
  Channel *p, *next;

#if USE_GTK
  GtkItemFactory *ifactory = NULL;
  char *buf;
#endif
  assert(win);
  p = win->chanStart->right;
#if USE_GTK

  if (p != win->chanStart)
    ifactory = gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin),
                                   "popup");
#endif
  while (p != win->chanStart)
  {
    User *u = p->userStart, *v;

    next = p->right;
    while (u != p->userEnd)
    {
      del_user(&p->users, u->nick);
      free(u->nick);
      free(u->address);
      free(u->ircname);
      v = u->next;
      if (v == p->userEnd)
        p->userEnd = u;
      else
        *u = *v;
      free(v);
    }
    free(u);
#if USE_GTK
    buf = malloc(sizeof(char) * (strlen(p->name) + 9));

    sprintf(buf, "/Part/%s", p->name);
    gtk_item_factory_delete_item(ifactory, buf);
    free(buf);
#endif
    p->left->right = p->right;
    p->right->left = p->left;
    free(p);
    p = next;
  }
  win->chanStart->left = win->chanStart->right = win->chanCur =
     win->chanStart;
}

#define WIN_ALLOC 3
static void win_alloc()
{
  int i;

  if (winstruct == NULL)
    winstruct = my_malloc(sizeof(Winstruct) * WIN_ALLOC);
  else
    winstruct =
       my_realloc(winstruct, (win_count + WIN_ALLOC) * sizeof(Winstruct));
  for (i = win_count; i < win_count + WIN_ALLOC; i++)
  {
    winstruct[i].chanwin = NULL;
    winstruct[i].server = NULL; /* new_process_cmd needs this */
  }
  win_count += WIN_ALLOC;
}

extern void go_menu_setup(Winstruct *);

Winstruct *new_chan_win(void)
{
  int i;

  if (winstruct == NULL)
    win_alloc();
retry:
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin == NULL)
    {
      Winstruct *win;
      Go *p;

      win = &winstruct[i];

      win->chanwin = create_chanwin(win);
      win->flag = 0;
      win->server = NULL;

      win->chanStart = (Channel *) my_malloc(sizeof(Channel));
      win->chanStart->left = win->chanStart->right = win->chanCur =
         win->chanStart;
      win->dccStart = (DCCChat *) my_malloc(sizeof(DCCChat));
      win->dccStart->left = win->dccStart->right = win->dccCur =
         win->dccStart;
      win->lastJoin = (NoChannel *) my_malloc(sizeof(NoChannel));
      win->lastPart = (NoChannel *) my_malloc(sizeof(NoChannel));
      win->lastJoin->name = NULL;
      win->lastJoin->key = NULL;
      win->lastPart->name = NULL;
      win->lastPart->key = NULL;
      win->goStart = win->goEnd = (Go *) my_malloc(sizeof(Go));
      p = win->goStart;
      win->goStart = (Go *) my_malloc(sizeof(Go));
      win->goStart->name = strdup("#sula");	/* okay.otherwise free() gets stuck */
      win->goStart->key = NULL;
      win->goStart->next = p;
      win->query_nick = NULL;
      SET_BUTTON(win->chanwin->history, sflags & LOG);
#if USE_XFORMS
      set_object_attribs(&winstruct[i]);
      go_menu_setup(win);
#elif USE_GTK
      gtk_object_set_data(GTK_OBJECT(win->chanwin->status), "gone", (gpointer) 0);	/* no of entries in Go_menu */
      go_menu_setup(win);
#endif
      return (&winstruct[i]);
    }
  win_alloc();
  goto retry;

}

static void duplicate_win(Winstruct * w)
{
#if USE_XFORMS
#include "info.xpm"
#include "here.xpm"
#include "away.xpm"
#include "connected.xpm"
#endif
/* duplicate a channel window */
  Winstruct *win;
  int ww = w - winstruct;
  char *label = NULL;

  win = new_chan_win();
  w = winstruct + ww;           /*if winstruct was realloc'd in new_chan_win,
                                   then w no longer points to the right space, hence the integer
                                   index ww is used */
  if (w->server)
  {
    win->server = w->server;

    label = (char *) malloc(sizeof(char) *
                            (strlen(win->server->name) +
                             strlen(sula_NAME " " sula_VERSION) + 32));

    sprintf(label, "[%d] " sula_NAME " " sula_VERSION ": %s %d",
            win - winstruct, win->server->alias, win->server->port);

    if (win->server->fd > -1)
    {
      if (!win->server->connecting ||
#if USE_XFORMS
          win->chanwin->close_con->u_vdata
#elif USE_GTK
          gtk_object_get_data(GTK_OBJECT(win->chanwin->close_con),
                              "connecting")
#endif
          /*getting hostname */ )
      {
#if USE_GTK
        GtkItemFactory *ifactory;

        gtk_tooltips_set_tip(tooltips, win->chanwin->close_con, "disconnect",
                             NULL);
        ifactory =
           gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin), "popup");
        gtk_widget_set_sensitive(gtk_item_factory_get_item(ifactory, "/Part"),
                                 TRUE);

#endif
#if USE_XFORMS
        fl_set_pixmapbutton_data(win->chanwin->info, info_xpm);
        fl_show_object(win->chanwin->info);
        fl_free_pixmapbutton_pixmap(win->chanwin->close_con);
        fl_set_pixmapbutton_data(win->chanwin->close_con, connected_xpm);
        fl_set_pixmapbutton_data(win->chanwin->away,
                                 win->server->
                                 flag & SET_AWAY ? away_xpm : here_xpm);
        fl_show_object(win->chanwin->away);
#endif

      }
      else
      {
#if USE_XFORMS
        fl_deactivate_object(win->chanwin->close_con);
        fl_set_object_color(win->chanwin->close_con,
                            FL_INACTIVE_COL, FL_MCOL);
#endif
      }
    }
  }
  else
  {
    win->server = NULL;
    label =
       (char *) malloc(sizeof(char) *

                       (strlen(sula_NAME " " sula_VERSION) + 32));

    sprintf(label, "[%d] " sula_NAME " " sula_VERSION
            ": No server connection", (win - winstruct));
  }
  show_chanwin(win, &label, 1, 1);

}
void show_chanwin(Winstruct * win, char **s, int show_form, int do_form)
{
  if (show_form)
  {

    char free_s = (*s == NULL);

    if (*s == NULL)
    {
      *s = malloc(sizeof(char) * (strlen(sula_NAME " " sula_VERSION) + 32));

      sprintf(*s, "[%d] " sula_NAME " " sula_VERSION
              ": No server connection", (win - winstruct));
    }
#if USE_XFORMS
    fl_show_form(win->chanwin->chanwin,
                 FL_PLACE_FREE | FL_FREE_SIZE, FL_FULLBORDER, *s);
#else
    SET_WINDOW_TITLE(win->chanwin->chanwin, *s);
    gtk_widget_show(win->chanwin->chanwin);
#endif
    if (free_s)
      free(*s);
  }
  UpdateStatus(win);
  if (do_form)
  {
    check_msg_hook(WINDOW_CREATE, win - winstruct, "");
#if USE_XFORMS
    fl_do_forms();
#endif
  }
}

/* 
 *    CALLBACKS
 */
#if USE_XFORMS
#define reset_focus(__win) ;
/*do{}while(0) */
#else
#define reset_focus(__w) gtk_widget_grab_focus((__w)->chanwin->sinput)
#endif

void radio_cb(SPX_OBJ(ob), SPX_DATA(data))
{

  Winstruct *win = WINSTRUCT(ob);

  switch ((long) data)
  {
     case 0:
       SET_RADIO(win->chanwin->r_quote, 0);
       break;
     case 1:
       if (!win->server || win->server->fd < 0 || !win->query_nick)
         SET_RADIO(win->chanwin->r_echo, 1);
       else
         SET_RADIO(win->chanwin->r_query, 0);
       break;
     case 2:
       if (win->chanCur == win->chanStart)
         SET_RADIO(win->chanwin->r_echo, 1);
       else
         SET_RADIO(win->chanwin->r_channel, 0);
       break;
     case 3:
       if (win->dccCur == win->dccStart)
         SET_RADIO(win->chanwin->r_echo, 1);
       else
         SET_RADIO(win->chanwin->r_dcc_chat, 0);
       break;
     case 4:
       SET_RADIO(win->chanwin->r_echo, 0);
       break;
  }
  reset_focus(win);
  UpdateStatus(win);
}
#if USE_XFORMS

#endif
void chanwin_cb(SPX_OBJ(ob), SPX_DATA(data))
{
  Winstruct *win = WINSTRUCT(ob);

#if USE_XFORMS
// urgent todo:move out of this file
  extern void find_text(FL_OBJECT * ob);
  extern void delete_lines(FL_OBJECT * browser);
  extern int get_clipboard_cb(FL_OBJECT *, long, const void *, long);
  extern int get_send_clipboard_cb(FL_OBJECT *, long, const void *, long);
  extern void find(Winstruct * win);
  extern void edit_browser(FL_OBJECT * browser, int cut);
#endif

  switch ((long) data)
  {

     case 0:
       {                        /* sinput */
         const char *str = spx_get_input(ob);

         if (*str)
         {
           int id = win - winstruct;
           int stop;

           input_line = strdup(str);
           spx_set_input(ob, "");	/* this must be done now */
           sflags |= s_DOING_INPUT_HOOK;
           stop = check_msg_hook(INPUT, id, "%s", input_line);
           sflags &= ~s_DOING_INPUT_HOOK;
           if (!stop)
             if (input_line)
             {
               parse_input(id, input_line, 1);
               free(input_line);
             }

         }
       }
       return;
#if USE_XFORMS
     case 41:                  /* cut */
       switch (fl_mouse_button())
       {
          case FL_MIDDLEMOUSE:
            edit_browser(win->chanwin->brow2, 1);
            break;
            break;
          default:
            edit_browser(win->chanwin->browser, 1);
            break;
            break;
       }
       break;

     case 40:                  /* copy */
       switch (fl_mouse_button())
       {
          case FL_MIDDLEMOUSE:
            edit_browser(win->chanwin->brow2, 0);
            break;
            break;
          default:
            edit_browser(win->chanwin->browser, 0);
            break;
            break;
       }
       break;

     case 42:                  /* delete */
       switch (fl_mouse_button())
       {
          case FL_MIDDLEMOUSE:
            delete_lines(win->chanwin->brow2);
            break;
            break;
          default:
            delete_lines(win->chanwin->browser);
            break;
            break;
       }
       break;
     case 43:                  /* paste */
       switch (fl_mouse_button())
       {
          case FL_LEFTMOUSE:
            fl_request_clipboard(win->chanwin->clock, FL_STRING,
                                 get_send_clipboard_cb);
            break;
          case FL_MIDDLEMOUSE:
            fl_request_clipboard(win->chanwin->browser, FL_STRING,
                                 get_clipboard_cb);
            break;
          default:
            fl_request_clipboard(win->chanwin->brow2, FL_STRING,
                                 get_clipboard_cb);
            break;
       }
       break;
     case 4:
       {                        /* find */
         find(win);
         break;
       }
     case 5:                   /* info */
       break;
#endif //USE_XFORMS
     case 6:
       if (!win->server)
       {
         if (gflags & BEEP_ERR)
           spx_bell(0);
         break;
       }
       else
       {                        /* away */
         char *msg = (char *) spx_get_input(win->chanwin->sinput);
         char *buf;

         if (!(win->server->flag & SET_AWAY))
         {
           if (!(*msg))
             msg = away_text;
         }
         else if (!(*msg))
           msg = NULL;
         if (!msg)
           buf = strdup("away");
         else
         {
           buf = (char *) malloc(sizeof(char) * (strlen(msg) + 8));

           sprintf(buf, "away %s", msg);
           spx_set_input(win->chanwin->sinput, "");
         }
         if (process_cmd(buf, win))
           spx_writeln(win->chanwin->brow2, PROMPT "away failed!");
         free(buf);
         break;
       }
     case 7:                   /* (dis)connect */
       if (!win->server)
       {
         spx_writeln(win->chanwin->brow2,
                     PROMPT "Window has no server. Use /server to connect");
         if (gflags & BEEP_ERR)
           spx_bell(0);
       }
       else if (win->server->fd < 0)
         connect_to_server(win->server, win, NULL, 0);
       else
         new_process_cmd("quit", win - winstruct);
       break;
     case 8:
       /* lead window */
       if (win->server)
       {
         //static *Server *server=NULL;
         WinList *p;

         if (win->server->flag & CHANGING_W)
           break;
         win->server->flag |= CHANGING_W;
         if (!BUTTON_IS_ON(ob))
         {
           win->server->flag &= ~CHANGING_W;
           SET_BUTTON(ob, 1);
           win->server->w = win - winstruct;
           break;
         }
         win->server->w = win - winstruct;
         build_winlistbyservname(win->server->name, win->server->port);
         p = servWin;
         while (p)
         {
           if (winstruct + p->w != win)
             if (BUTTON_IS_ON(winstruct[p->w].chanwin->lead))
               SET_BUTTON(winstruct[p->w].chanwin->lead, 0);
           p = p->next;
         }
         win->server->flag &= ~CHANGING_W;
       }
       else
       {
         if (gflags & BEEP_ERR)
           spx_bell(0);
         SET_BUTTON(ob, 0);
       }
       break;
     case 11:                  /* lag */
       if (!win->server || win->server->fd < 0)
       {
         fit_object_label(win->chanwin->WinStatusLine,
                          "You are not connected to a server");
       }
       else
         send_lag_junk(win->server, 1, 1);
       break;

     case 14:
       {
         static char active = 0;

         if (active)
           return;
         active = 1;
         if (logFp != NULL)
         {
           int i;
           int id = win - winstruct;

           if (BUTTON_IS_ON(win->chanwin->history))
             sflags |= LOG;
           else
             sflags &= ~LOG;
           for (i = 0; i < win_count; i++)
             if (winstruct[i].chanwin)
             {
               gtk_tooltips_set_tip(tooltips,
                                    winstruct[i].chanwin->history,
                                    (sflags & LOG) ? "suspend logging" :
                                    "resume logging", NULL);
               if (i != id)
                 SET_BUTTON(winstruct[i].chanwin->history, sflags & LOG);
             }
         }
         else
         {
           SET_BUTTON(win->chanwin->history, 0);
           if (gflags & VERBOSE_CLIENT)
             say(PROMPT "first /SET logging on", win - winstruct, 1);
           if (gflags & BEEP_ERR)
             spx_bell(-60);
         }
         active = 0;
       }
       break;
     default:
       break;
     case 30:
       {                        /* cmd fwd */
#if USE_XFORMS
         History *hist = (History *) ob->u_ldata;

#elif USE_GTK
         History *hist = (History *) gtk_object_get_data(GTK_OBJECT(ob), "H");
#endif
         if (hist == NULL)
           hist = histCur;
         else
           hist = hist->right;
         if (hist == histStart)
           hist = hist->right;
#if USE_XFORMS
         ob->u_ldata = (long) hist;
#elif USE_GTK
         gtk_object_set_data(GTK_OBJECT(ob), "H", hist);
#endif
         if (hist == histStart) /*empty list */
           break;
         spx_set_input(win->chanwin->sinput, hist->line);
       }
       break;
     case 31:
       {
#if USE_XFORMS
         History *hist =

            (History *) ((FD_chanwin *) ob->form->fdui)->cmd_fwd->u_ldata;

#elif USE_GTK
         History *hist =
            (History *) gtk_object_get_data(GTK_OBJECT(win->chanwin->cmd_fwd),
                                            "H");
#endif
         if (hist == NULL)
           hist = histCur;
         else
           hist = hist->left;
         if (hist == histStart)
           hist = hist->left;
#if USE_XFORMS
         ((FD_chanwin *) ob->form->fdui)->cmd_fwd->u_ldata = (long) hist;
#elif USE_GTK
         gtk_object_set_data(GTK_OBJECT(win->chanwin->cmd_fwd), "H", hist);
#endif
         if (hist != histStart)
           spx_set_input(win->chanwin->sinput, hist->line);
       }
       break;
     case 33:
       {                        /* chan_right */
         if (TO_CHANNEL(win))
         {
           win->chanCur = win->chanCur->right;
#if USE_XFORMS
           if (fl_mouse_button() == FL_MIDDLEMOUSE)
             win->dccCur = win->dccCur->right;
           if (win->dccCur == win->dccStart)
             win->dccCur = win->dccCur->right;
#endif
           if (win->chanCur == win->chanStart &&
               (win->chanCur = win->chanCur->right) == win->chanStart
               && win->dccCur == win->dccStart)
             break;             /* empty channel list */
         }
         else if (TO_DCC(win))
         {
           win->dccCur = win->dccCur->right;
#if USE_XFORMS
           if (fl_mouse_button() == FL_MIDDLEMOUSE)
             win->chanCur = win->chanCur->right;
           if (win->chanCur == win->chanStart)
             win->chanCur = win->chanCur->right;
#endif
           if (win->dccCur == win->dccStart &&
               (win->dccCur = win->dccCur->right) == win->dccStart &&
               win->chanCur == win->chanStart)
             break;             /* no dcc chat connections, no channels */
         }
         else
         {
           /* if(fl_get_button(win->chanwin->r_channel)) */
           win->chanCur = win->chanCur->right;
           if (win->chanCur == win->chanStart &&
               (win->chanCur = win->chanCur->right) == win->chanStart)
             break;             /* empty channel list */
         }
         UpdateStatus(win);
         break;
       }
     case 34:
       {                        /* chan_left */

         if (TO_CHANNEL(win))
         {
           win->chanCur = win->chanCur->left;
#if USE_XFORMS
           if (fl_mouse_button() == FL_MIDDLEMOUSE)
             win->dccCur = win->dccCur->left;
           if (win->dccCur == win->dccStart)
             win->dccCur = win->dccCur->left;
#endif
           if (win->chanCur == win->chanStart &&
               (win->chanCur = win->chanCur->left) == win->chanStart &&
               win->dccCur == win->dccStart)
             break;             /* empty channel list */
         }
         else if (TO_DCC(win))
         {
           win->dccCur = win->dccCur->left;
#if USE_XFORMS
           if (fl_mouse_button() == FL_MIDDLEMOUSE)
             win->chanCur = win->chanCur->left;
           if (win->chanCur == win->chanStart)
             win->chanCur = win->chanCur->left;
#endif
           if (win->dccCur == win->dccStart &&
               (win->dccCur = win->dccCur->left) == win->dccStart &&
               win->chanCur == win->chanStart)
             break;             /* no dcc chat connections */
         }
         else
         {
           win->chanCur = win->chanCur->left;
           if (win->chanCur == win->chanStart &&
               (win->chanCur = win->chanCur->left) == win->chanStart)
             break;             /* empty channel list */
         }
         UpdateStatus(win);
         break;
       }
  }                             /* switch */
  reset_focus(win);
}

#if USE_XFORMS
static void load_hist(Winstruct * win, int load)
{
  char *ptr;

  char *buf;

  buf =

     (char *) malloc(sizeof(char) *
                     (strlen(prog_home) + 2 + strlen(P_HOME P_HISTORY)));

  sprintf(buf, "%s/%s", prog_home, P_HISTORY);
  ptr = getstr2("Type the name of the history file below",
                sula_NAME " " sula_VERSION ": Load history file", buf, 1);
  if (!ptr)
    free(buf);
  else
  {
    free(buf);
    buf = (char *) malloc(sizeof(char) * (strlen(ptr) + 24));

    if (load)
      sprintf(buf, "history -load %s", ptr);
    else
      sprintf(buf, "history -save %s", ptr);
    process_cmd(buf, win);
    free(buf);
    free(ptr);
  }
}

#endif
#if USE_XFORMS
#define LOAD	0
#define SAVE	1
#define save_  "Save as:",sula_NAME  ": Save browser lines"
#define load_ "File name:",sula_NAME ": Load a file"
static void save_load_browser(Winstruct * win, char what, char save_all)
{
  char *ptr;

  if (what == SAVE)
    ptr = getstr2(save_, NULL, 1);
  else
    ptr = getstr2(load_, NULL, 1);
  if (!ptr)
    return;
  else
  {
    char *buf = malloc(sizeof(char) * (strlen(ptr) + 32));

    sprintf(buf, "window -%s 1 -f %s%s", what == LOAD ? "l" : "s",
            ptr, (what == SAVE && save_all) ? "" : " -m");
    process_cmd(buf, win);
    free(buf);
    free(ptr);
  }

}
#elif USE_GTK
static void load_into_browser(const char *fname, void *data)
{
  Winstruct *win = data;

  if (win && win->chanwin && fname && *fname)
    if (spx_load_file(win->chanwin->browser, fname))
    {
      say2(0, win - winstruct, -1,
           PROMPT "Error loading \"%s\" into browser: %s", fname,
           strerror(errno));
      if (gflags & BEEP_ERR)
        spx_bell(0);
    }
}

static void shutdown_chanwin(int yes, void *data)
{
  Winstruct *win = data;

  if (yes && win && win->chanwin && win->chanStart != win->chanCur)
    del_chanwin_from_list(win);
}
#endif

#if USE_XFORMS
void file_menu_cb(Winstruct * w)
#elif USE_GTK
     void file_menu_cb(GtkWidget * ob, gpointer data)
#endif
{
#if USE_XFORMS
  int item = fl_get_menu(w->chanwin->file_menu);

  if (item <= 0)
    return;
#elif USE_GTK
  Menu_info *mi = (Menu_info *) data;
  Winstruct *w = winstruct + mi->w;
  int item = mi->data;
#endif

  switch (item)
  {
     case 1:

       duplicate_win(w);
       break;
     case 5:
#if USE_XFORMS
       save_load_browser(w, LOAD, 0);
#else
       get_filename2(sula_NAME ": Load file", NULL, load_into_browser, w);
#endif
       break;
#if USE_XFORMS
     case 2:
       TEXT_CLEAR(w->chanwin->browser);
       break;
     case 3:
       TEXT_CLEAR(w->chanwin->brow2);
       break;
     case 401:
       save_load_browser(w, SAVE, 1);
       break;
     case 402:
       save_load_browser(w, SAVE, 0);
       break;
     case 701:                 /* clear */
       process_cmd("history -clear", w);
       break;
     case 702:                 /*reload */
       process_cmd("history -reload", w);
       break;
     case 703:
       load_hist(w, 1);
       break;
     case 704:
       load_hist(w, 0);
       break;
#endif
     case 8:
#if USE_XFORMS
       if (w->chanwin->close_con->u_vdata)
#else
       if (gtk_object_get_data(GTK_OBJECT(w->chanwin->close_con),
                               "connecting"))
#endif
       {
         /* have requested server connection. Wait for it! */
         spx_writeln(w->chanwin->brow2, PROMPT "Cannot close."
                     "Waiting for server connection. Waiting.");
         spx_bell(0);
       }
       else
#if USE_XFORMS
         if
          (w->chanStart == w->chanCur
           ||
           confirm("Leave channels and close window?",
                   sula_NAME " " sula_VERSION ": Confirm", 7))
         del_chanwin_from_list(w);

#else
       if (w->chanStart != w->chanCur)
         confirm2("Leave channels and close window?",
                  sula_NAME ": Confirm", 7, shutdown_chanwin, w);

       else
         del_chanwin_from_list(w);
#endif
       break;
     case 9:
       TRIGGER_OBJECT(main_window->quit);
       break;
     default:
       break;
  }
}
