/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



/*
 *  ctcp.c  - CTCP and some DCC protocol. see also: dcc.c
 *
 * (C) 1997-1999 Tano Fotang
 *
 * This software is distributed under the GNU General Public License,
 * either version 2, or any later version. The license is included
 * herein by reference.
 *
 * ctcp_quote_it(), ctcp_unquote_it(), decrypt() and encrypt() are
 * from the IrcII source code. They have been modified and included
 * here for compatibility.
 */
#include "spx.h"
#include <sys/utsname.h>
#include <pwd.h>
#include <utmp.h>
#include <netdb.h>
#include <arpa/inet.h>
#ifndef UT_NAMESIZE
#define UT_NAMESIZE 8
#endif
#ifndef UT_LINESIZE
#define UT_LINESIZE 12
#endif
#ifndef UT_HOSTSIZE
#define UT_HOSTSIZE 16
#endif

#include "config.h"

#include "nc.h"
#include "server.h"
#include "parser.h"
#include "dcc.h"
#include "setting.h"
#include "ignore.h"
#include "cmd.h"
#include "hooks.h"
#include "flood.h"


void ctcp_unquote_it(char *, int *len);
char *ctcp_quote_it(char *str, int len);
static void decrypt(char *, int, char *);
static char *msg = 0, *sender = 0, *nick = 0, *emailaddr = 0, *dest = 0;

static void addkey(int w, Key ** s, char *nick, char *key)
{
   Key *p = *s;

   while (p)
      if (!strcasecmp(p->who, nick)) {
	 free(p->key);
	 p->key = strdup(key);
	 p->flag = 1;
	 say2(1, w,-1, "@ikey for %s changed to \"%s\"", p->who, p->key);
	 break;
      }
      else
	 p = p->next;
   if (p)
      return;
   else {

      p = *s;
      *s = (Key *) malloc(sizeof(Key));
      (*s)->next = p;
      (*s)->who = strdup(nick);
      (*s)->key = strdup(key);
      (*s)->flag = 1;
      say2(1, w,-1, "@i%s added to crypt list with key \"%s\"", (*s)->who, (*s)->key);
   }
}
static void del_key_node(Key ** head, Key * trail, Key * node)
{
   if (trail)
      trail->next = node->next;
   else {
#warning uncomment and  test
      /*
         free((*head)->nick);free((*head)->key); 
       */
      *head = (*head)->next;
      free(node);
   }
}
static void remove_key(int w, char *who)
{
   Key *p = keys;

   if (p) {
      char found = 0;

      if (!strcasecmp(p->who, who)) {
	 keys = keys->next;
	 free(p);
	 found++;
      }
      else {
	 Key *q = p->next;

	 while (q)
	    if (!strcasecmp(q->who, who)) {
	       del_key_node(&(keys), p, q);
	       found++;
	       break;
	    }
	    else {
	       p = q;
	       q = q->next;
	    }
      }
      if (!found)
	 return;
      say2(0, w, 1, "%s removed from crypt list", who);
   }
}
static void toggle_sed_flag(int w, char *who)
{
   Key *p = keys;

   while (p)
      if (!strcasecmp(p->who, who)) {
	 p->flag = p->flag ? 0 : 1;
	 say2(0, w, 1, "encryption to %s now set %s",
	      p->who, p->flag ? "on" : "off");
	 break;
      }
      else
	 p = p->next;

}

char *have_key(char *who, int action)
{
   Key *p = keys;

   while (p)
      if (!strcasecmp(p->who, who)) {
	 if (action == ENCRYPT && p->flag == 0)
	    return NULL;
	 else
	    return p->key;
      }
      else
	 p = p->next;
   return NULL;
}

extern void do_encrypt(int argc, char **argv, int w)
{

   if (argc == 1) {
      Key *p = keys;

      if (p) {
	 say2(1, w,1,
          "@b@f@.  %-20s%-20s  %s", "User/Channel", "Key", "Status");
      }
      while (p) {
	 say2(1, w,1, "@f@.  %-20s%-20s  %s", p->who, p->key,
		 p->flag ? "on" : "off");
	 p = p->next;
      }
      return;
   }
   if (argc > 1)
   {
      if (!strncasecmp(argv[1], "-del", 4) && argv[2])
	 remove_key(w, argv[2]);
      else if (argc == 2)
	 toggle_sed_flag(w, argv[1]);
      else if (argc > 2)
	 addkey(w, &keys, argv[1], argv[2]);
   }
}

#define CTCP_QUOTE_CHAR '\\'
#define CTCP_DELIM_CHAR '\001'

static char *
   ctcp_unquote_it2(str, len)
/*
   ctcp_unquote_it() breaks SED. Hence this version, just for SED  
 */
     char *str;
     int *len;
{
   char *buffer;
   char *ptr;
   char c;
   int i, new_size = 0;

   buffer = (char *) malloc(sizeof(char) * *len);

   if (!buffer)
      return NULL;
   ptr = buffer;
   i = 0;
   while (i < *len) {
      if ((c = str[i++]) == CTCP_QUOTE_CHAR) {
	 switch (c = str[i++]) {
	    case CTCP_QUOTE_CHAR:
	       *(ptr++) = CTCP_QUOTE_CHAR;
	       break;
	    case 'a':
	       *(ptr++) = CTCP_DELIM_CHAR;
	       break;
	    case 'n':
	       *(ptr++) = '\n';
	       break;
	    case 'r':
	       *(ptr++) = '\r';
	       break;
	    case '0':
	       *(ptr++) = '\0';
	       break;
	    default:
	       *(ptr++) = c;
	       break;
	 }
      }
      else
	 *(ptr++) = c;
      new_size++;
   }
   *ptr = '\0';
   *len = new_size;
   return (buffer);
}

static void do_sed(CmdStruct *junk)
{
   strshift(msg, 4);
#if CTCP_more
   if (!check_msg_hook(CTCP_SED, W,
		       "%s,%d %s %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest, msg))
#endif
   {
      char *buf;
      char *login = 0, *hh = 0;
      char *fmt;

      hh = have_key((*dest == '#' || *dest == '&') ? dest : nick, DECRYPT);
      if (hh) {
	 size_t n;

	 n = strlen(msg);
	 buf = ctcp_unquote_it2(msg, &n);
	 decrypt(buf, n, hh);
	 ctcp_unquote_it(buf, &n);
	 strcpy(msg, buf);
	 free(buf);
         if (check_msg_hook((*dest == '#' || *dest == '&')?
         PUBLIC_MSG:PRIVATE_MSG,
                       Win - winstruct,
		       "%s,%d %s %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest, msg))
                return;
         fmt = (*dest == '#' || *dest == '&') ? fmt_sed_pub : fmt_sed_priv;
      }
      else
	 fmt = fmt_sed_nokey;
      hh = (char *) alloca(sizeof(char) * Len);
      login = (char *) alloca(sizeof(char) * Len);

      if (sscanf(emailaddr, "%[^@]@%s", login, hh) != 2)
	 strcpy(hh, "<unknown>");
      fmt_string = "%n%l%h%c%p%z%Z$";
      buf = format_msg(fmt, nick, login, hh, dest, msg, Len, Win->server->read);
      if (buf) {
	 isay("SED", buf, W, 0);
	 free(buf);
      }
   }
}

static void do_action(CmdStruct *cs)
{
   char *txt = msg + find_pos(msg, 1);

   if (!check_msg_hook(ACTION, W,
		       "%s,%d %s %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest, txt)) {
      char *buf;
      char *login, *host;
      size_t ll;

      ll = strlen(emailaddr) + 8;
      login = (char *) alloca(sizeof(char) * ll);
      host = (char *) alloca(sizeof(char) * ll);

      *login = *host = 0;
      if (sscanf(emailaddr, "%[^@]@%s", login, host) != 2)
	 strcpy(host, "<unknown>");
      buf = 0;
      fmt_string = "%n%l%h%c%p%z%Z$";
      buf = format_msg(
	  (*dest == '#' || *dest == '&') ? fmt_pub_action : fmt_priv_action,
			 nick, login, host,
			 dest,
			 txt,
			 Len, Win->server->read);
      if (buf) {
	 isay("ACTION", buf, W, 0);
	 free(buf);
      }
   }
}

static void do_clientinfo(CmdStruct *cs)
{

#if CTCP_more
   if (!check_msg_hook(CTCP_CLIENTINFO, Win - winstruct,
		       "%s,%d %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest))
#endif
   {
      char *s, buf[512];
      char *tt;

      s = (char *) malloc(sizeof(char) *
		        (strlen(sula_INFOSITE sula_EMAIL sula_NAME) + 50));

      if (!s)
	 return;
      sprintf(s, "CLIENTINFO " sula_NAME "\n"
	      "Infoterial: " sula_INFOSITE " \n"
	      "Email: " sula_EMAIL);
      tt = ctcp_quote_it(s, strlen(s));
      sprintf(buf, "NOTICE %s :%c%s%c\n", nick, 0x01, tt, 0x01);
      sendto_server(Win, buf);
      free(s);
      free(tt);
   }
}
static void do_source(CmdStruct *cs)
{
#if CTCP_more
   if (!check_msg_hook(CTCP_SOURCE, W,
		       "%s,%d %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest))
#endif
   {
      char *s, *tt;

      s = malloc(sizeof(char) * (strlen(sula_GETTING) + 10));

      sprintf(s, "SOURCE " sula_GETTING);
      tt = ctcp_quote_it(s, strlen(s));
      free(s);
      s = malloc(sizeof(char) * (strlen(tt) + strlen(nick) + 30));

      sprintf(s, "NOTICE %s :%c%s%c\n", nick, 0x01, tt, 0x01);
      sendto_server(Win, s);
      free(s);
      free(tt);
   }
}

#define do_DCC_CHAT	0
#define DCC_SEND	1
#define DCC_ACCEPT	2
#define DCC_RESUME	3
#define DCC_RENAME	4
#define DCC_REJECT	5
extern void receive_send_req(const char *nick,const char * email,char *fname,
	u_long inaddr, u_short port, off_t filesize, u_long checksum);
extern void accept_request(const char *nick, const char *email,
			     u_short port, off_t offset);
extern void resume_request(const char *nick, const char *email,
			     u_short port, off_t offset, u_long checksum);
extern void rename_request(const char *, const char *, u_short port);
extern void reject_request(const char *, const char *, u_short port);
extern void receive_chat_req(const char *nick,const char *email, 
		u_long inaddr,u_short port);


static void parse_dcc_request(int which)
{
   unsigned short port = 0;

   switch (which) {
      case DCC_SEND:
	 {
	    char *args = msg + find_pos(msg, 2);

	    if (!check_msg_hook(DCC_SEND_REQUEST,
				W, "%s,%d %s %s %s",
				Win->server->name,
				Win->server->port,
				sender, dest, args)) {
	       char *fname, *ext_block;
	       u_long cksum = 0;
	       u_long inaddr = 0;
	       u_long fsize = 0;

	       ext_block = (char *) alloca(sizeof(char) * Len);

	       *ext_block = 0;
	       fname = (char *) alloca(sizeof(char) * Len);

	       *fname = 0;
	       if (sscanf(args, "%s %lu %hu %lu %lu",
			  fname, &inaddr, &port, &fsize, &cksum) < 3) {
		  if (debug)
		     fprintf(stderr,
			     "invalid DCC SEND from %s: %s\n",
			     args, nick);
		  break;
	       }
	       /*
	          read away extension block 
	        */
	       sscanf(Msg, "%*[^\x1]\x1%*[^\x1]\x1%[^\n]", ext_block);
             if(debug)
	       fprintf(stderr, "DCC SEND: extension:%s (%d bytes)\n",
		       ext_block, strlen(ext_block));
	       receive_send_req(nick, emailaddr, fname, inaddr,
                 port, fsize, cksum);
	       break;
	    }
	 }
      case DCC_ACCEPT:
	 {
	    off_t offset = 0;

	    /*
	       offset is redundant: open in O_APPEND mode 
	     */
	    sscanf(msg, "%*s %*s %*s %hu %lu", &port, &offset);
	    if (port == 0) {
	       if (debug)
		  error(ERR_MSG, "bad ACCEPT from %s: %s\n", msg, nick);
	    }
	    else
	       accept_request(nick, emailaddr, port, offset);
	    break;
	 }
      case DCC_RESUME:
	 {
	    off_t offset = 0;
	    u_long checksum = 0;
	    char *pp = malloc(sizeof(char) * strlen(msg)), *ss = 0;

	    sscanf(msg, "%*s %*s %s %hu %lu", pp, &port, &offset);
	    checksum = strtoul(pp, &ss, 0);
	    if (*ss)
	       checksum = 0;
	    free(pp);
	    if (port)
	       resume_request(nick, emailaddr, port, offset, checksum);
	    else if (debug)
	       fprintf(stderr, "bad RESUME from %s: %s\n", nick, msg);
	    break;
	 }
      case DCC_RENAME:
	 {
	    if (sscanf(msg, "%*s %*s %*s %hu", &port) != 1) {
	       if (debug)
		  fprintf(stderr, "bad RENAME from %s: %s\n", msg, nick);
	    }
	    else
	       rename_request(nick, emailaddr, port);
	    break;
	 }
      case DCC_REJECT:
	 {
	    extern void reject_request(const char *, const char*,u_short);

            if (sscanf(msg, "%*s %*s %*s %hu", &port) == 1)
	       reject_request(nick, emailaddr, port);
            
            else if (debug)
	       fprintf(stderr, "bad REJECT from %s: %s\n", msg, nick);
	    break;
	 }
      case do_DCC_CHAT:
	 {
	    char *args = msg + find_pos(msg, 3);

	    if (!check_msg_hook(DCC_CHAT_REQUEST,
				W, "%s,%d %s %s %s",
				Win->server->name,
				Win->server->port,
				sender, dest, args)) {
	       u_long inaddr;

	       if (sscanf(args, "%lu %hu", &inaddr, &port) < 2) {
		  if (debug)
		     fprintf(stderr, "bad DCC CHAT from %s: %s\n", sender, msg);
	       }
	       else
		  receive_chat_req(nick, emailaddr, inaddr, port);
	       break;
	    }
	 }
      default:
	 if(debug) fputs("DCC wha's??", stderr);
         break;
   }				/*switch*/
}

static int lookup_DCC_type(const char *name)
{
   typedef struct {
      short nr;
      char *name;
   } DCC_request;
   DCC_request request_type[] =
   {
   /*
      binary search, keep sorted by name!! 
    */
      {DCC_ACCEPT, "ACCEPT"},
      {do_DCC_CHAT, "CHAT"},
      {DCC_REJECT, "REJECT"},
      {DCC_RENAME, "RENAME"},
      {DCC_RESUME, "RESUME"},
      {DCC_SEND, "SEND"},
      {-1, NULL}
   }, *p = request_type;
   register int low, high, mid, cond;

   low = 0;
   high = sizeof(request_type) / sizeof(DCC_request) - 1;
   while (p->name && low <= high) {
      mid = (low + high) / 2;
      if ((cond = strcasecmp(name, (p + mid)->name)) < 0)
	 high = mid - 1;
      else if (cond > 0)
	 low = mid + 1;
      else {
	 parse_dcc_request((p + mid)->nr);
	 return mid;
      }
   }
   return -1;
}

static void do_dcc(CmdStruct *cs)
{

   char *cmd;

   cmd = nextword(msg, 1);
   if (*cmd)
      if (lookup_DCC_type(cmd) < 0)
	 if (gflags & VERBOSE_CTCP)
	    error(ERR_MSG, "unknown DCC cmd %s in %s\n", cmd, Msg);
   free(cmd);
}

static void do_ping(CmdStruct *cs)
{
   char *args = msg + find_pos(msg, 1);

#if CTCP_more
   if (!check_msg_hook(CTCP_PING,
		       W, "%s,%d %s %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest, args))
#endif
   {
      char *s = malloc(sizeof(char) * (Len + 32));

      sprintf(s, "NOTICE %s :\x1PING %s\x1\n", nick, args);
      sendto_server(Win, s);
      free(s);
   }

}

static void do_time(CmdStruct *cs)
{
#if CTCP_more
   if (!check_msg_hook(CTCP_TIME,
		       W, "%s,%d %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest))
#endif
   {
      char *s;
      time_t p;
      char *t;
      int n;

      p = time(NULL);
      t = ctime(&p);
      n = strlen(t);
      *(t + n - 1) = '\0';
      s = malloc(sizeof(char) * (strlen(nick) + n + 30));

      sprintf(s, "NOTICE %s :%cTIME %s%c\n", nick, 0x01, t, 0x01);
      sendto_server(Win, s);
      free(s);
   }
}

static void do_version(CmdStruct *cs)
{
#if CTCP_more
   if (!check_msg_hook(CTCP_VERSION,
		       W, "%s,%d %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest))
#endif
   {
      #define CACHE_IT 0
      #if CACHE_IT
      /*no, then we dont get the right nick Win->server->nick
      as it may change*/
      static
      #endif 
      char *res = 0;
      char *buf;
      static size_t len = 0;

      #if CACHE_IT
      if (!res) 
      #endif
      {
		 char *s = 0;
	 struct utsname ut;

	 if (uname(&ut) < 0) {
	    static char *release = 0;

	    if (release == 0) {
	       time_t t = sula_RELEASE;

	       release = ctime(&t);
	       *(release + strlen(release) - 1) = 0;
	    }
	    s = malloc(sizeof(char) * (strlen(
            sula_NAME " " sula_DESCR sula_VERSION) + 80));

	    sprintf(s, "VERSION %s (Release %s). Send"
		    " \"CTCP %s HELP\" for more info.",
		    sula_NAME " - "  sula_VERSION, release,
                    Win->server->nick);
	 }
	 else {
	    s = malloc(sizeof(char) * (strlen(
            sula_NAME " " sula_DESCR sula_VERSION) +
				       strlen(ut.sysname) + 80));

	    if (!s)
	       return;
	    sprintf(s, "VERSION %s on %s %s. Do"
		    " \"CTCP %s HELP\" for more info.",
		    sula_NAME " - "  sula_VERSION, ut.sysname,
                     ut.release, Win->server->nick);
	 }
	 res = ctcp_quote_it(s, strlen(s));
	 free(s);
	 len = strlen(res);
      }
      buf = malloc(sizeof(char) * (len + 20 + strlen(nick)));

      sprintf(buf, "NOTICE %s :%c%s%c\n", nick, 0x01, res, 0x01);
      sendto_server(Win, buf);
      free(buf);
   }

}

static void do_ctcp_help(CmdStruct *cs)
{
#if CTCP_more
   if (!check_msg_hook(CTCP_HELP,
		       W, "%s,%d %s %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest, msg + find_pos(msg, 1)))
#endif
   {
#define LINEBUF	2048
      char s[LINEBUF];

      char *cmd;

      s[0] = '\0';
      cmd = nextword(msg, 1);
      if (*cmd) {
	 Cmd *p;

	 p = find_ctcp_cmd(cmd, 0);
	 if (!p)
	    sprintf(s, "NOTICE %s :%cHELP %s: No such command%c\n", nick, 0x01, cmd, 0x01);

	 else if (p->help)
	    sprintf(s, "NOTICE %s :%cHELP %s%c\n", nick, 0x01, p->help, 0x01);

	 else
	    sprintf(s, "NOTICE %s :%cHELP %s: No help for command%c\n", nick, 0x01, cmd, 0x01);

	 sendto_server(Win, s);
      }
      else {
	 static void listcmds(Cmd * p, char **buf);
	 char *buf = (char *) my_malloc2(sizeof(char) * LINEBUF);

	 if (!buf)
	    return;
	 buf[0] = '\0';
	 listcmds(ctcp_cmdTree, &buf);
	 if (buf[0])
	    sprintf(s, "NOTICE %s :%cHELP Help topics: %s%c\n", nick, 0x01, buf, 0x01);
	 else
	    sprintf(s, "NOTICE %s :%cHELP %s%c\n", nick, 0x01, "No help found for cmd", 0x01);
	 sendto_server(Win, s);
	 free(buf);
      }
      free(cmd);
   }
}
static void listcmds(Cmd * p, char **s)
{
   if (p) {
      listcmds(p->left, s);
      {
#warning 12/98 todo: use realloc(2) or snprintf
	 strcat(*s, p->name);
	 strcat(*s, " ");
      }
      listcmds(p->right, s);
   }
}

static void do_userinfo(CmdStruct *cs)
{
#if CTCP_more
   if (!check_msg_hook(CTCP_USERINFO,
		       W, "%s,%d %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest))
#endif
   {

      if (*userinfo)
      {
         char *buf = expand_quote(userinfo, "", W);
         if(buf){
	   char *s =my_malloc2(sizeof(char) * (strlen(buf) + 
             strlen(nick) + 30));
	   if (s){
	      sprintf(s, "NOTICE %s :\x1USERINFO %s\x1\n", nick,buf);
	       sendto_server(Win, s);
              free(s);;
           }
         free(buf);
       }
      }
   }
}

static void do_finger(CmdStruct *cs)
{
#if CTCP_more
   if (!check_msg_hook(CTCP_FINGER,
		       W, "%s,%d %s %s",
		       Win->server->name,
		       Win->server->port,
		       sender, dest))
#endif
   {
      if (!(gflags & FINGER))
	 return;
      else {
	 char *s;

	 s = NULL;
	 if (*finger_reply) {
	    char *buf = expand_quote(finger_reply, "", W);
            if(!buf) return;
	     s =alloca(sizeof(char) * (strlen(buf) + strlen(nick) + 10));
	   if (!s)
              {perror("alloca error");free(buf); return;}
	      sprintf(s, "FINGER %s",buf);
            free(buf);
            
	 }
	 else {
	    /*
	       cache the results obtained in this block. It is expensive
	       to repeat for each finger request.
	     */
	    static struct passwd *pwd = NULL;
	    static char *utmp_result = 0;
	    FILE *fp;

	    if (pwd == NULL)
	       if (!(pwd = getpwuid(getuid()))) {
		  error(ERR_SYS, "getuid");
		  return;
	       }
#ifdef UTMP
	    if (!(gflags & FINGER_UTMP))
	       goto no_utmp;
	    if (!utmp_result) {
	       if ((fp = fopen(UTMP, "r")) != NULL) {
		  struct utmp ut;
		  char name[UT_NAMESIZE + 1];
		  int found = 0;

		  while (fread((char *) &ut, sizeof(ut), 1, fp) == 1) {
		     if (ut.ut_user[0] == '\0')
			continue;
		     strncpy(name, ut.ut_user, UT_NAMESIZE);
		     if (!strcmp(pwd->pw_name, name)) {
			found = 1;
			break;
		     }
		  }
		  fclose(fp);
		  if (found) {
		     char *t;
		     char ut_host[UT_HOSTSIZE + 1];
		     char ut_line[UT_LINESIZE + 1];

		     t = ctime(&ut.ut_time);
		     *(t + strlen(t) - 1) = '\0';
		     utmp_result = malloc(sizeof(char) * (strlen(pwd->pw_gecos) + strlen(t) +
					strlen(pwd->pw_name) + UT_HOSTSIZE +
					    UT_NAMESIZE + 128 + strlen(host)
					  ));

		     strncpy(ut_host, ut.ut_host, UT_HOSTSIZE);
		     strncpy(ut_line, ut.ut_line, UT_LINESIZE);
		     sprintf(utmp_result,
			     "FINGER Login:%s 	Name:%s\n"
			     "Host: %s From: %s Device:%s.\n"
			     "On since %s",
			     pwd->pw_name, pwd->pw_gecos,
			     host, ut_host, ut_line, t);
		  }
	       }
	       else
		  error(ERR_SYS, UTMP);
	    }			/*
				   if !utmp_result
				 */
	    s = utmp_result;
	  no_utmp:
#endif
	    if (!s) {
	       s = alloca(sizeof(char) * (strlen(pwd->pw_gecos) + strlen(pwd->pw_name) +
					  strlen(host) + 64));

	       sprintf(s, "FINGER %s (%s) on host %s",
		       pwd->pw_name, pwd->pw_gecos, host);
	    }
	 }			/*
				   if(*finger_reply) 
				 */
	 if (s) {
	    int l = strlen(s);
	    char *tt = ctcp_quote_it(s, l);
	    char *b;
	    b = alloca(sizeof(char) * (l + 16));

	    sprintf(b, "NOTICE %s :%c%s%c\n", nick, 0x01, tt, 0x01);
	    sendto_server(Win, b);
	    free(tt);
	 }
      }
   }
}

extern int load_ctcp_cmds(void)
{
   typedef struct {
      char *name;
      char *help;
      void (*func) (CmdStruct *);
   } CtcpCmd;
   CtcpCmd ctcp_cmds[] =
   {
    {"ACTION", "ACTION describes sender's actions or feelings", &do_action},
      {"CLIENTINFO", "CLIENTINFO  returns info about the client", &do_clientinfo},
      {"DCC", "DCC request direct client to client connection", &do_dcc},
      {"FINGER", "FINGER gets system info", &do_finger},
      {"HELP", "HELP gets info about a client's CTCP commands", &do_ctcp_help},
      {"PING", "PING sends stuff and expects an echo", &do_ping},
      {"SED", "SED marks simple(?) encryted data", &do_sed},
      {"SOURCE", "SOURCE says where to get the client", &do_source},
      {"TIME", "TIME requests for the time on recipient host", &do_time},
      {"USERINFO", "USERINFO gets any info set for this purpose", &do_userinfo},
      {"VERSION", "VERSION requests for client version", &do_version},

   };

   Cmd cmd;
   int nvars = sizeof(ctcp_cmds) / sizeof(CtcpCmd);
   int i;

   for (i = 0; i < nvars; i++) {
      cmd.name = ctcp_cmds[i].name;
      cmd.help = ctcp_cmds[i].help;
      cmd.type = CMD_BI | CMD_CTCP;
      cmd.cmd.in = ctcp_cmds[i].func;
      insert_ctcp_cmd(&cmd);
   }
   return 0;

}

#define byebye() do{ free(name);free(sender); free(dest);return 1;}while(0)
extern int ctcp_cmd(void)
{
   char *name;

   msg = alloca(sizeof(char) * Len);

   if (sscanf(Msg, "%*s %*s %*s :\x1%[^\x1]\x1", msg) < 1)
      return 0;
   name = nextword(msg, 0);	//  ctcp command 

   if (*name == 0) {
      free(name);
      return 1;
   }
   dest = nextword(Msg, 2);
   sender = nextword(Msg, 0);
   nick = alloca(sizeof(char) * strlen(sender));
   emailaddr = alloca(sizeof(char) * strlen(sender));

   if (sscanf(sender, "%[^!]!", nick) == 1 &&
       sscanf(sender, "%*[^!]!%s", emailaddr) == 1) {
      if (*emailaddr == '~') {
	 strshift(emailaddr, 1);
	 sprintf(sender, "%s!%s", nick, emailaddr);
      }
   }
   else
      byebye();
   if(X>1 && !win_invalid(W) && winstruct[W].server==Win->server)
       Win=winstruct+W;
   if ((!strcasecmp(name, "DCC") && ignored(sender, IG_DCC))
       || (/* !strcasecmp(name, "CTCP") &&*/ ignored(sender, IG_CTCP))) {
      if (gflags & INFORM_IGNORED) {
	 char *m;

	 fmt_string = "%n%h%p$";
	 m = format_msg(fmt_ignored, nick, emailaddr, name);
	 if (m) {
	    char *s = alloca(sizeof(char) * (
					    strlen(m) + strlen(nick) + 16));

	    sprintf(s, "NOTICE %s :%s\n", nick, m);
	    sendto_server(Win, s);
	    free(m);
	 }
      }
   }
   else {
      Cmd *cmd;

      if (sflags & FLOOD_CHECK &&
	  flooding(sender, PRIVATE_FLOOD, FLOOD_CTCP) &&
	  check_msg_hook(FLOOD_PRIVATE,
			 W, "%s,%d %s",
			 Win->server->name,
			 Win->server->port,
			 Msg))
	 byebye();
      if (check_msg_hook(CTCP_ALL, W, "%s,%d %s %s %s",
			 Win->server->name,
			 Win->server->port,
			 sender, dest, msg))
	 return 1;
      cmd = find_ctcp_cmd(name, 1);
      if (!cmd) {
	 if (!check_msg_hook(CTCP_UNKNOWN, W,
			     "%s,%d %s %s %s",
			     Win->server->name,
			     Win->server->port,
			     sender, dest, msg))
	    if (gflags & VERBOSE_CTCP)
	       error(0, "unknown ctcp %s from %s: %s", name, sender, msg);
	 byebye();
      }
      if (gflags & VERBOSE_CTCP)
	 say2(0, W, 1, PROMPT "CTCP: %s from %s", msg, sender);
      if (cmd->type & CMD_BI) {
	 (cmd->cmd.in) ((void *) 0);
      }
      else if (cmd->type & CMD_FD) {
	 char *buff;

	 buff = malloc(sizeof(char) * (Len + strlen(Win->server->name) + 32));

	 /*
	    <id> __CTCP__ <yournick> <sender> <args>
	  */
	 sprintf(buff, "%d __CTCP__ %s,%hu %s %s %s %s\n",
		 W, Win->server->name,
		 Win->server->port, Win->server->nick,
		 sender, cmd->name, msg + find_pos(msg, 1));
	 write_to_sp(cmd->cmd.sp, buff);
	 free(buff);
      }
#ifdef _GUILE
      else if (cmd->type & CMD_SCM) {
	 char *buff = alloca(sizeof(char) * (Len + 64));
	 char *tmp = msg + find_pos(msg, 1);

#define DAT_SIZE 128
	 char data[DAT_SIZE + 1];
	 Scm_cmd_arg args;

	 args.func = cmd->cmd.scm;
	 if (*tmp)
	    sprintf(buff, "%s,%hu %s %s",
		    Win->server->name,
		    Win->server->port, sender, tmp);
	 else
	    sprintf(buff, "%s,%hu %s",
		    Win->server->name,
		    Win->server->port, sender);
	 args.args = gh_list(gh_str02scm(buff),
			     gh_long2scm(Win - winstruct),
			     SCM_UNDEFINED);

	 if (snprintf(data, DAT_SIZE, "Processing CTCP cmd \"%s\"",
		      (char *) buff) == -1) {
	    data[DAT_SIZE] = 0;
	    strcpy(&data[DAT_SIZE - 4], "...");
	    data[DAT_SIZE - 1] = '"';
	 }
	 gh_catch(SCM_BOOL_T, &call_scm_command, &args,
		  (scm_catch_handler_t) & exception_handler, (void *) &data);
      }
#endif
      /*else
	 {}
         fprintf(stderr, "bug:ctcp type %d\n", cmd->type & CMD_CTCP);*/
   }
   byebye();
}

/*
   -- originally from EPIC;  modified for sula by Tano Fotang 10/1998
    o return quoted string
    o don't quote "\n" ,"\t" etc

   quote_it: This quotes the given string making it sendable via irc.  A
   pointer to the length of the data is required and the data need not be
   null terminated (it can contain nulls).  Returned is a malloced, null
   terminated string.     
 */
char *
   ctcp_quote_it(str, len)
     char *str;
     int len;
{
   char *buffer;
   char *ptr;
   register int i;

   buffer = (char *) malloc(sizeof(char) * (len + len));

   if (!buffer)
      return NULL;
   ptr = buffer;
   for (i = 0; i < len; i++) {
      switch (str[i]) {
	 case CTCP_DELIM_CHAR:
	    *(ptr++) = CTCP_QUOTE_CHAR;
	    *(ptr++) = 'a';
	    break;
	 case '\n':
	    *(ptr++) = CTCP_QUOTE_CHAR;
	    *(ptr++) = 'n';
	    break;
	 case '\r':
	    *(ptr++) = CTCP_QUOTE_CHAR;
	    *(ptr++) = 'r';
	    break;
	 case CTCP_QUOTE_CHAR:
	    /*
	       Sula Primerix requires this 
	     */
	    switch (str[i + 1]) {
	       case 'n':
	       case 't':
	       case 'r':
	       case '0':
	       case CTCP_QUOTE_CHAR:
		  *(ptr++) = str[i];
		  break;
	       default:
		  *(ptr++) = CTCP_QUOTE_CHAR;
		  *(ptr++) = CTCP_QUOTE_CHAR;
		  break;
	    }
	    break;
	 case '\0':
	    *(ptr++) = CTCP_QUOTE_CHAR;
	    *(ptr++) = '0';
	    break;
	 default:
	    *(ptr++) = str[i];
	    break;
      }
   }
   *ptr = '\0';
   return buffer;
}
/*
 *  -- originally from EPIC;  modified for sula by Tano Fotang 10/98
 *  o s-str  used as loop counter instead of an integer
 *  o pointer used instead of array str[i]
 *  o after \n, add multiline string to each new line
 *  o memcpy in place of a strange function in the original
 *
 *  NOTE: The CTCP_QUOTE_CHAR character is discarded if the succeeding char
 *  isnt  one of the following:  NUL, NL, CR, CTCP_QUOTE_CHAR. 
 */

void ctcp_unquote_it(char *str, int *len)
{
   char *buffer;
   char *ptr, c;
   char *s;

   buffer = (char *) malloc(sizeof(char) * (*len + 16));

   if (!buffer)
      return;
   ptr = buffer;
   s = str;

   while (s - str < *len) {
      if ((c = *s++) == CTCP_QUOTE_CHAR) {
	 switch (c = *s++) {
	    case CTCP_QUOTE_CHAR:
	       *(ptr++) = CTCP_QUOTE_CHAR;
	       break;
	    case 'a':
	       *(ptr++) = CTCP_DELIM_CHAR;
	       break;
	    case 'n':
	       {
		  char *p = line_break;

		  *ptr++ = '\n';
		  if (p)
                  {
		     while (*p)
			if (*p == '\\' && *(p + 1) == 't') {
			   *ptr++ = '\t';
			   p += 2;
			}
			else
			   *ptr++ = *p++;
                 }
	       }
	       break;
	    case 'r':
	       *(ptr++) = '\r';
	       break;
	    case 't':
	       *(ptr++) = '\t';
	       break;
	    case '0':
	       *(ptr++) = '\0';
	       break;
	    default:
	       *(ptr++) = c;
	       break;
	 }
      }
      else
	 *(ptr++) = c;
   }
   *ptr = 0;
   *len = ptr - buffer;
   memcpy(str, buffer, *len + 1);
}
/*
   -- from EPIC  
 */
void encrypt_str(str, len, key)
     char *str, *key;
     int len;
{
   int key_len, key_pos, i;
   char mix, tmp;

   key_len = strlen(key);
   key_pos = 0;
   /*
      mix = key[key_len-1]; 
    */
   mix = 0;
   for (i = 0; i < len; i++) {
      tmp = str[i];
      str[i] = mix ^ tmp ^ key[key_pos];
      mix ^= tmp;
      key_pos = (key_pos + 1) % key_len;
   }
   str[i] = (char) 0;
}

/*
   -- from ircII  
 */
static void decrypt(str, len, key)
     char *str, *key;
     int len;
{
   int key_len, key_pos, i;
   char mix, tmp;

   key_len = strlen(key);
   key_pos = 0;
   /*
      mix = key[key_len-1]; 
    */
   mix = 0;
   for (i = 0; i < len; i++) {
      tmp = mix ^ str[i] ^ key[key_pos];
      str[i] = tmp;
      mix ^= tmp;
      key_pos = (key_pos + 1) % key_len;
   }
   str[i] = (char) 0;
}
