/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* flood.c        - flood detection

 * We *just* determine whether [nick!]user@host.domain is flooding or not.
 * No action is taken. It is up to the user to set hooks on PRIV_FLOOD
 * and PUB_Flood.

 * Author: Tano Fotang,1998
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License , or (at your option) 
 * any later version.
 * see the file COPYING for more info.
 * 
 */

#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "flood.h"
#include "spx.h"
int flood_max,
     flood_period;
Flood *floodTree=NULL,
    *publicfloodTree=NULL;

static void flood_left_rotate(pFlood * pp)
{
  pFlood p = *pp,
       r;

  *pp = r = p->right;
  p->right = r->left;
  r->left = p;
  p->bf--;
  if (r->bf > 0)
    p->bf -= r->bf;
  r->bf--;
  if (p->bf < 0)
    r->bf += p->bf;
}

static void flood_right_rotate(pFlood * pp)
{
  pFlood p = *pp,
       l;

  *pp = l = p->left;
  p->left = l->right;
  l->right = p;
  p->bf++;
  if (l->bf < 0)
    p->bf -= l->bf;
  l->bf++;
  if (p->bf > 0)
    l->bf += p->bf;
}
static Flood *find_flooder(const char *name, Flood * p)
{
  int c;

  while (p)
  {
    c = strcasecmp(name, p->from);
    if (c == 0)
      return p;
    else if (c < 0)
      p = p->left;
    else
      p = p->right;
  }
  return NULL;
}
static int insert_flooder(pFlood * pp, Flood * c)
{
  int dH = 0;
  pFlood p = *pp;

  if (p == NULL)
  {

    *pp = p = (pFlood) my_malloc(sizeof(Flood));
    p->from = strdup(c->from);
    p->count = c->count;
    p->at = c->at;
    p->bf = 0;
    p->left = p->right = NULL;
    dH = 1;
  }
  else
  {
    int tt = strcasecmp(c->from, p->from);

    if (tt > 0)
    {
      if (insert_flooder(&p->right, c))
      {
        p->bf++;
        if (p->bf == 1)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            flood_right_rotate(&p->right);
          flood_left_rotate(pp);
        }
      }
    }
    else if (tt < 0)
    {
      if (insert_flooder(&p->left, c))
      {
        p->bf--;
        if (p->bf == -1)
          dH = 1;
        else if (p->bf == -2)
        {
          if (p->left->bf == 1)
            flood_left_rotate(&p->left);
          flood_right_rotate(pp);
        }
      }
    }
  }
  return dH;
}

int del_flooder(pFlood * pp, Flood * c)
{
  pFlood p = *pp,
      *q;
  int dH = 0;
  int tt;

  if (!p)
    return 0;
  if (
       (tt = strcasecmp(c->from, p->from)) < 0
     )
  {
    if (del_flooder(&p->left, c))
    {
      p->bf++;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == 2)
      {
        if (p->right->bf == -1)
          flood_right_rotate(&p->right);
        flood_left_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else if ((tt > 0))
  {
    if (del_flooder(&p->right, c))
    {
      p->bf--;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == -2)
      {
        if (p->left->bf == 1)
          flood_left_rotate(&p->left);
        flood_right_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else
  {                             /* got it! */
    if (p->right == NULL)
    {
      *pp = p->left;
      free(p->from);
      free(p);
      p = NULL;
      return 1;
    }
    else if (p->left == NULL)
    {
      *pp = p->right;
      free(p->from);
      free(p);
      p = NULL;
      return 1;
    }
    else
    {
      Flood *foo = my_malloc(sizeof(Flood));
      struct TFlood *left,
          *right;

      memcpy((void *) foo, p, sizeof(Flood));

      q = &p->left;
      while ((*q)->right != NULL)
        q = &(*q)->right;

      left = p->left;
      right = p->right;
      memcpy((void *) p, (*q), sizeof(Flood));
      p->left = left;
      p->right = right;

      left = (*q)->left;
      right = (*q)->right;
      memcpy((void *) (*q), foo, sizeof(Flood));
      (*q)->left = left;
      (*q)->right = right;

      if (del_flooder(&p->left, foo))
      {
        p->bf++;
        if (p->bf == 0)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            flood_right_rotate(&p->right);
          flood_left_rotate(pp);
          dH = 1;
        }
      }
      free(foo);
    }

  }
  return dH;
}

int clear_flood(const char *from, pFlood * tree, int type)
{
  Flood *p;

  p = find_flooder(from, *tree);
  if (p == NULL)
    return -1;
  del_flooder(tree, p);
  return 0;
}
int flooding(const char *from, int type, int msgtype)
{
/*   
   from = [nick!]user@host.domain
   type = PUBLIC or PRIVATE
   return TRUE if flood detected.
   Note: flooder is deleted from the flood tree
 */
  Flood *p,
     **tree;

  tree = type == PRIVATE_FLOOD ? &floodTree : &publicfloodTree;
  p = find_flooder(from, *tree);
  if (p == NULL)
  {
    p = (Flood *) my_malloc(sizeof(Flood));
    p->from = (char *) from;
    p->count = 1;
    p->at = time(NULL);
    insert_flooder(tree, p);
  }
  else
  {
    time_t t = time(NULL);

    if ((t - p->at) > flood_period)
    {
      p->at = t;                // reset

      p->count = 1;             // reset

    }
    else
    {
      p->count++;
      if (p->count > flood_max)
      {
        del_flooder(tree, p);
        return 1;
      }
    }
  }
  return 0;
}
