/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
 * global.c     -global functions
 * 
 *
 * Author: Tano Fotang, 1997-1999
 * 
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License , or (at your option) 
 * any later version.
 * see the file COPYING for further information.
 *
 */

#include "config.h"
#include "spx.h"
#include <errno.h>
#include <sys/time.h>
#include <stdarg.h>
#include <ctype.h>
#include <assert.h>
WinList *servWin=NULL;
FILE *logFp=NULL;
CmdSent *cmdsentStart,
 *cmdsentEnd;
char *log_file;
char *fmt_server_notice;
char *fmt_priv_msg;
char *fmt_you_priv_msg;
char *fmt_pub_msg;
char *fmt_pub_msg2;
char *fmt_pub_msg3;
char *fmt_you_pub_msg;
char *fmt_pub_notice;
char *fmt_pub_notice2;
char *fmt_pub_notice3;
char *fmt_you_pub_notice;
char *fmt_priv_notice;
char *fmt_you_priv_notice;
char *fmt_pub_action;
char *fmt_you_pub_action;
char *fmt_priv_action;
char *fmt_you_priv_action;
char *fmt_topic;
char *fmt_chanmode;
char *fmt_usermode;
char *fmt_you_kick;
char *fmt_other_kick;
char *fmt_you_join;
char *fmt_other_join;
char *fmt_you_part;
char *fmt_other_part;
char *fmt_signoff;
char *fmt_you_nick;
char *fmt_other_nick;
char *fmt_you_dccchat;
char *fmt_other_dccchat;
char *fmt_invite;
char *fmt_ignored; /* doesnt apply for IG_MISC! */
char *fmt_sed_pub, *fmt_sed_priv, *fmt_sed_your, *fmt_sed_nokey; /* SED */
char *fmt_ctcp_reply;
char *fmt_dcc_chat_notify, fmt_dcc_file_notify;
#if USE_GTK
IO_id *io_id=NULL;
short io_count=0;
#define IO_ALLOC  10
static void io_alloc(void)
{
  register int i;

  if (io_id == NULL)
    io_id = my_malloc(sizeof(IO_id) * IO_ALLOC);
  else
    io_id = my_realloc(io_id, (io_count + IO_ALLOC) * sizeof(IO_id));
  for (i = io_count; i < io_count + IO_ALLOC; i++)
    io_id[i].fd = -1;
  io_count += IO_ALLOC;
}
void spx_add_input(gint fd,
                   GdkInputCondition cond,
                   GdkInputFunction func,
                   gpointer data)
{
  gint id = gdk_input_add(fd, cond | GDK_INPUT_EXCEPTION, func, data);

  if (io_id == NULL)
    io_alloc();
  do
  {
    int i;

    for (i = 0; i < io_count; i++)
      if (io_id[i].fd == -1)
      {
        io_id[i].fd = fd;
        io_id[i].id = id;
        return;
      }
    io_alloc();
  }
  while (1);
}
void spx_remove_input(gint fd)
{
  register int i;

  for (i = 0; i < io_count; i++)
    if (io_id[i].fd == fd)
    {
      gdk_input_remove(io_id[i].id);
      io_id[i].fd = -1;
      return;
    }
}
#endif

void *getmemory(size_t size, int error_flag)
/* error_flag = ERR_SYS_QUIT or ERR_SYS */
{
  void *p = malloc(size);

  if (p == NULL)
  {
    int err = errno;

    error(error_flag, "malloc error");
    errno = err;
  }
  return p;
}

void *my_realloc(void *ptr, size_t size)
{
  void *p = realloc(ptr, size);

  if (p == NULL)
    error(ERR_SYS_QUIT, "realloc error");
  return p;
}
/*
void my_free(void *ptr)
{
 free(ptr);
}*/
#if HAVE_NO_STRSEP
extern char *strsep(char **p, const char *delim)
{
  char *res;

  if (*p == NULL)
    return NULL;
  res = strpbrk(*p, delim);
  if (!res)
  {
    res = *p;
    *p = NULL;
  }
  else
  {
    char *tmp = *p;

    *res = 0;
    *p = res + 1;
    res = tmp;
  }
  return res;
}
#endif
void _say(const char *str, int to, int where, int flag)
{

  if (!win_invalid(to))
  {
    SPX_OBJ(ob);
    ob = where ? winstruct[to].chanwin->brow2 : winstruct[to].chanwin->browser;
#if USE_GTK
    spx_write0(ob, "\n");
    if (flag)
      spx_write(ob, str);
    else
#endif
      spx_write0(ob, str);
  }
  else if (main_window)
  {
#if USE_GTK
    spx_write(main_window->browser, "\n");
    if (flag)
      spx_write(main_window->browser, str);
    else
#endif
      spx_write0(main_window->browser, str);
  }
  else
    fputs(str,stderr);
  if (sflags & LOG)
    if (logFp)
      if (fprintf(logFp, "%s\n", str) < 1)
      {
        fclose(logFp);
        logFp = NULL;
        sflags &= ~LOG;
        say2(0, to, 1, "write error to %s", log_file);
      }
}

void say2(int format_it, int to, int where, const char *fmt,...)
{
  char *buf;
  int count = 256;
  va_list ap;

  va_start(ap, fmt);
  buf = (char *) malloc(sizeof(char) * count);

  while (buf != NULL)
    if (vsnprintf(buf, count, fmt, ap) == -1)
    {
      count *= 2;
      buf = (char *) realloc(buf, count);
    }
    else
      break;
  va_end(ap);
  if (buf)
  {
    if(format_it)
      say(buf, to, where);
    else
      say0(buf, to, where);
    free(buf);
  }
}

void error(int code, const char *fmt,...)
{
/* dsiplay various types of messages */
  char *buf;
  int count = 256;
  va_list ap;
  int err = errno;

  va_start(ap, fmt);
  buf = (char *) malloc(sizeof(char) * count);

  while (buf != NULL)
    if (vsnprintf(buf, count, fmt, ap) == -1)
    {
      count *= 2;
      buf = (char *) realloc(buf, count);
    }
    else
      break;
  va_end(ap);
  if (buf == NULL)
  {
    if (code == ERR_SYS_QUIT)
      exit(-1);
    else
      return;
  }
  say(buf, -1, 1);              // logged to logFd too

  if (code < 0)
  {
    sprintf(buf, ": %s", strerror(err));
    if (code == ERR_SYS)
      say0(buf, -1, 1);
    else
    {
      fputs(buf, stderr);
      if (code == ERR_SYS_QUIT)
        exit(1);
    }
  }
  else if (code > 0)
  {
    if (code == ERR_FATAL)
      raise(SIGSEGV);
    if (code == ERR_QUIT)
      exit(-1);
  }
  free(buf);
}

int _save_history(History * h, const char *f)
{
  History *current;
  FILE *fp;

  if(f)
    fp = fopen(f, "w");
  else{
    char *buf=alloca(sizeof(char)*(strlen(prog_home)+8+strlen(P_HISTORY)));
    char *tmp;
    int err;
    sprintf(buf, "%s/%s", prog_home, P_HISTORY);
    tmp=strdup(buf);
    fp=fopen(tmp, "w");
    err=errno;
    free(tmp);
    errno=err;
  }
  if (fp == NULL)
    return -1;
  current = h->right;
  while (current != h)
  {
    fprintf(fp, "%s\n", current->line);
    current = current->right;
  }
  fclose(fp);

  return 0;
}
int load_history(const char *f)
{
  FILE *fp;
  char s[512 + 1];

  if ((fp = fopen(f, "r")) == NULL)
    return -1;
  while (fgets(s, 512, fp))
  {
    s[strlen(s) - 1] = '\0';
    if (s[0])
      AddToHistory(s);
  }
  fclose(fp);

  return 0;
}

void addto_cmd_sent(Winstruct * win, const char *cmd, const char *arg)
{
  CmdSent *p = cmdsentStart;

  if (!win->server || win->server->fd < 0)
    return;
  cmdsentStart = (CmdSent *) my_malloc(sizeof(CmdSent));
  cmdsentStart->cmd = strdup(cmd);
  cmdsentStart->arg = arg ? strdup(arg) : NULL;
  cmdsentStart->w = win-winstruct;
  cmdsentStart->t=time(NULL);

  cmdsentStart->next = p;
}

Winstruct *
  search_winlistbyfd(int fd, int *n)
{
  register int i;
  Winstruct *win = NULL;

  *n = 0;
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin && winstruct[i].server &&
        winstruct[i].server->fd == fd)
    {
      (*n)++;
      if (!win)
        win = &winstruct[i];
    }
  return win;
}

Winstruct *
  search_winlist_byservname(char *name, int port, int *total)
{
/* 
 * return first window on this server 
 * 
 */
  Winstruct *p = NULL;
  register int i;

  *total = 0;

  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin && winstruct[i].server &&
        !strcasecmp(name, winstruct[i].server->name) &&
        port == winstruct[i].server->port)
    {
      if (!p)
        p = &winstruct[i];
      (*total)++;
    }
  return p;
}

#if USE_XFORMS
extern void fit_object_label(FL_OBJECT * ob, const char *label)
{

  if (label == NULL || *label == 0)
    fl_set_object_label(ob, "");
  else
  {
    int ll;
    size_t l;
    char *buf;

    buf = (char *) label;
    l = strlen(buf);
    ll = ob->w - 2;
    while (*buf &&
           fl_get_string_width(ob->lstyle, ob->lsize, buf, l) > ll)
      *(buf + --l) = '\0';
    fl_set_object_label(ob, buf);
  }

}
#endif

#define free_win_list() do{\
	WinList *p; \
	while(servWin){\
		p=servWin;\
		servWin=servWin->next;\
		free(p);\
	}\
}while(0)
#define win_add(_w) \
do{ \
  WinList *_p_ = servWin; \
  servWin = (WinList *) my_malloc(sizeof(WinList));\
  servWin->w = _w;\
  servWin->next = _p_;\
}while(0)

void build_winlistbyfd(int fd)
{
  register int i;

  free_win_list();
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin && winstruct[i].server &&
        fd == winstruct[i].server->fd)
      win_add(i);
}

void
  build_winlistbyservname(char *name, int port)
{
/* 
 * similar to build_winlistbyfd  */

  register int i;

  free_win_list();
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin && winstruct[i].server &&
        !strcasecmp(name, winstruct[i].server->name) &&
        port == winstruct[i].server->port)
      win_add(i);
}

void cleanup(void)
{
  char buf[MAXPATHLEN + 1];

#if USE_XFORMS
  fl_finish();
#endif
  main_window = NULL;
  if (gflags & SAVE_HISTORY)
  {
    sprintf(buf, "%s/%s", prog_home, P_HISTORY);
    save_history(buf);
    sprintf(buf, "%s/%s", prog_home, P_CONSOLE_HISTORY);
    save_mainhistory(buf);
  }
  buf[0] = '\0';
}
