/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* 
   help.c: help commands, probably APROPOS, WHATIS, HELP
   Author: Tano Fotang 1997, 1998, 1999
   (fotang@yahoo.com)

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "spx.h"
#include <errno.h>
#include <sys/param.h>
#include "cmd.h"
#include "help.h"

void whatis(int argc, char **argv, int w)
{

  if (argc == 1)
    say0(PROMPT "what is what?", w, 1);
  else
  {
    Cmd *p;
    p = _find_cmd(argv[1], (CMD_BI | CMD_SCM | CMD_FD), 0);
    if (!p)
      p = find_ctcp_cmd(argv[1], 0);
    if (!p)
      say2(0, w, 1 ,PROMPT "%s: why do you ask me?", argv[1] );
    else if (p->help)
      say2(0,w, 1, PROMPT "%s: %s", p->name, p->help);
    else
      say2(0, w, 1, PROMPT "%s: no entry found", argv[1]);
  }
}
static void show_apropos(Cmd * p,
                         char *str,
                         SPX_OBJ(brow),
                         short *i,
                         short total)
{
  static int j = 0;

  if (p)
  {
    #define BLEN 255
    char buf[BLEN+1];
    char *bla,
     *bla2;

    show_apropos(p->left, str, brow, i, total);
    bla = lowercase(p->name);
    bla2 = lowercase(p->help);
    if (strstr(bla, str) ||
        (p->help && strstr(bla2, str)))
    {
      buf[BLEN]=0;
      snprintf(buf,BLEN, "\n@f%s%-15.14s- %s%s",
              p->type & CMD_FD ? " " : "*",
              p->name, p->type & CMD_CTCP ? "(CTCP) " : "",
              p->help ? p->help : ""
         );
      spx_write(brow, buf);
      (*i)++;
    }
    free(bla);
    free(bla2);
    if (++j == total)
      j = 0;
    show_apropos(p->right, str, brow, i, total);
  }
}
void apropos2(int argc, char **argv, Winstruct * win)
{

  if (argc == 1)
  {                             /* /apropos        */
    say(PROMPT "apropos what?", win - winstruct, 1);
  }
  else
  {
    short i,
      j,
      k,
      m;

    j = k = m = i = 0;
    lowercase2(argv[1]);
    show_apropos(bi_cmdTree, argv[1], win->chanwin->browser, &i, count_bi_cmds);
    show_apropos(scm_cmdTree, argv[1], win->chanwin->browser, &k, count_scm_cmds);
    show_apropos(fd_cmdTree, argv[1], win->chanwin->browser, &m, count_fd_cmds);
    show_apropos(ctcp_cmdTree, argv[1], win->chanwin->browser, &j, count_ctcp_cmds);
    if (i == 0 && j == 0 && m == 0 && k == 0)
      say2(0, win - winstruct, 1, PROMPT "apropos %s: i'm lost.", argv[1]);
  }
}

int show_std_help(const char *s1,
                  const char *s2,
                  SPX_chanwin * chanwin)
{
/* leave here so as not to have to include help.h everywhere */
  char *hfname;
  char *hdir = sula_lib;

  size_t ll;

  if (s1 == 0 || *s1 == 0)
    return -1;
  ll = strlen(hdir);
  if (ll == 0)
    ll = 1;

  if (s2 == 0 || *s2 == 0)
  {
    hfname = (char *) alloca(sizeof(char) * (ll + strlen(s1) + 16));

    sprintf(hfname, "%s/help/%s.hlp", *hdir ? hdir : ".", s1);
  }
  else
  {
    hfname = (char *) alloca(sizeof(char) * (ll + strlen(s1) + strlen(s2) + 16));

    sprintf(hfname, "%s/help/%s/%s.hlp", *hdir ? hdir : ".", s1, s2);
  }
  if (access(hfname, R_OK) != -1)
  {
#if USE_XFORMS
    FILE *fp = fopen(hfname, "r");

    if (fp != NULL)
    {

      FL_OBJECT *b = chanwin ? chanwin->browser : main_window->browser;
      char buf[BUFSIZ + 2];

      if (chanwin)
        fl_freeze_form(chanwin->chanwin);
      else
        fl_freeze_form(main_window->main_form);
      while (fgets(buf, BUFSIZ, fp))
      {
        buf[strlen(buf) - 1] = ' ';	/* kludge to include empty lines */
        fl_addto_browser(b, buf);
      }
      //fl_addto_browser(b,"\n");
      if (chanwin)
        fl_unfreeze_form(chanwin->chanwin);
      else
        fl_unfreeze_form(main_window->main_form);
      fclose(fp);
      return 0;
    }
#else
    if (!spx_load_file(chanwin->browser, hfname))
      return 0;
#endif
  }

  {
    char *buf;
    char *errstr = strerror(errno);
    int err = errno;
    static char said_it=0;

    if (gflags & BEEP_ERR)
      spx_bell(0);
    buf = alloca(sizeof(char) * (strlen(s1) + (s2 ? strlen(s2) : 0) +
                                 strlen(errstr) + strlen(PROMPT) + 80+
                                 strlen(sula_lib)));
    #if USE_GTK
    sprintf(buf, "\n@C1@vhelp for %s %s@^@$: %s (looked in %s/help).%s",
    s1, s2 ? s2 : "", errstr, sula_lib, said_it? "":
    "\nYou may have to use @!$@b/set libdirectory@^@. to set valid help path. Humans!");
    #else
    sprintf(buf, PROMPT "help for %s %s: %s (looked in %s/help).%s"
      s1, s2 ? s2 : "", errstr, sula_lib, said_it? "":
    "\nUse /set libdirectory to set help path.");
    #endif
    spx_write(chanwin ? chanwin->brow2 : main_window->browser, buf);
    said_it=1;
    errno = err;
    return -1;
  }

}
static void show_cmds_in_columns(Cmd * p, int to,
                                 char *buf, int *i, int *count,
                                 int total)
{
  #define NROWS 4
  char s[50];

  if (*i == 0)
    buf[0] = '\0';
  if (p)
  {
    show_cmds_in_columns(p->left, to, buf, i, count, total);
    if (*i == 0)
      strcat(buf, "@f");
    if(*i < NROWS -1 )
    sprintf(s, "%-1.1s%-15.13s",
#if _GUILE
            p->type & (CMD_BI | CMD_SCM)
#else
            p->type & CMD_BI
#endif
            ? " " : "*", p->name);
    else
    sprintf(s, "%-1.1s%s",
#if _GUILE
            p->type & (CMD_BI | CMD_SCM)
#else
            p->type & CMD_BI
#endif
            ? " " : "*", p->name);
    strcat(buf,"@$");
    strcat(buf, s);
    strcat(buf,"@!$");
    (*i)++;
    *count = ++(*count) % total;
    if (*i == NROWS || *count == 0)
    {
      *i = 0;
      if(buf[0]) say(buf, to,0);
      buf[0] = '\0';
    }
    show_cmds_in_columns(p->right, to, buf, i, count, total);
  }
}

void help_cmd(CmdStruct * cs)
{
/* show help on a cmd */
  char *name;
  
  if (win_invalid(cs->w))
    return;
  name=nextword(cs->args, 1);
  if (*name == 0)
  {
    char buf[300];
    int total,
      i;

    total = i = 0;
    #if USE_GTK
    gtk_text_freeze(GTK_TEXT(winstruct[cs->w].chanwin->browser));
    #endif
    say("@b\t\tHelp Topics", cs->w, 0);
    show_cmds_in_columns(bi_cmdTree, cs->w,
                         &buf[0], &i, &total, count_bi_cmds);
    buf[0] = 0;
    total = i = 0;
    if (count_scm_cmds > 0)
    {
      say("@C4@D7@v\tScript defined commands", cs->w, 0);
      show_cmds_in_columns(scm_cmdTree, cs->w,
                           &buf[0], &i, &total, count_scm_cmds);
      buf[0] = 0;
      total = i = 0;
    }
    else
      say("@C1@v\tNo script defined commands.", cs->w, 0);
    if (count_fd_cmds > 0)
    {
      say("@C4@D7@v\tExternally defined commands:", cs->w, 0);
      show_cmds_in_columns(fd_cmdTree, cs->w,
                           &buf[0], &i, &total, count_fd_cmds);
      buf[0] = 0;
      total = i = 0;
    }
    else
      say("@C1@v\tNo externally defined commands.", cs->w, 0);
    say("@C4@D7@v\tCTCP commands", cs->w, 0);
    show_cmds_in_columns(ctcp_cmdTree, cs->w,
                         &buf[0], &i, &total, count_ctcp_cmds);
    
    #if USE_GTK
    gtk_text_thaw(GTK_TEXT(winstruct[cs->w].chanwin->browser));
    #endif
  }
  else
  {
    Cmd *cmd;

    cmd = _find_cmd(name, CMD_BI | CMD_SCM | CMD_FD, 0);
    if (!cmd)
    {
      say2(0, cs->w, -1, PROMPT "%s: Unknown command", name);
      free(name);
      return;
    }
    if (cmd->type & CMD_BI)
    {
      char *sub=nextword(cs->args, 2);
      uppercase2(name);
      if (*sub)
        uppercase2(sub);
      else
        sub=NULL;
      show_std_help(name, sub, winstruct[cs->w].chanwin);
      if(sub) free(sub);
    }
    else
    {
      char *buf2;

      buf2 = alloca(sizeof(char) * (strlen(cmd->name) + 10 + strlen(cs->args)));

      sprintf(buf2, "%s -help %s", cmd->name, cs->args+find_pos(cs->args,2));
      if(new_process_cmd(buf2, cs->w))
        say2(0, cs->w, -1, PROMPT "%s: Unknown command", name);
    }
  }
  free(name);
}
