/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
 * hooks.c 
 * Originally part of _sula_. Mofified for Sula PrimeriX II.
 *
 * Author: Tano Fotang, 1998
 *
 * See the file COPYING for license.
 */

#include "spx.h"
#include <time.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/wait.h>
#include <fnmatch.h>
#include <ctype.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdarg.h>
#include "nc.h"
#include "dcc.h"
#include "hooks.h"
#include "cmd.h"

#ifndef FNM_CASEFOLD
/* you dont have this?! blaeh....*/
#define FNM_CASEFOLD FNM_PATHNAME
#endif
int MAX_ON;
Want *want;
NumHook *numTree=NULL;
static int event_id = 0;

typedef struct
{
  MsgNr nr;
  char *name;
}
MsgType;
static MsgType msg_type[] =
{
/*
   These are the availabe hooks types. To add a new hook type, just
   add it to this table and put its number in the enumerated list
   in include/hooks.h. The rest will be taken care of. Name must be
   capitalized as we're using strcmp, not strcasecmp.
   keep sorted by name because binary search is used when installing
   a hook.
   hook installation    : O(log2 n)
   hook matching        : O(1). However, a one-time sanity check must be done
   on this table.
 */
  {ACTION, "ACTION"},
  {CTCP_ALL, "CTCP_ALL"},
#if CTCP_more                   /* hook.h */
  /* example: 
     CTCP_PING => CTCP_ALL "* * * PING *"
   */
  {CTCP_CLIENTINFO, "CTCP_CLIENTINFO"},
  {CTCP_FINGER, "CTCP_FINGER"},
  {CTCP_HELP, "CTCP_HELP"},
  {CTCP_PING, "CTCP_PING"},
  {CTCP_REPLY, "CTCP_REPLY"},   // server,port sender dest msg
   {CTCP_SED, "CTCP_SED"},
  {CTCP_SOURCE, "CTCP_SOURCE"},
  {CTCP_TIME, "CTCP_TIME"},
  {CTCP_UNKNOWN, "CTCP_UNKNOWN"},
  {CTCP_USERINFO, "CTCP_USERINFO"},
  {CTCP_VERSION, "CTCP_VERSION"},
#else
  {CTCP_REPLY, "CTCP_REPLY"},
  {CTCP_UNKNOWN, "CTCP_UNKNOWN"},
#endif

  {DCC_CHAT_DONE, "DCC_CHAT_DONE"},	//  chat connection closed 
   {DCC_CHAT_LOST, "DCC_CHAT_LOST"},
  {DCC_CHAT_MSG, "DCC_CHAT_MSG"},
  {DCC_CHAT_REQUEST, "DCC_CHAT_REQUEST"},
  {DCC_CHAT_START, "DCC_CHAT_START"},	//  on successfully conencting 
   {DCC_GET_DONE, "DCC_GET_DONE"},
  {DCC_GET_REQUEST, "DCC_GET_REQUEST"},	//   before sending out a dcc file request 
   {DCC_GET_START, "DCC_GET_START"},
  {DCC_SEND_DONE, "DCC_SEND_DONE"},
  {DCC_SEND_REQUEST, "DCC_SEND_REQUEST"},
  {DCC_SEND_START, "DCC_SEND_START"},
  {ERROR, "ERROR"},
  {EXIT, "EXIT"},
  {FLOOD_PRIVATE, "FLOOD_PRIVATE"},
  {FLOOD_PUBLIC, "FLOOD_PUBLIC"},
  {INPUT, "INPUT"},             /* user input; for debugging purposes */
  {INVITE, "INVITE"},           // server,port sender dest channel
  {IRC_LINE_OUT, "IRC_LINE_OUT"},
  {JOIN, "JOIN"},
  {JUNK, "JUNK"},
  {KICK, "KICK"},
  {MODE, "MODE"},
  {NC, "NC"},
  {NC_LOST, "NC_LOST"},
  {NC_RAW, "NC_RAW"},
  {NICK, "NICK"},
  {NOTE, "NOTE"},

  {NOTIFY_SIGNOFF, "NOTIFY_SIGNOFF"},
  {NOTIFY_SIGNON, "NOTIFY_SIGNON"},
  {PART, "PART"},
  {PING, "PING"},
  {PONG, "PONG"},
  /*obsolete {PRIV_FLOOD, "PRIV_FLOOD"}, */
  {PRIVATE_MSG, "PRIVATE_MSG"},
  {PRIVATE_NOTICE, "PRIVATE_NOTICE"},
  {PUBLIC_MSG, "PUBLIC_MSG"},
  {PUBLIC_NOTICE, "PUBLIC_NOTICE"},
  {QUIT, "QUIT"},
  {RAW_IRC, "RAW_IRC"},
  {RAW_NON_NUMERIC, "RAW_NON_NUMERIC"},
  {RAW_NUMERIC, "RAW_NUMERIC"},

  {SEND_ACTION, "SEND_ACTION"},
  {SEND_CHATMSG, "SEND_CHATMSG"},
  {SEND_DCC_CHAT, "SEND_DCC_CHAT"},
  {SEND_ENCRYPTED, "SEND_ENCRYPTED"},	// for all encrypted messages
   {SEND_PRIVATE_MSG, "SEND_PRIVATE_MSG"},
  {SEND_PRIVATE_NOTICE, "SEND_PRIVATE_NOTICE"},
  {SEND_PUBLIC_MSG, "SEND_PUBLIC_MSG"},
  {SEND_PUBLIC_NOTICE, "SEND_PUBLIC_NOTICE"},
  {SEND_TO_SERVER, "SEND_TO_SERVER"},

  {SERVER_FAILED, "SERVER_FAILED"},	// SERVER cmd didnt connect.args:server,port nick
   {SERVER_LOST, "SERVER_LOST"},
  {SERVER_NOTICE, "SERVER_NOTICE"},

  {SIGNOFF, "SIGNOFF"},
  {SILENCE, "SILENCE"},
  {TOPIC, "TOPIC"},             // server,port sender channel topic
   {UPDATE_STATUS, "UPDATE_STATUS"},
  {UPDATE_STATUS_DONE, "UPDATE_STATUS_DONE"},	// args: new status text
   {WALLOPS, "WALLOPS"},
  {WINDOW_CREATE, "WINDOW_CREATE"},
  {WINDOW_DESTROY, "WINDOW_DESTROY"}

};

// verify the table defined above
#define sanity_check()\
do{\
   register int i = 0;\
   MsgType *p = msg_type;\
   while (i != INVALID) \
   {\
      assert(i == p->nr);\
      i++;\
      p++;\
   }\
   assert(i == sizeof(msg_type) / sizeof(MsgType)); \
}while(0)

void event_setup(void)
// initialize all hook types
{
  register int i;
  MsgType *p = msg_type;

  sanity_check();
  MAX_ON = sizeof(msg_type) / sizeof(MsgType);

  want = (Want *) my_malloc(sizeof(Want) * MAX_ON);
  i = 0;
  while (i < MAX_ON)
  {
    want[i].type = p->nr;
    want[i].start = want[i].end = NULL;
    i++;
    p++;
  }
}

extern MsgNr get_type(const char *var)
/* takes name of hook type and returns index into the array
   of hook types */
{
  MsgType *p = msg_type;
  register int low,
       high,
       mid,
       cond;

  low = 0;
  high = MAX_ON - 1;
  while (low <= high)
  {
    mid = (low + high) / 2;
    if ((cond = strcasecmp(var, (p + mid)->name)) < 0)
      high = mid - 1;
    else if (cond > 0)
      low = mid + 1;
    else
      return (p + mid)->nr;
  }
  return INVALID;
}
void *lookup_type(const char *cmdname, int *is_numeric)
{
/*
   THis is only used when a hook is to be set.
   takes the name of a hook type and returns the type.
   On return,  is_numeric==0 if hook type is not numeric. 
 */
  static int num;
  char *s;

  *is_numeric = 0;

  num = (int) strtol(cmdname, &s, 0);
  if (*s)
  {
    static MsgNr type = INVALID;

    type = get_type(cmdname);
    return ((void *) &type);
  }
  else
  {
    *is_numeric = 1;
    if (invalid_server_numeric(num))
      return NULL;
    else
      return ((void *) &num);
  }
}

/* Display all hooks and named connections in the event tool */
void hook_list(SPX_OBJ(b), int script, int do_list)
{

  static void list_numhooks(NumHook * h, SPX_OBJ(brow));
  register int i;

#if USE_XFORMS
#define LLEN 512
  char *buf;

#elif USE_GTK
  gint row;
  GtkStyle *style = NULL;
#endif
  SPX_OBJ(brow);

  if (script)
    if (!script_form)
      return;
#if USE_XFORMS
  buf = alloca(sizeof(char) * LLEN);

  *buf = 0;
#endif
  if (script)
  {                             // what 's this about???

#if USE_XFORMS
    brow = do_list ? ((FD_event *) script_form->folder->u_vdata)->browser :
       ((FD_script *) script_form->folder->u_ldata)->browser;
    fl_clear_browser(brow);
    fl_freeze_form(script_form->scriptcontrol);
#elif USE_GTK
    brow = gtk_object_get_data(GTK_OBJECT(script_form->window),
                               do_list ? "clist" : "clist2");
    gtk_clist_clear(GTK_CLIST(brow));
    gtk_clist_freeze(GTK_CLIST(brow));
#endif
  }
  else
    brow = b;
  if (do_list)
  {
    On *p;

#if USE_XFORMS
    sprintf(buf, "@N@m%-14.18s ID  %-10s Sock %-8s Pattern",
            "Command", "SN", "Flag");
    fl_addto_browser(brow, buf);
#elif USE_GTK
    char *s[6];
    char tmp[12],
         tmp1[8],
         tmp2[12];

#endif
    for (i = 0; i < MAX_ON; i++)
    {
      p = want[i].start;
      while (p != want[i].end)
      {
        if(!(p->flag&HK_DIRTY))
        {
#if USE_XFORMS
        *buf = 0;

        if (snprintf(buf, LLEN,
                     "%s%-19.17s %-4d %-12d %-6d %-10d  %s", (
                               p->flag & HK_SUSPENDED || (p->flag & HK_FD &&
                   s_pipe[p->cmd.sp].status & (SCR_SUSPENDED | SCR_STOPPED))
                     )? "@C4@z" : "",
                     msg_type[i].name,
                     p->id, p->ser_number,
                     (p->flag & HK_FD) ? p->cmd.sp : (-1),
                     p->flag,         // & HK_PREEMPTIVE) ? 'Y' : 'N',
                      p->pattern) == -1)
          buf[LLEN] = 0;
        fl_addto_browser(brow, buf);
#elif USE_GTK
        s[0] = msg_type[i].name;
        sprintf(tmp, "%d", p->ser_number);
        s[1] = tmp;
        sprintf(tmp1, "%d", (p->flag & HK_FD) ? p->cmd.sp : -1);
        s[2] = tmp1;
        sprintf(tmp2, "%d", p->flag);
        s[3] = tmp2;
        s[4]=p->flag&HK_PREEMPTIVE? "Y":"N";
        s[5] = p->pattern;
        row = gtk_clist_append(GTK_CLIST(brow), s);
        gtk_clist_set_row_data(GTK_CLIST(brow),row,(gpointer)p->id);
        if (p->flag & HK_SUSPENDED || (p->flag & HK_FD &&
                  s_pipe[p->cmd.sp].status & (SCR_SUSPENDED | SCR_STOPPED)))
        {
          style = gtk_style_copy(brow->style);
          style->fg[GTK_STATE_NORMAL] = SPX_BLUE();
          gtk_clist_set_row_style(GTK_CLIST(brow), row, style);
        }
#endif
        }
        p = p->next;
      }
    }
    list_numhooks(numTree, brow);
  }
  else
  {
    /*     named connections */
#if USE_GTK
    char *s[3];
    char tmp[12];

#endif
    for (i = 0; i < sp_count; i++)
    {
      if (s_pipe[i].fd < 0)
        continue;

      switch (s_pipe[i].type)
       {
         case CON_SCRIPT:
#if USE_XFORMS
           sprintf(buf, "%s%s %d %s",
                   s_pipe[i].status & SCR_SUSPENDED ? "@C4@z" :
                   (s_pipe[i].status & SCR_STOPPED ? "@i" : ""),
                   s_pipe[i].name, i, s_pipe[i].to.proc->sys_cmd);
#elif USE_GTK
           s[0] = s_pipe[i].name;
           sprintf(tmp, "%d", i);
           s[1] = tmp;
           s[2] = s_pipe[i].to.proc->sys_cmd;
#endif
           break;
         case CON_SERVER:
#if USE_XFORMS
           sprintf(buf, "%s%s %d %s",
                   s_pipe[i].status & SCR_SUSPENDED ? "@C4@z" :
                   (s_pipe[i].status & SCR_STOPPED ? "@i" : ""),
                   s_pipe[i].name, i, s_pipe[i].to.server.name);
#elif USE_GTK
           s[0] = s_pipe[i].name;
           sprintf(tmp, "%d", i);
           s[1] = tmp;
           s[2] = s_pipe[i].to.server.name;
#endif
           break;
         case CON_DCC:         // what's this??? remove
#if USE_XFORMS
           sprintf(buf, "%s%s %d",
                   s_pipe[i].status & SCR_SUSPENDED ? "@C4@z" :
                   (s_pipe[i].status & SCR_STOPPED ? "@i" : ""),
                   s_pipe[i].to.dcc.nick, i);
#elif USE_GTK
           s[0] = s_pipe[i].to.dcc.nick;
           sprintf(tmp, "%d", i);
           s[1] = tmp;
           s[2] = "";
#endif
           break;
           break;
         default:
           break;
       }
#if USE_XFORMS
      fl_addto_browser(brow, buf);
#elif USE_GTK
      row = gtk_clist_append(GTK_CLIST(brow), s);
      if (s_pipe[i].status & SCR_SUSPENDED)
      {
        style = gtk_style_copy(brow->style);
        style->fg[GTK_STATE_NORMAL] = SPX_BLUE();
        gtk_clist_set_row_style(GTK_CLIST(brow), row, style);
      }
      else if (s_pipe[i].status & SCR_STOPPED)
      {
        style = gtk_style_copy(brow->style);
        gdk_font_unref(style->font);
        style->font = spx_idx2font(STYLE_ITALIC);
        gtk_clist_set_row_style(GTK_CLIST(brow), row, style);
      }
#endif
    }
  }
  if (script)
#if USE_XFORMS
    fl_unfreeze_form(script_form->scriptcontrol);
#elif USE_GTK
  gtk_clist_thaw(GTK_CLIST(brow));
#endif
}
static void list_numhooks(NumHook * h, SPX_OBJ(brow))
{
  if (h)
  {
    On *p;

#if USE_XFORMS
    char *buf;

#elif USE_GTK
    char *s[6];
    char tmp[12],
         tmp0[12],
         tmp1[8],
         tmp2[12];
#endif

    list_numhooks(h->left, brow);

#if USE_XFORMS
#define BUFLEN 255
    buf = my_malloc(sizeof(char) * BUFLEN + 1);
#endif

    p = h->start;
    while (p != h->end)
    {
     if(!(p->flag&HK_DIRTY))
        {

#if USE_XFORMS
      if (snprintf(buf, BUFLEN,
                   "%s%-19.3d %-4d %-12d %-6d %-10d  %s",
                   (p->flag & HK_SUSPENDED ||
                    (p->flag & HK_FD &&
                     s_pipe[p->cmd.sp].status & (SCR_SUSPENDED | SCR_STOPPED)
                    )
                   )? "@C4@z" : "",
                   h->numeric,
                   p->id, p->ser_number,
                   (p->flag & HK_FD) ? p->cmd.sp : (-1),
                   p->flag,           // & HK_PREEMPTIVE) ? 'Y' : 'N',
                    p->pattern) == -1)
        buf[LLEN] = 0;
      fl_addto_browser(brow, buf);
#elif USE_GTK
      gint row;
      GtkStyle *style = NULL;

      sprintf(tmp0, "%d", h->numeric);
      s[0] = tmp0;
      sprintf(tmp, "%d", p->ser_number);
      s[1] = tmp;
      sprintf(tmp1, "%d", (p->flag & HK_FD) ? p->cmd.sp : -1);
      s[2] = tmp1;
      sprintf(tmp2, "%d", p->flag);
      s[3] = tmp2;
      s[4]=p->flag&HK_PREEMPTIVE? "Y":"N";
      s[5] = p->pattern;
      row = gtk_clist_append(GTK_CLIST(brow), s);
      gtk_clist_set_row_data(GTK_CLIST(brow),row,(gpointer)p->id);
      if (p->flag & HK_SUSPENDED || (p->flag & HK_FD &&
                  s_pipe[p->cmd.sp].status & (SCR_SUSPENDED | SCR_STOPPED)))
      {
        style = gtk_style_copy(brow->style);
        style->fg[GTK_STATE_NORMAL] = SPX_BLUE();
        gtk_clist_set_row_style(GTK_CLIST(brow), row, style);
      }
#endif
      }
      p = p->next;
    }
#if USE_XFORMS
    free(buf);
#endif
    list_numhooks(h->right, brow);
  }
}

static void collect_hook_garbage(On ** p, On ** end)
{
    On *q = (*p)->next;
    
    free((*p)->pattern);
#if REGEX_HOOKS
    if ((*p)->flag & HK_REGEX)
    {
      regfree((*p)->preg);
      free((*p)->preg);
    }
#endif
    if ((*p)->flag & HK_IN)
      free((*p)->cmd.cmd);
#if _GUILE
    else if ((*p)->flag & HK_SCM)
      remove_func((*p)->cmd.scm);
#endif
    if (q == *end)
      *end = *p;
    else **p = *q;
    free(q);
}

static void purify_hook_stack(On **head, On **trail)
{
  On *p=*head;
  while(p!=*trail)
        if((p)->flag&HK_DIRTY)
           collect_hook_garbage(&p, trail);
        else p=p->next;

} 
static void sweep_numerics( NumHook *h)
{
  if (h)
  {
    sweep_numerics(h->left);
    if (h->start != h->end)
        purify_hook_stack(&h->start, &h->end);
    sweep_numerics(h->right);
  }
}

void collect_stale_hooks(void)
{
  register int i = 0;
  for(;i< MAX_ON;i++)
    if(want[i].start != want[i].end)
      purify_hook_stack(&want[i].start, & want[i].end);
  sweep_numerics(numTree);
}

#define DUMMY_SN -30514797 /* dont use this SN if u intend to remove hooks based on
SN. it helps is used for removing all hooks that have a serial number*/ 
static char update_display=0;
static void taint_hook(On ** p,
                          int ser_nr,
                          char *pattern,
                          char preempt)
{
/*
   remove one on-hook entry from a hook list
   *p is the head of the list
   *end is the sentinel.
 */
  if (
       !((*p)->flag &HK_DIRTY)
        &&
       ((!preempt && !((*p)->flag & HK_PREEMPTIVE)) ||
        (preempt && (*p)->flag & HK_PREEMPTIVE))
       &&
       ((*p)->flag & (HK_IN | HK_SCM))
       &&
       ((*p)->ser_number == ser_nr || (ser_nr == DUMMY_SN && (*p)->ser_number != 0))
       &&
       (!pattern ||
        ((((*p)->flag & HK_ICASE) && !strcasecmp((*p)->pattern, pattern))
         || (!((*p)->flag & HK_ICASE) && !strcmp((*p)->pattern, pattern))))
     )
  {
    (*p)->flag |=HK_DIRTY;
    update_display=1;
  }
  *p = (*p)->next;
}

static void remove_hook_bytype(MsgNr j,
                               int ser_nr,
                               char *pattern,
                               char preempt)
{
/*   remove numeric hook if event matches <pattern> */
  On *q;

  q = want[j].start;
  while (q != want[j].end)
    taint_hook(&q, ser_nr, pattern, preempt);
}

static void remove_numhook_bynum(int numeric, int ser_nr, char *pattern,
                                 NumHook * h, char preempt)
{
  if (h)
  {
    On *p;

    remove_numhook_bynum(numeric, ser_nr, pattern, h->left, preempt);
    p = h->start;
    if (h->numeric == numeric)
      while (p != h->end)
        taint_hook(&p, ser_nr, pattern, preempt);
    remove_numhook_bynum(numeric, ser_nr, pattern, h->right, preempt);
  }
}

static void hook_replace(On * p, On * what, int not_different, void *proc)
/*
   replace p with what 
 */
{
  if (not_different)            // pattern exists already; just change it 

  {
    //  not really required.just for optical reasons-- the display
    // we display "foo" instead of "FOo" altho matching is case-insensitive
    free(p->pattern);
    p->pattern = strdup(what->pattern);
  }
  if (p->flag & HK_IN){
    free(p->cmd.cmd);
    p->flag &= ~HK_IN;
  }
#if _GUILE
  else if (p->flag & HK_SCM){
    remove_func(p->cmd.scm);
    p->flag &= ~HK_SCM;
  }
  if (what->flag & HK_SCM)
    p->cmd.scm = define_func(*((SCM *) proc));
  else
#endif
  if (what->flag & HK_IN)
    p->cmd.cmd = strdup(what->cmd.cmd);
  p->flag |= what->flag;
}
static void insert_hook(On ** q, On * what, On ** end)
// insert what just before q
{
  On *p = my_malloc(sizeof(On));

  *p = **q;
#if REGEX_HOOKS
  if (what->flag & HK_REGEX)
  {
    int ret;
    regex_t *preg;

    preg = my_malloc(sizeof(regex_t));
    ret = regcomp(preg,
                  what->pattern,
                  what->flag & HK_ICASE ?
       (REG_EXTENDED | REG_NOSUB | REG_ICASE) : (REG_EXTENDED | REG_NOSUB));
    if (ret)
    {
#define ERRLEN 64
      char errbuf[ERRLEN];

      regerror(ret, preg, &errbuf[0], ERRLEN);
      say2(0, -1, 1, "Error in regex \"%s\": %s", what->pattern, errbuf);
      free(preg);
      free(p);
      if (gflags & BEEP_ERR)
        spx_bell(0);
      return;
    }
    (*q)->preg = preg;
    (*q)->pattern = strdup(what->pattern);
  }
  else
#endif
    (*q)->pattern = strdup(what->pattern);
  if (*q == *end)
    *end = p;
  (*q)->next = p;
  (*q)->flag = what->flag;
#if _GUILE
  if (what->flag & HK_SCM)
    (*q)->cmd.scm = what->cmd.scm;
  else
#endif
  if (what->flag & HK_IN)
    (*q)->cmd.cmd = strdup(what->cmd.cmd);
  else
  {
    assert(what->flag & HK_FD);
    (*q)->cmd.sp = what->cmd.sp;
  }
  (*q)->ser_number = what->ser_number;
  (*q)->id = ++event_id;
}
static void insert_it(On ** start, On ** end, On * what, void *proc)
{
  On *p = *start,
      *q;

  while (p != *end)
  {
    if (
         (((p->flag & HK_ICASE) && (what->flag & HK_ICASE) &&
           !strcasecmp(p->pattern, what->pattern))
          ||
          (!(p->flag & HK_ICASE) && !(what->flag & HK_ICASE) &&
           !strcmp(p->pattern, what->pattern)))
         &&
         (((p->flag & HK_PREEMPTIVE && what->flag & HK_PREEMPTIVE)
           || (!(p->flag & HK_PREEMPTIVE) && !(what->flag & HK_PREEMPTIVE)))
          &&
          (((p->flag & (HK_IN | HK_SCM) && what->flag & (HK_IN | HK_SCM))
            &&
            ((what->flag & (HK_IN | HK_SCM))
             && p->ser_number == what->ser_number))
           ||
           (what->flag & HK_FD && s_pipe[p->cmd.sp].fd ==
            s_pipe[what->cmd.sp].fd && p->ser_number == what->ser_number))))
    {
      hook_replace(p, what, 0, proc);
      return;
    }
    else
      p = p->next;
  }
#if _GUILE
  if (what->flag & HK_SCM)
  {
    what->cmd.scm = define_func(*((SCM *) proc));
  }
#endif
  q = *start;
  if (*start != *end &&
      !(what->flag & HK_FD && !((*start)->flag & HK_EXCLUSIVE)))
  {
    p = *end;
    if (what->ser_number == 0)
      while (q != p && q->ser_number != 0)
        q = q->next;
    else
    {
      p->ser_number = what->ser_number;
      while (q->ser_number < what->ser_number)
        q = q->next;
    }
  }
  insert_hook(&q, what, end);
}
void add_hook2(MsgNr i, On * what, void *proc)
{
/*
   add a hook on a non-server numeric event 
 */

#if _GUILE
  assert(what->flag & (HK_IN | HK_SCM | HK_FD));
#else
  assert(what->flag & (HK_IN | HK_FD));
#endif
  if (want[i].start == want[i].end && want[i].start == NULL)
  {
    want[i].start = want[i].end = my_malloc(sizeof(On));
    want[i].start->flag = HK_RESET;	//HK_RESET_MODE;

  }
  insert_it(&(want[i].start), &(want[i].end), what, proc);
}

static int add_numeric(pNumHook *, int);
void add_numhook2(int numeric, On * what, void *proc)
// hook on a server numeric
{
  NumHook *N;

#if _GUILE
  assert(what->flag & (HK_IN | HK_SCM | HK_FD));
#else
  assert(what->flag & (HK_IN | HK_FD));
#endif

  N = find_numhook(numeric);
  if (!N)
  {
    add_numeric(&numTree, numeric);
    N = find_numhook(numeric);
    assert(N);
  }
  insert_it(&(N->start), &(N->end), what, proc);
}

NumHook *find_numhook(int numeric)
{
  NumHook *p = numTree;

  while (p)
  {
    if (p->numeric == numeric)
      return p;
    else if (p->numeric > numeric)
      p = p->left;
    else
      p = p->right;
  }
  return NULL;
}

static void num_left_rotate(pNumHook * pp)
{
  pNumHook p = *pp,
       r;

  *pp = r = p->right;
  p->right = r->left;
  r->left = p;
  p->bf--;
  if (r->bf > 0)
    p->bf -= r->bf;
  r->bf--;
  if (p->bf < 0)
    r->bf += p->bf;
}

static void num_right_rotate(pNumHook * pp)
{
  pNumHook p = *pp,
       l;

  *pp = l = p->left;
  p->left = l->right;
  l->right = p;
  p->bf++;
  if (l->bf < 0)
    p->bf -= l->bf;
  l->bf++;
  if (p->bf > 0)
    l->bf += p->bf;
}

static int add_numeric(pNumHook * pp, int numeric)
{

  int dH = 0;
  pNumHook p = *pp;

  if (p == NULL)
  {

    *pp = p = (pNumHook) my_malloc(sizeof(NumHook));
    p->numeric = numeric;
    p->start = p->end = (On *) my_malloc(sizeof(On));
    p->bf = 0;
    p->left = p->right = NULL;
    dH = 1;
  }
  else
  {
    if (numeric > p->numeric)
    {
      if (add_numeric(&p->right, numeric))
      {
        p->bf++;
        if (p->bf == 1)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            num_right_rotate(&p->right);
          num_left_rotate(pp);
        }
      }
    }
    else if (numeric < p->numeric)
    {
      if (add_numeric(&p->left, numeric))
      {
        p->bf--;
        if (p->bf == -1)
          dH = 1;
        else if (p->bf == -2)
        {
          if (p->left->bf == 1)
            num_left_rotate(&p->left);
          num_right_rotate(pp);
        }
      }
    }
  }
  return dH;
}

static int do_internal_hook(On * h, const char *msg, int w, char preempt)
/*
   return 0 if message processing should continue, else 1 
 */
{
  assert(h->flag & (HK_IN | HK_SCM));
#if _GUILE
  if (h->flag & HK_SCM)
  {
    if (h->cmd.scm == -1)
      return 1;
    else
    {
#define DAT_SIZE 80
      char data[DAT_SIZE + 1];
      Scm_cmd_arg args;
      SCM ret;

      if (snprintf(data, DAT_SIZE, "Processing hook %d, SN=%d: \"%s\"",
                   h->flag, h->ser_number, (char *) msg) == -1)
      {
        data[DAT_SIZE] = 0;
        strcpy(&data[DAT_SIZE - 4], "...\"");
      }
      args.func = h->cmd.scm;
      args.args = gh_list(gh_str02scm((char *) msg),
                          gh_long2scm(w),
                          SCM_UNDEFINED);
      ret = gh_catch(SCM_BOOL_T, &call_scm_command, &args,
                     (scm_catch_handler_t) & exception_handler,
                     (void *) &data);
      // value of h may now no longer be valid!
      if (preempt)
        return (!gh_equal_p(ret, SCM_BOOL_F));	//#f continues 

      else
        return 0;
    }
  }
  else if (!preempt)
#endif
  {
    char *buf;

    buf = expand_quote(h->cmd.cmd, msg, w);
    if (buf)
    {
      new_process_cmd(buf, w);
      free(buf);
    }
  }
  return 0;
}

#if _GUILE
static int preempted(On *p, On *end, const char *pat, int w)
{
  int ret = 0;
  
  while (p != end)
  {
    if (!(p->flag & (HK_SUSPENDED|HK_DIRTY))
#if _GUILE
          && (p->flag & HK_PREEMPTIVE)
#endif
    )
    {
      int res;

#if REGEX_HOOKS
      if (p->flag & HK_REGEX)
        res = regexec(p->preg,
                      pat,
                      0, NULL, 0);
      else
#endif
        res = fnmatch(p->pattern, pat,
                      p->flag & HK_ICASE ?
                      FNM_PATHNAME | FNM_PERIOD | FNM_CASEFOLD :
                      FNM_PATHNAME | FNM_PERIOD);
      if (res == 0)
      {
        ret = do_internal_hook(p, pat, w, 1);
        if (ret)
          break;
      }
    }
    p = p->next;
  }
  return ret;
}
#endif
static int match_it(On *p, On *end, const char *pat, short win)
{

#if _GUILE
  if (preempted(p, end, pat, win))
    return 1;
  else
#endif
  {
    char stop = 0,
         do_external = 1;
    
    while (p != end)
    {
      if (!(p->flag & (HK_SUSPENDED|HK_DIRTY
#if _GUILE
          | HK_PREEMPTIVE
#endif
         )))
      {
        int ret;

#if REGEX_HOOKS
        if (p->flag & HK_REGEX)
          ret = regexec(p->preg,
                        pat,
                        0, NULL, 0);
        else
#endif
          ret = fnmatch(p->pattern, pat,
                        p->flag & HK_ICASE ?
                        FNM_PATHNAME | FNM_PERIOD | FNM_CASEFOLD :
                        FNM_PATHNAME | FNM_PERIOD);
        if (ret == 0)
        {
          if (p->flag & (HK_SCM | HK_IN))
          {
            if (p->ser_number == 0)
              stop = 1;
            do_internal_hook(p, pat, win, 0);
          }
          else if (p->flag & HK_FD)
          {
            if (do_external)
            {
              char *s = alloca(sizeof(char) * (strlen(pat) + 64));

              sprintf(s, "%d %d %s\n", win, p->ser_number, pat);
              if (!write_to_sp(p->cmd.sp, s) &&
                  (p->flag & HK_EXCLUSIVE))
                do_external = 0;
            }
          }
        }
      }
      p = p->next;
    }
    return (stop || !do_external);
  }
}

extern int check_msg_hook(MsgNr i, int w, const char *fmt, ...)
{
  if (want[i].start != want[i].end)
  {
    va_list ap;
    char *buf;
    int ret = 256;

    buf = (char *) my_malloc(sizeof(char) * ret);

    *buf = 0;
    va_start(ap, fmt);
    while (buf != NULL)
      if (vsnprintf(buf, ret, fmt, ap) == -1)
      {
        ret *= 2;
        buf = (char *) my_realloc(buf, ret);
      }
      else
        break;
    va_end(ap);
    if (buf[0] == 0)
      buf[0] = ' ';
    ret = match_it(want[i].start, want[i].end, buf, w);
    free(buf);
    return ret;
  }
  return 0;
}

extern int check_numeric(int numeric,
                         Winstruct * win,
                         const char *msg)
{
  NumHook *N;

  N = find_numhook(numeric);
  if (!N || N->start == N->end)
    return 0;
  else
  {
    char *buf;
    int ret;
    assert(win);
    buf = malloc(sizeof(char) * (strlen(msg) + strlen(win->server->name) + 12));

    sprintf(buf, "%s,%hu %s", win->server->name, win->server->port, msg);

    ret = (match_it(N->start, N->end, buf, win - winstruct));
    free(buf);
    return ret;
  }
}

static void remove_hook(MsgNr type, char *str, int num, char preempt)
{
/*
   remove one or many events for a message type or for a numeric(if
   numeric!=0)

   #privmsg 300 "foo bar base.."  quotes not required if either a ser_no is
   given, or '#' is not used.
   1) -del #type [ser_no] [pattern]
   ser_no not given => remove all serial nos (ser_no=DUMMY_SN)
   2) -del type [pattern] =>  ser_no=0
   pattern not given at all => all patterns

 */
  char *pattern;
  int ser_nr = DUMMY_SN;
  char *s;

  pattern = alloca(sizeof(char) * strlen(str));

  *pattern = '\0';
  if (*str == '#')
  {
    if (*(str + 1) == '\0')
      return;
    s = nextword(str, 1);
    if (sscanf(str, "%*s %d", &ser_nr) != 1 && *s)
    {
      fprintf(stderr, "Missing SN-- \"%s\"\n", str);
      free(s);
      return;
    }
    sscanf(str, "%*s %*s %[^\n]\n", pattern);

    free(s);
  }
  else
  {
    ser_nr = 0;
    sscanf(str, "%*s %[^\n]\n", pattern);
  }
  if (*pattern && *pattern == '"')
  {
    size_t ll = strlen(pattern) - 1;

    if (ll > 0 && *(pattern + ll) == '"')
    {
      *(pattern + ll) = '\0';
      s = pattern + 1;
    }
    else
    {
      fprintf(stderr, "unterminated \"\"\"\n");
      return;
    }
  }
  else
    s = *pattern ? pattern : NULL;
  if (num)
    remove_numhook_bynum(num, ser_nr, s, numTree, preempt);
  else
    remove_hook_bytype(type, ser_nr, s, preempt);
  /*if (script_form)
    list_hooks(1);
    */
}
void delete_hook(char *what, char preempt, char update)
{
  //int had_error = 1,
  int     num;
  char *cmd,
      *tt,
      *foo;

  update_display=0;
  foo = alloca(sizeof(char) * (1 + strlen(what)));

  sscanf(what, "%s", foo);
  cmd = foo;
  if (*cmd == '#')
  {
    cmd++;
    if ((*cmd == '\0'))
    {
      fprintf(stderr, "%s: missing msg type", what);
      return;
    }
  }
  num = strtol(cmd, &tt, 0);
  if (*tt)
  {
    MsgNr type;

    type = get_type(cmd);
    if (type != INVALID)
      remove_hook(type, what, 0, preempt);
    else
      fprintf(stderr, "Unknown event type:%s\n", cmd);
  }
  else if (!(*tt) && num > 0)
    remove_hook(0, what, num, preempt);
  else
    fprintf(stderr, "Invalid numeric:%s\n", cmd);
  if (script_form && update && update_display)
    list_hooks(1);

}
