/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
   idle_cb.c - activities for an idle client.
   Copyright (c) 1997-1999 Tano Fotang
   
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include "spx.h"
#include <time.h>
#include "server.h"
#include "dcc.h"
#include "ignore.h"
#include "lag.h"
#include "idle_cb.h"
#include "cmd.h"
#include "flood.h"
#include "timer.h"
#include "scheme.h"
#include "notify.h"
#include "userhost.h"
#include "hooks.h"
//extern void collect_stale_hooks(void);
static void check_server_lag(Server * p)
{
  if (p)
  {
    Server *s = search_server_tree_byname(p->g, p->name, p->port);

    assert(s);
    check_server_lag(p->left);
    if (s->lag)
    {
      struct timeval t;

      gettimeofday(&t, NULL);
      update_lag_display(s,
                         t.tv_sec - s->lag->when.tv_sec +
                   (float) ((t.tv_usec - s->lag->when.tv_usec) / 1000000.0),
                         (struct timeval *) 0);
    }
    check_server_lag(p->right);
  }
}

// clear flood list
#define DEL_CNT  50
static void update_flood(Flood * p, time_t t,
                         char *buf[DEL_CNT], int *n)
{
  if (p && *n < DEL_CNT)
  {
    update_flood(p->right, t, buf, n);
    if (t - p->at > flood_period)
    {
      buf[(*n)] = strdup(p->from);
      (*n)++;
    }
    update_flood(p->right, t, buf, n);
  }
}
static void check_flood(pFlood * tree)
{

  //Flood **tree=priv?&floodTree:&publicfloodTree;
  if (tree)
  {
    char *buf[DEL_CNT];
    int n = 0;

    update_flood(*tree, time(NULL), buf, &n);
    while (n-- > 0)
    {
      clear_flood(buf[n], tree, 0);

      //assert(res == 0);
      free(buf[n]);
    }
  }
}

extern void remove_dcc_by_id(int);
static void check_dcc(void)
{
  if (dccStart != dccEnd)
  {
    DCC *p = dccStart;
    time_t t = time(NULL);

    while (p != dccEnd){
      if(p->type& ~DCC_ACTIVE){
        if (t > (p->starttime + dcc_timeout * 60))
          remove_dcc_by_id(p->id);
      }
      if(p!=dccEnd)/* p is changed when you delete one*/
        p = p->next;
    }
  }
}

static void check_alarm(time_t t)
{
  register int i;

  for (i = 0; i < timer_count; i++)
    if (aTimer[i].type != -1 && aTimer[i].flag & TIMER_ALARM && aTimer[i].expire.stop <= t)
    {
      if (aTimer[i].type == ALARM_IN)
      {
        int ret = -999;

        ret = new_process_cmd(aTimer[i].cmd.cmd, -1);
        if (ret && ret != -999)
          fprintf(stderr, "Timer:Unknown cmd? %s\n", aTimer[i].cmd.cmd);
        free(aTimer[i].cmd.cmd);
      }
#if _GUILE
      else if (aTimer[i].type == ALARM_SCM)
      {
#define DAT_SIZE 128
        char data[DAT_SIZE + 1];
        Scm_cmd_arg args;

        args.func = aTimer[i].cmd.scm;
        args.args = gh_list(
                             gh_long2scm(aTimer[i].ref),
                             gh_long2scm(aTimer[i].expire.stop),
                             SCM_UNDEFINED);
        sprintf(data, "Processing alarm %d at %lu",
                aTimer[i].ref, aTimer[i].expire.stop);
        scm_func[aTimer[i].cmd.scm].idx = -1;	// mark for overwrite

        gh_catch(SCM_BOOL_T, &call_scm_command, &args,
                 (scm_catch_handler_t) & exception_handler, (void *) &data);
        if (scm_func[aTimer[i].cmd.scm].idx == -1)
          remove_func(aTimer[i].cmd.scm);
      }
#endif
      aTimer[i].type = -1;
      aTimer[i].expire.stop = 0;
    }

}

#define clock_expired(then,now) \
 ((now)->tm_year > (then)->tm_year ||  \
 ((now)->tm_year==(then)->tm_year && (  \
    (now)->tm_mon>(then)->tm_mon ||      \
      ((now)->tm_mon==(then)->tm_mon && ( \
         (now)->tm_mday>(then)->tm_mday || \
	   ((now)->tm_mday==(then)->tm_mday && (  \
	     (now)->tm_hour>(then)->tm_hour ||    \
	       ((now)->tm_hour==(then)->tm_hour && ( \
	         (now)->tm_min>(then)->tm_min ||      \
		   ((now)->tm_min==(then)->tm_min &&   \
		     (now)->tm_sec>=(then)->tm_sec))))))))))

static void check_clock(time_t t)
{
  register int i;
  static struct tm *now=NULL;
  
  for (i = 0; i < timer_count; i++)
    if (aTimer[i].type != -1 && aTimer[i].flag & TIMER_CLOCK)
    {
      if(now==NULL)
        now = localtime(&t);
      if (clock_expired(aTimer[i].expire.date, now))
      {
        if (aTimer[i].type == ALARM_IN)
        {
          int ret = -999;

          ret = new_process_cmd(aTimer[i].cmd.cmd, -1);
          if (ret && ret != -999)
            fprintf(stderr, "Clock:Unknown cmd? %s\n", aTimer[i].cmd.cmd);
          free(aTimer[i].cmd.cmd);
        }
#if _GUILE
        else if (aTimer[i].type == ALARM_SCM)
        {
#define DAT_SIZE 128
          char data[DAT_SIZE + 1];
          Scm_cmd_arg args;

          args.func = aTimer[i].cmd.scm;
          args.args = gh_list(
                               gh_long2scm(aTimer[i].ref),
                               gh_list(
                                 gh_long2scm(aTimer[i].expire.date->tm_sec),
                                 gh_long2scm(aTimer[i].expire.date->tm_min),
                                gh_long2scm(aTimer[i].expire.date->tm_hour),
                                gh_long2scm(aTimer[i].expire.date->tm_mday),
                             gh_long2scm(aTimer[i].expire.date->tm_mon + 1),
                         gh_long2scm(aTimer[i].expire.date->tm_year + 1900),
                                        SCM_UNDEFINED),
                               SCM_UNDEFINED);
          sprintf(data, "Processing clock %d at %lu",
                  aTimer[i].ref, aTimer[i].expire.stop);
          scm_func[aTimer[i].cmd.scm].idx = -1;
          gh_catch(SCM_BOOL_T, &call_scm_command, &args,
                 (scm_catch_handler_t) & exception_handler, (void *) &data);
          if (scm_func[aTimer[i].cmd.scm].idx == -1)
            remove_func(aTimer[i].cmd.scm);
        }
#endif
        aTimer[i].type = -1;
        free(aTimer[i].expire.date);
      }
    }
  now=NULL;
}
static void rm_uhost(Userhost_info ** uh, Userhost_info ** end)
{
  Userhost_info *q = (*uh)->next;

  free((*uh)->cmd);
  free((*uh)->pattern);
  if (q == *end)
    *end = (*uh);
  else
    **(uh) = *q;
  free(q);
}

#if USE_XFORMS
extern int idle_cb(XEvent * ev, void *junk)
#elif USE_GTK
extern gint idle_cb(gpointer junk)
#endif
{
  static int flag = 0;

  if (aTimer)
  {
    time_t t = time(NULL);

    check_alarm(t);
    check_clock(t);
  }
  send_lag_msg();
  check_server_lag(servFdTree);
  flag %= 11;
  switch (++flag)
   {
     case 1:
       {
         Ignore *p = ignoreStart;
         time_t t = time(NULL);

         while (p != ignoreEnd)
         {
           if (p->period != 0 &&
               ((p->starttime + 60 * p->period) < t))
           {
             Ignore *q = p->next;

             free(p->mask);
             if (q == ignoreEnd)
               ignoreEnd = p;
             else
               *p = *q;
             free(q);
             continue;
           }
           p = p->next;
         }
       }
       break;
     case 2:
       check_dcc();
       break;
     case 3:
        if((time(NULL) % 10) == 0)
          collect_stale_hooks();
        break;
     case 4:
       //  automatically update ignore display?
       if (sflags & sUPDATE_IGNORE_DISPLAY)
         if (servFdTree)
           if (ignore_form /*&& (time(NULL) % 60) == 0*/)
           {
#if 1
             static char i = 0;

             i %= 6;            //  kludge to stop flashing on display 

             if ((++i) == 1)
#endif
               TRIGGER_OBJECT(ignore_form->update);
           }
       break;
     case 6:
       if (servFdTree)
         check_flood(&floodTree);
       break;
     case 7:
       if (servFdTree)
         check_flood(&publicfloodTree);
       break;
     case 8:
       if (servFdTree)
         check_notify(0);
       break;
     case 9:
       if (uh_start != uh_end)
       {
         Userhost_info *p = uh_start;
         time_t t = time(NULL);

         while (p != uh_end)
         {
           if (p->t + uhost_timeout < t)
             rm_uhost(&p, &uh_end);
           else
             p = p->next;
         }
       }
       break;
     case 10:
       if (servFdTree)
       {
         static char i = 0;

         i %= 3;
         if (++i == 1)
         {
#define CMD_TMOUT 120
           time_t t = time(NULL);
           CmdSent *p = cmdsentStart;
           CmdSent *q;

           while (p != cmdsentEnd)
           {
             if (p->t + CMD_TMOUT < t)
             {
               q = p->next;
               fprintf(stderr, "%s %s %ld\n", p->cmd, p->arg, p->t);
               free(p->cmd);
               free(p->arg);
               if (q == cmdsentEnd)
                 cmdsentEnd = p;
               else
                 *p = *q;
               free(q);
               continue;
             }
             p = p->next;
           }
         }
       }
     case 11:
       // update user list
       if ((sflags & sUPDATE_USER_DISPLAY) && servFdTree)
       {
         static time_t last_update = 0;
         time_t t = time(NULL);

         if (userupdate_frequency + last_update < t)
         {
           int i;

           last_update = t;
           for (i = 0; i < win_count; i++)
           {
             if (winstruct[i].chanwin)
             {
               Channel *ch = winstruct[i].chanStart->right;

               while (ch != winstruct[i].chanStart)
               {
                 if (ch->flag & ch_UPDATE_USERS)
                 {
                   char buf[255];

                   sprintf(buf, "/who -update %s", ch->name);
                   new_process_cmd(buf, i);
                 }
                 ch = ch->right;
               }
             }
           }
         }
       }
       break;
     default:
       break;
   }
#if USE_XFORMS
  return 0;
#else
  return TRUE;
#endif
}
