/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
 *  ignore.c  - handles all i g n o r e s
 *
 * (C) 1997-1999 Tano Fotang
 *
 * This software is distributed under the GNU General Public License,
 * either version 2, or any later version. The license is included
 * herein by reference.
 *
 */

// there are memory leaks in here. check malloc's

#include "spx.h"
#include <errno.h>
#include <sys/param.h>
#include <fnmatch.h>
#include "config.h"
#include "ignore.h"
#include "cmd.h"
Ignore_form *ignore_form = NULL;
Ignore *ignoreStart, *ignoreEnd;
#if USE_GTK
GtkWidget *create_edit_ignore(void);
#endif
typedef struct
{
  char *name;
  int what;
  char *help;
}
What;

	/*ignore cmds; keep sorted!!! */
static What ig_what[] =
{
  {"abs", IG_ABS, "Absolutely abandon (even nick, mode, topic..changes: evyrthang)"},
  {"all", IG_ALL, "all message types and DCCs"},
  {"channel", IG_PUBMSG, "normal channel messages"},
  {"ctcp", IG_CTCP, "all CTCPs (ping, time etc)"},
  {"dcc", IG_DCC, "all DCC's (chat, send file requests)"},
  {"etc", IG_MISC, "nick, mode, topic changes by the person, plus some xtra stuff"},
  {"everythang", IG_ABS, "same as abs"},
  {"invites", IG_INVITE, "invitations"},
  {"misc", IG_MISC, "same as etc"},
  {"msg", IG_PRIVMSG, "private messages"},
  {"none", IG_NONE, "ignore nothing (reset)"},
  {"notes", IG_NOTE, "notes"},
  {"notices", IG_PRIVNOTICE, "private notices"},
  {"pubmsg", IG_PUBMSG, "normal channel messages"},
  {"pubnotices", IG_PUBNOTICE, "public (chanel) notices"},
};

static int binary(const char *var, int n)
{
  register int low,
       high,
       mid,
       cond;

  low = 0;
  high = n - 1;
  while (low <= high)
  {
    mid = (low + high) / 2;
    if ((cond = strcasecmp(var, ig_what[mid].name)) < 0)
      high = mid - 1;
    else if (cond > 0)
      low = mid + 1;
    else
      return mid;
  }
  return -1;
}
#if _GUILE
extern int ignored_p(const char *mask, const char *what)
{
  int i;

  i = binary(what, sizeof(ig_what) / sizeof(What));
  if (i < 0)
    return 0;
  else
    return ignored(mask, ig_what[i].what);
}
#endif
extern int ignored(const char *mask, int flag)
{
  Ignore *p = ignoreStart;
  char *pat = lowercase(mask);

  while (p != ignoreEnd)
  {
    char *m = lowercase(p->mask);

    if (
         !fnmatch(m, pat, FNM_PATHNAME | FNM_PERIOD)
         && (p->what & flag))
    {
      free(pat);
      free(m);
      return 1;
    }
    free(m);
    p = p->next;
  }
  free(pat);
  return 0;
}

Ignore *get_ignore(const char *mask)
{
  Ignore *p = ignoreStart;

  while (p != ignoreEnd)
  {
    if (!strcasecmp(mask, p->mask))
      return p;
    else
      p = p->next;
  }
  return NULL;
}

static char *save_ignore(const char *fname)
{
  FILE *fp;
  Ignore *p;
  time_t t = time(NULL);
  char buf[MAXLINE];

  if (!fname)
  {
    sprintf(buf, "%s/" P_IGNORE, prog_home);
    fname = alloca(sizeof(char) * (strlen(buf) + 1));

    strcpy((char *) fname, buf);
  }
  if (access(fname, F_OK) > -1)
  {
    if (access(fname, W_OK) < 0)
    {
      return NULL;
    }
    sprintf(buf, "%s.bak", fname);
    rename(fname, buf);         /* dont care whether this succeeds or not */
  }
  if ((fp = fopen(fname, "w")) == NULL)
  {                             /* jeez.. stop repeatin yerself */
    return NULL;
  }
  fprintf(fp, "%c" sula_NAME " " sula_VERSION "\n%cIgnore list %s\n\n", COMMENT, COMMENT, ctime(&t));
  p = ignoreStart;
  while (p != ignoreEnd)
  {
    sprintf(buf, "%s\t%#x\t%hu\n", p->mask, p->what, p->period);
    fputs(buf, fp);
    p = p->next;
  }
  fflush(fp);
  fclose(fp);
  return strdup(fname);
}
static char *load_ignore(const char *fname)
{

  FILE *fp;
  Ignore *p,
      *q;
  char buf[MAXLINE + 1];

  if (!fname)
  {
    sprintf(buf, "%s/" P_IGNORE, prog_home);
    fname = strdup(buf);
  }
  fprintf(stderr, "load ignore:%s\n", fname);
  if ((fp = fopen(fname, "r")) == NULL)
    return 0;
  while (fgets(buf, MAXLINE, fp) != NULL)
  {
    char *l;
    int i;

    buf[strlen(buf) - 1] = '\0';
    l = clean(buf);
    if (!l || *l == COMMENT)
      continue;
    p = (Ignore *) my_malloc(sizeof(Ignore));
    p->mask = nextword(l, 0);
    i = sscanf(l, "%*s %i %hu", &p->what, &p->period);
    if (i < 2)
      p->period = 0;
    if (i < 1)
      p->what = IG_ALL;
    p->starttime = time(NULL);
    q = ignoreStart;
    ignoreStart = (Ignore *) my_malloc(sizeof(Ignore));
    *ignoreStart = *p;
    ignoreStart->next = q;
  }
  fclose(fp);
  return strdup(fname);
}

#define ig_remove	0
#define ig_add		1
static int remove_ignore(const char *);
static void list_ignore(SPX_OBJ(brow))
{
  Ignore *p = ignoreStart;
  char i = 0;

  while (p != ignoreEnd)
  {
    char buf[1024],
         s[200];
    char t[20];

    if (p->period > 0)
      sprintf(t, "%ld min(s)", 1 + (p->starttime + 60 * p->period - time(NULL)) / 60);
    else
      strcpy(t, "infinity");
    if (!i)
    {
      spx_writeln(brow, "");
      sprintf(buf, "@f@v@.%-20s %-10s Stuff", "Who", "Time left");
      spx_writeln(brow, buf);
      i = 1;
    }
    if (p->what == IG_ABS)
      sprintf(s, "all traces of them");
    else if (p->what == IG_ALL)
      sprintf(s, "all message types");
    else
    {
      size_t ll;

      sprintf(s, "%s%s%s%s%s%s%s%s%s",
              p->what & IG_MISC ? "misc.(mode,nick..), " : "",
              p->what & IG_PRIVMSG ? "priv. msgs, " : "",
              p->what & IG_PUBMSG ? "chan. msgs, " : "",
              p->what & IG_PRIVNOTICE ? "priv. notices, " : "",
              p->what & IG_PUBNOTICE ? "chan. notices, " : "",
              p->what & IG_INVITE ? "invites, " : "",
              p->what & IG_DCC ? "DCCs, " : "",
              p->what & IG_NOTE ? "notes, " : "",
              p->what & IG_CTCP ? "CTCPs " : ""
         );
      ll = strlen(s) - 1;
      if (*s && *(s + --ll) == ',')
        *(s + ll) = '\0';
    }
    sprintf(buf, "@.%-30s %-10s %s", p->mask, t, s);
    spx_writeln(brow, buf);
    p = p->next;
  }

  if (i == 0)
    spx_writeln(brow, "\n" PROMPT "Ignore list is empty");

  return;
}

extern void ignore(int argc, char **argv, int to)
{
  /* e.g.: ig mask -all +all -privmsg +pubotice for 10
     ig -c(lear)
     ig -d(elete) 
   */
  char flag = ig_add,
       new_ig = 0,
       has_changed = 0;
  int i;
  int nvars;
  Ignore *p = NULL;

  if (argc == 1 || !strncasecmp(argv[1], "-list", 5))
  {
    /* FIXME : use say() */
    list_ignore(win_invalid(to) ? main_window->browser:winstruct[to].chanwin->browser);
    return;
  }
  if (!strncasecmp(argv[1], "-load", 5))
  {
    char *fname = load_ignore(argv[2]);

    if (!fname)
    {
      char *errstr = strerror(errno);
      char *buf = alloca(sizeof(char) * (strlen(errstr) +
                                         strlen(PROMPT) + 16));

      sprintf(buf, PROMPT "ignore_file: %s", errstr);
      say(buf, to, 2);
    }
    else if (ignore_form)
      TRIGGER_OBJECT(ignore_form->update);
    free(fname);
    return;
  }
  if (!strncasecmp(argv[1], "-save", 5))
  {
    char *fname = save_ignore(argv[2]);

    if (!fname)
    {
      char *errstr = strerror(errno);
      char *buf = alloca(sizeof(char) * (strlen(errstr) +
                                         strlen(PROMPT) + 24));

      sprintf(buf, PROMPT "No write access: %s", errstr);
      say(buf, to, 2);
    }
    else
      free(fname);
    return;
  }

  argv++;

  if (!strncasecmp(*argv, "-clear", 6))
  {
    Ignore *p = ignoreStart;

    say(PROMPT "Clearing ignore list..", to, 2);
    while (p != ignoreEnd)
    {
      Ignore *q = p->next;

      free(p->mask);
      if (q == ignoreEnd)
        ignoreEnd = p;
      else
        *p = *q;
      free(q);
    }
    if (ignore_form)
      TRIGGER_OBJECT(ignore_form->update);
    return;
  }

  p = get_ignore(*argv);
  if (p)
  {                             /*&& p!=NULL */

    if (argc < 3)
      p->what = IG_ALL;
    p->starttime = time(NULL);

  }
  else if (!p)
  {
    p = (Ignore *) my_malloc(sizeof(Ignore));
    new_ig = 1;
    p->mask = strdup(*argv);
    p->what = argc < 3 ? IG_ALL : 0;
    p->period = 0;
    has_changed = 0;
  }
  argv++;
  nvars = sizeof(ig_what) / sizeof(What);
  while (*argv)
  {
    if ((*argv)[0] == '-')
    {
      flag = ig_remove;
      (*argv)++;
      if (!(*argv))
        continue;
    }
    else
    {
      if (**argv == '+')
      {
        (*argv)++;
        if (!(**argv))
        {
          argv++;
          continue;
        }
      }
      if (!strcasecmp(*argv, "for"))
      {
        char u[8];

        if ((!(*++argv) || sscanf(*argv, "%hu", &p->period) < 1))
        {
          say(PROMPT "ignore: for how long?", to, 2);
          continue;
        }
        if (sscanf(*argv, "%*u%7s", u) < 0)
          if (!(*++argv) || sscanf(*argv, "%7s", u) < 0)
            continue;
        if (!strcasecmp(u, "mins") || !strcasecmp(u, "minutes")
            || !strcasecmp(u, "minute") || !strcasecmp(u, "min"))
        {
          argv++;
        }
        else if (!strcasecmp(u, "sec") || !strcasecmp(u, "secs")
                 || !strcasecmp(u, "second") || !strcasecmp(u, "seconds"))
        {
          if (p->period < 60)
            p->period = 60;
          p->period /= 60;
          argv++;
        }
        else if (!strcasecmp(u, "hour") || !strcasecmp(u, "hours")
                 || !strcasecmp(u, "hrs") || !strcasecmp(u, "hr"))
        {
          p->period *= 60;
          argv++;
        }
        continue;
      }
      else
        flag = ig_add;
    }
    if (!(*argv))
      break;
    i = binary(*argv, nvars);
    if (i < 0)
    {
      char *buf = (char *) alloca(sizeof(char) * (strlen(PROMPT) + strlen(*argv) + 25));

      sprintf(buf, PROMPT "ignore: Unkown type \"%s\"", *argv);
      say(buf, to, 2);
      argv++;
      continue;
    }
    has_changed = 1;
    if (ig_what[i].what == IG_NONE)
      p->what = 0;
    else
      p->what = flag == ig_remove ? p->what & ~ig_what[i].what : p->what | ig_what[i].what;
    argv++;
  }
  if (new_ig && !has_changed)
    p->what = IG_ALL;
  if (p->what == 0)
  {
    char *s = (char *) alloca(sizeof(char) * (strlen(PROMPT) + strlen(p->mask) + 45));
    char *tmp = strdup(p->mask);

    if (!remove_ignore(p->mask))
    {
      sprintf(s, PROMPT "No longer ignoring %s.", tmp);
      /*else 
         sprintf(s, PROMPT"%s couldn't be removed from ignore list",p->mask);
       */
      say0(s, to, 2);
    }
    if (ignore_form)
      TRIGGER_OBJECT(ignore_form->update);
    return;
  }
  if (new_ig)
  {
    Ignore *q = ignoreStart;

    ignoreStart = (Ignore *) my_malloc2(sizeof(Ignore));
    if (!ignoreStart)
      return;
    ignoreStart->mask = strdup(p->mask);
    ignoreStart->what = p->what;
    ignoreStart->starttime = time(NULL);
    ignoreStart->period = p->period > 0 ? p->period : 0;
    ignoreStart->next = q;

  }
  if (gflags & VERBOSE_CLIENT)
  {
    char buf[MAXLINE],
         s[512];
    char t[20];

    p = ignoreStart;
    if (p->period > 0)
      sprintf(t, "%ld min(s)", (p->starttime + 60 * p->period - time(NULL)) / 60);
    else
      strcpy(t, "infinity");
    if (p->what == IG_ABS)
      sprintf(s, "be careful: ignoring completely");
    else
    {
      size_t ll;

      sprintf(s, " %s%s%s%s%s%s%s%s",
              p->what & IG_MISC ? "misc stuff, " : "",
              p->what & IG_PRIVMSG ? "priv msg, " : "",
              p->what & IG_PUBMSG ? "pub msg, " : "",
              p->what & IG_PRIVNOTICE ? "priv notices, " : "",
              p->what & IG_INVITE ? "invites, " : "",
              p->what & IG_DCC ? "DCCs, " : "",
              p->what & IG_NOTE ? "notes, " : "",
              p->what & IG_CTCP ? " CTCPs " : ""
         );
      ll = strlen(s) - 1;
      if (*(s + --ll) == ',')
        *(s + ll) = '\0';
    }
    sprintf(buf, PROMPT "Ignoring %s for %s (%s)", p->mask, t, s);
    say0(buf, to, 2);
    if (ignore_form)
      TRIGGER_OBJECT(ignore_form->update);

  }
}

static int remove_ignore(const char *mask)
{
  Ignore *p = ignoreStart;

  while (p != ignoreEnd)
  {
    if (!strcasecmp(p->mask, mask))
    {
      Ignore *q = p->next;

      free(p->mask);
      if (q == ignoreEnd)
        ignoreEnd = p;
      else
        *p = *q;
      free(q);
      return 0;
    }
    else
      p = p->next;
  }
  return (-1);
}

/*

   callbacks

 */

static void redisplay_ignore_list(void)
{

  Ignore *p = ignoreStart;
  time_t t0 = 0;

  if (p != ignoreEnd)
    t0 = time(NULL);
#if USE_XFORMS
  fl_freeze_form(ignore_form->ignore);
#elif USE_GTK
  gtk_clist_freeze(GTK_CLIST(ignore_form->clist));
#endif
  while (p != ignoreEnd)
  {
    char t[20];

#if USE_XFORMS
    char buf[128];

#elif USE_GTK
    char *buf[2];
#endif

    if (p->period > 0)
    {
      time_t tt = 1 + (p->starttime + 60 * p->period - t0) / 60;

      sprintf(t, "%ld minute%s", tt, tt > 1 ? "s" : "");
    }
    else
      strcpy(t, "infinity");
#if USE_XFORMS
    sprintf(buf, "@f%-40s %s", p->mask, t);
    fl_addto_browser(ignore_form->browser, buf);
#elif USE_GTK
    buf[0] = p->mask;
    buf[1] = t;
    gtk_clist_append(GTK_CLIST(ignore_form->clist), buf);
#endif
    p = p->next;
  }
  //deactivate all buttons
  SET_BUTTON(ignore_form->msg, 0);
  SET_BUTTON(ignore_form->pubmsg, 0);
  SET_BUTTON(ignore_form->notice, 0);
  SET_BUTTON(ignore_form->pubnotice, 0);
  SET_BUTTON(ignore_form->invites, 0);
  SET_BUTTON(ignore_form->dcc, 0);
  SET_BUTTON(ignore_form->note, 0);
  SET_BUTTON(ignore_form->ctcp, 0);
  SET_BUTTON(ignore_form->misc, 0);
#if USE_XFORMS
  fl_unfreeze_form(ignore_form->ignore);
#elif USE_GTK
  gtk_clist_thaw(GTK_CLIST(ignore_form->clist));
#endif
}
static void ig_ok(void)
{
  char *mask;
  Ignore *p;
  int n;

#if USE_XFORMS
  char *buf;

  n = fl_get_browser(ignore_form->browser);
  if (n < 1)
#elif USE_GTK
    GList *pclist = GTK_CLIST(ignore_form->clist)->selection;

  if (!pclist)
#endif
    return;
#if USE_XFORMS
  buf = (char *) fl_get_browser_line(ignore_form->browser, n);
  mask = (char *) alloca(sizeof(char) * strlen(buf));

  if (sscanf(buf, "@f%s", mask) < 1)
    return;
#endif

  do
  {
#if USE_GTK
    n = GPOINTER_TO_INT(pclist->data);
    gtk_clist_get_text(GTK_CLIST(ignore_form->clist), n, 0, &mask);
#endif
    p = get_ignore(mask);
    if (!p)
    {
      char buf[128];

      sprintf(buf, "\"%s\" has expired", mask);
      fit_object_label(ignore_form->status, buf);
    }
    else
    {
      p->what = 0;
      if (BUTTON_IS_ON(ignore_form->msg))
        p->what |= IG_PRIVMSG;
      if (BUTTON_IS_ON(ignore_form->pubmsg))
        p->what |= IG_PUBMSG;
      if (BUTTON_IS_ON(ignore_form->notice))
        p->what |= IG_PRIVNOTICE;
      if (BUTTON_IS_ON(ignore_form->pubnotice))
        p->what |= IG_PUBNOTICE;
      if (BUTTON_IS_ON(ignore_form->invites))
        p->what |= IG_INVITE;
      if (BUTTON_IS_ON(ignore_form->dcc))
        p->what |= IG_DCC;
      if (BUTTON_IS_ON(ignore_form->note))
        p->what |= IG_NOTE;
      if (BUTTON_IS_ON(ignore_form->ctcp))
        p->what |= IG_CTCP;
      if (BUTTON_IS_ON(ignore_form->misc))
        p->what |= IG_MISC;

      if (p->what == 0)
      {
        if (!remove_ignore(p->mask))
        {
          char buf[128];

          sprintf(buf, "No longer ignoring %s", mask);
          fit_object_label(ignore_form->status, buf);
        }
      }
    }
    #if USE_GTK
    pclist = pclist->next;
    #endif
  }
  while (
#if USE_XFORMS
          0
#elif USE_GTK
          pclist
#endif
     );
  TRIGGER_OBJECT(ignore_form->update);
}

#if USE_GTK
static void save_it(const char *fname, void *junk)
{
  if (fname && *fname)
  {
    char buf[512];

    if (!save_ignore(fname))
      sprintf(buf, "Cant write '%s': %s", fname, strerror(errno));
    else
      sprintf(buf, "ignore list saved to '%s'", fname);
    fit_object_label(ignore_form->status, buf);
  }
}
static void load_it(const char *fname, void *junk)
{
  if (fname && *fname)
  {
    char buf[512];

    if (!load_ignore(fname))
      sprintf(buf, "Cant read '%s': %s", fname, strerror(errno));
    else
      sprintf(buf, "ignore list '%s' loaded", fname);
    fit_object_label(ignore_form->status, buf);
    TRIGGER_OBJECT(ignore_form->update);
  }
}
#endif
void ig_save(void)
{
  char buf[512];

  snprintf(buf, 511, "%s/" P_IGNORE, prog_home);
#if USE_GTK
  get_filename2(sula_NAME ": Save ignore list",
               buf, save_it, NULL);
#elif USE_XFORMS
  {
    char *ptr;

    fl_set_cursor(ignore_form->ignore->window, XC_watch);
    fl_deactivate_form(ignore_form->ignore);
    ptr = getstr2("File name:",
          sula_NAME " " sula_VERSION ": Save ignore list", "ignore.txt", 1);
    fl_activate_form(ignore_form->ignore);
    fl_reset_cursor(ignore_form->ignore->window);
    if (!ptr)
      return;

    if (!save_ignore(ptr))
      sprintf(buf, "Cant write %s: %s", ptr, strerror(errno));
    else
      sprintf(buf, "ignore list saved as %s", ptr);
    free(ptr);
    fit_object_label(ignore_form->status, buf);
  }
#endif
}
void ig_load(void)
{
  char buf[512];

  snprintf(buf, 511, "%s/" P_IGNORE, prog_home);
#if USE_GTK
  get_filename2(sula_NAME ": Load an ignore file",
               buf, load_it, NULL);
#elif USE_XFORMS
  {
    char *ptr;

    fl_set_cursor(ignore_form->ignore->window, XC_watch);
    fl_deactivate_form(ignore_form->ignore);
    ptr = getstr2("File name:",
          sula_NAME " " sula_VERSION ": Load ignore file", "ignore.txt", 1);
    fl_activate_form(ignore_form->ignore);
    fl_reset_cursor(ignore_form->ignore->window);
    if (!ptr)
      return;
    if (!load_ignore(ptr))
      sprintf(buf, "cant read %s: %s", ptr, strerror(errno));
    else
    {
      sprintf(buf, "ignore %s loaded", ptr);
      fl_trigger_object(ignore_form->update);
    }
    free(ptr);
    fit_object_label(ignore_form->status, buf);
  }
#endif
}
static void ignore_remove(void)
{
  char *buf,
      *mask;

#if USE_XFORMS
  int n = fl_get_browser(ignore_form->browser);

  if (n < 1)
  {
    fl_set_object_label(ignore_form->status, "Remove what??");
    return;
  }
  buf = (char *) fl_get_browser_line(ignore_form->browser, n);
  mask = (char *) malloc(sizeof(char) * strlen(buf));

  if (sscanf(buf, "@f%s", mask) < 1)
    return;
#elif USE_GTK
  GList *pclist = GTK_CLIST(ignore_form->clist)->selection;
  gint row;

  if (!pclist)
  {
    if (gflags & BEEP_ERR)
      spx_bell(0);
    return;
  }
#endif
  do
  {
#if USE_GTK
    row = GPOINTER_TO_INT(pclist->data);
    gtk_clist_get_text(GTK_CLIST(ignore_form->clist), row, 0, &mask);
#endif
    if (!remove_ignore(mask))
    {
      buf = (char *) malloc(sizeof(char) * (strlen(mask) + 45));

      sprintf(buf, "No longer ignoring %s", mask);
      fit_object_label(ignore_form->status, buf);
      free(buf);
    }
    else
    {
      buf = (char *) malloc(sizeof(char) * (strlen(mask) + 45));

      sprintf(buf, "\"%s\" has expired (?)", mask);
      fit_object_label(ignore_form->status, buf);
      free(buf);
    }
    #if USE_GTK
    pclist = pclist->next;
    #endif
  }
  while (
#if USE_XFORMS
          0
#elif USE_GTK
          pclist
#endif
     );
  TRIGGER_OBJECT(ignore_form->update);
}

#if USE_XFORMS
static void ignore_browser(void)
{
  int n;
  char *buf,
      *mask;
  Ignore *p;

  n = fl_get_browser(ignore_form->browser);
  if (n < 1)
  {
    return;
  }
  buf = (char *) fl_get_browser_line(ignore_form->browser, n);
  mask = (char *) malloc(sizeof(char) * strlen(buf));

  if (sscanf(buf, "@f%s", mask) < 1)
    return;
  p = get_ignore(mask);
  if (!p)
  {
    char buf[128];

    sprintf(buf, "\"%s\" has expired (?)", mask);
    fit_object_label(ignore_form->status, buf);
    /*fl_call_object_callback(ignore_form->update); endless loop! */
    return;
  }
  else
  {
    fl_set_button(ignore_form->msg, p->what & IG_PRIVMSG);
    fl_set_button(ignore_form->pubmsg, p->what & IG_PUBMSG);
    fl_set_button(ignore_form->notice, p->what & IG_PRIVNOTICE);
    fl_set_button(ignore_form->pubnotice, p->what & IG_PUBNOTICE);
    fl_set_button(ignore_form->invites, p->what & IG_INVITE);
    fl_set_button(ignore_form->dcc, p->what & IG_DCC);
    fl_set_button(ignore_form->note, p->what & IG_NOTE);
    fl_set_button(ignore_form->ctcp, p->what & IG_CTCP);
    fl_set_button(ignore_form->misc, p->what & IG_MISC);

  }

}
#endif

static void ignore_add(void)
{
#if USE_XFORMS
  FD_edit_ig *form = create_form_edit_ig();

  fl_set_cursor(ignore_form->ignore->window, XC_watch);
  fl_deactivate_form(ignore_form->ignore);
  fl_set_form_atclose(form->edit_ig, dont_close_win, 0);
  /* prehandler: */
  form->mask->u_ldata = form->period->u_ldata = (long) XC_xterm;
  fl_set_object_prehandler(form->mask, set_cursor);
  fl_set_object_prehandler(form->period, set_cursor);

  fl_addto_choice(form->unit, "seconds|minutes|hours");
  fl_set_choice(form->unit, 2);
  fl_set_choice_fontsize(form->unit, 14);
  fl_set_choice_fontstyle(form->unit, FL_TIMES_STYLE);
  fl_set_choice_align(form->unit, FL_ALIGN_LEFT);

  fl_show_form(form->edit_ig, FL_PLACE_MOUSE, FL_FULLBORDER, sula_NAME " " sula_VERSION ": Add an ignore mask");
  while (fl_do_forms() != form->close);
#elif USE_GTK
  GtkWidget *wid = create_edit_ignore();

  if (!wid)
    return;
  gtk_widget_show(wid);
#endif

}
static void ignore_edit(void)
{
#if USE_XFORMS
  FD_edit_ig *form;
  FL_OBJECT *status;

#elif USE_GTK
  GtkWidget *wid,
      *status;
#endif
  char *mask;
  Ignore *p;

#if USE_XFORMS
  char *buf;
  int n = fl_get_browser(ignore_form->browser);

  if (n < 1)
    return;
  form = create_form_edit_ig();
  status = form->status;
  fl_set_cursor(ignore_form->ignore->window, XC_watch);
  fl_deactivate_form(ignore_form->ignore);
  fl_set_form_atclose(form->edit_ig, dont_close_win, 0);

  buf = (char *) fl_get_browser_line(ignore_form->browser, n);
  mask = (char *) alloca(sizeof(char) * strlen(buf));

  if (sscanf(buf, "@f%s", mask) < 1)
    return;
#elif USE_GTK
  gint row;

  if (!GTK_CLIST(ignore_form->clist)->selection)
  {
    spx_bell(0);
    return;
  }
  row = GPOINTER_TO_INT(GTK_CLIST(ignore_form->clist)->selection->data);
  gtk_clist_get_text(GTK_CLIST(ignore_form->clist), row, 0, &mask);
  status = gtk_object_get_data(GTK_OBJECT(ignore_form->window), "status");
#endif
  p = get_ignore(mask);
  if (!p)
  {
    char *buf = malloc(sizeof(char) * (strlen(mask) + 20));

    sprintf(buf, "'%s' is gone", mask);
    fit_object_label(status, buf);
    free(buf);
    return;
  }
  else
  {
    char buf[12];

#if USE_XFORMS
    sprintf(buf, "%d", p->period);
    spx_set_input(form->mask, p->mask);
    fl_set_input(form->period, buf);
#elif USE_GTK
    GtkWidget *w;

    wid = create_edit_ignore();
    if (!wid)
      return;
    sprintf(buf, "%d", p->period);
    w = gtk_object_get_data(GTK_OBJECT(wid), "mask");
    spx_set_input(w, p->mask);
    w = gtk_object_get_data(GTK_OBJECT(wid), "period");
    spx_set_input(w, buf);
    w = gtk_object_get_data(GTK_OBJECT(wid), "combo");
    spx_set_input(GTK_COMBO(w)->entry, "minutes");
    gtk_widget_show(wid);
#endif
  }

#if USE_XFORMS
  /* prehandler: */
  form->mask->u_ldata = form->period->u_ldata = (long) XC_xterm;
  fl_set_object_prehandler(form->mask, set_cursor);
  fl_set_object_prehandler(form->period, set_cursor);

  fl_addto_choice(form->unit, "seconds | minutes | hours");
  fl_set_choice(form->unit, 2);
  fl_set_choice_fontsize(form->unit, 14);
  fl_set_choice_fontstyle(form->unit, FL_TIMES_STYLE);
  fl_set_choice_align(form->unit, FL_ALIGN_LEFT);

  fl_show_form(form->edit_ig, FL_PLACE_MOUSE, FL_FULLBORDER, sula_NAME " " sula_VERSION ": Edit an ignore mask");
  while (fl_do_forms() != form->close);
#endif
}

void ig_edit_cb(SPX_OBJ(ob), SPX_DATA(data))
{
#if USE_XFORMS
  FD_edit_ig *form = (FD_edit_ig *) ob->form->fdui;

#elif USE_GTK
  GtkWidget *form = gtk_object_get_user_data(GTK_OBJECT(ob));
#endif
  if ((long) data)
  {
#if USE_XFORMS
    fl_hide_form(form->edit_ig);
    fl_free_form(form->edit_ig);
    fl_reset_cursor(ignore_form->ignore->window);
    fl_activate_form(ignore_form->ignore);
#elif USE_GTK
    gtk_widget_destroy(form);
#endif
  }
  else
  {
    char *mask;
    u_short t;
    Ignore *p;
    char *buf = 0;

#if USE_XFORMS
    FL_OBJECT *status = form->status;	//, *input=form->mask;

    mask = (char *)spx_get_input(form->mask);
#elif USE_GTK
    GtkWidget *status = gtk_object_get_data(GTK_OBJECT(form), "status");
    GtkWidget *input = gtk_object_get_data(GTK_OBJECT(form), "mask");
    GtkWidget *input2 = gtk_object_get_data(GTK_OBJECT(form), "period");

    mask = spx_get_input(input);
#endif
    if (!*mask)
    {
      fit_object_label(status, "Specify a mask or cancel!");
      spx_bell(0);
      return;
    }
#if USE_GTK
    input = gtk_object_get_data(GTK_OBJECT(form), "combo");
    buf = spx_get_input(GTK_COMBO(input)->entry);
    if (!strcmp(buf, "minutes"))
      t = atoi(spx_get_input(input2));
    else if (!strcmp(buf, "seconds"))
    {
      t = atoi(spx_get_input(input2));
      t = t > 59 ? t / 60 : 1;
    }
    else
      t = atof(spx_get_input(input2)) * 60;
#elif USE_XFORMS
    switch (fl_get_choice(form->unit))
     {
       default:
       case 0:                 /* NO SELECTION */
       case 2:
         t = atoi(spx_get_input(form->period));	/*minutes */
         break;
       case 1:
         t = atoi(spx_get_input(form->period));	/* secs */
         t = t > 59 ? t / 60 : 1;
         break;
       case 3:
         t = atof(spx_get_input(form->period)) * 60;	/* hour */
         break;
     }
#endif
    p = get_ignore(mask);
    if (p)
    {
      p->starttime = time(NULL);

      p->period = t;
      buf = malloc(sizeof(char) * (strlen(mask) + 30));

      sprintf(buf, "'%s' exists. Times updated", mask);

    }
    else
    {
      Ignore *q = ignoreStart;

      ignoreStart = (Ignore *) my_malloc(sizeof(Ignore));
      ignoreStart->mask = strdup(mask);
      ignoreStart->what = IG_ALL;
      ignoreStart->starttime = time(NULL);
      ignoreStart->period = t;
      ignoreStart->next = q;
      buf = malloc(sizeof(char) * (strlen(mask) + 30));

      sprintf(buf, "'%s' is now being ignored", mask);
    }
    fit_object_label(status, buf);
    free(buf);
    TRIGGER_OBJECT(ignore_form->update);
  }
}

void ignore_form_cb(SPX_OBJ(ob), SPX_DATA(data))
{
  switch ((long) data)
   {
#if USE_XFORMS
     case 0:                   /* browser */
       ignore_browser();
       break;
#endif
     case 1:                   /* remove */
       ignore_remove();
       break;
     case 2:
       ignore_edit();
       break;
     case 3:
       ignore_add();
       break;
     case 4:                   /*save */
       ig_save();
       break;
     case 5:                   /*load */
       ig_load();
       break;
     case 6:
       {                        /*update */

#if USE_XFORMS
         int n = fl_get_browser(ignore_form->browser),
              m;

         fl_clear_browser(ignore_form->browser);
         redisplay_ignore_list();
         m = fl_get_browser_maxline(ignore_form->browser);
         if (m > 0)
         {
           if (m > n && n > 0)
             fl_select_browser_line(ignore_form->browser, n);
           else
             fl_select_browser_line(ignore_form->browser, m);

         }
         /*fl_call_object_callback(ignore_form->browser); */
         fl_trigger_object(ignore_form->browser);
#elif USE_GTK
         gtk_clist_clear(GTK_CLIST(ignore_form->clist));
         redisplay_ignore_list();
#endif
         break;
       }
     case 7:
       {                        /*dismiss */
#if USE_XFORMS
         FD_ignore *form = (FD_ignore *) ob->form->fdui;

         fl_hide_form(form->ignore);
         (*((FD_ignore **) form->done->u_vdata)) = NULL;
         fl_free_form(form->ignore);
#elif USE_GTK
         gtk_widget_destroy(ignore_form->window);
#endif
         break;
       }
     case 8:                   /* ok */
       ig_ok();
       break;
     default:
       break;
   }                            /* switch */
}
