/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
   keybinding.c - bind keys to events.
   Author: Tano Fotang, 1999
   (fotang@yahoo.com)

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if _GUILE

#include "scheme.h"

#define BIND_ALLOC 10
static void bind_allocate(void)
{
  register int i;

  if (keybinding == NULL)
    keybinding = malloc(sizeof(KeyBinding) * BIND_ALLOC);
  else
    keybinding = realloc(keybinding,
                         (bind_count + BIND_ALLOC) * sizeof(KeyBinding));
  if (!keybinding)
  {
    perror("mem error");
    exit(-1);
  }
  for (i = bind_count; i < bind_count + BIND_ALLOC; i++)
    keybinding[i].key = NoSymbol;
  bind_count += BIND_ALLOC;
}
static int add_keybinding(KeySym key, unsigned int state, SCM proc)
{
  register int i;

  if (!keybinding)
    bind_allocate();
  do
  {
    for (i = 0; i < bind_count; i++)
      if (keybinding[i].key == NoSymbol)
      {
        keybinding[i].key = key;
        keybinding[i].state = state;
        keybinding[i].proc = define_func(proc);
        return i;
      }
    bind_allocate();
  }
  while (1);
}

extern SCM gs_bind_proc(SCM Key, SCM state, SCM proc)
/*
   mask:Shift,Lock,Control, Mod2 , Button1,Button2,Button3,
   Mod4,Mod5 etc.
 */
{
  int n;
  char *key = gh_scm2newstr(Key, &n);
  KeySym keysym;

  if (n == 0)
    return SCM_BOOL_F;
  keysym = XStringToKeysym(key);
  free(key);
  if (keysym != NoSymbol)
  {
    register int i;

    if (gh_equal_p(state, SCM_BOOL_F))
      n = 0;
    else
      n = gh_scm2ulong(state);
    for (i = 0; i < bind_count; i++)
      if (keybinding[i].key == keysym && keybinding[i].state == n)
      {
        keybinding[i].key = NoSymbol;
        gh_defer_ints();
        remove_func(keybinding[i].proc);
        gh_allow_ints();
        break;
      }
    gh_defer_ints();
    add_keybinding(keysym,
                   (unsigned int) n,
                   gh_null_p(proc) ? SCM_BOOL_F : gh_car(proc));
    gh_allow_ints();
    return (SCM_BOOL_T);
  }
  return SCM_BOOL_F;
}

extern SCM gs_delete_binding_proc(SCM Key, SCM state)
{
  int n,
       i;
  char *key = gh_scm2newstr(Key, &n);
  KeySym keysym;

  if (n == 0)
    return SCM_BOOL_F;
  keysym = XStringToKeysym(key);
  free(key);
  if (keysym == NoSymbol)
    return SCM_BOOL_F;
  if (gh_equal_p(state, SCM_BOOL_F))
    n = 0;
  else
    n = gh_scm2ulong(state);
  for (i = 0; i < bind_count; i++)
    if (keybinding[i].key == keysym && keybinding[i].state == n)
    {
      keybinding[i].key = NoSymbol;
      gh_defer_ints();
      remove_func(keybinding[i].proc);
      gh_allow_ints();
      return SCM_BOOL_T;
    }
  return SCM_BOOL_F;
}
extern SCM gs_query_bindings_proc(void)
/*list all key bindings */
{
  SCM list = gh_list(SCM_UNDEFINED);
  register int i;
  char *name;

  for (i = 0; i < bind_count; i++)
    if (keybinding[i].key != NoSymbol)
    {
      name = XKeysymToString(keybinding[i].key);
      list = gh_cons(gh_list(gh_str02scm(name),
                             gh_long2scm(keybinding[i].state),
                             SCM_UNDEFINED),
                     list);
    }
  return list;
}
int key_preempted(KeySym k, unsigned int state, int win)
{
  register int i;

  for (i = 0; i < bind_count; i++)
    if (keybinding[i].key == k && keybinding[i].state == state)
    {
      if (keybinding[i].proc == -1)
        return 1;
      else
      {
#define DAT_SIZE 64
        char data[DAT_SIZE + 1];
        char *name;
        Scm_cmd_arg args;
        SCM ret;

        gh_defer_ints();
        name = XKeysymToString(k);
        gh_allow_ints();
        args.func = keybinding[i].proc;
        args.args = gh_list(gh_long2scm(win),
                            gh_str02scm(name),
                            gh_long2scm(state),
                            SCM_UNDEFINED);
        if (snprintf(data, DAT_SIZE, "Key binding %s %d", name, state) == -1)
          data[DAT_SIZE] = 0;
        ret = gh_catch(SCM_BOOL_T, &call_scm_command, &args,
                 (scm_catch_handler_t) & exception_handler, (void *) &data);
        return (!gh_equal_p(ret, SCM_BOOL_F));
      }
    }
  return 0;
}
/* keybinding end */

#endif
