/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* lag.c - measure server lag

   Copyright (C) 1997 Tano Fotang

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


*/

#include <time.h>
#include "spx.h"
#include "server.h"
#include "lag.h"

void ClearLag(Server * s)
{
  while (s->lag)
  {
    Lag *p = s->lag;

    s->lag = (s->lag)->next;
    free(p);
  }
}


static void addlagtime(Lag ** s, struct timeval t)
{
  Lag *p = *s;

  *s = (Lag *) malloc(sizeof(Lag));
  (*s)->next = p;
  (*s)->when.tv_sec = t.tv_sec;
  (*s)->when.tv_usec = t.tv_usec;
  /*(*s)->wait=timeout; */
}
static void del_lag_node(Lag ** head, Lag * trail, Lag * node)
{
  if (trail)
    trail->next = node->next;
  else
    *head = (*head)->next;
  free(node);
}
static void remove_lag(Server * s, struct timeval when)
{
  Lag *p = s->lag;

  if (!p)
    return;
  if (p->when.tv_sec == when.tv_sec && p->when.tv_usec == when.tv_usec)
  {
    s->lag = s->lag->next;
    free(p);
  }
  else
  {
    Lag *q = p->next;

    while (q)
      if (q->when.tv_sec == when.tv_sec &&
          q->when.tv_usec == when.tv_usec)
      {
        del_lag_node(&(s->lag), p, q);
        break;
      }
      else
      {
        p = q;
        q = q->next;
      }
  }
}

static void ping_server(Server * p)
{
  if (p)
  {
    Server *s;

    ping_server(p->left);
    s = search_server_tree_byname(p->g, p->name, p->port);
    assert(s);
    if (!s->connecting)
      send_lag_junk(s, 0, 1);
    ping_server(p->right);
  }
}

static int lagTimeoutID = 0;
#if USE_XFORMS
static void autocheck_lag(int id, void *junk)
#else
gint autocheck_lag(gpointer junk)
#endif
{
  /*check all connected servers */
  ping_server(servFdTree);
  lagTimeoutID = 0;
 #if !USE_XFORMS
  return FALSE;
#endif
}
extern void send_lag_msg(void)
{
  /* lag timeout is in seconds ! */
  if (servFdTree == NULL || !(gflags & AUTO_CHECKLAG))
  {
    if (lagTimeoutID)
    {
      spx_remove_timeout(lagTimeoutID);
      lagTimeoutID = 0;
    }
  }
  else if (!lagTimeoutID)
  {
    static char first_run = 0;

    if (!first_run)
      ping_server(servFdTree);
    first_run = 1;
    lagTimeoutID = spx_add_timeout(lag_frequency * 1000,
                                  autocheck_lag,
                                  0);
  }
}

extern void send_lag_junk(Server * p, char reset, char send)
{

  assert(p);
  if (!(p->fd < 0))
  {
    if (reset)
      ClearLag(p);
    if (!p->lag)
    {                           /* now using only the 1st array element
                                   todo: p->lag shouldnt be an array */
      struct timeval t;

      gettimeofday(&t, NULL);
      if (send)
      {
        char *buf = malloc(sizeof(char) * (strlen(p->nick) + 50));
        int n;

        sprintf(buf, "INVITE %s #__%ld_%ld\n", p->nick, t.tv_sec, t.tv_usec);
        n = strlen(buf);
        if (writen(p->fd, buf, n) == n)
          addlagtime(&(p->lag), t);
        free(buf);
      }
      else
        addlagtime(&(p->lag), t);	/* called form connect_to_server */
    }

  }

}

void update_lag_display(Server * s, float t, struct timeval *remove)
{

  assert(s);
  if (s->lag)                   /* have requested lag */
  {

    WinList *p;
    char buf[16];

    build_winlistbyfd(s->fd);
    p = servWin;
    while (p)
    {
      sprintf(buf, "%0*.*fs", 7, 2, t);
      fit_object_label(winstruct[p->w].chanwin->lag, buf);
      p = p->next;
    }                           /*while */
    if (remove)
      remove_lag(s, *remove);
  }
}
