/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/

/* 
   main.c: The main program for Sula PrimeriX.
   Copyright (C) 1997-1999 Tano Fotang
   (fotang@yahoo.com)

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "spx.h"
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/wait.h>
#include <time.h>
#include <ctype.h>
#include "config.h"
#include "server.h"
#include "nicks.h"
#include "nc.h"
#include "dcc.h"
#include "setting.h"
#include "parser.h"
#include "ignore.h"
#include "cmd.h"
#include "lag.h"
#include "idle_cb.h"
#include "hooks.h"
#include "flood.h"
#include "server.h"
#include "notify.h"
#include "userhost.h"

struct sockaddr_in me;
char host[MAXHOSTNAMELEN + 1];
char *fmt_string;
char *Name, *sula_lib, *quit_text, *away_text;
int MaxChanLen, MaxNickLen;
size_t HistSize, mainHistSize;
History *histStart, *histCur, *mainhistStart, *mainhistCur;
char chanopChar, chanvoiceChar, serveropChar;
int debug;
int gflags, sflags;
int connect_timeout;
int timeout;
int tips_tmout;
int lag_frequency;
int notify_frequency;
int userupdate_frequency;
int max_go;
char *gethostbynameprogram;

SPX_main_window *main_window;

#if USE_XFORMS
extern SPX_colour browser_colour, browser2_colour;
extern SPX_colour browser_selected_colour, browser2_selected_colour;
extern SPX_colour browser_textcolour, browser2_textcolour;
extern SPX_colour input_colour; /* of input line */
extern SPX_font editor_fontstyle;
extern SPX_font browser_fontsyle, browser2_fontsyle, input_fontstyle;
static SPX_colour main_brow_col, main_brow_text_col, main_brow_selected_col;
static SPX_font main_brow_fontstyle;
static int main_brow_fontsize;
extern int browser_fontsize, browser2_fontsize;
#endif
#if USE_GTK
static void init_gtk(void);
#endif

extern int load_bi_cmds(void);
extern void setup_set_variables(void);

static void sig_handler(int);
char *prog_home;
static void get_prog_home(void)
{
  char *buf, *p;
  buf = my_malloc(sizeof(char) * (MAXPATHLEN + 255));

  p = getenv("HOME");
  if (p)
    strcpy(buf, p);
  else
  {
    p = getenv("PWD");
    if (p)
      strcpy(buf, p);
    else
    {
      buf[0] = '.';
      buf[1] = 0;
    }
  }
  prog_home = my_malloc(sizeof(char) * (strlen(buf) + 3 + strlen(P_HOME)));

  sprintf(prog_home, "%s/" P_HOME, buf);

  if (access(prog_home, R_OK) < 0)
  {
    if (errno == ENOENT)
    {
      sprintf(buf, "%s/user-install %s %s", sula_lib, sula_lib, prog_home);
      system(buf);
    }
    else if (debug)
      perror(prog_home);
  }
  free(buf);
}
/* *INDENT-OFF* */
static void show_help_and_exit(const char *progname)
{
 fprintf(stderr, sula_NAME" "sula_VERSION"\nUsage: %s [options]
 Options:\n"
#if USE_GTK
"   -gtkrc <file>
       Use <file> for private GTK widget customization.
       default:%s/gtkrc.\n"
#endif
#if _GUILE
"    -spxrc <file>
       Use <file> as private startup file.
       default:%s/.gsularc.
    -bootlocation <dir>
       The file sula-boot is located in directory <dir>.
       Now set to '%s'.\n"
#endif
"    -libdir <dir>
       <dir> is the location of client system files (trill/, script/,
       help/, skel/, etc).  Use '/set libdirectory' to change. On startup
       it MUST contain all necessary files or program will NOT run correctly.
       Now it is set to '%s'.
    -debug <level>
      Set debugging level.
      Use '/set debug' to change.
      default: 0 (no debugging).\n"
#if MUTABLE_IRC
"   -mutable_irc
      Hooks on RAW_NON_NUMERIC may modify IRC output. You have been warned.\n"
#endif
"   -version
      Print program version to standard output and exit succesfully.
    -help
      ->|<- to standard error and exit successfully.
Please see %s for more options.\n" , progname, prog_home, prog_home,
      sula_lib, sula_lib, __FILE__);
  exit(0);
}
/* *INDENT-ON* */
#if _GUILE
void main_prog(int argc, char **argv);
int main(int argc, char **argv)
{
  gh_enter(argc, argv, main_prog);
  return 0;
}

void main_prog(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
  static void read_int(void);
  static void read_object_attribs(Display * d, Colormap cm);
  static void read_res_string(void);
  static void read_res_flags(void);
  static void set_main_window_attribs(void);
  static int load_mainhistory(const char *);
  static void get_my_hostname(void);
  char Cmdchar[3], ChanOpChar[3], VoiceChar[3], ServOpChar[3];
  int no_no;

  SPX_resource res[] = {
    /* the rest will be read in at the end of main().
       This table should  not contain string SET variables
       since we're not malloc'ing. /set will free-->  sigsegv. */
    {"UserUpdateFrequency", "NumCLASS", SPX_INT, &userupdate_frequency, "30"},	/*secs */
    {"ConnectTimeout", "NumCLASS", SPX_INT, &connect_timeout, "20"},	/* secs */
    {"MaxNicknameLength", "NumCLASS", SPX_SHORT, &MaxNickLen, "20"},
    {"MaxChannelNameLength", "NumCLASS", SPX_SHORT, &MaxChanLen, "20"},
    {"DccTimeout", "NumCLASS", SPX_INT, &dcc_timeout, "2"},	/* 2 mins */
    {"LagFrequency", "NumCLASS", SPX_INT, &lag_frequency, "120"},	/* seconds */
    {"Tooltip.timeout", "NumCLASS", SPX_INT, &tips_tmout, "500"},	/* tmout for tipper in millisecs */
    {"GetValueTimeout", "NumCLASS", SPX_INT, &timeout, "120"},	/* 120 sec */
    {"MaxChannelGoto", "NumCLASS", SPX_INT, &max_go, "20"},
    {"CommandCharacter", "charCLASS", SPX_STRING, Cmdchar, "/", 2},
    {"ChanOpCharacter", "charCLASS", SPX_STRING, ChanOpChar, "@", 2},
    {"ChanVoiceCharacter", "charCLASS", SPX_STRING, VoiceChar, "+", 2},
    {"ServerOpCharacter", "charCLASS", SPX_STRING, ServOpChar, "*", 2},
    {"MaxSendBuffer", "NumCLASS", SPX_INT, &max_sendbuf, "1024"},
    {"Notify.Frequency", "NumCLASS", SPX_INT, &notify_frequency, "60"},	//60 seconds
    {"UserhostTimeout", "NumCLASS", SPX_INT, &uhost_timeout, "120"},
    {"FloodMax", "NumCLASS", SPX_INT, &flood_max, "4"},	//msg count/sec before considered flooding
    {"FloodPeriod", "NumCLASS", SPX_INT, &flood_period, "3"},	// 4 messages/3second
    {"NC.ReadBufferSize", "NumCLASS", SPX_INT, &nc_read_bufsize, "2048"},
  };

  /* Commandline options */
  SPX_CMD_OPT cmdopt[] = {
#if USE_GTK
    {"-gtkrc", ".gtkrc", XrmoptionSepArg, 0},
#endif
#if _GUILE
    {"-spxrc", ".spxrc", XrmoptionSepArg, 0},
    {"-bootlocation", ".Sula-boot", XrmoptionSepArg, 0},
#endif
    {"-libdirectory", ".Libdir", XrmoptionSepArg, 0},
    {"-debug", ".debug", XrmoptionSepArg, 0},
    {"-help", ".help", XrmoptionNoArg, "True"},
    {"-version", ".version", XrmoptionNoArg, "True"},
    /* Add any other options below. They must be SET flag variables.
       See read_res_flags() below for resource names.
       <commandline option> <resource name> <type> <flag>
       flag==True means that if the option is specified on the command line, it
       will be turned on.
     */
    {"-autorejoin", ".autorejoin", XrmoptionNoArg, "True"},
#if MUTABLE_IRC
    {"-mutable_irc", ".mutable_irc", XrmoptionNoArg, "True"},
#endif
    {"-verbose_return", ".verbose_return", XrmoptionNoArg, "True"},
    {"-autochat", ".autochat", XrmoptionNoArg, "True"},
    {"-nmotd", ".suppress_motd", XrmoptionNoArg, "True"},
  };

  main_window = NULL;
  if (Signal(SIGCHLD, sig_handler) == SIG_ERR ||
      Signal(SIGSEGV, sig_handler) == SIG_ERR ||
      Signal(SIGPIPE, sig_handler) == SIG_ERR)
    error(ERR_SYS_QUIT, "signal error");
#if USE_GTK
  gtk_init(&argc, &argv);
#endif
  if (!spx_initialize(&argc, argv, "Sula",
                      cmdopt, sizeof(cmdopt) / sizeof(SPX_CMD_OPT)))
    exit(-1);
  (void) spx_get_app_resource("version", "BoolCLASS", SPX_BOOL, "0", &no_no, 0);
  if (no_no)
  {
/* *INDENT-OFF* */
    fputs(sula_NAME" version "sula_VERSION"\n", stdout);
    fflush(stdout);
    fputs(
"Copyright (c) 1997-1999 Tano Fotang
"sula_NAME" is free software with no warranty, to the extent
permitted by laws in the territory where it is being run. You
are free to distribute "sula_NAME" under the terms of
the GNU General Public License; see the file LICENSE in the
distribution. For any other arrangements, the contact address
is "sula_EMAIL".\n", stderr);
/* *INDENT-ON* */
    exit(0);
  }
  (void) spx_get_app_resource("debug", "NumCLASS", SPX_INT, "0", &debug, 0);
  sula_lib = strdup(spx_get_app_resource("Libdir", "StringCLASS", SPX_NONE,
#ifdef LIB_DIR
                                         LIB_DIR
#else
                                         "/usr/local/lib/sula"
#endif
                                         , NULL, 0));
  if (*sula_lib != '/')
  {
    char *buf = getenv("PWD");
    char *s = strdup(sula_lib);

    if (!buf)
      buf = ".";
    free(sula_lib);
    sula_lib = my_malloc(sizeof(char) * (strlen(s) + strlen(buf) + 2));

    sprintf(sula_lib, "%s/%s", buf, s);
    free(s);
  }
  get_prog_home();
  if (debug > 2)
    fprintf(stderr, "home dir: %s\nsystem wide libdir: %s\n",
            prog_home, sula_lib);
  (void) spx_get_app_resource("help", "BoolCLASS", SPX_BOOL, "0", &no_no, 0);
  if (no_no)
    show_help_and_exit(*argv);
#if USE_GTK
  {
    char *rc_file, *buf = my_malloc(sizeof(char) * (strlen(sula_lib) + 12));
    char *first;
    char got_one = 0;

    if (debug)
      fputs("Checking customization file\n", stderr);

    sprintf(buf, "%s/spx-gtkrc", sula_lib);
    if (debug)
      fprintf(stderr, "Global: %s\n", buf);
    gtk_rc_add_default_file(buf);
    if (access(buf, R_OK) == 0)
    {
      gtk_rc_parse(buf);
      got_one = 1;
    }
    else if (debug)
      perror(buf);
    free(buf);
    buf = my_malloc(sizeof(char) * (strlen(prog_home) + 20));

    sprintf(buf, "%s/gtkrc", prog_home);
    rc_file = (char *) spx_get_app_resource("gtkrc",
                                            "StringCLASS",
                                            SPX_NONE, buf, 0, 0);
    gtk_rc_add_default_file(rc_file);
    first = rc_file;
    errno = 0;
    if (access(rc_file, R_OK) == 0)
    {
      struct stat ss;

      if (!stat(rc_file, &ss))
        if (!S_ISREG(ss.st_mode))
          errno = EISDIR;
    }
    if (errno)
    {
      if (debug)
        perror(rc_file);
      rc_file = NULL;
      if (!got_one)
      {
        char *files[] = { NULL, "conf/spx-gtkrc", "./gtkrc", NULL };
        char **p;

        files[0] = strdup(buf);

        for (p = files; *p; p++)
          if (strcmp(*p, first))
          {
            if (debug)
              fprintf(stderr, "  Retrying with %s \n", *p);
            if (!access(*p, R_OK))
            {
              rc_file = *p;
              got_one = 1;
              break;
            }
            if (debug)
              perror(*p);
          }
        strcpy(buf, rc_file ? rc_file : *(p - 1));
        rc_file = buf;
        free(files[0]);
      }
    }
    if (!rc_file || access(rc_file, R_OK))
    {
      if (!got_one)
      {
        fflush(stdin);
        fprintf(stderr,
                "\n**WARNING:\n\tGTK rc file cannot be read.\n\tI even tried '%s'. Don't quit? ",
                buf);
        if (getchar() != 'n')
        {
          fputs("Goodbye.\n", stderr);
          exit(-1);
        }
      }
    }else
    {
    if(strcmp(first, rc_file))
      gtk_rc_add_default_file(rc_file);
     if(debug)
       fprintf(stderr, "private: %s\n", rc_file);
      gtk_rc_parse(rc_file);
    }
    free(buf);
    init_fonts();
  }
#endif
  Name = getenv("LOGNAME");
  if (!Name && !(Name = getenv("USER")))
    Name = sula_NAME;
  if (debug > 2)
    fputs("checking hostname...\n", stderr);
  get_my_hostname();
  NotifySentStart = NotifySentEnd = my_malloc(sizeof(Notify_sent));
  uh_start = uh_end = my_malloc(sizeof(Userhost_info));

  dccchatwinStart = dccchatwinEnd = my_malloc(sizeof(DCCChatWin));
  dccStart = dccEnd = my_malloc(sizeof(DCC));
  cmdsentStart = cmdsentEnd = (CmdSent *) my_malloc(sizeof(CmdSent));
  cmdonconStart = cmdonconEnd = cmdonconEnd = my_malloc(sizeof(CmdOnCon));
  ignoreEnd = ignoreStart = my_malloc(sizeof(Ignore));

  chanStart = chanEnd = my_malloc(sizeof(gChannel));
  histStart = (History *) my_malloc(sizeof(History));
  histStart->left = histStart->right = histCur = histStart;
  HistSize = 0;
  mainhistStart = (History *) my_malloc(sizeof(History));
  mainhistStart->left = mainhistStart->right = mainhistCur = mainhistStart;
  mainHistSize = 0;

  spx_get_app_resources(res, sizeof(res) / sizeof(SPX_resource));

  if (debug > 2)
    fputs("initializing event hooks...\n", stderr);
  event_setup();
  cmdchar = Cmdchar[0];
  if (isspace(cmdchar))
    cmdchar = '/';
  chanopChar = ChanOpChar[0];
  chanvoiceChar = VoiceChar[0];
  serveropChar = ServOpChar[0];
  read_object_attribs(spx_display,
                      DefaultColormap(spx_display,
                                      DefaultScreen(spx_display)));
  read_res_string();
  gflags = ALL_GFLAGS;
#if MUTABLE_IRC
  sflags = ~(s_IRC_OUTPUT_MODIFIED | s_DOING_IRC_HOOK | s_DOING_INPUT_HOOK);
#else
  sflags = ~s_DOING_INPUT_HOOK;
#endif
  read_res_flags();

  if (debug > 2)
    fputs("session output log: ", stderr);
  log_set(-1, (void *) &sflags);
  if (debug > 2)
    fputs("\n'/help HISTORY' for more on session transcript.\n", stderr);

  main_window = create_control_window();
  set_main_window_attribs();
  if (debug > 2)
    fputs("Initializing SET vars and built-in cmds. "
          "This will take some time...\n", stderr);
  setup_set_variables();
  load_ctcp_cmds();
  load_bi_cmds();
  if (1)
  {
    /* try loading servers from ~/.sula/.
       if this fails, try directory specified in X resource file.
       read history from dir ~/.sula/
     */
    char buf[MAXPATHLEN + 255];

    sprintf(buf, "%s/%s", prog_home, P_NICKNAMES);
    if (debug > 2)
      fprintf(stderr, "\nreading nickname groups from \E[1m%s\E[m."
              " Use /ln to list to stdout\n", buf);
    if (load_nicks(buf))
    {
      if (debug > 1)
        perror("error reading nick names");
      if (iNickListCount == 0)
      {
        Nickcount i = new_nicklist("default");

        if (i < 0)
          error(-2, "Mem errors");
        aNickList[i].current = add_nick_to_list(i, Name);
      }
    }
    sprintf(buf, "%s/%s", prog_home, P_NOTIFY);
    if (debug > 2)
      fprintf(stderr, "loading notify groups from \E[1m%s\E[m.\n", buf);
    if (load_notify_lists(buf))
    {
      if (debug > 2)
        perror(buf);
      if (NotifyListCount == 0)
      {
        if (debug > 2)
          fputs("Creating group \"default\"...", stderr);
        if (new_notify_list("default") == -1)
          error(-2, "\nToo many errors. Ciao.");
      }
      if (debug > 2)
        fputs("ok, got default.\n", stderr);
    }
    sprintf(buf, "%s/%s", prog_home, P_HISTORY);
    if (load_history(buf))
      if (debug > 2)
        perror(buf);
    sprintf(buf, "%s/%s", prog_home, P_CONSOLE_HISTORY);
    if (load_mainhistory(buf))
      if (debug > 2)
        perror(buf);
    sprintf(buf, "%s/%s", prog_home, P_SERVERS);
    if (access(buf, R_OK) < 0)
    {
      if (debug > 2)
        perror(buf);
      sprintf(buf, "%s/%s", sula_lib, P_SERVERS);
      if (debug > 2)
        fprintf(stderr, "Will try %s\n", buf);
    }
    if (debug > 2)
      fprintf(stderr, "loading servers from \E[1m%s\E[m\n", buf);
    if (init_serverlist(buf) && debug > 1)
      perror(buf);
  }

#if USE_XFORMS
  fl_set_idle_callback(idle_cb, 0);
  fl_show_form(main_window->main_form, FL_PLACE_FREE, FL_FULLBORDER,
               sula_NAME " " sula_VERSION ": Control");
#elif USE_GTK
  init_gtk();
#endif
  gflags |= CTRL_WIN_SHOWN;
#if _GUILE
  if (debug > 2)
    fputs("setting up Scheme interpreter...\n", stderr);
  scheme_setup(argv);
#endif
  read_int();

  fputs("\n\nWelcome to \E[4m" sula_NAME "\E[m version " sula_VERSION
        " (beta).\n" "Copyright (c) 1997-1999 Tano Fotang\n"
        "\E[4mThis is free software with ABSOLUTELY NO WARRANTY.\E[m\n"
        "See the GNU General Public License for more details.\n\n", stdout);
#if _GUILE == 0
  fprintf(stderr,
          "Please recompile with Scheme (Guile) programming support.\n"
          "Info: \E[1m\E[4m" sula_GETTING "\E[m. Bye bye.\n\n");
#endif

#if USE_XFORMS
  while (fl_do_forms() != main_window->quit);
#elif USE_GTK
  gtk_main();
#endif
#if _GUILE == 0
  return 0;
#endif
}

#if USE_GTK
static gint update_clocks(gpointer junk);
static void init_gtk(void)
{
#if 0
  GdkColor bg = { 0, 0xffff, 0xffff, 0 };
  GdkColor fg = { 0, 0, 0, 0 };
  char *s;
#endif

#define IDLE_TIMEOUT 200

  gtk_timeout_add(1000, (GtkFunction) update_clocks, 0);
  gtk_timeout_add(IDLE_TIMEOUT, (GtkFunction) idle_cb, 0);
  gtk_tooltips_set_delay(tooltips, tips_tmout);
#if 0
// gtk_tooltips_set_colors  doesnt seem to work!!
  s = spx_get_app_resource("Tooltip.background",
                           "StringCLASS", SPX_NONE, "yellow", 0, 0);
  if (gdk_color_parse(s, &bg) == 0)
    gdk_color_alloc(gdk_colormap_get_system(), &bg);
  s = spx_get_app_resource("Tooltip.foreground",
                           "StringCLASS", SPX_NONE, "black", 0, 0);
  if (gdk_color_parse(s, &fg) == 0)
    gdk_color_alloc(gdk_colormap_get_system(), &fg);
  gtk_tooltips_set_colors(tooltips, &bg, &fg);
#endif
  if ((gflags & SHOW_TIPS) == 0)
    gtk_tooltips_disable(tooltips);

  gtk_widget_show(main_window->main_window);
}

static gint update_clocks(gpointer junk)
{
  time_t t = time(NULL);
  char *str = ctime(&t);
  char res[12];

  sscanf(str, "%*s %*s %*d %s", res);
  gtk_label_set_text(GTK_LABEL(main_window->clock), res);
  if (win_count > 0)
  {
    register int i;

    res[8] = ' ';
    res[9] = ' ';
    res[10] = 0;
    for (i = 0; i < win_count; i++)
      if (winstruct[i].chanwin)
        gtk_label_set_text(GTK_LABEL(winstruct[i].chanwin->clock), res);
  }

  return TRUE;
}
#endif

static void read_int(void)
{
  char path[MAXPATHLEN];
  char buf[MAXPATHLEN + 255];

  /* this is a klude to setup signal handler.
     Otherwise next process will be killed! */
  /*   error has probably been fixed */
  /*new_process_cmd("run _|junk|_ _ignore_this!_.", -1); */

  sprintf(path, "%s/sularc", sula_lib);
  if (access(path, R_OK) == 0)
  {
    sprintf(buf, "run sularc_%d %s", getpid(), path);
    new_process_cmd(buf, -1);
  }
  else if (debug)
    fprintf(stderr, "[ignored] %s: %s\n", path, strerror(errno));
  sprintf(path, "%s/" P_SULARC, prog_home);
  if (access(path, R_OK) == 0)
  {
    sprintf(buf, "run .sularc_%d %s", getpid(), path);
    new_process_cmd(buf, -1);
  }
  else if (debug)
    fprintf(stderr, "[ignored] %s: %s\n", path, strerror(errno));
}

static void get_my_hostname(void)
{
  memset((void *) &me, 0, sizeof(me));
  if (gethostname(host, sizeof(host)) < 0)
  {
    char *hh;

    herror("unable to determine hostname");
    hh = getenv("HOSTNAME");
    if (!hh)
      strncpy(host, "un.kno.wn", MAXHOSTNAMELEN);
    else
      strncpy(host, hh, MAXHOSTNAMELEN);
    me.sin_addr.s_addr = 0;
  }
  else if ((me.sin_addr.s_addr = inet_addr(host)) == INADDR_NONE)
  {
    struct hostent *hp;

    if (!(hp = gethostbyname(host)))
    {
      herror("gethostbyname error");
      me.sin_addr.s_addr = 0;
    }
    else
    {
      strncpy(host, hp->h_name, MAXHOSTNAMELEN);
      memcpy((void *) &me.sin_addr, (void *) hp->h_addr, hp->h_length);
      if (debug)
        fprintf(stderr, "You are %s (%s)\n", host, inet_ntoa(me.sin_addr));
    }
  }

}
static void set_main_window_attribs(void)
{
#if USE_XFORMS
  fl_set_browser_fontsize(main_window->browser, main_brow_fontsize);
  fl_set_browser_fontstyle(main_window->browser, main_brow_fontstyle);
  fl_set_object_color(main_window->browser, main_brow_col,
                      main_brow_selected_col);
  fl_set_object_lcolor(main_window->browser, main_brow_text_col);
  fl_set_object_lstyle(main_window->main_input, input_fontstyle);
  fl_set_input_color(main_window->main_input, input_colour, FL_BLUE);
#endif
}

static void read_res_flags(void)
{
  typedef struct
  {
    char *name;
    u_int *flag;                /* s|gflags */
    int val;                    /* e.g. AUTO_CHAT */
    char *defval;               /* "1" or "0" */
  } Sula_set;
  Sula_set sula_set[] = {
    {"Notify.autocheck", &gflags, AUTO_CHECKNOTIFY, "1"},
    {"autochat", &gflags, AUTO_CHAT, "0"},
    {"autochecklag", &gflags, AUTO_CHECKLAG, "1"},
    {"autoget", &gflags, AUTO_GETFILE, "0"},
    {"autoinvite", &gflags, AUTO_INVITE, "0"},
    {"autorejoin", &gflags, AUTO_REJOIN, "0"},
    {"beep_away", &gflags, BEEP_AWAY, "0"},
    {"beep_on_dcc", &gflags, BEEP_DCC, "0"},
    {"beepOnClientError", &gflags, BEEP_ERR, "1"},
    {"beepOnServerError", &gflags, BEEP_SERVER_ERR, "0"},
    {"beepOnMessage", &gflags, BEEP_MSG, "0"},
    {"encrypt", &gflags, ENCRYPT_MSG, "1"},
    {"finger", &gflags, FINGER, "1"},
    {"finger_utmp", &gflags, FINGER_UTMP, "1"},
    {"history", &gflags, HISTORY, "1"},
    {"inform_ignored", &gflags, INFORM_IGNORED, "1"},
    {"quote_exec", &gflags, QUOTE_EXEC, "0"},
    {"quote_multiline", &gflags, QUOTE_ML, "0"},
    {"save_history", &gflags, SAVE_HISTORY, "1"},
    {"show_numeric", &gflags, SHOW_NUMERIC, "1"},
    {"show_raw_message", &gflags, SHOW_RAW_MSG, "0"},
    {"show_tips", &gflags, SHOW_TIPS, "1"},
    {"verbose_client", &gflags, VERBOSE_CLIENT, "1"},
    {"verbose_ctcp", &gflags, VERBOSE_CTCP, "0"},
    {"force_connection", &sflags, FORCE_CONNECTION, "0"},
    {"extended_DCC", &sflags, EXTENDED_DCC, "1"},
    {"external_gethost", &sflags, EXTERNALGETHOST, "0"},
    {"dynamic_slip", &sflags, DYNAMIC_SLIP, "0"},
    {"suppress_motd", &sflags, SUPPRESS_MOTD, "0"},
    {"log", &sflags, LOG, "1"},
    {"flood_check", &sflags, FLOOD_CHECK, "1"},
    {"update_ignore_display", &sflags, sUPDATE_IGNORE_DISPLAY, "0"},
    {"echo_input", &sflags, sECHO_INPUT, "1"},
#if _GUILE
    {"verbose_return", &sflags, s_VERBOSE_RETURN, "0"},
#endif
    {"user_update", &sflags, sUPDATE_USER_DISPLAY, "1"},
#if MUTABLE_IRC
    {"mutable_irc", &sflags, sMUTABLE_IRC, "0"},
#endif
    {NULL, NULL, 0, NULL}
  };
  int flag_val;
  Sula_set *p = sula_set;

  while (p->name)
  {
    spx_get_app_resource(p->name, "BoolCLASS", SPX_BOOL,
                         p->defval, &flag_val, 0);
    if (!flag_val)
      *(p->flag) &= ~p->val;
    else
      *(p->flag) |= p->val;
    p++;
  }

}

static void read_res_string(void)
{
  typedef struct
  {
    char **var;
    char *name;
    char *defval;
  } Res;
  Res vars[] = {
    {&line_break, "MultilineStart", "\t"},
    {&log_file, "File.Log", "irc.log"},
    {&gethostbynameprogram, "Aux.GethostnameProgram", "sulahp"},
    {&quit_text, "QuitText", "$X signing off. Goodbye."},
    {&chat_quit_text, "ChatQuitText", "have to go. bye bye"},
    {&away_text, "AwayText", "be back l8r.."},
    {&finger_reply, "FingerReply", ""},
    {&userinfo, "Userinfo", "Running " sula_NAME " version " sula_VERSION},
    {&fmt_priv_msg, "Format.PrivateMessage", "@.[%H:%M.%S] <%n> %p"},
    {&fmt_pub_msg, "Format.PublicMessage", "@.<%n> %p (%Z)"},
    {&fmt_pub_msg2, "Format.PublicMessage2", "@.<%n:%c> %p"},
    {&fmt_pub_msg3, "Format.PublicMessage3", "@.(%n/%c) %p"},
    {&fmt_you_pub_msg, "Format.Your.PublicMessage", "@.<%n> %p"},
    {&fmt_you_priv_msg, "Format.Your.PrivateMessage", "@.->%c: %p"},
    {&fmt_pub_notice, "Format.PublicNotice", "@.-%n- %p"},
    {&fmt_pub_notice2, "Format.PublicNotice2", "@.-%n:%c- %p"},
    {&fmt_pub_notice3, "Format.PublicNotice3", "@.(-%n/%c-) %p"},
    {&fmt_priv_notice, "Format.PrivateNotice", "@.[%H:%M.%S] -%n- %p"},
    {&fmt_you_pub_notice, "Format.Your.PublicNotice", "@.-%n- %p"},
    {&fmt_server_notice, "Format.ServerNotice", "@.-%n- %p"},
    {&fmt_you_priv_notice, "Format.Your.PrivateNotice", "@.->%c- %p"},
    {&fmt_pub_action, "Format.PublicAction", "@.Action: %n %p"},
    {&fmt_you_pub_action, "Format.Your.PublicAction", "@.Action: %n %p"},
    {&fmt_priv_action, "Format.PrivateAction", "@.>Action: %n %p"},

    {&fmt_you_priv_action, "Format.Your.PrivateAction",
     "@.-> %c: Action: %n %p"},
    {&fmt_you_dccchat, "Format.Your.ChatMessage", "@.-> = %c = %p"},
    {&fmt_other_dccchat, "Format.ChatMessage", "@.= %n = %p"},

    {&fmt_topic, "Format.Topic",
     "@.%n has changed the topic on channel %c to %p"},
    {&fmt_chanmode, "Format.ChannelMode",
     "@.Mode change \"%p\" on channel %c by %n"},
    {&fmt_usermode, "Format.UserMode", "@.Mode change \"%p\" for %f by %n"},

    {&fmt_you_kick, "Format.Your.Kick",
     "@.[%H:%M] %n has kicked you off %c (%p)"},
    {&fmt_other_kick, "Format.Kick",
     "@.%f has been kicked off channel %c by %n (%p)"},
    {&fmt_you_join, "Format.Your.Join", "@.You have joined channel %c"},
    {&fmt_other_join, "Format.Join", "@.%n (%l@%h) has joined %c"},
    {&fmt_you_part, "Format.Your.LeaveChannel", "@.You have left channel %c"},

    {&fmt_other_part, "Format.LeaveChannel",
     "@.[%H:%M] %n has left channel %c"},
    {&fmt_signoff, "Format.Signoff", "@.%n has left IRC (%p)"},
    {&fmt_you_nick, "Format.Your.Nickname", "@.You are now known as %p"},
    {&fmt_other_nick, "Format.Nickname", "@.%n changed nick to %p."},
    {&fmt_invite, "Format.Invite", "@.%n is inviting you to channel %c."},
    {&fmt_ignored, "Format.Ignored", "%p: You are being ignored."},
    {&fmt_sed_pub, "Format.SED.Public", "@i@.<%n> %p"},
    {&fmt_sed_priv, "Format.SED.Private", "@i@.[%H:%M.%S]<%n> %p"},
    {&fmt_sed_your, "Format.SED.Your.Public", "@.E<%n> %p"},
    {&fmt_sed_nokey, "Format.SED.NoKey", "@i@.<%n> %p [encrypted]"},
    {&fmt_ctcp_reply, "Format.CTCP_Reply", "@.CTCP %f reply from %n:%p"},
    {&fmt_dcc_chat_notify, "Format.ChatNotify",
     "@.[%H:%M] %i. Chat request from %n (%h) [%z %Z]"},
    {&fmt_dcc_file_notify, "Format.FileNotify",
     "@.[%H:%M] %i. DCC GET [%f %j %k] from %n (%h) [%z %Z]"},

    {&fmt_notify_signon, "Notify.Format.Signon",
     "@.[%H:%M]%n " "has signed on"},
    {&fmt_notify_signoff, "Notify.Format.Signoff",
     "@.[%H:%M]%n " "has signed off (%h - %z)"},
    {NULL, NULL, NULL}
  };
  Res *p = vars;
  const char *s;

  while (p->var)
  {
    s = spx_get_app_resource(p->name,
                             "FormatCLASS", SPX_NONE, p->defval, NULL, 0);
    *(p->var) = my_malloc(sizeof(char) * (strlen(s) + 1));

    strcpy(*(p->var), s);
    p++;
  }
}

extern void AddTomainHistory(const char *);
static int load_mainhistory(const char *f)
{
  FILE *fp;
  char s[512 + 1];

  if ((fp = fopen(f, "r")) == NULL)
    return -1;
  while (fgets(s, 512, fp))
  {
    s[strlen(s) - 1] = '\0';
    if (s[0])
      AddTomainHistory(s);
  }
  fclose(fp);

  return 0;
}

/* needs to be cleaned up */
static void sig_handler(int signo)
{
  switch (signo)
  {
     case SIGCHLD:
       {
         int status;
         pid_t pid;

         pid = waitpid(0, &status, WUNTRACED | WNOHANG);
         if (pid <= 0)
         {
           if (debug > 3)
             if (pid < 0)
               perror("waitpid");
           break;
         }
         else if (WIFEXITED(status))
           (void) WEXITSTATUS(status);
         else if (WIFSIGNALED(status))
         {
           (void) WTERMSIG(status);
           if (debug > 3)
           {
             fprintf(stderr, "process %d killed. Signal %d", pid,
                     WTERMSIG(status));
             psignal(WTERMSIG(status), "");
           }
         }
         else if (WIFSTOPPED(status))
         {
           register int i;

           for (i = 0; i < sp_count; i++)
           {
             if (s_pipe[i].fd > -1 && s_pipe[i].to.proc->pid == pid)
             {
               s_pipe[i].status |= SCR_STOPPED;
               break;
             }
           }
           if (debug)
             fprintf(stderr, "process %d stopped. Signal:%d",
                     pid, WSTOPSIG(status));
         }
       }
       break;
     case SIGSEGV:
       fprintf(stderr,
               "\n\nSorry, " sula_NAME " " sula_VERSION " has one more bug.\n"
               "Please inform \E[1m" sula_EMAIL "\E[m or visit\n\E[1m"
               sula_INFOSITE "\E[m.\nTschuess.\n\n");
/*cleanup(); *//* reentrant! */
       exit(1);
     case SIGPIPE:
       if (debug > 3)
         fputs(PROMPT "Broken pipe == ~ ==", stderr);
       break;

     default:
       fprintf(stderr, PROMPT "Signal %d has no handler\n", signo);
       break;
  }                             //switch

  if (Signal(signo, sig_handler) == SIG_ERR)
    error(-2, "Signal error");
}

static void read_object_attribs(Display * disp, Colormap cmap)
{
#if USE_XFORMS
/*
   currently only used with xforms
 */

#define BROW_COL FL_FREE_COL2
#define BROW2_COL (FL_FREE_COL2+1)
#define SEL_COL (FL_FREE_COL2+2)
#define SEL2_COL (FL_FREE_COL2+3)
#define TEXT_COL (FL_FREE_COL2+4)
#define TEXT2_COL (FL_FREE_COL2+5)
#define INPUT_COL (FL_FREE_COL2+6)
#define MAIN_BROW_COL (FL_FREE_COL2+7)
#define MAIN_BROW_TEXT_COL (FL_FREE_COL2+8)
#define MAIN_BROW_SEL_COL (FL_FREE_COL2+9)
#define FONT_START 16
#define CHANWIN_BROWSER_FONT FONT_START	//16,17,18,19,20,21,22,23:normalx4,fixedx4
#define CHANWIN_BROWSER2_FONT (FONT_START+4)
#define CHANWIN_INPUT_FONT (CHANWIN_BROWSER2_FONT+4)
#define MAIN_BROWSER_FONT (CHANWIN_INPUT_FONT+1)
#define EDITOR_FONT (MAIN_BROWSER_FONT+1)
  int junk;

//#endif

  typedef struct
  {
    char type;                  /* color, style.. */
#define GET_COLOUR 0
#define GET_FONT 1
#define GET_NONE 5

    void *var;
#if USE_XFORMS
    int (*func) (const char *); /* conversion function if needed */
#endif
    char *name;
    char *defval;
#if USE_XFORMS
    union
    {
      int int_defval;
      FL_COLOR index;           /* FL_COLOR if colormap index has to be changed */
      int style;
    } spec;
#endif
  } Res;

#define TIMES   "-*-times-medium-r-*-*-*-?-*-*-*-*-*-*"
#define TIMES_BOLD      "-*-times-bold-r-*-*-*-?-*-*-*-*-*-*"
#define TIMES_ITALIC    "-*-times-medium-i-*-*-*-?-*-*-*-*-*-*"
#define TIMES_BOLD_ITALIC       "-*-times-bold-i-*-*-*-?-*-*-*-*-*-*"
#define FIXED "-*-courier-medium-r-*-*-*-?-*-*-*-*-*-*"
#define FIXED_BOLD "-*-courier-bold-r-*-*-*-?-*-*-*-*-*-*"
#define FIXED_ITALIC "-*-courier-medium-i-*-*-*-?-*-*-*-*-*-*"
#define FIXED_BOLD_ITALIC "-*-courier-bold-i-*-*-*-?-*-*-*-*-*-*"
  Res vars[] = {
#if USE_XFORMS
    {GET_FONT, &browser_fontsyle, &str2fontstyle, "Channelwin.Font", TIMES,
     {CHANWIN_BROWSER_FONT}},
    {GET_FONT, &junk, &str2fontstyle, "Channelwin.Font.Bold", TIMES_BOLD,
     {CHANWIN_BROWSER_FONT + FL_BOLD_STYLE}},
    {GET_FONT, &junk, &str2fontstyle, "Channelwin.Font.Italic", TIMES_ITALIC,
     {CHANWIN_BROWSER_FONT + FL_ITALIC_STYLE}},
    {GET_FONT, &junk, &str2fontstyle, "Channelwin.Font.Italic.Bold", TIMES_BOLD_ITALIC,
     {CHANWIN_BROWSER_FONT + FL_BOLDITALIC_STYLE}},

    {GET_NONE, &browser_fontsize, &str2fontsize, "Channelwin.Font.Size",
     "normal",
     {FL_NORMAL_SIZE}},

    {GET_FONT, &browser2_fontsyle, &str2fontstyle, "StatusWindow.Font", TIMES,
     {CHANWIN_BROWSER2_FONT}},
    {GET_FONT, &junk, &str2fontstyle, "StatusWindow.Font.Bold", TIMES_BOLD,
     {CHANWIN_BROWSER2_FONT + FL_BOLD_STYLE}},
    {GET_FONT, &junk, &str2fontstyle, "StatusWindow.Font.Italic", TIMES_ITALIC,
     {CHANWIN_BROWSER2_FONT + FL_ITALIC_STYLE}},
    {GET_FONT, &junk, &str2fontstyle, "StatusWindow.Font.Italic.Bold", TIMES_BOLD_ITALIC,
     {CHANWIN_BROWSER2_FONT + FL_BOLDITALIC_STYLE}},
    {GET_FONT, &input_fontstyle, &str2fontstyle, "Input.Font", TIMES,
     {CHANWIN_INPUT_FONT}},

    {GET_NONE, &browser2_fontsize, &str2fontsize, "StatusWindow.Font.Size",
     "normal",
     {FL_NORMAL_SIZE}},

    {GET_COLOUR, &browser_colour, &str2color, "Channelwin.Color",
     "rgb:20/30/78",
     {BROW_COL}},

    {GET_COLOUR, &browser2_colour, &str2color, "StatusWindow.Color",
     "bottom_bcol",
     {BROW2_COL}},

    {GET_COLOUR, &browser_selected_colour, &str2color,
     "Channelwin.Selection.Color", "yellow",
     {SEL_COL}},

    {GET_COLOUR, &browser2_selected_colour, &str2color,
     "StatusWindow.Selection2.Color", "blue",
     {SEL2_COL}},

    {GET_COLOUR, &browser_textcolour, &str2color, "Channelwin.Text.Color",
     "black",
     {TEXT_COL}},

    {GET_COLOUR, &browser2_textcolour, &str2color,
     "StatusWindow.Text.Color", "white",
     {TEXT2_COL}},
    {GET_COLOUR, &input_colour, &str2color, "Input.Color", "black",
     {INPUT_COL}},

    {GET_COLOUR, &main_brow_selected_col, &str2color,
     "MainBrowser.Selection.Color", "yellow",
     {MAIN_BROW_SEL_COL}},
    {GET_COLOUR, &main_brow_col, &str2color, "MainWindow.Color", "slateblue",
     {MAIN_BROW_COL}},
    {GET_COLOUR, &main_brow_text_col, &str2color, "MainWindow.Text.Color",
     "black",
     {MAIN_BROW_TEXT_COL}},

    {GET_FONT, &main_brow_fontstyle, &str2fontstyle, "MainWindowFont.", TIMES,
     {MAIN_BROWSER_FONT}},
    {GET_FONT, &junk, &str2fontstyle, "MainWindow.Font.Bold", TIMES_BOLD,
     {MAIN_BROWSER_FONT + FL_BOLD_STYLE}},
    {GET_FONT, &junk, &str2fontstyle, "MainWindow.Font.Italic", TIMES_ITALIC,
     {MAIN_BROWSER_FONT + FL_ITALIC_STYLE}},
    {GET_FONT, &junk, &str2fontstyle, "MainWindow.Font.Italic.Bold", TIMES_BOLD_ITALIC,
     {MAIN_BROWSER_FONT + FL_BOLDITALIC_STYLE}},
    {GET_NONE, &main_brow_fontsize, &str2fontsize, "MainWindow.Font.Size",
     "normal",
     {FL_NORMAL_SIZE}},

    {GET_FONT, &editor_fontstyle, &str2fontstyle, "Editor.Font", FIXED,
     {EDITOR_FONT}},

#endif
    {0, NULL, NULL, 0},
  };
  Res *p = vars;
  char *name;

  while (p->var)
  {
    name = (char *) spx_get_app_resource(p->name, "AttributeCLASS", FL_NONE,
                                         p->defval, NULL, 0);
    switch (p->type)
    {
       case GET_COLOUR:
         *((int *) p->var) = (p->func) (name);
         if (*((int *) p->var) < 0)
           if (!new_str2color(disp, cmap, p->spec.index, name))
           {                    /* failed */
             fprintf(stderr, "[%s %d] Bad colour: %s: "
                     "Not found or bad RGB format. Using %d"
                     "(probably black!)",
                     __FILE__, __LINE__, name, p->spec.int_defval);
             *((int *) p->var) = p->spec.int_defval;
           }
           else
             *((int *) p->var) = p->spec.index;
         break;
       case GET_FONT:
         {
           if (str2font(p->spec.style, name) < 0)
           {
             fprintf(stderr,
                     "[%s %d] Invalid font \"%s\"\n", __FILE__, __LINE__,
                     name);
             str2font(p->spec.style, p->defval);
           }
           if (p->var != (void *) &junk)
             *((int *) p->var) = p->spec.style;
           break;
         }
       default:
         *((int *) p->var) = (p->func) (name);
         if (*((int *) p->var) < 0)
           *((int *) p->var) = p->spec.int_defval;
         break;
    }
    p++;
  }
#endif
}
