/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



/****************************************************************/
/*                                                              */
/*              M O D E                                         */
/*                                                              */
/****************************************************************/

/* mode.c       -mode changes  from server

   Author: Tano Fotang, 1997-1999

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License , or
   (at your option) any later version.

 */

#include <ctype.h>
#include "spx.h"
#include "nc.h"
#include "parser.h"
#include "mode.h"
#include "setting.h"
#include "ignore.h"
#include "hooks.h"

extern void p_mode(void)
{
  char *changed = NULL,
      *changer = NULL,
      *mode = NULL;

  changer = (char *) alloca(sizeof(char) * Len);
  changed = (char *) alloca(sizeof(char) * Len);
  mode = (char *) alloca(sizeof(char) * Len);

  if (sscanf(Msg, "%s MODE %s %[^\n]\n", changer, changed, mode) < 3)
    return;
  untilde(changer);
  if (*changed != '#' && *changed != '&')
  {
    char *pmode = mode;
    int to = Win - winstruct;

    if (*pmode == ':')
      pmode++;
    if (!strcasecmp(changed, Win->server->nick))
      changemymode(Win, pmode, 0);

    if (ignored(changer, IG_MISC))
      return;
    if (check_msg_hook(MODE, Win - winstruct, "%s,%d %s %s %s",
                       Win->server->name,
                       Win->server->port,
                       changer, changed, pmode))
      return;
    if (gflags & SHOW_RAW_MSG)
      isay0("MISC", Msg, to, 1);
    else
    {
      char *buf;

      fmt_string = "%f%n%p$";
      buf = format_msg(fmt_usermode, changer, changed, pmode);
      if (buf)
      {
        isay("MISC", buf, to, 1);
        free(buf);
      }
    }

  }
  else
  {
    int to = Win - winstruct;

    sscanf(Msg, "%*s MODE %*s %[^\n]\n", mode);
    if (!check_msg_hook(MODE, to,
                        "%s,%d %s %s %s",
                        Win->server->name,
                        Win->server->port,
                        changer, changed, mode))
    {
      if (!ignored(changer, IG_MISC))
      {
        if (gflags & SHOW_RAW_MSG)
          isay0("MISC", Msg, to, 1);
        else
        {
          char *nick,
              *login,
              *host,
              *buf;
          int i;
          size_t ll = strlen(changer);
          nick = (char *) alloca(sizeof(char) * ll);
          login = (char *) alloca(sizeof(char) * (ll + 10));
          host = (char *) alloca(sizeof(char) * (ll + 10));

          i = sscanf(Msg, "%[^!]!%[^@]@%s", nick, login, host);
          if (i == 1)
          {
            strcpy(login, "<unknown>");
            strcpy(host, "<unknown>");
          }
          else if (i == 2)
            strcpy(host, "<unknown>");
          if (*login == '~')
            strshift(login, 1);
          fmt_string = "%n%l%h%p%c$";
          buf = format_msg(fmt_chanmode, nick, login, host,
                           mode, changed);
          if (buf)
          {
            isay("MISC", buf, to, 1);
            free(buf);
          }
        }
      }
      if (changechanmode(Win, changed, mode, 0) &&
          !strcasecmp(changed, Win->chanCur->name))
        update_server_stuff(Win->server->fd);
    }
  }
}

extern void changemymode(Winstruct * win, char *mode, int reset)
{
/* change your server    mode 
   reset>0: clear mode and set new mode
 */
  if (!mode)
    return;
  if (reset && Win->server->mode)
  {                             /* free( Win->server->mode ); */
    Win->server->mode = NULL;
  }
  while (*mode)
  {
    if (*mode == '+')
      while (*++mode && *mode != '-')
        addmode(&Win->server->mode, *mode);
    if (*mode == '-')
      while (*++mode && *mode != '+')
        Win->server->mode = strdchr(Win->server->mode, *mode);
  }

  if (!(Win->server->mode) || !(*Win->server->mode))
    Win->server->mode = NULL;
  update_server_stuff(Win->server->fd);

}
extern int changechanmode(Winstruct * win, const char *channame, char *mode, int reset)
{
/* change channel modes 
   reset!=0: clear modes and update, this should be a response to
   RPL_CHANNELMODEIS. see numeric.c
 */
  Channel *chan;
  char update = 0;              /* update display after this */
  char usermode = 0;
  static void change_gokey(Winstruct *, const char *, const char *);

  if (!mode)
    return 0;
  chan = get_chan_byname(win, channame);
  if (chan == NULL)
    return 0;
  if (reset && chan->modes)
  {
    /* RPL_CHANNELMODEIS doesnt supply the o and v modes, so save them
       first before clearing channel modes
     */
    char t[3],
        *p = &t[0];

    if (strchr(chan->modes, 'o'))
      *p++ = 'o';
    if (strchr(chan->modes, 'v'))
      *p++ = 'v';
    *p = '\0';
    free(chan->modes);
    if (t[0])
      chan->modes = strdup(t);
    else
      chan->modes = NULL;
  }
  while (*mode)
  {
    if (*mode == '+')
    {
      while (*++mode && *mode != '-')
      {
        if (!isgraph(*mode))
          continue;             /* skip space and ctrl-chars */
        switch (*mode)
         {
           case 'l':
             {
               char *l = nextword(mode, 1);

               if (*l == 0)
                 break;
               chan->limit = atoi(l);
               free(l);
               rmstr(mode, 1);
               break;
             }
           case 'k':
             {
               if (chan->key)
                 free(chan->key);
               chan->key = nextword(mode, 1);
               if (*(chan->key) == 0)
                 break;
               change_gokey(win, channame, chan->key);
               rmstr(mode, 1);
               break;
             }
           case 'b':           /* someone's been banned */
             rmstr(mode, 1);
             break;
           case '+':
             break;
           case 'o':
           case 'v':
             {
               char *nick = nextword(mode, 1);

               if (*nick == 0)
                 break;
               usermode = 1;
               rmstr(mode, 1);
               if (!strcasecmp(win->server->nick, nick))
               {
                 /* our mode has been changed */
                 addmode(&chan->modes, *mode);
                 update = 1;
               }
               free(nick);
               break;
             }
           default:
           {
             if(*(mode+1)==' ')
               rmstr(mode, 1);
             addmode(&chan->modes, *mode);
             break;
          }
         }
      }
    }                           /* if(*mode=='+') */

    if (*mode && *mode == '-')
    {
      while (*++mode && *mode != '+')
      {
        if (!isgraph(*mode))
        {
          continue;
        }
        switch (*mode)
         {
           case 'l':
             chan->limit = 0;
             break;
           case 'k':
             free(chan->key);
             chan->key = NULL;
             rmstr(mode, 1);
             change_gokey(win, channame, NULL);
             break;
           case 'b':           /* someone's been unbanned */
             rmstr(mode, 1);
             break;
           case '-':
             break;
           case 'o':
           case 'v':
             {
               char *nick = nextword(mode, 1);

               if (*nick == 0)
                 break;
               usermode = 1;
               rmstr(mode, 1);
               if (!strcasecmp(win->server->nick, nick))
               {
                 /* our channel mode has been changed */
                 chan->modes = strdchr(chan->modes, *mode);
                 update = 1;
               }
               free(nick);
               break;
             }
           default:
             if(*(mode+1)==' ')
               rmstr(mode, 1);
             chan->modes = strdchr(chan->modes, *mode);
             break;
         }
      }
    }
    else if (*mode && *mode != '+')
      mode++;
  }                             /*while(*mode) */
  if (!chan->modes || !(*chan->modes))
    chan->modes = NULL;
  if (usermode && !update)
    return 0;
  return 1;
}
#if 0
static void remove_gokey(Winstruct * win, const char *chan)
{
  Go *p = win->goStart;

  while (p != win->goEnd)
    if (!strcasecmp(p->name, chan))
    {
      free(p->key);
      p->key = NULL;
      break;
    }
    else
      p = p->next;
}
#endif
static void change_gokey(Winstruct * win, const char *chan,
                         const char *key)
{
  Go *p = win->goStart;

  while (p != win->goEnd)
    if (!strcasecmp(p->name, chan))
    {
      free(p->key);
      if (key)
        p->key = strdup(key);
      else
        p->key = NULL;
      break;
    }
    else
      p = p->next;
}

extern void addmode(char **s, char c)
{
  size_t ll = 0;

  if (!(*s))
    *s = (char *) malloc(sizeof(char) * 2);

  else
  {
    if (strchr(*s, c))
      return;
    ll = strlen(*s);
    *s = realloc(*s, (ll + 1) * sizeof(char));

    //             ^^^^^|-> sizeof(*s)+1
  }
  *(*s + ll++) = c;
  *(*s + ll) = '\0';
}

extern void update_server_stuff(int fd)
{

  if (fd > -1)
  {
    WinList *p;

    build_winlistbyfd(fd);
    p = servWin;
    while (p)
    {
      UpdateStatus(winstruct + p->w);
      p = p->next;
    }
  }
}
