/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
   msg.c  - topic, invite, privmsg , note & notice
   Copyright (C) 1997 Tano Fotang

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <time.h>
#include <stdarg.h>
#include <ctype.h>
#include "spx.h"
#include "nc.h"
#include "parser.h"
#include "dcc.h"
#include "setting.h"
#include "ignore.h"
#include "cmd.h"
#include "lag.h"
#include "hooks.h"
#include "flood.h"

extern User *find_chanuser(Channel *ch,const char *nick);
/********************* 
 * T O P I C
 *********************/

extern void p_topic(void)
{
  char *channel, *sender, *newtopic = NULL, *nick, *host, *login;
  size_t ll;
  Channel *chan;
  int to;

  channel = (char *) alloca(sizeof(char) * Len);
  sender = (char *) alloca(sizeof(char) * (Len));
  newtopic = (char *) malloc(sizeof(char) * Len);

  to = Win - winstruct;
  if (sscanf(Msg, "%s %*s %s %[^\n]\n", sender, channel, newtopic) < 3)
  {
    free(newtopic);
    return;
  }
  untilde(sender);
  ll = strlen(sender) + 8;
  nick = (char *) alloca(sizeof(char) * (ll));
  host = (char *) alloca(sizeof(char) * (ll));
  login = (char *) alloca(sizeof(char) * (ll));

  *login = 0;
  *host = 0;
  if (sscanf(sender, "%[^!]!%[^@]@%s", nick, login, host) < 3)
  {
    if (*login == 0)
      strcpy(login, "<unknown>");
    if (*host == 0)
      strcpy(host, "<unknown>");
  }
  chan = get_chan_byname(Win, channel);
  if (!chan)/* server bug?*/
    {free(newtopic); return;}
  if (*newtopic == ':')
    strshift(newtopic, 1);
  if (chan->topic)
    free(chan->topic);
  if (!*newtopic)
  {
    chan->topic = NULL;
    if (!ignored(sender, IG_MISC) &&
        (!(sflags & FLOOD_CHECK) ||
         !flooding(sender, PUBLIC_FLOOD, FLOOD_TOPIC) ||
         !check_msg_hook(FLOOD_PUBLIC,
                         Win - winstruct, "%s,%d %s %s",
                         Win->server->name,
                         Win->server->port,
                         sender, chan)) &&
        !check_msg_hook(TOPIC, Win - winstruct, "%s,%d %s %s",
                        Win->server->name, Win->server->port,
                        sender, channel))
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("TOPIC", Msg, to, 1);
      else
      {
        char buf[256];

        if (sscanf(sender, "%*[^!]!%s", host) < 1)
          strcpy(host, "<unknown>");
        sprintf(buf, "%s (%s) has cleared the topic on %s", nick, host,
                channel);
        isay0("TOPIC", buf, to, 1);
      }
    }
    update_topic(Win, channel,
                 "<" sula_NAME " " sula_VERSION
                 "> says no topic has been set");
  }
  else
  {
    chan->topic = strdup(newtopic);
    if (!ignored(sender, IG_MISC) &&
        (!(sflags & FLOOD_CHECK)
         || !flooding(sender, PUBLIC_FLOOD, FLOOD_TOPIC)
         || !check_msg_hook(FLOOD_PUBLIC, Win - winstruct, "%s,%d %s %s",
                            Win->server->name, Win->server->port, sender,
                            chan))
        && !check_msg_hook(TOPIC, Win - winstruct, "%s,%d %s %s %s",
                           Win->server->name, Win->server->port, sender,
                           channel, newtopic))
    {

      if (gflags & SHOW_RAW_MSG)
        isay0("TOPIC", Msg, to, 1);
      else
      {
        char *buf;

        if (sscanf(sender, "%*[^@]@%s", host) < 1)
          strcpy(host, "<unknown>");
        fmt_string = "%n%l%h%c%p$";
        buf = format_msg(fmt_topic, nick, login, host, channel, newtopic);
        if (buf)
        {
          isay("TOPIC", buf, to, 1);
          free(buf);
        }
      }
    }
    update_topic(Win, channel, newtopic);
  }
  free(newtopic);
}

static int is_lag(const char *nick, const char *chan, Winstruct * win)
{
  struct timeval t;

  t.tv_usec = 0;
  if (sscanf(chan, "#__%lu_%lu", &t.tv_sec, &t.tv_usec) < 1)
    return 0;
  if (!strcasecmp(nick, win->server->nick))
  {
    struct timeval now;

    gettimeofday(&now, NULL);
    update_lag_display(win->server, now.tv_sec - t.tv_sec +
                       (float) ((now.tv_usec - t.tv_usec) / 1000000.0), &t);
  }
  return 1;
}
/*
 * I N V I T E                                  
 *
 */

extern void p_invite(void)
{
  char *nick, *channel;

  channel = (char *) alloca(sizeof(char) * Len);
  nick = (char *) alloca(sizeof(char) * (Len));

  if (sscanf(Msg, "%[^!]!%*s", nick) < 1)
    strcpy(nick, "<unknown>");
  if (sscanf(Msg, "%*s INVITE %*s :%s", channel) < 1)
    return;
  if (!is_lag(nick, channel, Win))
  {
    char *login, *host;
    char *sender;

    sender = (char *) alloca(sizeof(char) * (Len));
    host = (char *) alloca(sizeof(char) * (Len));
    login = (char *) alloca(sizeof(char) * (Len));

    sscanf(Msg, "%s", sender);
    untilde(sender);

    *login = 0;
    *host = 0;
    if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) < 2)
    {
      if (*login == 0)
        strcpy(login, "<unknown>");
      if (*host == 0)
        strcpy(host, "<unknown>");
    }

    if (ignored(sender, IG_INVITE))
    {
      if (gflags & INFORM_IGNORED)
      {
        char *s, *buf;

        fmt_string = "%n%l%h%c%p$";
        buf = format_msg(fmt_ignored, nick, login, host, channel, "INVITE");
        if (!buf)
          return;
        s = my_malloc(sizeof(char) * (strlen(buf) + strlen(nick) + 20));
        sprintf(s, "NOTICE %s :%s\n", nick, buf);
        sendto_server(Win, s);
        free(s);
        free(buf);
      }
      return;
    }
    else if ((!(sflags & FLOOD_CHECK) ||
              !flooding(sender, PRIVATE_FLOOD, FLOOD_INVITE) ||
              !check_msg_hook(FLOOD_PRIVATE,
                              Win - winstruct, "%s,%d %s %s",
                              Win->server->name,
                              Win->server->port, sender, channel)))
    {
      char *buf = nextword(Msg, 1);

      if (check_msg_hook(INVITE, Win - winstruct,
                         "%s,%d %s %s %s",
                         Win->server->name,
                         Win->server->port, sender, buf, channel))
      {
        free(buf);
        return;
      }
      free(buf);
      Win->server->lastInvite = strdup(channel);
      if (Win->server->flag & SET_AWAY && (gflags & BEEP_AWAY))
        spx_bell(0);
      //to = Win - winstruct;
      if (gflags & SHOW_RAW_MSG)
        isay0("MISC", Msg, W, 1);
      else
      {
        fmt_string = "%n%l%h%c%p$";
        buf = format_msg(fmt_invite, nick, login, host, channel, channel);
        if (buf)
        {
          isay("MISC", buf, W, 1);
          free(buf);
        }
      }
      if (gflags & AUTO_INVITE)
      {
        buf = (char *) malloc(sizeof(char) * (strlen(channel) + 40));

        if (gflags & VERBOSE_CLIENT)
        {
          sprintf(buf, "Accepting invitation to %s", channel);
          isay("MISC", buf, W, 1);
        }
        addto_cmd_sent(Win, "JOIN", channel);
        sprintf(buf, "JOIN  %s\n", channel);
        sendto_server(Win, buf);
        free(buf);
      }
    }                           //if((!flooding(
  }
}

/****************************************************************
* 
* N O T E  N O T I C E                         
* 
****************************************************************/
extern void p_note(void)
{
  char *buf;

  buf = (char *) alloca(sizeof(char) * Len);

  if ((sscanf(Msg, "NOTICE %*s :%[^\n]\n", buf) < 1))
    return;
  if (*buf == '#')
  {
    if (!check_msg_hook(NOTE, Win - winstruct, "%s,%d %s",
                        Win->server->name, Win->server->port, Msg))
    {
      *(buf + strlen(buf) - 1) = '\0';
      isay2("NOTE", 0, W, 1, "-%s- %s", Win->server->name, buf + 3);
    }
    return;
  }
  else
  {
    char *buf2, *addr, *nick;

    addr = (char *) alloca(sizeof(char) * Len);
    nick = (char *) alloca(sizeof(char) * Len);
    buf2 = (char *) alloca(sizeof(char) * Len);

    if (sscanf(Msg, "%*s %*s %*s %*s %s", buf2) < 1)
      return;                   /* note: buf2 is sender  */
    if (ignored(buf2, IG_NOTE))
      /* dont reply. might cause a ping-pong endless loop */
      return;
    if (check_msg_hook(NOTE, Win - winstruct, "%s,%d %s",
                       Win->server->name, Win->server->port, Msg))
      return;
    if (gflags & SHOW_RAW_MSG)
      isay0("NOTE", Msg, W, 0);
    else
    {
      int H, M;
      char d[] = "0000", h[] = "00", m[] = "00";

      if (sscanf(Msg,
                 "%*s %*s %*s %*s %[^!]!%s /%[^d:]d:%[^h]h:%[^m/]m/ %*s %[^\n]\n",
                 nick, addr, d, h, m, buf2) < 6)
        isay2("NOTE", 1, W, 0, "@C1-@C6%s@C1- %s", Win->server->name, buf);
      else
      {
        int D = atoi(d);

        H = atoi(h);
        M = atoi(m);
        isay2("NOTE", 0, W, 0,
              "-%s- Note from %s (%s) %s%s%s%s%s%s%d min%s ago:",
              Win->server->name, nick, addr, D ? d : "", D ? "day" : "",
              D > 1 ? "s " : D ? " " : "", (H) ? h : "", H ? "hr" : "",
              H > 1 ? "s " : H ? " " : "", M, M != 1 ? "s" : "");
        isay2("NOTE", 0, W, 1, "\t%s", buf2);
      }
    }
  }
}

/****************************************************************
   P R I V M S G                                                
   N O T I C E                                                  
****************************************************************/

extern void p_privmsg(int flag)
{
  if (flag != ISNOTICE && ctcp_cmd())/* do  dcc */
    return;
  else
  {
    char *sender, *nick, *addr, *dest;
    char *msg = NULL;
    size_t ll;
    int i;

    sender = (char *) alloca(sizeof(char) * (8 + Len));
    dest = (char *) alloca(sizeof(char) * Len);
    msg = (char *) alloca(sizeof(char) * Len);

    if (flag == ISNOTICE)
      i = sscanf(Msg, "%s NOTICE %s :%[^\n]\n", sender, dest, msg);
    else
      i = sscanf(Msg, "%s PRIVMSG %s :%[^\n]\n", sender, dest, msg);
    if (i < 3)
    {
      if (i == 2)
      {
        sscanf(Msg, "%*s %*s %[^\n]\n", msg);
        isay2("PRIV_MSG", 0, W, 1, "-%s- %s", sender, msg);
      }
      return;
    }
    ll = strlen(sender) + 8;
    nick = (char *) alloca(sizeof(char) * ll);
    addr = (char *) alloca(sizeof(char) * ll);

    if (sscanf(sender, "%[^!]!%s", nick, addr) < 2)
    {
      /* probably a server notice */
      if (!check_msg_hook(SERVER_NOTICE,
                          Win - winstruct, "%s,%d %s %s %s",
                          Win->server->name,
                          Win->server->port, sender, dest, msg))
      {
        if(gflags&SHOW_RAW_MSG)
          isay("SNOTICE", Msg, W, 1);
        else
        {
          char *s;
          fmt_string = "%n%c%p$";
          s=format_msg(fmt_server_notice, sender, dest, msg);
          if(s){
            isay("SNOTICE", s, W, 1);
            free(s);
          }
        }
      }
      return;
    }
    else
    {
      static int ctcp_reply(const char *,
                            const char *, const char *,
                            const char *, const char *);
      char *name, *host;
      char *fmt = NULL;
      int to;
      char is_public = 0;

      host = (char *) alloca(sizeof(char) * (ll));
      name = (char *) alloca(sizeof(char) * (ll));

      if (*addr == '~')
      {
        strshift(addr, 1);
        sprintf(sender, "%s!%s", nick, addr);
      }
      if (sscanf(addr, "%[^@]@%s", name, host) < 2)
      {
        strcpy(host, "<unknown>");
        name = addr;
      }
#warning CTCP-REPLY flood check has been left out for now
      if (ctcp_reply(nick, name, host, dest, msg))
        return;
      if (*dest == '#' || *dest == '&')
      {
        if (ignored(sender, flag == ISNOTICE ? IG_PUBNOTICE : IG_PUBMSG))
        {
          char *s = NULL;
          char *buf;

          if (flag == ISNOTICE || !(gflags & INFORM_IGNORED))
            return;
          fmt_string = "%n%l%h%c%p$";
          s = format_msg(fmt_ignored, nick, name, host, dest, "CHANNEL MSG");
          if (!s)
            return;
          buf = my_malloc(sizeof(char) * (strlen(s) + strlen(nick) + 15));

          sprintf(buf, "NOTICE %s :%s\n", nick, s);
          sendto_server(Win, buf);
          free(s);
          free(buf);
          return;
        }
        is_public = 1;
        if (flag == ISNOTICE)
          Win->server->flag |= DOING_NOTICE;
        if (((sflags & FLOOD_CHECK) &&
             flooding(addr, PUBLIC_FLOOD, FLOOD_PUBMSG) &&
             check_msg_hook(FLOOD_PUBLIC,
                            Win - winstruct, "%s,%d %s %s",
                            Win->server->name,
                            Win->server->port,
                            sender, dest)) ||
            check_msg_hook(flag == ISNOTICE ? PUBLIC_NOTICE : PUBLIC_MSG,
                           Win - winstruct, "%s,%d %s %s %s",
                           Win->server->name,
                           Win->server->port, sender, dest, msg))
        {
          if (flag == ISNOTICE)
            Win->server->flag &= ~DOING_NOTICE;
          return;
        }
        to = Win - winstruct;
        if (flag == ISNOTICE)
          Win->server->flag &= ~DOING_NOTICE;
        if (!find_chanuser(get_chan_byname(Win, dest), nick))
          /*    sender is not  on this channel */
          fmt = flag == ISNOTICE ? fmt_pub_notice3 : fmt_pub_msg3;
        else if (strcasecmp(dest, Win->chanCur->name))
          /* this isnt my current channel */
          fmt = flag == ISNOTICE ? fmt_pub_notice2 : fmt_pub_msg2;
        else
          fmt = flag == ISNOTICE ? fmt_pub_notice : fmt_pub_msg;
      }
      else
      {   /* this is a private msg/notice */
        if (ignored(sender, flag == ISNOTICE ? IG_PRIVNOTICE : IG_PRIVMSG))
        {
          char *s = NULL, *buf;

          if (flag == ISNOTICE || !(gflags & INFORM_IGNORED))
            return;
          fmt_string = "%n%l%h%c%p$";
          s = format_msg(fmt_ignored, nick, name, host, dest, "PRIVATE MSG");
          if (!s)
            return;
          buf = (char *) malloc(sizeof(char) * (strlen(s) +

                                                strlen(nick) + 15));

          sprintf(buf, "NOTICE %s :%s\n", nick, s);
          sendto_server(Win, buf);
          free(s);
          free(buf);
          return;
        }
        if (flag == ISNOTICE)
          Win->server->flag |= DOING_NOTICE;
        if ((sflags & FLOOD_CHECK &&
             flooding(addr, PRIVATE_FLOOD, FLOOD_PRIVMSG) &&
             check_msg_hook(FLOOD_PRIVATE,
                            Win - winstruct, "%s,%d %s",
                            Win->server->name,
                            Win->server->port,
                            sender)) ||
            check_msg_hook(flag == ISNOTICE ? PRIVATE_NOTICE : PRIVATE_MSG,
                           Win - winstruct, "%s,%d %s %s %s",
                           Win->server->name,
                           Win->server->port, sender, dest, msg))
        {
          if (flag == ISNOTICE)
            Win->server->flag &= ~DOING_NOTICE;
          return;
        }
        to = W;
        if (flag == ISNOTICE)
          Win->server->flag &= ~DOING_NOTICE;
        fmt = flag == ISNOTICE ? fmt_priv_notice : fmt_priv_msg;
        if ((gflags & BEEP_MSG)
            || (Win->server->flag & SET_AWAY && (gflags & BEEP_AWAY)))
          spx_bell(0);
      }
      if (gflags & SHOW_RAW_MSG)
        isay0(flag == ISNOTICE ? "PRIV_NOTICE" : "PRIV_MSG", Msg, to, 0);
      else
      {
        char *ptr;

        ll = strlen(msg);
        ctcp_unquote_it(msg, &ll);
        fmt_string = "%f%n%l%h%c%p%z%Z$";
        ptr = format_msg(fmt, Win->server->name,
                         nick, name, host, dest, msg, Len, Win->server->read);
        if (ptr)
        {
          if (is_public)
            isay(flag == ISNOTICE ? "PUB_NOTICE" : "PUB_MSG", ptr, to, 0);
          else
            isay(flag == ISNOTICE ? "PRIV_NOTICE" : "PRIV_MSG", ptr, to, 0);
          free(ptr);
        }
      }
    }
  }
}

static int ctcp_reply(const char *nick,
                      const char *name,
                      const char *host,
                      const char *dest,
                      const char *msg)
{

  if (*msg != 0x01)
    return 0;
  else
  {
    register char *str;
    char *buf, *ptr;
    size_t ll = strlen(msg);

    buf = (char *) alloca(sizeof(char) * ll);

    str = (char *) (msg);
    ptr = buf;
    while (*++str && *str != 0x01)
      *ptr++ = *str;
    if (*str != 0x01)
      return 0;
    *ptr = '\0';                //   ignore all else after 0x01 

    if (check_msg_hook(CTCP_REPLY, W,
                       "%s,%d %s!%s@%s %s %s",
                       Win->server->name,
                       Win->server->port, nick, name, host, dest, buf))
      return 1;
    if (gflags & SHOW_RAW_MSG)
    {
      isay0("CTCP_REPLY", Msg, W, 1);
      return 1;
    }

    ll = strlen(buf);
    ctcp_unquote_it(buf, &ll);
    str = nextword(buf, 0);
    if (!strcasecmp(str, "PING"))
    {
      struct timeval t, t2;
      char s[32];
      int i = sscanf(buf, "%*s %lu %lu", &t.tv_sec, &t.tv_usec);

      free(str);
      if (i < 1)
        return 1;
      if (i < 2)
        t.tv_usec = 0;
      gettimeofday(&t2, NULL);
      sprintf(s, "%f seconds",
              (float) (t2.tv_sec - t.tv_sec +
                       (float) ((t2.tv_usec - t.tv_usec) / 1000000.0)));
      fmt_string = "%f%n%l%h%p%z%Z$";
      ptr = format_msg(fmt_ctcp_reply,
                       "PING", nick, name, host, s, Len, Win->server->read);
      if (ptr)
      {
        isay("CTCP_REPLY", ptr, W, 1);
        free(ptr);
      }
    }
    else
    {
      rmstr(buf, 0);            //  rm ctcp cmdname

      fmt_string = "%f%n%l%h%p%z%Z$";
      ptr = format_msg(fmt_ctcp_reply,
                       str, nick, name, host, buf, Len, Win->server->read);
      if (ptr)
      {
        isay("CTCP_REPLY", ptr, W, 1);
        free(ptr);
      }
      free(str);
    }
    return 1;
  }
}
