/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* nicks.c                                                                                          - create and manipulate nickname groups

   Author: Tano Fotang, 1998

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License , or
   (at your option) any later version.
   see the file COPYING for more information.

   Becasue of the way nickname groups are used, it is a better idea
   to have just 1 nick in a group than to have very few nicks in the group.
   Nicks are kept in a ring. If one nick is already in use, the next one
   is sent to server.
   Therefore, if u have only 2 nicks and both are already taken, client just
   keeps alternating between the two..forever until server gets tired of it.
   If there's only one nick, client appends a '_' to it and adds a random number.
   Obviously, 1 or zero nick is better than having too few.
 */
#include "spx.h" //my_malloc
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include "nicks.h"
#include "util.h"
NickList *aNickList=NULL;
Nickcount iNickListCount=0;
static Nicks *in_list(Nickcount i, const char *nick)
{
  Nicks *p = aNickList[i].start->left;

  while (p != aNickList[i].start)
    if (!strcasecmp(p->nick, nick))
      return p;
    else
      p = p->left;
  return NULL;
}
extern Nicks *add_nick_to_list(Nickcount i, const char *nick)
{

  Nicks *p;
  assert(i>-1);
  p = in_list(i, nick);
  if (p)
    return p;
  p = (Nicks *) my_malloc(sizeof(Nicks));
    p->nick = strdup(nick);
    p->left = aNickList[i].current;
    p->right = aNickList[i].current->right;
    aNickList[i].current->right->left = p;
    aNickList[i].current->right = p;

    return p;
}

#define NICKLIST_ALLOC 2
static void NickList_alloc(void)
{
  Nickcount i;

  if (aNickList == NULL)
    aNickList = my_malloc(sizeof(NickList) * NICKLIST_ALLOC);
  else
    aNickList = my_realloc(aNickList,
                      (iNickListCount + NICKLIST_ALLOC) * sizeof(NickList));
  for (i = iNickListCount; i < iNickListCount + NICKLIST_ALLOC; i++)
    aNickList[i].label = NULL;
  iNickListCount += NICKLIST_ALLOC;
}
Nickcount get_list_bylabel(const char *label)
{
  NickList *p = aNickList;

  while (p - aNickList < iNickListCount)
    if (p->label && !strcasecmp(p->label, label))
      return (p - aNickList);
    else
      p++;
  return -1;
}
Nickcount new_nicklist(const char *label)
{
  register int i;

  i = get_list_bylabel(label);
  if (i != -1)
    return i;
  if (aNickList == NULL) NickList_alloc();
retry:
  for (i = 0; i < iNickListCount; i++)
    if (!aNickList[i].label)
    {
      aNickList[i].start = my_malloc(sizeof(Nicks));
      aNickList[i].start->left = aNickList[i].start->right =
         aNickList[i].current = aNickList[i].start;
      aNickList[i].label = strdup(label);
      return i;
    }
  NickList_alloc();
  goto retry;
}

extern int load_nicks(const char *fname)
{
  FILE *fp = fopen(fname, "r");

  if (!fp)
    return -1;
  else
  {
    char **nicks,
        *label;
    int count;

    nicks = alloca(sizeof(char *) * (NICK_QUEUE_LEN + 1));

    while ((label = get_string_entries(fp,
                                       &count, nicks, NICK_QUEUE_LEN, 1)))
    {
      Nickcount i = new_nicklist(label);
      char **p;

      if (i < 0)
      {
        count = errno;
        fclose(fp);
        errno = count;
        return -1;
      }
      p = nicks;
      while (*p)
      {
        aNickList[i].current = add_nick_to_list(i, *p);
        free(*p);
        p++;
      };
      free(label);
    }
  }
  fclose(fp);
  return 0;
}
