/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/

/* numeric.c -parse numeric commands

   (c) 1997-1999 Tano Fotang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License , or
   (at your option) any later version.

   see the file COPYING for more info.

 */

#include "spx.h"
#include <errno.h>
#include <time.h>
#include <stdarg.h>
#include "nicks.h"
#include "server.h"
#include "server-numerics.h"
#include "parser.h"
#include "mode.h"
#include "dcc.h"
#include "cmd.h"
#include "lag.h"
#include "notify.h"

#if USE_XFORMS
#include "here.xpm"
#include "away.xpm"
#endif
extern Winstruct *Win;
extern int check_numeric(int, Winstruct *, const char *);
extern int check_userhost(int w, const char *msg);
static char *buf;
#define get_win_bychanname2(fd, ch) (X==1? Win : get_win_bychanname(fd, ch))
#if USE_GTK
static char num[22];
#else
static char num[5];
#endif

void p_numeric(int numeric)
{
  static Winstruct *get_whois_win(char try_whowas);
  char *sender;

  sender = nextword(Msg, 0);
  if (gflags & SHOW_NUMERIC)
#if USE_XFORMS
    sprintf(num, "%4d ", numeric);
#elif USE_GTK
    sprintf(num, "@f@D7@C4@v%4d@^@. ", numeric);
#endif
  else
#if USE_XFORMS
    num[0] = 0;
#elif USE_GTK
  {
    num[0] = '@';
    num[1] = '.';
    num[2] = 0;
  }
#endif
  buf = malloc(sizeof(char) * (1 + Len + sizeof(num)));

  *buf = 0;
  if (X > 1 && !win_invalid(W) && winstruct[W].server == Win->server)
    Win = winstruct + W;
  switch (numeric)
  {
     case RPL_WELCOME:
       {                        /*001 */
         static void TryOldChannels(void);
         static void cmds_oncon(void);
         struct timeval now;

         if (sscanf(Msg, "%*s %*s %s", buf) < 1)
           break;
         Win->server->connecting = 0;
         gettimeofday(&now, NULL);
         ClearLag(Win->server);
         update_lag_display(Win->server,
                            now.tv_sec - Win->server->t.tv_sec +
                            (float) ((now.tv_usec - Win->server->t.tv_usec) /
                                     1000000.0), 0);
         free(Win->server->nick);
         Win->server->nick = strdup(buf);
         aNickList[Win->server->iNick].current =
            add_nick_to_list(Win->server->iNick, Win->server->nick);
         attach_notify_group(Win->server,
                             find_notify_list_bylabel("default"));
         if (Win->server->mode)
         {                      /* maintain previous mode */
           sprintf(buf, "MODE %s %s\n", Win->server->nick, Win->server->mode);
           free(Win->server->mode);
           Win->server->mode = NULL;
           sendto_server(Win, buf);
         }
         cmds_oncon();
         TryOldChannels();
         if (strcasecmp(Win->server->name, sender))
         {
            free(Win->server->alias);
            Win->server->alias = strdup(sender);
         }
         UpdateWindows(Win->server->fd, 1);
         connecting(Win->server->g, sender, Win->server->port, 1);
       }
     case RPL_YOURHOST:        /* 002 */
     case RPL_CREATED:         /* 003 */
     case RPL_MYINFO:
       {                        /* 004 */
         if (check_numeric(numeric, Win, Msg))
           break;
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, -1, 1);
         else
         {
           sscanf(Msg, "%*s %*s %*s %[^\n]\n", buf);
           isay2("NUMERIC", 1, W, 1, "%s%s", num, numeric != RPL_MYINFO ?
                 buf + 1 : buf);
         }
       }
       break;

     case RPL_LUSEROP:         /*252 */
     case RPL_LUSERUNKNOWN:    /*253 */
     case RPL_LUSERCHANNELS:   /*254 */
       if (!check_numeric(numeric, Win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
         {
           int x;

           if (sscanf(Msg, "%*s %*s %*s %d", &x) < 1)
             break;
           if (numeric == RPL_LUSERCHANNELS)
             isay2("NUMERIC", 1, W, 1, "%s%s> %d channel%s been formed", num,
                   sender, x, x > 1 ? "s have" : " has");
           else if (numeric == RPL_LUSERUNKNOWN)
             isay2("NUMERIC", 1, W, 1,
                   "%s%s> There %s %d unknown connection%s", num, sender,
                   x > 1 ? "are" : "is", x, x > 1 ? "s" : "");
           else
             isay2("NUMERIC", 1, W, 1, "%s%s> %d operator%s online", num,
                   sender, x, x > 1 ? "s are" : " is");
         }
       }
       break;

     case RPL_UMODEIS:         /* 221 */
       {
         char *who;
         who = (char *) alloca(sizeof(char) * Len);

         if (sscanf(Msg, "%*s %*s %s %s", who, buf) < 2)
         {
           break;
         }

         if (!strcasecmp(who, Win->server->nick))
         {
           changemymode(Win, buf, 1);
           if (check_numeric(numeric, Win, Msg))
             break;
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, W, -1);
           else
             isay2("NUMERIC", 1, W, 1, "%s%s> Your user mode is \"%s\"", num,
                   sender, buf);

         }
         else
         {
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, W, 1);
           else
             isay2("NUMERIC", 1, W, 1, "%s%s> User mode for %s is \"%s\"",
                   num, sender, who, buf);
         }
       }
       break;
     case RPL_ADMINME:         /* 256 */
     case RPL_ADMINLOC1:       /* 257 */
     case RPL_ADMINLOC2:       /* 258 */
     case RPL_ADMINEMAIL:      /* 259 */
       {
         if (check_numeric(numeric, Win, Msg))
           break;
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
         {
           sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf);
           isay2("NUMERIC", 1, W, 1, "%s\t%s", num, buf);
         }
       }
       break;

     case RPL_INFO:            /* 371 */
     case RPL_MOTD:            /* 372 */

       {
         if (check_numeric(numeric, Win, Msg))
           break;
         if (numeric == RPL_MOTD)
           if ((Win->server->flag & GOT_MOTD))
             if (sflags & SUPPRESS_MOTD)
               break;
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
         {
           sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf);
           isay2("NUMERIC", 1, W, 1, "@f@.    %s", buf);
         }
       }
       break;
     case RPL_MOTDSTART:       /*375 */
       if (check_numeric(numeric, Win, Msg))
         break;
       if ((Win->server->flag & GOT_MOTD))
         if (sflags & SUPPRESS_MOTD)
           break;
       if (gflags & SHOW_RAW_MSG)
         isay0("NUMERIC", Msg, W, 1);
       else
       {
         sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf);
         isay2("NUMERIC", 1, W, 1, "@f%s%s", num, buf);
       }
       break;
     case RPL_ENDOFMOTD:       /*376  */
       if (!check_numeric(numeric, Win, Msg))
       {
         if (!(sflags & SUPPRESS_MOTD) || !(Win->server->flag & GOT_MOTD))
         {
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, W, 1);
           else
           {
             sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf);
             isay2("NUMERIC", 1, W, 1, "@f%s%s", num, buf);
           }
         }
       }
       Win->server->flag |= GOT_MOTD;
       break;
     case RPL_AWAY:            /* 301 */
       {
         Winstruct *win = get_whois_win(1);

         if (!check_numeric(numeric, win, Msg))
         {
           int w = win - winstruct;

           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, w, 1);
           else
           {
            char *nick=alloca(sizeof(char) * Len);
            *buf=0;
            sscanf(Msg, "%*s %*s %*s %s %[^\n]\n", nick, buf);
            isay2("NUMERIC", 1, W, 1, "%s\t%s away %s", num, nick, buf);
           }
         }
       }
       break;
     case RPL_USERHOST:        /* 302 */
       getwinbycmd(Win->server, "USERHOST", NULL, 1);	//wild kludge....

       if (sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf) < 1)
         break;
       else
       {
         unsigned char flag;

#define UH_IS_AWAY (1<<0)
#define UH_IS_OP   (1<<1)
         char *pbuf;
         int i;
         char *tmp;
         char *nick;

         nick = alloca(sizeof(char) * Len);

         tmp = malloc(sizeof(char) * (Len + 10 + strlen(Win->server->name)));

         strcpy(tmp, Msg);

         i = 0;
         pbuf = nextword(buf, i++);
         do
         {
           char *pos;
           char *pos2;
           int end;

           flag = 0;
           pos = strchr(pbuf, '=');
           if (!pos)
             break;
           *pos = 0;
           if (*(pos - 1) == '*')
           {
             flag |= UH_IS_OP;
             *(pos - 1) = 0;
           }
           strcpy(nick, pbuf);
           pos++;
           if (*pos == '-')
             flag |= UH_IS_AWAY;
           pos++;
           // user@host
           end = strchr(pos, '@') - pos;
           pos2 = alloca(sizeof(char) * strlen(pos));

           strncpy(pos2, pos, end);
           *(pos2 + end) = 0;
           /*
              tmp:= sender nick +|- +|- username hostname
            */
           sprintf(tmp, "%s,%hu %s %s %c %c %s %s",
                   Win->server->name, Win->server->port,
                   sender, nick, (flag & UH_IS_OP) ? '+' : '-',
                   (flag & UH_IS_AWAY) ? '+' : '-', pos2, pos + end + 1);

           /* userhost nick -cmd ... */
           if (!check_userhost(Win - winstruct, tmp))
           {
             end = find_pos(Msg, 3);
             strcpy(tmp + end, pbuf);
             if (!check_numeric(numeric, Win, tmp))
             {
               if (gflags & SHOW_RAW_MSG)
                 isay0("NUMERIC", tmp, W, 1);
               else
                 isay2("NUMERIC", 1, W, 1, "%s%s> %s is %s%s%s", num, sender,
                       nick, pos,
                       (flag & UH_IS_OP) ? ", an IRC operator" : "",
                       (flag & UH_IS_AWAY) ? " (now away)" : "");

             }
           }
           free(pbuf);
           pbuf = nextword(buf, i++);
         }
         while (*pbuf);
         free(pbuf);
         free(tmp);
       }
       break;

     case RPL_ISON:            /* 303 */
       if (sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf) < 1)
         *buf = 0;              //nobody is online
       if (requested_notify(buf, Win))
         break;

       //getwinbycmd(Win->server,"ISON",NULL,1); //wild kludge....
       if (!check_numeric(numeric, Win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
         {
           isay0("NUMERIC", Msg, W, 1);
           break;
         }

         if (*buf == 0)
         {
           isay2("NUMERIC", 1, W, 1, "%s%s> Person currently not on IRC", num,
                 sender);
           break;
         }
         else
           isay2("NUMERIC", 1, W, 1, "%s%s> Currently on IRC: %s", num,
                 sender, buf);
       }
       break;

     case RPL_UNAWAY:          /* 305 */
     case RPL_NOWAWAY:         /* 306 */
       {
         WinList *p;
         int nothing = check_numeric(numeric, Win, Msg);

         if (numeric == RPL_NOWAWAY)
           Win->server->flag |= SET_AWAY;
         else
           Win->server->flag &= ~SET_AWAY;
         build_winlistbyfd(Win->server->fd);
         p = servWin;
         while (p)
         {
           /* todo: replace all fl_ -routines */
#if USE_XFORMS
           Winstruct *win = winstruct + p->w;

           if (Win->server->flag & SET_AWAY)
           {
             fl_free_pixmapbutton_pixmap(win->chanwin->away);
             fl_set_pixmapbutton_data(win->chanwin->away, away_xpm);
           }
           else
           {
             fl_free_pixmapbutton_pixmap(win->chanwin->away);
             fl_set_pixmapbutton_data(win->chanwin->away, here_xpm);
           }
#endif
           if (!nothing)
           {
             if (gflags & SHOW_RAW_MSG)
               isay0("NUMERIC", Msg, p->w, 1);
             else if (sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf) > 0)
               isay0("NUMERIC", buf, p->w, 1);
           }
           p = p->next;
         }

       }
       break;

     case RPL_WHOISUSER:       /* 311 */
     case RPL_WHOWASUSER:      /* 314 */
       {
         Winstruct *win = get_whois_win(1);

         if (!check_numeric(numeric, win, Msg))
         {
           int w = win - winstruct;

           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, w, 1);
           else
           {
             char *nick, *name, *host, *ircname, txt[] = "was";
             int i;

             nick = (char *) alloca(sizeof(char) * Len);
             name = (char *) alloca(sizeof(char) * Len);
             host = (char *) alloca(sizeof(char) * Len);
             ircname = (char *) alloca(sizeof(char) * Len);

             i =
                sscanf(Msg, "%*s %*s %*s %s %s %s %*s :%[^\n]\n", nick, name,
                       host, ircname);
             if (i < 3)
               break;
             if (numeric == RPL_WHOISUSER)
               strcpy(txt, "is");
             if (i < 4)
               isay2("NUMERIC", 1, w, 1, "%s\t%s %s %s@%s", num, nick, txt,
                     name, host);
             else
               isay2("NUMERIC", 1, w, 1, "%s\t%s %s %s@%s (%s)", num, nick,
                     txt, name, host, ircname);
           }
         }
       }
       break;
     case RPL_WHOISSERVER:     /* 312 */
       {
         Winstruct *win = get_whois_win(1);

         if (!check_numeric(numeric, win, Msg))
         {
           int w = win - winstruct;

           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, w, 1);
           else
           {
             char *des = (char *) alloca(sizeof(char) * Len);
             int i;

             i = sscanf(Msg, "%*s %*s %*s %*s %s :%[^\n]\n", buf, des);
             if (i < 1)
               break;
             if (i < 2)
               isay2("NUMERIC", 1, w, 1, "%s\ton IRC via server %s", num,
                     buf);
             else
               isay2("NUMERIC", 1, w, 1, "%s\ton IRC via server %s (%s)", num,
                     buf, des);
           }
         }
       }
       break;

     case RPL_WHOISOPERATOR:   /* 313 */
       {
         Winstruct *win = get_whois_win(0);

         if (!check_numeric(numeric, win, Msg))
         {
           int w = win - winstruct;

           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, w, 1);
           else
           {
             char *nick = (char *) alloca(sizeof(char) * Len);

             if (sscanf(Msg, "%*s %*s %*s %s :%[^\n]\n", nick, buf) < 2)
               break;
             isay2("NUMERIC", 1, w, 1, "%s\t%s %s", num, nick, buf);
           }
         }
       }
       break;
      case RPL_WHOISIDLE:       /* 317 */
       {
         Winstruct *win = get_whois_win(0);

         if (!check_numeric(numeric, win, Msg))
         {
           int w = win - winstruct;

           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, w, 1);
           else
           {
             long t;
             long secs;
             int hrs, mins;

             t = 0;
             if (sscanf(Msg, "%*s %*s %*s %s %ld %ld", buf, &secs, &t) < 2)
               break;
             hrs = secs / 3600;
             mins = (secs - (hrs * 3600)) / 60;
             secs = secs - (hrs * 3600 + mins * 60);

             if (t == 0)
             {
               isay2("NUMERIC", 1, w, 1,
                     "%s\t%s has been idle for " \
                     "%d hour%s, %d minute%s and %ld seconds)", num,
                     buf, hrs, hrs > 1 ? "s" : "",
                     mins, mins > 1 ? "s" : "", secs);
               /* do we say "for 0 hrs"?? */
             }
             else
               isay2("NUMERIC", 1, w, 1,
                     "%s\t%s signed on %s%*s\tand has been idle for " \
                     "%d hour%s, %d minute%s and %ld seconds",
                     num, buf, ctime(&(t)),
                     7, " ",
                     hrs, hrs > 1 ? "s" : "",
                     mins, mins > 1 ? "s" : "", secs);
           }                    //else
         }
       }
       break;
     case RPL_ENDOFWHOWAS:     /* 369 */
     case RPL_ENDOFWHOIS:      /* 318 */
       {                        /* 318 */
         char *a = nextword(Msg, 3);
         Winstruct *win;

         if (!(win = getwinbycmd(Win->server, "WHOIS", a, 1)))
           win = getwinbycmd(Win->server, "WHOWAS", a, 1);
         free(a);
         if (!win)
           win = Win;
         if (!check_numeric(numeric, win, Msg))
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, win - winstruct, 1);
         break;
       }

     case RPL_WHOISCHANNELS:   /* 319 */
       {
         Winstruct *win = get_whois_win(0);

         if (!check_numeric(numeric, win, Msg))
         {
           int w = win - winstruct;

           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, w, 1);
           else if (sscanf(Msg, "%*s %*s %*s %*s %[^\n]\n", buf) < 1)
             break;
           else
             isay2("NUMERIC", 1, w, 1, "%s\ton channels %s", num, buf);
         }
       }
       break;

     case RPL_LISTSTART:       /* 321 */
       if (check_numeric(numeric, Win, Msg))
         break;
       if (gflags & SHOW_RAW_MSG)
         isay0("NUMERIC", Msg, W, 1);
       else
         isay2("NUMERIC", 1, W, 1, "%s%s-Channel list start-", num, sender);
       break;
     case RPL_LIST:            /* 322 */
       if (!check_numeric(numeric, Win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
         {
           char *topic = (char *) malloc(sizeof(char) * Len);
           unsigned n, i;

           i = sscanf(Msg, "%*s %*s %*s %s %u :%[^\n]\n", buf, &n, topic);
           if (i > 1)
             isay2("NUMERIC", 1, W, 1, "@f%4d@. %s\t%d\t%s", numeric,
                   *buf == '*' ? "(private)" : buf, n, i > 2 ? topic : "");
           free(topic);
         }
       }
       break;

     case RPL_LISTEND:         /* 323 */
       if (!check_numeric(numeric, Win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
           isay2("NUMERIC", 1, W, 1, "%s%s-channel list end-", num, sender);
       }
       break;
#warning Check windows for 324, 329, 331, 332 and 333! Might be wrong.     
     case RPL_CHANNELMODEIS:  /* 324 */
       {
         Winstruct *win;
         char *channel = (char *) alloca(sizeof(char) * Len);

         sscanf(Msg, "%*s %*s %*s %s %[^\n]\n", channel, buf);
         win = getwinbycmd(Win->server, "MODE", channel, 1);
         if (win && !check_numeric(numeric, Win, Msg))
         {                      /* we asked for chan mode */
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, win - winstruct, 1);
           else
             isay2("NUMERIC", 1,win - winstruct, 1,
              "%sMode for channel %s is \"%s\"", num, channel, buf);
         }
         win = get_win_bychanname(Win->server->fd, channel);
         if (win)
         {
           Channel *p;

           changechanmode(win, channel, buf, 1);
           p = win->chanStart->left;
           while (p != win->chanStart)
             if (strcasecmp(channel, p->name))
               p = p->left;
             else
             {
               if (p == win->chanCur)
                 UpdateStatus(win);
               break;
             }
         }
       }
       break;
     case 329:                 /* RPL_CREATIONTIME */
       {
         long t;
         char *channel =  alloca(sizeof(char) * Len);
         Winstruct *win;


         if (sscanf(Msg, "%*s %*s %*s %s %ld", channel, &t) < 2)
           break;
         win = get_win_bychanname2(Win->server->fd, channel);
         if(!win) win=Win;
       if (!check_numeric(numeric, win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
            isay0("NUMERIC", Msg, win - winstruct, 1);
         else
         {
         char *s;
         
         s = strdup(ctime(&(t)));
         *(s + strlen(s) - 1) = '\0';
         isay2("NUMERIC", 1, win - winstruct, 1, "%s%s was created on %s", num,
                   channel, s);
         free(s);
         }
       }
     }
       break;

#warning [23Aug99] if(gflags & SHOW_RAW_MSG) to be continued from here

     case RPL_NOTOPIC:  /* 331 */
       {
         Winstruct *win;
         sscanf(Msg, "%*s %*s %*s %s", buf);
         win = get_win_bychanname(Win->server->fd, buf);
         if (!check_numeric(numeric, win?win:Win, Msg))
         {
           if (win)
           {
             Channel *chan = get_chan_byname(win, buf);
             if (chan)
             {
               chan->topic = NULL;
               update_topic(win, buf,
                            "No topic is set (" sula_NAME "-" sula_DESCR").");
             }
             isay2("NUMERIC", 1, win - winstruct, 1, "%s%s has no topic", num, buf);
           }
           else
             isay2("NUMERIC", 1, W, 1, "%s%s> %s: no topic is set", num,
                   sender, buf);
         }
       }
       break;
  
     case RPL_TOPIC:           /* 332 */
       {
         Winstruct *win;
         int just_update; 
         char *channel = alloca(sizeof(char) * Len);

         if (sscanf(Msg, "%*s %*s %*s %s %[^\n]\n ", channel, buf) < 2)
           break;

         win= get_win_bychanname2(Win->server->fd, channel);
         just_update= check_numeric(numeric, win?win:Win, Msg);
         if (win)
         {
           Channel *chan = get_chan_byname(win, channel);

           if (chan)
           {
             chan->topic = strdup(buf + 1);
             update_topic(win, channel, buf + 1);
           }
           if (!just_update)
             isay2("NUMERIC", 1, win - winstruct, 1, "%sTopic for %s %s", num,
                   channel, buf);
         }
         else if (!just_update)
           isay2("NUMERIC", 1, W, 1, "%s%s> Topic for %s %s", num, sender,
                 channel, buf);
       }
       break;
     case 333:
       {
         Winstruct *win;
         char *channel = (char *) alloca(sizeof(char) * Len);
         if (sscanf(Msg, "%*s %*s %*s %s", channel) < 1)
           break;
         win = get_win_bychanname2(Win->server->fd, channel);
         if (!check_numeric(numeric, win?win:Win, Msg))
         {
          long t;
          char *by = (char *) alloca(sizeof(char) * Len);
          if (sscanf(Msg, "%*s %*s %*s %*s %s %ld", by, &t) < 2)
            break;
         free(buf);
         buf = strdup(ctime(&(t)));
         *(buf + strlen(buf) - 1) = '\0';
           isay2("NUMERIC", 1, win?win - winstruct:W, 1,
                 "%sTopic for %s was set by %s on %s", num, channel, by, buf);
        }
       }
       break;
     case RPL_ENDOFNAMES:      /* 366 */
     {
         Winstruct *win=Win;
         int w=W;
         sscanf(Msg, "%*s %*s %*s %s", buf);
         if(X>1){
           win = get_win_bychanname(Win->server->fd, buf);
           if(win) w=win-winstruct;
           else win=Win;
         }
         if (!check_numeric(numeric, win, Msg))
         {
           if (gflags & SHOW_RAW_MSG)
            isay0("NUMERIC", Msg, w, 1);
           else
            isay2("NUMERIC", 1,w, 1, "%s%s", num, Msg+find_pos(Msg,3));
         }
       }
       break;

     case RPL_LISTUSAGE:       /* 334 *//* Undernet extension */
       if (check_numeric(numeric, Win, Msg))
         break;
       if (sscanf(Msg, "%*s %*s %*s :%[^\n]\n", buf) > 0)
       {
         if (strstr(Msg, "m" "IRC"))
           break;
         isay0("NUMERIC", buf, W, 1);
       }
       break;
     case RPL_INVITING:        /* 341 */
       {
         struct timeval t;

         if (sscanf(Msg, "%*s %*s %*s %*s #__%lu_%lu", &t.tv_sec, &t.tv_usec)
             < 2)
           if (!check_numeric(numeric, Win, Msg))
           {
             char *nick = (char *) alloca(sizeof(char) * (Len));

             if (sscanf(Msg, "%*s %*s %*s %s %s", nick, buf) < 2)
               break;
             isay2("NUMERIC", 1, W, 1, "%sInviting %s to channel %s", num,
                   nick, buf);
           }
       }
       break;
     case RPL_VERSION:         /* 351 */
       if (!check_numeric(numeric, Win, Msg))
       {
         char *version;
         version = (char *) alloca(sizeof(char) * (Len + 32));

         if (sscanf(Msg, "%*s %*s %*s %s %*s :%[^\n]\n", version, buf) < 2)
           break;

         isay2("NUMERIC", 1, W, 1, "%s%s> Server version: %s %s", num, sender,
               version, buf);
       }
       break;
     case RPL_WHOREPLY:        /* 352 */
       {
         Winstruct *win = NULL;
         char mode[4];

         char *chan = (char *) alloca(sizeof(char) * Len);
         char *name = (char *) alloca(sizeof(char) * Len);
         char *host = (char *) alloca(sizeof(char) * Len);
         char *ircname = (char *) alloca(sizeof(char) * Len);
         char *nick = (char *) alloca(sizeof(char) * Len);
         char hop[4];

         if (sscanf(Msg, "%*s %*s %*s %s %s %s %*s %s %s :%s %[^\n]\n",
                    chan, name, host, nick, mode, hop, ircname) < 7)
         {
           check_numeric(numeric, Win, Msg);
           break;
         }
/**(ircname + strlen(ircname) ) = '\0';*/
         win = getwinbycmd(Win->server, "WHO_UPDATE", chan, 0);
         if (win)
         {
           Channel *p = get_chan_byname(win, chan);

           if (p)
           {
             User /**v=p->userStart,*/  * u;
             u = my_malloc(sizeof(User));
             u->nick = strdup(nick);
             u->address = (char *) malloc(sizeof(char) * Len);
             u->ircname = (char *) malloc(sizeof(char) * strlen(ircname));

             sprintf(u->address, "%s@%s", name, host);
             u->mode = strdup(mode);
             u->ircname = strdup(ircname);
             if (new_addto_chanusers(win, p->name, u))
               getwinbycmd(win->server, "WHO_UPDATE", p->name, 1);
             free(u->nick);
             free(u->address);
             free(u->ircname);
             free(u->mode);
             free(u);
           }
           break;
         }
         else
           win = X == 1 ? Win : getwinbycmd(Win->server, "WHO", chan, 0);
         if (!check_numeric(numeric, win?win:Win, Msg))
         {
           if (win)
           {
             if (gflags & SHOW_RAW_MSG)
               isay0("NUMERIC", Msg, win - winstruct, 1);
             else
             {
               isay2("NUMERIC", 1, win - winstruct, 1,
                     "@f%s%-*.*s %-10s %-4s %s@%s (%s) %s ", num,
                     MaxChanLen + 2, MaxChanLen,
                     *chan == '*' ? "(private)" : chan, nick, mode, name,
                     host, ircname, hop);
             }
           }
           else if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, W, 1);
           else
             isay2("NUMERIC", 1, W, 1,
                   "%s%s> %-*.*s %-10s %-4s %s@%s (%s) %s ", num, sender,
                   MaxChanLen + 2, MaxChanLen,
                   *chan == '*' ? "(private)" : chan, nick, mode, name, host,
                   ircname, hop);
         }
       }
       break;
     case RPL_ENDOFWHO:        /*315 */
       {
#if 1
         if (sscanf(Msg, "%*s %*s %*s %s", buf) == 1)
         {
           Winstruct *win;

           getwinbycmd(Win->server, "WHO", buf, 1);
           win = getwinbycmd(Win->server, "WHO_UPDATE", buf, 1);
           if (win)
             load_userlist(win, buf, 1);
         }
         check_numeric(numeric, Win, Msg);
#endif
         break;
       }

     case RPL_NAMREPLY:
       {                        /* 353 */
         static void p_namereply(int numeric, const char *msg);

         p_namereply(numeric, Msg);
         break;
       }
     case RPL_BANLIST:
       if (!check_numeric(numeric, Win, Msg))
       {                        /* 367 */
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
         {
           long t = 0;
           char *by = (char *) alloca(sizeof(char) * Len);
           char *channel = (char *) alloca(sizeof(char) * Len);
           char *who = (char *) alloca(sizeof(char) * Len);
           int i;

           i = sscanf(Msg, "%*s %*s %*s %s %s %s %ld", channel, who, by, &t);
           if (i < 2)
             break;
           strcpy(buf, "");
           if (i > 3)
             sscanf(ctime(&t), "%[^\n]\n", buf);
           else
             *buf = '\0';
           if (i < 3)
             *by = '\0';
           /*strcpy(by, ""); */

           if (X == 1)
             isay2("NUMERIC", 1, W, 1, "@f%s%s\t%s\tby %s (%s)", num, channel,
                   who, by, buf);
           else
             isay2("NUMERIC", 1, W, 1, "@f%s%s> %s %s by %s (%s)", num,
                   sender, channel, who, by, buf);
         }
       }
       break;

     case RPL_YOUREOPER:       /* 381 */
       addmode(&Win->server->mode, 'o');
       update_server_stuff(Win->server->fd);
       if (!check_numeric(numeric, Win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else if (sscanf(Msg, "%*s %*s %*s %[^\n]\n", buf) > 0)
           isay2("NUMERIC", 1, W, 1, "%s%s %s", num, sender, buf);

       }
       break;

     case ERR_NOSUCHNICK:      /* 401 */
       {
         extern void remove_dcc_by_id(int);
         DCC *q = dccStart;
         char *nick = (char *) alloca(sizeof(char) * Len);

         if (sscanf(Msg, "%*s %*s %*s %s %[^\n]\n", nick, buf) < 2)
           break;
         while (q != dccEnd)
         {
           if ((q->type & (DCC_SENT & ~DCC_ACTIVE)) &&
               !strcasecmp(q->nick, nick))
           {
             remove_dcc_by_id(q->id);
           }
           if (q != dccEnd)
             q = q->next;
         }
         if (check_numeric(numeric, Win, Msg))
           break;
         if (X == 1)
           isay2("NUMERIC", 1, Win - winstruct, 1, "%s%s> %s%s", num, sender,
                 nick, buf);
         else
           isay2("NUMERIC", 1, W, 1, "%s%s> %s%s", num, sender, nick, buf);
         if (gflags & BEEP_SERVER_ERR)
           spx_bell(0);
       }
       break;

     case ERR_NOTREGISTERED:   /* 451 */
       {
         ClearLag(Win->server);
         if (!check_numeric(numeric, Win, Msg))
         {                      /* register again */
           char line[256];

           sprintf(line, "NICK %s\n", Win->server->nick);
           sendto_server(Win, line);
           if (Win->server->password)
           {
             sprintf(line, "PASS %s\n", Win->server->password);
             sendto_server(Win, line);
           }
           if (Win->server->email)
           {
             char *name = strxstr(Win->server->email, "@");
             char *hhost = strchr(Win->server->email, '@');

             sprintf(line, "USER %s %s %s :%s\n", name ? name : Name,
                     (hhost && *(++hhost)) ? hhost : host,
                     Win->server->name, Win->server->ircname ?
                     Win->server->ircname : sula_NAME " " sula_VERSION);
             if (name)
               free(name);
           }
           else
             sprintf(line, "USER %s %s %s :%s\n", Name, host,
                     Win->server->name,
                     Win->server->ircname ? Win->
                     server->ircname : sula_NAME " " sula_VERSION);
           sendto_server(Win, line);
#if USE_XFORMS
           fl_activate_object(Win->chanwin->lag);
#else
           gtk_signal_emit_by_name(GTK_OBJECT(Win->chanwin->lag_button),
                                   "clicked");
#endif
           break;
         }
         else
         {
           say("@C1Warning: ERR_NOTREGISTERED preempted", W, 0);
           spx_bell(100);
         }
       }
     case ERR_ALREADYREGISTRED:	/* 462 */
       check_numeric(numeric, Win, Msg);
       break;
     case ERR_CANNOTSENDTOCHAN:	/* 404 */
     case ERR_CHANOPRIVSNEEDED:	/* 482 */
     case ERR_KEYSET:          /* 467 */
       {
         short to;
         Winstruct *win;

         sscanf(Msg, "%*s %*s %*s %s", buf);
         win = get_win_bychanname(Win->server->fd, buf);
         if (gflags & BEEP_SERVER_ERR)
           spx_bell(0);
         to = win == NULL ? W : win - winstruct;
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, to, 1);
         else
           isay2("NUMERIC", 1, W, 1, "%s%s> %s", num, sender,
                 Msg + find_pos(Msg, 3));
         break;
       }
#if 0
     case ERR_NOSUCHSERVER:    /* 402 */
     case ERR_NOSUCHCHANNEL:   /* 403 */
       /* above-- case ERR_CANNOTSENDTOCHAN: 404 */
     case ERR_TOOMANYCHANNELS: /* 405 */
     case ERR_WASNOSUCHNICK:   /* 406 */
     case ERR_TOOMANYTARGETS:  /* 407 */
     case ERR_NOSUCHSERVICE:   /* 408 */
     case ERR_NOORIGIN:        /* 409 */
     case ERR_NORECIPIENT:     /* 411 */
     case ERR_NOTEXTTOSEND:    /* 412 */
     case ERR_NOTOPLEVEL:      /* 413 */
     case ERR_WILDTOPLEVEL:    /* 414 */
     case ERR_UNKNOWNCOMMAND:  /* 421 */
     case ERR_NOMOTD:          /* 422 */
     case ERR_NOADMININFO:     /* 423 */
     case ERR_FILEERROR:       /* 424 */
     case ERR_NICKTOOFAST:     /* 438 *//* Undernet extension */
     case ERR_TARGETTOOFAST:   /* 439 *//* Undernet extension */
     case ERR_USERNOTINCHANNEL:	/* 441 */
     case ERR_NOTONCHANNEL:    /* 442 */
     case ERR_USERONCHANNEL:   /* 443 */
     case ERR_NOLOGIN:         /* 444 */
     case ERR_SUMMONDISABLED:  /* 445 */
     case ERR_USERSDISABLED:   /* 446 */

     case ERR_NONICKNAMEGIVEN: /* 431 */
     case ERR_SERVICENAMEINUSE:	/* 434 */
     case ERR_SERVICECONFUSED: /* 435 */

     case ERR_NEEDMOREPARAMS:  /* 461 */

     case ERR_NOPERMFORHOST:   /* 463 */
     case ERR_PASSWDMISMATCH:  /* 464 */
     case ERR_YOUREBANNEDCREEP:	/* 465 */
     case ERR_YOUWILLBEBANNED: /* 466 */
/* above-- case ERR_KEYSET:                                                                                                                                                                       *//* 467 */
     case ERR_BADCHANMASK:     /* 476 */

/* continued further below */

     case ERR_NOPRIVILEGES:    /* 481 */
/* above--case ERR_CHANOPRIVSNEEDED:                                                          *//* 482 */
     case ERR_CANTKILLSERVER:  /* 483 */
     case 484:                 /* Your connectionis restricted */
     case ERR_NOOPERHOST:      /* 491 */
     case ERR_NOSERVICEHOST:   /* 492 */

     case ERR_UMODEUNKNOWNFLAG:	/* 501 */
     case ERR_USERSDONTMATCH:  /* 502 */
     case ERR_BADPING:         /* 513 *//* Undernet extension */
       if (!check_numeric(numeric, Win, Msg))
       {
         if (sscanf(Msg, "%*s %*s %*s %[^\n]\n", buf) < 1)
           break;
         if (gflags & BEEP_SERVER_ERR)
           spx_bell(0);
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
           isay2("NUMERIC", 1, W, 1, "%s%s> %s", num, sender, buf);

       }
       break;
#endif
     case ERR_CHANNELISFULL:   /* 471 */
     case ERR_INVITEONLYCHAN:  /* 473 */
     case ERR_BANNEDFROMCHAN:  /* 474 */
     case ERR_BADCHANNELKEY:   /* 475 */
       {
         Winstruct *win;

         sscanf(Msg, "%*s %*s %*s %s", buf);
         win = getwinbycmd(Win->server, "JOIN", buf, 1);
         if (win == NULL)
           win = Win;
         if (!check_numeric(numeric, win, Msg))
         {
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, win - winstruct, 1);
           else
             isay2("NUMERIC", 1, win - winstruct, 1, "%s%s", num, Msg + find_pos(Msg, 3));
         }
       }
       break;

     case ERR_ERRONEUSNICKNAME:	/* 432 */
     case ERR_NICKNAMEINUSE:   /* 433 */
/*ERR_BANNICKCHANGE 437: *//* Undernet extension */
     case 437:                 /* Nick is temporarily unavailable */
       {
         char *line, *ptr = NULL;
         char *nick = nextword(Msg, 3);

         if (Win->server->connecting)
         {
           NickList *nl;

           assert(Win->server->iNick >= 0);
           nl = &aNickList[Win->server->iNick];
           if (nl->start != nl->start->left)
           {                    /* list not empty */
             Nicks *n;

             if (nl->start->left == nl->start->right)
             {                  /*just 1 nick entry */
               ptr = nl->current->nick;
               goto cont;
             }
             if (debug)
               fprintf(stderr, "_curent:%s ", nl->current->nick);
             n =
                strcasecmp(nick,
                           nl->current->nick) ? nl->current : nl->
                current->left;
             if (n == nl->start)
               n = n->left;
             ptr = n->nick;
             nl->current = nl->current->left;
             if (nl->current == nl->start)
               nl->current = nl->current->left;
             if (debug)
               fprintf(stderr, "now curent:%s\n", nl->current->nick);
             line = malloc(sizeof(char) * (strlen(ptr) + 12));

             sprintf(line, "NICK %s\n", ptr);
           }
           else
           {
           cont:
             if (!ptr)
               ptr = nick + 1;
             line = malloc(sizeof(char) * (2 * strlen(ptr) + 40));

             srandom(time(NULL));
             sprintf(line, "NICK _%s%d%s\n", ptr, random() % 1000, ptr);
             /* Note: '_' comes first, just in case nick is truncated */
           }
           if (Win->server->fd > 0)
             writen(Win->server->fd, line, strlen(line));
           if (Win->server->connecting)
           {
             Win->server->connecting = 1;
             gettimeofday(&Win->server->t, NULL);
             send_lag_junk(Win->server, 1, 0);
           }
           if (gflags & VERBOSE_CLIENT)
             isay2("NUMERIC", 1, W, -1, "nick %s taken;new %s\n", nick, line);
           free(line);
           free(nick);
         }                      /* Win->server->connecting */
         if (!check_numeric(numeric, Win, Msg) && !Win->server->connecting)
         {
           if (gflags & BEEP_SERVER_ERR)
             spx_bell(0);
           if (gflags & SHOW_RAW_MSG)
             isay0("NUMERIC", Msg, W, 1);
           else if (sscanf(Msg, "%*s %*s %*s %[^\n]\n", buf) > 0)
             isay2("NUMERIC", 1, W, 1, "%s%s> %s", num, sender, buf);
         }
         break;
       }

     case ERR_UNKNOWNMODE:     /* 472 */
       {
         char c;

         if (check_numeric(numeric, Win, Msg))
           break;
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else
         {
           if (sscanf(Msg, "%*s %*s %*s %s", &c) < 1)
             break;
           isay2("NUMERIC", 1, W, 1, "%s%s> %c is an unknown mode character",
                 num, sender, c);
         }
       }
       break;
     default:
#if 0
     
     case RPL_WHOISCHANOP:

     case RPL_REHASHING:       /* 382 */
     case RPL_YOURESERVICE:    /* 383 */
     case RPL_MYPORTIS:        /* 384 */
     case RPL_NOTOPERANYMORE:  /* 385 */

     case RPL_NONE:            /* 300 *//* what's this numeric?- fotang */
     case RPL_TEXT:            /* 304 */
     case RPL_ENDOFBANLIST:    /* 368 */
     case RPL_INFOSTART:       /*373 */
     case RPL_ENDOFINFO:       /*374 */
     case ERR_NICKCOLLISION:   /* 436 */
     case RPL_SUMMONING:       /* 342 */
     case RPL_SILELIST:        /* 271 Undernet extension */
     case RPL_ENDOFSILELIST:   /* 272 Undernet extension */
     case RPL_KILLDONE:        /* 361 */
     case RPL_CLOSING:         /* 362 */
     case RPL_CLOSEEND:        /* 363 */
     case RPL_LINKS:           /* 364 */
     case RPL_ENDOFLINKS:      /* 365 */
     case RPL_TIME:            /* 391 */
     case RPL_USERSSTART:      /* 392 */
     case RPL_USERS:           /* 393 */
     case RPL_ENDOFUSERS:      /* 394 */
     case RPL_NOUSERS:         /* 395 */

     case RPL_TRACELINK:       /* 200 */
     case RPL_TRACECONNECTING: /* 201 */
     case RPL_TRACEHANDSHAKE:  /*E 202 */
     case RPL_TRACEUNKNOWN:    /* 203 */
     case RPL_TRACEOPERATOR:   /* 204 */
     case RPL_TRACEUSER:       /* 205 */
     case RPL_TRACESERVER:     /* 206 */
     case RPL_TRACESERVICE:    /* 207 */
     case RPL_TRACENEWTYPE:    /* 208 */
     case RPL_TRACECLASS:      /* 209 */

     case RPL_STATSLINKINFO:   /* 211 */
     case RPL_STATSCOMMANDS:   /* 212 */
     case RPL_STATSCLINE:      /* 213 */
     case RPL_STATSNLINE:      /* 214 */
     case RPL_STATSILINE:      /* 215 */
     case RPL_STATSKLINE:      /* 216 */
     case RPL_STATSQLINE:      /* 217 */
     case RPL_STATSYLINE:      /* 218 */
     case RPL_ENDOFSTATS:      /* 219 */

     case RPL_SERVICEINFO:     /* 231 */
     case RPL_ENDOFSERVICES:   /* 232 */
     case RPL_SERVICE:         /* 233 */
     case RPL_SERVLIST:        /* 234 */
     case RPL_SERVLISTEND:     /* 235 */

     case RPL_STATSLLINE:      /* 241 */
     case RPL_STATSUPTIME:     /* 242 */
     case RPL_STATSOLINE:      /* 243 */
     case RPL_STATSHLINE:      /* 244 */
     case RPL_STATSSLINE:      /* 245 */

     case RPL_STATSDEBUG:      /* 249 */
     case RPL_TRACELOG:        /* 261 */
     case 250:
     case 265:
     case 266:
     case RPL_LUSERCLIENT:     /*251 */
     case RPL_LUSERME:         /*255 */
#endif
       if (!check_numeric(numeric, Win, Msg))
       {
         if (gflags & SHOW_RAW_MSG)
           isay0("NUMERIC", Msg, W, 1);
         else if (sscanf(Msg, "%*s %*s %*s %[^\n]\n", buf) > 0)
           isay2("NUMERIC", 1, W, 1, "%s%s", num,
                 *buf == ':' ? buf + 1 : buf);
       }
       break;
  }                             /* switch */
  free(buf);
  free(sender);
}                               /* end of function ! */
/*-----------------------------------------------*/

static void cmds_oncon(void)
{
  CmdOnCon *p = cmdonconStart;

  while (p != cmdonconEnd)
    if ((!p->server && (p->port == Win->server->port || p->port < 1)) ||
        (!strcasecmp(p->server, Win->server->name) &&
         (p->port == Win->server->port || p->port < 1)))
    {
      CmdOnCon *q = p->next;

      if (p->type == SERV_CMD)
        sendto_server(Win, p->cmd);
      else
        process_cmd(p->cmd, Win);
      free(p->cmd);
      free(p->server);
      if (q == cmdonconEnd)
        cmdonconEnd = p;
      else
        *p = *q;
      free(q);
    }
    else
      p = p->next;
  return;
}

static void TryOldChannels(void)
{
/* attempt to rejoin the channels u were on b4 server connection was lost/closed *

 * -only if server closed down the connection on you- */

  Channel *current;
  WinList *p;

  build_winlistbyfd(Win->server->fd);
  p = servWin;
  while (p)
  {
    char *buf;
    Winstruct *win = winstruct + p->w;

    current = win->chanStart->right;
    while (current != win->chanStart)
    {
      buf = alloca(sizeof(char) * (strlen(current->name) +
                                   (current->key ? strlen(current->key) : 0) +

                                   16));

      sprintf(buf, "JOIN %s %s\n",
              current->name, current->key ? current->key : "");
      if (sendto_server(win, buf))
        break;
      else
        addto_cmd_sent(win, "JOIN", current->name);
      current = current->right;
    }
    ClearWinChanList(win);
    p = p->next;
  }                             /* while(p!=nULL */

}
static void p_namereply(int numeric, const char *msg)
{                               /* 353 */
  Winstruct *win = NULL;
  char *sender = NULL, *chan = NULL, *firstnick, *dummy = NULL, *others;
  char *blah = NULL;

  chan = nextword(msg, 4);
  if (!*chan)
    return;
  sender = nextword(msg, 0);
  dummy = nextword(msg, 3);
  if (*dummy == '*' || *chan == '*')	/*certainly a reply to NAMES cmd */
    goto do_names;
  blah = nextword(msg, 5);
  firstnick = blah;
  if (*firstnick == 0)
    goto xxit;
  if (*++firstnick == '@' && !strcmp(Win->server->nick, ++firstnick))
  {
    char *mm = nextword(msg, 6);

    if (!*mm)
    {
      Channel *p = get_chan_byname(Win, chan);

      if (p)
      {                         /* channel is on Win *//* just created channel */
        p->modes = strdup("o");
        update_server_stuff(Win->server->fd);
      }
    }
    free(mm);
  }
  if (check_numeric(353, Win, Msg))
  {
    getwinbycmd(Win->server, "NAMES", NULL, 1);
    goto xxit;
  }
do_names:
  others = (char *) malloc(sizeof(char) * strlen(msg));

  sscanf(msg, "%*[^:]:%[^\n]\n", others);

#if 0
  /*doesnt always work! but dont remove */
  win = getwinbycmd(Win->server, "NAMES", chan, 0);	/* names #test */
  if (!win)
#endif
    win = getwinbycmd(Win->server, "NAMES", NULL, 1);	/* names */
  if (!win)
  {
    win = get_win_bychanname(Win->server->fd, chan);	/* just joined chnannel */
    if (win)
    {
      Channel *p = get_chan_byname(win, chan);

      assert(p);
      if (strcmp(p->name, chan))
      {
        strcpy(p->name, chan);
#if USE_XFORMS
        if (win->chanwin->chanusers->u_vdata)
        {
          FD_chanusers *f = (FD_chanusers *) win->chanwin->chanusers->u_vdata;
          int total = fl_get_choice_maxitems(f->channel);
          register int i;

          for (i = 1; i <= total; i++)
            if (!strcasecmp(p->name, fl_get_choice_item_text(f->channel, i)))
            {
              fl_replace_choice(f->channel, i, chan);
              break;
            }
        }
#endif
        if (p == win->chanCur)
          UpdateStatus(win);
      }
    }
  }
  if (!check_numeric(numeric, win ? win : Win, Msg))
  {
    if (win)
    {
      sprintf(buf, "%sUsers on %s: %s", num,
              *dummy == '*' ? "(Private)" : chan, others);
      isay("NUMERIC", buf, win - winstruct, 1);
    }
    else
      isay2("NUMERIC", 1, W, 1, "%s%s> Users on %s: %s", num, sender,
            *dummy == '*' ? "(Private)" : chan, others);
  }

  free(others);
xxit:
  {
    free(blah);
    free(dummy);
    free(sender);
    free(chan);
    return;
  }
}
static Winstruct *get_whois_win(char whowas)
{
  Winstruct *win = Win;

  if (X > 1)
  {
    char *a = nextword(Msg, 3);

    win = getwinbycmd(Win->server, "WHOIS", a, 0);
    if (!win && whowas)
      win = getwinbycmd(Win->server, "WHOWAS", a, 0);
    free(a);
  }
  return win;
}
