/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* parser.c     -parse server output.
 * distributed as part of sula - an irc client for X
 * 
 * (c) 1997, 1998 Tano Fotang
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License , or (at your option) 
 * any later version.
 * 
 * see the file COPYING for further information.
 * 
 */
#include "spx.h"
#include <time.h>
#include <stdarg.h>
#include "parser.h"
#include "mode.h"
#include "user.h"
#include "setting.h"
#include "ignore.h"
#include "cmd.h"
#include "nc.h"
#include "hooks.h"
#include "server.h"
Winstruct *Win;                 /* parser window */
int X, Len;                     /* X=Win count */
char *Msg;

#if MUTABLE_IRC
char *Msg2 = NULL;
#endif
short W;
extern User *find_chanuser(Channel *ch,const char *nick);
typedef struct TparsWinList
{
  char *channame;
  short w;
  struct TparsWinList *next;
}
parsWinList;
static parsWinList *parsWin = NULL;

void IRC_say(const char *type, const char *line, int w, int flag,
             int do_format)
{
  if (!check_msg_hook(IRC_LINE_OUT, w, "%s,%d %s %s %d",
                      winstruct[w].server->name,
                      winstruct[w].server->port, type, line, flag))
    _say(line, w, flag, do_format);
}

void isay2(const char *type, int format_it, int to, int where,
           const char *fmt, ...)
{
  char *buf;
  int count = 256;
  va_list ap;

  va_start(ap, fmt);
  buf = (char *) malloc(sizeof(char) * count);

  while (buf != NULL)
    if (vsnprintf(buf, count, fmt, ap) == -1)
    {
      count *= 2;
      buf = (char *) realloc(buf, count);
    }
    else
      break;
  va_end(ap);
  if (buf)
  {
    IRC_say(type, buf, to, where, format_it);
    free(buf);
  }
}

#define free_win_list() do{\
  parsWinList *_p_;\
  while (parsWin) \
  {\
    _p_ = parsWin;  \
    parsWin = parsWin->next;\
    free(_p_->channame);\
    free(_p_);\
  }\
}while(0)

#define winlist_add(_w, _channame) do{\
  parsWinList *_p_ = parsWin;\
  parsWin = my_malloc(sizeof(parsWinList));\
  parsWin->w = _w;\
  parsWin->channame = strdup(_channame);\
  parsWin->next = _p_;\
}while(0)

static void build_winlist_byuser(int fd, const char *sender)
{
/* locate windows and channels this server with  channels for which
user is also a member */
  int i;

  free_win_list();
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin && winstruct[i].server &&
        winstruct[i].server->fd == fd)
    {
      Channel *current = winstruct[i].chanStart->right;

      while (current != winstruct[i].chanStart)
      {
        if (find_chanuser(current, sender))
          winlist_add(i, current->name);
        current = current->right;
      }
    }
}

extern Winstruct *get_win_bychanname(int fd, const char *channame)
{

  register int i;

  if (fd < 0)
    return NULL;
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin && winstruct[i].server &&
        winstruct[i].server->fd == fd)
    {
      Channel *current = winstruct[i].chanStart->left;

      while (current != winstruct[i].chanStart)
      {
        if (!strcasecmp(channame, current->name))
          return &winstruct[i];
        else
          current = current->left;
      }
    }
  return NULL;
}

extern Winstruct *getwinbycmd(Server * s, const char *cmd,
                              const char *args, int remove)
{
  CmdSent *p = cmdsentStart;

  while (p != cmdsentEnd)
    if (winstruct[p->w].server && winstruct[p->w].server == s &&
        !strcasecmp(p->cmd, cmd) && (!args || !strcasecmp(p->arg, args)))
      break;
    else
    {
      p = p->next;
    }
  if (p == cmdsentEnd)
    return NULL;
  else
  {
    Winstruct *ww;

    ww = winstruct + p->w;
    if (remove)
    {
      unsigned long w = (unsigned long) (winstruct + p->w);
      CmdSent *q = p->next;

      free(p->cmd);
      free(p->arg);
      if (q == cmdsentEnd)
        cmdsentEnd = p;
      else
      {
        *p = *q;
        free(q);
      }
      ww = ((Winstruct *) w);
    }
    return ww->chanwin ? ww : NULL;
  }
}
#if 0
extern User *get_user_byuser(const Channel * chan, const char *sender)
{
/* search channel for user named sender (nick) */
#warning slow on large channels. Use hash table.
  if (sender && chan)
  {                             //this is okay

    User *p = chan->userStart;

    chan->userEnd->name = (char *) sender;
    while (strcasecmp(p->name, sender))
      p = p->next;
    if (p != chan->userEnd)
      return p;
  }
  return NULL;
}
#endif
void prepare_server_output(int fd, const char *inp)
{
/*
   inp will be copied once in here. TODO: find a way to avoid copying.
 */
  static void parse_server_output(int);
  register char *ptr;
  char *buf;
  int i;
  static char *prev = 0;        /* sometimes we read a truncated line. We

                                   keep it and wait for the rest. This will only work if our next
                                   read is from an IRC server and does not begin with ':'.
                                   In that case, we append inp to prev and make a copy in 'line', setting
                                   copy_input to true so that the copy will be freed in the end. */
  char *line, copy_input = 0;

  Win = search_winlistbyfd(fd, &X);
  assert(Win);
  W = Win->server->w;
  i = strlen(inp);
  Win->server->read += i;

  if (prev)
  {
    if (*inp != ':')
    {
      i += strlen(prev) + 1;
      line = malloc(i * sizeof(char));

      sprintf(line, "%s%s", prev, inp);
      copy_input = 1;
    }
    else
      line = (char *) inp;
    free(prev);
    prev = 0;
  }
  else
    line = (char *) inp;
  ptr = (char *) line;
  buf = my_malloc(sizeof(char) * (i + 3));

  while (*ptr)
  {
    *buf = 0;
    Msg = buf;
    while (*ptr && *ptr != '\n')
      *Msg++ = *ptr++;

    if (*ptr == 0)
      prev = strdup(line);
    else
    {
      if (*buf && *(Msg - 1) == '\r')
        Msg--;
      *Msg = '\0';
      Len = Msg - buf;
      Msg = buf;
      if (*Msg == ':')
      {
        Msg++;
        Len--;
      }
      if (*Msg)
        parse_server_output(fd);	/* Len and Msg may be modifed after this! */
      i = ++ptr - (char *) line;
      strshift((char *) line, i);
      ptr = (char *) line;
    }
  }
  free(buf);
  if (copy_input)
    free(line);
}

static void p_msg(void);
static void p_notice(void);
static void p_wallops(void);
static void p_pong(void);
static void p_ping(void);
static void p_error(void);
static void p_junk(void);
#if DO_SILENCE
static void p_silence(void);
#endif
/* only needed if >1 window connected to server */
#define NICK_ 0
#define CHAN_ 1
#define JOIN_ 2
#define QUIT_ 3
#define NONE_ 4

typedef struct
{
  char junk;
  char *name;
  void (*func) (void);
}
server_cmd;
static server_cmd serv_cmd[] = {
  /* keeep sorted by name: binary search! */
  {NONE_, "INVITE", p_invite},
  {JOIN_, "JOIN", p_join},
  {CHAN_, "KICK", p_kick},
  {CHAN_, "MODE", p_mode},
  {NICK_, "NICK", p_nick},
  {NONE_, "NOTE", p_note},
  {CHAN_, "NOTICE", p_notice},
  {CHAN_, "PART", p_part},
  {NONE_, "PONG", p_pong},
  {CHAN_, "PRIVMSG", p_msg},
  {QUIT_, "QUIT", p_quit},
  #if DO_SILENCE
  {NONE_, "SILENCE", p_silence},
  #endif
  {CHAN_, "TOPIC", p_topic},
  {NONE_, "WALLOPS", p_wallops}
};

static int cur_cmd, cur_numeric;
static void parse_server_output(int fd)
{
  static int binary(server_cmd *, const char *var, int n);

  cur_cmd = cur_numeric = -1;   //assignemt is actually redundant
  if (X == 1)
    goto start_parsing;
  else
  {
    Winstruct *win = NULL;
    char command[64];

    if (sscanf(Msg, "%*s %s", command) < 1)
      return;
    if ((cur_numeric = atoi(command)) > 0)
      goto start_parsing;
    else
    {
      char what;

      //server_cmd *p = serv_cmd;
      cur_cmd =
         binary(serv_cmd, command, sizeof(serv_cmd) / sizeof(server_cmd));
      if (cur_cmd < 0)
        goto start_parsing;
      switch ((what = serv_cmd[cur_cmd].junk))
      {
         case CHAN_:
           {
             char *channel = (char *) alloca(sizeof(char) * Len);

             if (sscanf(Msg, "%*s %*s %s", channel) < 1)
               return;
             if (*channel == '#' || *channel == '&')
               win = get_win_bychanname(fd, channel);
             if (win)
               Win = win;
             break;
           }
         case JOIN_:
           {
             char *channel = (char *) alloca(sizeof(char) * Len);
             char *nick = (char *) alloca(sizeof(char) * Len);

             if (sscanf(Msg, "%[^!]!%*s JOIN :%[^\n]\n", nick, channel) < 2)
             {
               //fprintf(stderr, "error %s\n", Msg);
               return;
             }
             UNESCAPE(channel);
             if (!strcasecmp(nick, Win->server->nick))
               win = getwinbycmd(Win->server, "JOIN", channel, 1);
             else
               win = get_win_bychanname(fd, channel);
             if (win)
               Win = win;
             break;
           }
         case NICK_:
         case QUIT_:

           {

             char *nick = NULL, *new_nick = NULL;
             char *sender = (char *) alloca(sizeof(char) * Len);
             parsWinList *p;
             char *buf = NULL;
             char *tmp;

             if (sscanf(Msg, "%s", sender) < 1)
               return;
             tmp = sender;
             nick = (char *) alloca(sizeof(char) * strlen(sender));

             if (sscanf(tmp, "%[^!]!%*s", nick) < 1)
               return;
             if (!strcasecmp(nick, Win->server->nick))
               goto start_parsing;
             if (what == NICK_)
             {
               new_nick = (char *) alloca(sizeof(char) * Len);

               if (sscanf(Msg, "%*s %*s :%[^\n]\n)", new_nick) < 1)
               {
                 return;
               }
               buf = (char *) alloca(sizeof(char) * (strlen(nick) +
                                                     strlen(new_nick) + 32));

               sprintf(buf, "%s is now known as %s", nick, new_nick);
             }
             else
             {
               char *reason = (char *) malloc(sizeof(char) * Len);

               if (sscanf(Msg, "%*s %*s :%[^\n]\n", reason) < 1)
                 *reason = 0;
               buf = (char *) alloca(sizeof(char) * (strlen(nick) +
                                                     strlen(reason) + 32));

               sprintf(buf, "%s has signed off (%s)", nick, reason);
               free(reason);
             }
             build_winlist_byuser(fd, nick);
             if (!parsWin)
               return;
             Win = winstruct + parsWin->w;
             p = parsWin->next;
             while (p)
             {
               if (what == QUIT_)
                 RemoveFromChanUsers(winstruct + p->w, p->channame, nick);
               else
                 RenameChanUser(winstruct + p->w, p->channame, nick,
                                new_nick);
               isay0(what == NICK_ ? "MISC" : "QUIT", buf, p->w, 1);
               p = p->next;
             }
             break;
           }
         default:
           break;
      }                         /*switch */
    }                           /* else */
  }
start_parsing:
  if (*Msg == 'P' && *(Msg + 1) == 'I' && *(Msg + 2) == 'N' &&
      *(Msg + 3) == 'G' && *(Msg + 4) == ' ')
    p_ping();
  else if (!check_msg_hook(RAW_IRC, Win - winstruct, "%s,%d %s",
                           Win->server->name, Win->server->port, Msg))
  {
    if (X == 1)
    {
      char command[64];

      if (sscanf(Msg, "%*s %s", command) < 1)
        return;
      if ((cur_numeric = atoi(command)) < 1)
        cur_cmd = binary(serv_cmd, command,
                         sizeof(serv_cmd) / sizeof(server_cmd));
    }
    if (cur_numeric > 0)
    {
      if (!check_msg_hook(RAW_NUMERIC, W, "%s,%d %s",
                          Win->server->name, Win->server->port, Msg))
        p_numeric(cur_numeric);
    }
    else
    {
      int stop;

#if MUTABLE_IRC
      sflags |= s_DOING_IRC_HOOK;
#endif
      stop = check_msg_hook(RAW_NON_NUMERIC, Win - winstruct, "%s,%d %s",
                            Win->server->name, Win->server->port, Msg);
#if MUTABLE_IRC
      sflags &= ~s_DOING_IRC_HOOK;
      if (sflags & s_IRC_OUTPUT_MODIFIED)
      {
        sflags &= ~s_IRC_OUTPUT_MODIFIED;
        if (!Msg2)
          stop = 1;
        else
        {
          Msg = Msg2;
          Len = strlen(Msg);
        }
      }
#endif
      if (!stop)
      {
        if (cur_cmd > -1)
          (*serv_cmd[cur_cmd].func) ();
        else if (*Msg == 'E' && *(Msg + 1) == 'R' && *(Msg + 2) == 'R' &&
                 *(Msg + 3) == 'O' && *(Msg + 4) == 'R' && *(Msg + 5) == ' ')
          p_error();            // ERROR

        else if (*Msg == 'N' && *(Msg + 1) == 'O' && *(Msg + 2) == 'T' &&
                 *(Msg + 3) == 'I' && *(Msg + 4) == 'C' && *(Msg + 5) == 'E')	// NOTICE

          p_note();
        else
          p_junk();
      }
#if MUTABLE_IRC
      if (Msg2)
      {
        free(Msg2);
        Msg2 = NULL;
      }
#endif
    }
  }
}

static int binary(server_cmd * p, const char *var, int n)
{
  register int low, high, mid, cond;

  low = 0;
  high = n - 1;
  while (low <= high)
  {
    mid = (low + high) / 2;
    if ((cond = strcmp(var, (p + mid)->name)) < 0)
      high = mid - 1;
    else if (cond > 0)
      low = mid + 1;
    else
      return mid;
  }
  return -1;
}

static void p_msg(void)
{
  p_privmsg(ISNOTICE + 1);
}
static void p_notice(void)
{
  p_privmsg(ISNOTICE);
}

/****************************************************************
* 
* w a l l o p s                                        
*
****************************************************************/

/* what's that????????? */
static void p_wallops(void)
{
  if (!check_msg_hook(WALLOPS, Win - winstruct, "%s,%d %s",
                      Win->server->name, Win->server->port, Msg))
    isay2("WALLOP", 0, W, 1, "[%s] %s", Win->server->alias, Msg);

}

/****************************************************************/
/* P I N G                                                      */
/****************************************************************/

static void p_ping(void)
{
  int len = find_pos(Msg, 1);

  if (len != Len)
  {
    char *buf = malloc(sizeof(char) * (Len + 12));

    if (*(Msg + len) == ':')
      len++;
    sprintf(buf, "PONG %s\n\n\n\n\n", Msg + len);
    writen(Win->server->fd, buf, Len - len + 8 /*== strlen(buf) :P */ );
    free(buf);
  }
  /* shouldnt these be commented out? */
  if (!check_msg_hook(RAW_IRC, Win - winstruct, "%s,%d %s",
                      Win->server->name,
                      Win->server->port,
                      Msg) &&
      check_msg_hook(RAW_NON_NUMERIC, Win - winstruct, "%s,%d %s",
                     Win->server->name, Win->server->port, Msg))
    check_msg_hook(PING, W, "%s,%d %s",
                   Win->server->alias, Win->server->port, Msg);
}

/*

 * P O N G                                              
 * 
 */

static void p_pong(void)
{

  if (check_msg_hook(PONG, Win - winstruct, "%s,%d %s",
                     Win->server->name, Win->server->port, Msg))
    return;
  else if (gflags & SHOW_RAW_MSG)
    isay0("MISC", Msg, W, 1);
  else
  {
    char *buf;
    char *serv = nextword(Msg, 0);
    char *from = nextword(Msg, 2);
    buf = (char *) malloc(sizeof(char) * (Len + 32));

    sprintf(buf, "%s: received PONG from %s", serv, from);
    isay0("MISC", buf, W, 1);
    free(buf);
    free(serv);
    free(from);
  }
}

/*

 * S I L E N C E  
 *
 */
#if DO_SILENCE
static void p_silence(void)
{
  if (check_msg_hook(SILENCE, Win - winstruct, "%s,%d %s",
                     Win->server->name, Win->server->port, Msg))
    return;
  else if (gflags & SHOW_RAW_MSG)
  {
    isay0("MISC", Msg, W, 1);
  }
  else
  {
    char *buf;
    char *silenced = alloca(sizeof(char) * Len);

    if (sscanf(Msg, "%*s %*s %s", silenced) < 1)
      return;
    buf = (char *) malloc(sizeof(char) * (Len + 24));

    sprintf(buf, "@i@.%s silencing %s",
            *silenced == '+' ? "Now" : "No longer", silenced + 1);
    isay2("MISC", 0, W, 1, "%s: %s", Win->server->alias, buf + 2);
    free(buf);
  }
}
#endif
/***************************************************************
 * 
 * E R R O R
 *
 ***************************************************************/

static void p_error(void)
{

  if (check_msg_hook(ERROR, Win - winstruct, "%s,%d %s",
                     Win->server->name, Win->server->port, Msg))
    return;
  else if (gflags & SHOW_RAW_MSG)
    isay0("MISC", Msg, W, 1);
  else
  {
    char *buf;
    buf = (char *) alloca(sizeof(char) * (Len));

    if ((sscanf(Msg, "ERROR :%[^\n]\n", buf) < 1))
      return;
    isay2("MISC", 0, W, 1, "%s says: %s", Win->server->alias, buf);
  }
}
/****************************************************************/
/*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              */
/* U N K N O W N = J U N K                                                                          */
/*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              */
/****************************************************************/
static void p_junk(void)
{
  if (check_msg_hook(JUNK, Win - winstruct, "%s,%d %s",
                     Win->server->name, Win->server->port, Msg))
    return;
  else if (gflags & SHOW_RAW_MSG)
    isay0("MISC", Msg, W, 1);
  else
    isay2("MISC", 0, W, 1, "(Unknown stuff from %s) %s",
          Win->server->alias, Msg);
}
/*-----------------------------------------------------------------------*/
#define BUF_SIZE 256
#define PAD 64
#define get_next(_buf, _p, _end, _len, _ptr) \
do {\
 char _done_=0;\
  while(!_done_){\
    while ((_p) < (_end) && *(_ptr)){*(_p)= *(_ptr); (_p)++;(_ptr)++;}\
    if ((_p) >= (_end))\
    {\
      int _here_ = (_p) - (_buf);\
      _len = _here_ + BUF_SIZE;\
      _buf = my_realloc((_buf), (_len) + PAD);\
      _p = (_buf) + _here_;\
      _end = (_buf) + (_len) - 1;\
    }else _done_=1;\
  }\
}while(0)

   typedef struct
  {
    char c;
    char flag;
#define fc_INT  (1 << 0)
#define fc_STR  (1 << 1)
#define fc_GOT  (1 << 2)
    union
    {
      int ival;
      char *sval;
    }
    val;
  } Tvar;
extern char *format_msg(char *fmt, ...)
{
  register char *p, *ptr;
  char *pp, stop = 0;           /* stop!=0: no more program supplied variables in the string */
  int oooch = 0;
  struct tm *tt = 0;
  va_list arg_ptr;

  char *buf2, *end;
  int buf2_size = 0;
#define hr	(1<<6)
#define day	(1<<7)
#define min	(1<<8)
#define secs	(1<<9)
#define month	(1<<10)
#define year	(1<<11)
  Tvar vars[] = {
    {'i', fc_INT, {0}},
    {'j', fc_INT, {0}},
    {'k', fc_INT, {0}},
    {'z', fc_INT, {0}},
    {'Z', fc_INT, {0}},
    {'n', fc_STR, {0}},
    {'c', fc_STR, {0}},
    {'p', fc_STR, {0}},
    {'f', fc_STR, {0}},
    {'l', fc_STR, {0}},
    {'h', fc_STR, {0}},
    {0, 0, {0}},
  };
  if (!fmt)
    return NULL;
  pp = my_malloc(sizeof(char) * (strlen(fmt_string) + strlen(fmt) + 1));

  sprintf(pp, "%s%s", fmt_string, fmt);
  fmt = pp;
  buf2 = (char *) my_malloc(sizeof(char) * (BUF_SIZE + PAD));

  buf2_size = BUF_SIZE;
  p = buf2;
  end = buf2 + buf2_size - 1;
  va_start(arg_ptr, fmt);
  while (*fmt)
  {
  retry:
    while (p < end && *fmt && !(!stop && *fmt == '$') && *fmt != '%')
      *p++ = *fmt++;
    if (p >= end)
    {
      int here = p - buf2;

      buf2_size = here + BUF_SIZE;
      buf2 = my_realloc(buf2, buf2_size + PAD);
      p = buf2 + here;
      end = buf2 + buf2_size - 1;
      goto retry;
    }
    /* if we already have buf2_size bytes we should now read atmost PAD-1 bytes
       otherwise buffer overflow occurs
     */
    if (*fmt == '$')
    {
      stop = 1;
      fmt++;
      continue;
    }
    if (*fmt == '%')
      switch (*++fmt)
      {
         case 'S':
           {
             static char u[3];

             if (tt == 0)

             {
               time_t t_t = time(NULL);

               tt = localtime(&t_t);
             }
             if (!(oooch & secs))
             {
               sprintf(u, "%02d", tt->tm_sec);
               oooch |= secs;
             }
             ptr = u;
             while (*ptr)
               *p++ = *ptr++;
           }
           fmt++;
           break;
         case 'M':
           {
             static char u[3];

             if (tt == 0)

             {
               time_t t_t = time(NULL);

               tt = localtime(&t_t);
             }

             if ((oooch & min) == 0)
             {
               sprintf(u, "%02d", tt->tm_min);
               oooch |= min;
             }
             ptr = u;
             while (*ptr)
               *p++ = *ptr++;
           }
           fmt++;
           break;
         case 'H':
           {
             static char u[3];

             if (tt == 0)

             {
               time_t t_t = time(NULL);

               tt = localtime(&t_t);
             }
             if ((oooch & hr) == 0)
             {
               sprintf(u, "%02d", tt->tm_hour);
               oooch |= hr;
             }
             ptr = u;
             while (*ptr)
               *p++ = *ptr++;
           }
           fmt++;
           break;
         case '/':
           *p++ = '\n';
           fmt++;
           break;
         case 't':
           *p++ = '\t';
           fmt++;
           break;
         case 'd':
           {
             static char u[3];

             if (tt == 0)

             {
               time_t t_t = time(NULL);

               tt = localtime(&t_t);
             }
             if ((oooch & day) == 0)
             {
               sprintf(u, "%02d", tt->tm_mday);
               oooch |= day;
             }
             ptr = u;
             while (*ptr)
               *p++ = *ptr++;
           }
           fmt++;
           break;
         case 'm':
           {
             static char u[3];

             if (tt == 0)

             {
               time_t t_t = time(NULL);

               tt = localtime(&t_t);
             }
             if ((oooch & month) == 0)
             {
               sprintf(u, "%02d", tt->tm_mon);
               oooch |= month;
             }
             ptr = u;
             while (*ptr)
               *p++ = *ptr++;
           }
           fmt++;
           break;
         case 'Y':
           {
             static char u[5];

             if (tt == 0)

             {
               time_t t_t = time(NULL);

               tt = localtime(&t_t);
             }
             if ((oooch & year) == 0)
             {
               snprintf(u, 4, "%4d", 1900 + tt->tm_year);
               u[4] = 0;
               oooch |= year;
             }
             ptr = u;
             while (*ptr)
               *p++ = *ptr++;
           }
           fmt++;
           break;
         case 'D':
           {                    /*Sun Sep 21 14:08:25 1997 */
             time_t t_t = time(NULL);

             ptr = (char *) ctime(&t_t);
             while (*ptr && *ptr != '\n')
               *p++ = *ptr++;
             fmt++;
             break;
           }

         default:
           {
             Tvar *v = &vars[0];

             for (; v->c; v++)
               if (v->c == *fmt)
                 break;
             if (v->c)
             {
               if (v->flag & fc_GOT)
               {
                 if (v->flag & fc_INT)
                 {
                   char u[11];

                   ptr = &u[0];
                   snprintf(u, 10, "%d", v->val.ival);
                   while (*ptr)
                     *p++ = *ptr++;
                 }
                 else
                 {
                   ptr = v->val.sval;
                   get_next(buf2, p, end, buf2_size, ptr);
                 }
               }
               else
               {
                 if (v->flag & fc_INT)
                 {
                   v->val.ival = va_arg(arg_ptr, int);

                   v->flag |= fc_GOT;
                 }
                 else if (!stop)
                 {
                   v->val.sval = va_arg(arg_ptr, char *);

                   v->flag |= fc_GOT;
                 }
               }
             }
           }
           fmt++;
           break;
         case '%':
           *p++ = *fmt++;
           break;               /* %% */
      }                         /* switch */
  }                             /*while */
  va_end(arg_ptr);
  *p = '\0';
  free(pp);
  tt = 0;
  return (*buf2 ? buf2 : NULL);
}
