/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
   fotang@yahoo.com, 4/1999 for Sula PrimeriX.
   set.c  - SET variables
   All variables are stored in the same tree.


   Copyright (C) 1997-1999 Tano Fotang

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free 
   Software Foundation; either version 2 of the License , or (at your option) 
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. See the file LICENCE for details.

   You should have received a copy of the GNU General Public License along
   with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "spx.h"
#include <limits.h>
#include "setting.h"
#include "cmd.h"
#include "dcc.h"

extern unsigned int uhost_timeout;
extern char *fmt_notify_signon,
    *fmt_notify_signoff;
extern int flood_max,
     flood_period;
extern size_t nc_read_bufsize;

typedef struct TSetVar
{
  char *name;
  u_char type;
#define SETV_BOOL	(1<<0)
#define	SETV_CHAR	(1<<1)
#define	SETV_INT	(1<<2)
#define SETV_STR	(1<<3)
#define SET_SCM         (1<<5)
//#define SET_BI         (1<<6)

  void *val;
  u_int flag;                   //for boolean vars

  union
  {
    void (*func) (int, void *); //win, new value

    int scm;
  }
  proc;
  struct TSetVar *left;
  struct TSetVar *right;
  short bf;
}
SetVar;
typedef SetVar *pSetVar;
static SetVar *setTree;
static void set_left_rotate(pSetVar * pp)
{
  pSetVar p = *pp,
       r;

  *pp = r = p->right;
  p->right = r->left;
  r->left = p;
  p->bf--;
  if (r->bf > 0)
    p->bf -= r->bf;
  r->bf--;
  if (p->bf < 0)
    r->bf += p->bf;
}

static void set_right_rotate(pSetVar * pp)
{
  pSetVar p = *pp,
       l;

  *pp = l = p->left;
  p->left = l->right;
  l->right = p;
  p->bf++;
  if (l->bf < 0)
    p->bf -= l->bf;
  l->bf++;
  if (p->bf > 0)
    l->bf += p->bf;
}
static SetVar *find_var(const char *name)
{
  SetVar *p = setTree;
  int c;

  LOWERCASE((char *) name);
  while (p)
  {
    c = strcmp(name, p->name);
    if (c == 0)
      return p;
    else if (c < 0)
      p = p->left;
    else
      p = p->right;
  }
  return NULL;
}
static int insert_var(pSetVar * pp, SetVar * c)
{
  int dH = 0;
  pSetVar p = *pp;

  if (p == NULL)
  {
    *pp = p = (pSetVar) my_malloc(sizeof(SetVar));
    memcpy((void *) p, c, sizeof(SetVar));
    p->bf = 0;
    p->left = p->right = NULL;
    dH = 1;
  }
  else
  {
    int tt = strcmp(c->name, p->name);

    if (tt > 0)
    {
      if (insert_var(&p->right, c))
      {
        p->bf++;
        if (p->bf == 1)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            set_right_rotate(&p->right);
          set_left_rotate(pp);
        }
      }
    }
    else if (tt < 0)
    {
      if (insert_var(&p->left, c))
      {
        p->bf--;
        if (p->bf == -1)
          dH = 1;
        else if (p->bf == -2)
        {
          if (p->left->bf == 1)
            set_left_rotate(&p->left);
          set_right_rotate(pp);
        }
      }
    }
    else                        //replace

    if ((p->type & SET_SCM))    //dont replace builtin variables

    {
      struct TSetVar *left = p->left;
      struct TSetVar *right = p->right;
      short bf = p->bf;

      free((p)->name);
      if (((p)->type & (~SET_SCM)) == SETV_STR)
        free(*((char **) (p)->val));
      if (!((p)->type & SETV_BOOL))
        free((p)->val);
#if _GUILE
      if (((p)->type & SET_SCM) && (p)->proc.scm != -1)
        remove_func((p)->proc.scm);
#endif
      memcpy((void *) p, c, sizeof(SetVar));
      p->right = right;
      p->left = left;
      p->bf = bf;
    }
  }
  return dH;
}

static void done_setting(short w, SetVar * svar);

#if _GUILE
#define delete_node(p) do{\
         free((p)->name);\
         if (((p)->type & (~SET_SCM)) == SETV_STR)\
           free(*((char **) (p)->val));\
         if(!((p)->type & SETV_BOOL)) free((p)->val);\
	 if(((p)->type & SET_SCM) && (p)->proc.scm!=-1)\
            remove_func((p)->proc.scm);\
         }while(0)
static int del_var(pSetVar * pp, SetVar * c)
{
  pSetVar p = *pp,
      *q;
  int dH = 0;
  int tt;

  if (!p)
    return 0;
  if ((tt = strcmp(c->name, p->name)) < 0)
  {
    if (del_var(&p->left, c))
    {
      p->bf++;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == 2)
      {
        if (p->right->bf == -1)
          set_right_rotate(&p->right);
        set_left_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else if ((tt > 0))
  {
    if (del_var(&p->right, c))
    {
      p->bf--;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == -2)
      {
        if (p->left->bf == 1)
          set_left_rotate(&p->left);
        set_right_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else
  {
    if ((p->type & SET_SCM) == 0)
      return dH;                //dont remove builtin vars

    if (p->right == NULL)
    {
      *pp = p->left;
      delete_node(p);
      free(p);
      p = NULL;
      return 1;
    }
    else if (p->left == NULL)
    {
      *pp = p->right;
      delete_node(p);
      free(p);
      p = NULL;
      return 1;
    }
    else
    {
      SetVar *foo = my_malloc(sizeof(SetVar));
      struct TSetVar *left,
          *right;

      memcpy((void *) foo, p, sizeof(SetVar));

      q = &p->left;
      while ((*q)->right != NULL)
        q = &(*q)->right;

      left = p->left;
      right = p->right;
      memcpy((void *) p, (*q), sizeof(SetVar));
      p->left = left;
      p->right = right;

      left = (*q)->left;
      right = (*q)->right;
      memcpy((void *) (*q), foo, sizeof(SetVar));
      (*q)->left = left;
      (*q)->right = right;

      if (del_var(&p->left, foo))
      {
        p->bf++;
        if (p->bf == 0)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            set_right_rotate(&p->right);
          set_left_rotate(pp);
          dH = 1;
        }
      }
      free(foo);
    }
  }
  return dH;
}

static u_int junk_val = 1;
extern SCM create_set_variable(SCM vartype, SCM varname, SCM preproc)
{
  int n;
  SetVar svar;

  svar.name = gh_scm2newstr(varname, &n);
  if (n > 0)                    //!find_var(svar.name))

  {
    char *type = gh_scm2newstr(vartype, &n);

    if (n == 0)
    {
      free(svar.name);
      return SCM_BOOL_F;
    }
    svar.type = SET_SCM;
    lowercase2(svar.name);
    if (!strcmp(type, "boolean"))
    {
      svar.flag = 0;
      svar.type |= SETV_BOOL;
      svar.val = &junk_val;
    }
    else if (!strcmp(type, "string"))
    {
      svar.type |= SETV_STR;
      svar.val = (char **) malloc(sizeof(char *));
      *(char **) svar.val = (char *) calloc(1, sizeof(char));
    }
    else if (!strcmp(type, "number"))
    {
      svar.type |= SETV_INT;
      svar.val = (int *) calloc(1, sizeof(int));
    }
    else if (!strcmp(type, "char"))
    {
      svar.type |= SETV_CHAR;
      svar.val = (char *) calloc(2, sizeof(char));
    }
    else
    {
      free(svar.name);
      free(type);
      return SCM_BOOL_F;
    }
    svar.proc.scm = -1;
    if (!gh_null_p(preproc))
      svar.proc.scm = define_func(gh_car(preproc));
    insert_var(&setTree, &svar);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
extern SCM delete_set_variable(SCM varname)
{
  int n;
  char *name;
  SetVar *svar;

  name = gh_scm2newstr(varname, &n);
  if (n == 0)
    return SCM_BOOL_F;
  svar = find_var(name);
  if (svar && (svar->type & SET_SCM))
    del_var(&setTree, svar);
  free(name);
  return SCM_BOOL_T;
}

extern SCM get_set_variable(const char *name)
{
  SetVar *svar;

  svar = find_var(name);
  if (!svar)
    return SCM_BOOL_F;
  switch (svar->type & (~SET_SCM))
   {
     case SETV_BOOL:
       return (gh_bool2scm((*((u_int *) svar->val) & svar->flag)));
     case SETV_CHAR:
       return (gh_char2scm(*((char *) svar->val)));
     case SETV_INT:
       return (gh_long2scm(*((int *) svar->val)));
     case SETV_STR:
       return (gh_str02scm(*((char **) svar->val)));
     default:
       return SCM_BOOL_F;
   }
}

extern SCM cmd_set_var(SCM var, SCM val)
{
  SetVar *svar;
  int i;
  char *varname;

  varname = gh_scm2newstr(var, &i);
  if (i == 0)
    return SCM_BOOL_F;
  svar = find_var(varname);
  free(varname);
  if (svar)
  {
    switch (svar->type & (~SET_SCM))
     {
       case SETV_BOOL:
         if (svar->type & SET_SCM)
         {
           if (gh_equal_p(val, SCM_BOOL_F))
             svar->flag = 0;
           else if (gh_equal_p(val, SCM_BOOL_T))
             svar->flag = 1;
           else
             svar->flag = !svar->flag;
         }
         else if (gh_equal_p(val, SCM_BOOL_F))
           *((u_int *) svar->val) &= ~svar->flag;
         else if (gh_equal_p(val, SCM_BOOL_T))
           *((u_int *) svar->val) |= svar->flag;
         else
           *((u_int *) svar->val) =
              (*((u_int *) svar->val) & svar->flag) ?
              *((u_int *) svar->val) & ~svar->flag :
              *((u_int *) svar->val) | svar->flag;
         break;
       case SETV_STR:
         free(*((char **) svar->val));
         *((char **) svar->val) = gh_scm2newstr(val, &i);
         *(*((char **) svar->val) + i) =0;
         break;
       case SETV_INT:
         *((int *) svar->val) = gh_scm2int(val);
         break;
       case SETV_CHAR:
         *((char *) svar->val) = gh_scm2char(val);
         break;
       default:
         return SCM_BOOL_F;
     }                          //         switch 

    done_setting(-1, svar);
    return SCM_BOOL_T;
  }
  return SCM_BOOL_F;
}
#endif // #if _GUILE

#if USE_GTK
static void set_tips_tmout(int w, void *val)
{
  assert(tips_tmout == *((int *) val));
  gtk_tooltips_set_delay(tooltips, tips_tmout);
}
static void tips_enable(int to, void *status)
{
  if (*((int *) status) & SHOW_TIPS)
    gtk_tooltips_enable(tooltips);
  else
    gtk_tooltips_disable(tooltips);
}
#if _GUILE
static void verbose_return(int junk, void *status)
{
  SET_BUTTON(main_window->verbose_ret, *((int *) status) & s_VERBOSE_RETURN);
  /*if (*((int *) status) & s_VERBOSE_RETURN)
    SET_BUTTON(main_window->verbose_ret, 1);
  else
    DEACTIVATE_BUTTON(main_window->verbose_ret);*/
}
#endif
#endif
static void log_start(int to, void *f)
{
  static char *old_name = NULL;
  char **fname = (char **) f;

  if (*fname == 0)
    return;
  if (old_name == NULL || strcmp(old_name, *fname) || logFp == NULL)
  {
    if (**((char **) f) == '~')
    {
      char *s = expand_tilde(*fname);

      if (!s)
      {
        say2(0, to, 1, "error expanding %s: %s", *fname, strerror(errno));
        return;
      }
      free(*((char **) f));
      *((char **) f) = s;
    }
    if (**((char **) f) != '/')
    {
      char dir[MAXPATHLEN],
           s[MAXPATHLEN + NAME_MAX];

      if (getcwd(dir, MAXPATHLEN) == NULL)
      {
        say2(0, to, 1, "getcwd error: %s", strerror(errno));
        return;
      }
      sprintf(s, "%s/%s", dir, *fname);
      //puts(*((char **) f));
      free(*((char **) f));
      *((char **) f) = strdup(s);
    }
    if (gflags & VERBOSE_CLIENT)
      say2(0, to, 1, "--Setting session output to %s.", *fname);
    if (logFp)
      logFp = freopen(*fname, "a", logFp);
    else
      logFp = fopen(*fname, "a");
    if (logFp == NULL)
    {
      int i;

      say2(0, to, 1, "Unable to create/open %s: %s\n"
           "Use '/set logfile <filename>'.",
           *fname, strerror(errno));
      sflags &= ~LOG;
      for (i = 0; i < win_count; i++)
        if (winstruct[i].chanwin)
          DEACTIVATE_BUTTON(winstruct[i].chanwin->history);
      say2(0, to, 1, "--Logging now off.");
      return;
    }
    else
    {
      time_t t = time(NULL);

      setvbuf(logFp, NULL, _IONBF, 0);
      fprintf(logFp, "--Log start %s", ctime(&t));
      if (old_name)
        free(old_name);
      old_name = strdup(*fname);
    }
  }
}

void log_set(int to, void *status)
{
  int i;

  if (*((int *) status) & LOG)
  {
    if (logFp == NULL)
      log_start(to, (void *) &log_file);
  }
  else
  {
    if (logFp)
    {
      time_t t = time(NULL);

      fprintf(logFp, "--- Log stop %s", ctime(&t));
      fclose(logFp);
      logFp = NULL;
      if (gflags & VERBOSE_CLIENT)
        say("--- Stopping output log", to, 1);
    }
  }
  for (i = 0; i < win_count; i++)
    if (winstruct[i].chanwin)
      SET_BUTTON(winstruct[i].chanwin->history, *((int *) status) & LOG);
}

extern void setup_set_variables(void)
{
  typedef struct
  {
    char *name;
    u_char type;
    void *val;
    u_int flag;                 //for boolean vars

    void (*func) (int, void *); //win, new value

  }
  Bi_var;

  Bi_var vars[] =
  {
    /* use only lowercase variable names!! */
#if USE_GTK
    {"spx_format_char", SETV_CHAR, (void *) &spx_format_char, 0, NULL},
#endif
    {"debug", SETV_INT, (void *) &debug, 0, NULL},
    {"autochat", SETV_BOOL, (void *) &gflags, AUTO_CHAT, NULL},
    {"autochecklag", SETV_BOOL, (void *) &gflags, AUTO_CHECKLAG, NULL},

    {"autoget", SETV_BOOL, (void *) &gflags, AUTO_GETFILE, NULL},
    {"autoinvite", SETV_BOOL, (void *) &gflags, AUTO_INVITE, NULL},
    {"autorejoin", SETV_BOOL, (void *) &gflags, AUTO_REJOIN, NULL},
    {"away_text", SETV_STR, (void *) &away_text, 0, NULL},
    {"beep_away", SETV_BOOL, (void *) &gflags, BEEP_AWAY, NULL},	// private msg/notice/invite
     {"beep_on_dcc", SETV_BOOL, (void *) &gflags, BEEP_DCC, NULL},	// when dcc request arrives
     {"beep_on_error", SETV_BOOL, (void *) &gflags, BEEP_ERR, NULL},
    {"beep_on_msg", SETV_BOOL, (void *) &gflags, BEEP_MSG, NULL},	// when a msg ie received
     {"beep_on_server_error", SETV_BOOL, (void *) &gflags, BEEP_SERVER_ERR, NULL},	// bad command to server*/      

    {"charchanop", SETV_CHAR, (void *) &chanopChar, 0, NULL},
    {"charoper", SETV_CHAR, (void *) &serveropChar, 0, NULL},
    {"charvoice", SETV_CHAR, (void *) &chanvoiceChar, 0, NULL},
    {"cmdchar", SETV_CHAR, (void *) &cmdchar, 0, NULL},
    {"dynamic_slip", SETV_BOOL, (void *) &sflags, DYNAMIC_SLIP, NULL},
    {"encryption", SETV_BOOL, (void *) &gflags, ENCRYPT_MSG, NULL},
    {"extended_dcc", SETV_BOOL, (void *) &sflags, EXTENDED_DCC, NULL},
    {"externalgethost", SETV_BOOL, (void *) &sflags, EXTERNALGETHOST, NULL},
    {"finger_allow", SETV_BOOL, (void *) &gflags, FINGER, NULL},
    {"finger_reply", SETV_STR, (void *) &finger_reply, 0, NULL},
    {"finger_utmp", SETV_BOOL, (void *) &gflags, FINGER_UTMP, NULL},
    {"flood_check", SETV_BOOL, (void *) &sflags, FLOOD_CHECK, NULL},
    {"flood_max", SETV_INT, (void *) &flood_max, 0, NULL},
    {"flood_period", SETV_INT, (void *) &flood_period, 0, NULL},
    {"fmt_chanmode", SETV_STR, (void *) &fmt_chanmode, 0, NULL},
    {"fmt_dcc_chat_notify",SETV_STR, &fmt_dcc_chat_notify,0,NULL},
    {"fmt_dcc_file_notify",SETV_STR, &fmt_dcc_file_notify,0,NULL},
    {"fmt_ctcp_reply", SETV_STR, (void *) &fmt_ctcp_reply, 0, NULL},
    {"fmt_ignored", SETV_STR, (void *) &fmt_ignored, 0, NULL},
    {"fmt_invite", SETV_STR, (void *) &fmt_invite, 0, NULL},
    {"fmt_notify_signoff", SETV_STR, (void *) &fmt_notify_signoff, 0, NULL},
    {"fmt_notify_signon", SETV_STR, (void *) &fmt_notify_signon, 0, NULL},
    {"fmt_other_dccchat", SETV_STR, (void *) &fmt_other_dccchat, 0, NULL},
    {"fmt_other_join", SETV_STR, (void *) &fmt_other_join, 0, NULL},
    {"fmt_other_kick", SETV_STR, (void *) &fmt_other_kick, 0, NULL},
    {"fmt_other_nick", SETV_STR, (void *) &fmt_other_nick, 0, NULL},
    {"fmt_other_part", SETV_STR, (void *) &fmt_other_part, 0, NULL},
    {"fmt_priv_action", SETV_STR, (void *) &fmt_priv_action, 0, NULL},
    {"fmt_priv_msg", SETV_STR, (void *) &fmt_priv_msg, 0, NULL},
    {"fmt_priv_notice", SETV_STR, (void *) &fmt_priv_notice, 0, NULL},

    {"fmt_pub_action", SETV_STR, (void *) &fmt_pub_action, 0, NULL},
    {"fmt_pub_msg", SETV_STR, (void *) &fmt_pub_msg, 0, NULL},
    {"fmt_pub_msg2", SETV_STR, (void *) &fmt_pub_msg2, 0, NULL},
    {"fmt_pub_msg3", SETV_STR, (void *) &fmt_pub_msg3, 0, NULL},
    {"fmt_pub_notice", SETV_STR, (void *) &fmt_pub_notice, 0, NULL},
    {"fmt_pub_notice2", SETV_STR, (void *) &fmt_pub_notice2, 0, NULL},
    {"fmt_pub_notice3", SETV_STR, (void *) &fmt_pub_notice3, 0, NULL},

    {"fmt_sed_nokey", SETV_STR, (void *) &fmt_sed_nokey, 0, NULL},
    {"fmt_sed_priv", SETV_STR, (void *) &fmt_sed_priv, 0, NULL},
    {"fmt_sed_pub", SETV_STR, (void *) &fmt_sed_pub, 0, NULL},
    {"fmt_sed_your", SETV_STR, (void *) &fmt_sed_your, 0, NULL},
    {"fmt_signoff", SETV_STR, (void *) &fmt_signoff, 0, NULL},
    {"fmt_topic", SETV_STR, (void *) &fmt_topic, 0, NULL},
    {"fmt_usermode", SETV_STR, (void *) &fmt_usermode, 0, NULL},
    {"fmt_you_dccchat", SETV_STR, (void *) &fmt_you_dccchat, 0, NULL},
    {"fmt_you_join", SETV_STR, (void *) &fmt_you_join, 0, NULL},
    {"fmt_you_kick", SETV_STR, (void *) &fmt_you_kick, 0, NULL},
    {"fmt_you_nick", SETV_STR, (void *) &fmt_you_nick, 0, NULL},
    {"fmt_you_part", SETV_STR, (void *) &fmt_you_part, 0, NULL},
    {"fmt_you_priv_action", SETV_STR, (void *) &fmt_you_priv_action, 0, NULL},
    {"fmt_you_priv_msg", SETV_STR, (void *) &fmt_you_priv_msg, 0, NULL},
    {"fmt_you_priv_notice", SETV_STR, (void *) &fmt_you_priv_notice, 0, NULL},
    {"fmt_you_pub_action", SETV_STR, (void *) &fmt_you_pub_action, 0, NULL},
    {"fmt_you_pub_msg", SETV_STR, (void *) &fmt_you_pub_msg, 0, NULL},
    {"fmt_you_pub_notice", SETV_STR, (void *) &fmt_you_pub_notice, 0, NULL},
    
    {"fmt_server_notice", SETV_STR, (void *) &fmt_server_notice, 0, NULL},

    {"force_connection", SETV_BOOL, (void *) &sflags, FORCE_CONNECTION, NULL},
    {"gethostbynameprogram", SETV_STR, (void *) &gethostbynameprogram, 0, NULL},
    {"history", SETV_BOOL, (void *) &gflags, HISTORY, NULL},
    {"inform_ignored", SETV_BOOL, (void *) &gflags, INFORM_IGNORED, NULL},
    {"lag_frequency", SETV_INT, (void *) &lag_frequency, 0, NULL},
    {"libdirectory", SETV_STR, (void *) &sula_lib, 0, NULL},
    {"logfile", SETV_STR, (void *) &log_file, 0, (void *) &log_start},
    {"logging", SETV_BOOL, (void *) &sflags, LOG, (void *) &log_set},
    {"max_go", SETV_INT, (void *) &max_go, 0, NULL},
    {"max_sendbuf", SETV_INT, (void *) &max_sendbuf, 0, NULL},
    {"maxchanlen", SETV_INT, (void *) &MaxChanLen, 0, NULL},
    {"maxnicklen", SETV_INT, (void *) &MaxNickLen, 0, NULL},
    {"line_break", SETV_STR, (void *) &line_break, 0, NULL},
    {"nc_read_bufsize", SETV_INT, (void *) &nc_read_bufsize, 0, NULL},
    {"notify_autocheck", SETV_BOOL, (void *) &gflags, AUTO_CHECKNOTIFY, NULL},
    {"notify_frequency", SETV_INT, (void *) &notify_frequency, 0, NULL},
    {"show_numeric", SETV_BOOL, (void *) &gflags, SHOW_NUMERIC, NULL},	/*obsolete */

    {"quit_chat", SETV_STR, (void *) &chat_quit_text, 0, NULL},
    {"quit_text", SETV_STR, (void *) &quit_text, 0, NULL},

    {"quote_exec", SETV_BOOL, (void *) &gflags, QUOTE_EXEC, NULL},
    {"quote_ml", SETV_BOOL, (void *) &gflags, QUOTE_ML, NULL},
    {"save_history", SETV_BOOL, (void *) &gflags, SAVE_HISTORY, NULL},
    {"show_numeric", SETV_BOOL, (void *) &gflags, SHOW_NUMERIC, NULL},
    {"show_raw_msg", SETV_BOOL, (void *) &gflags, SHOW_RAW_MSG, NULL},

    {"suppress_motd", SETV_BOOL, (void *) &sflags, SUPPRESS_MOTD, NULL},
    {"tmout_connect", SETV_INT, (void *) &connect_timeout, 0, NULL},
    {"tmout_dcc", SETV_INT, (void *) &dcc_timeout, 0, NULL},
    {"tmout_getstr", SETV_INT, (void *) &timeout, 0, NULL},	// for getstring GUI dialog
#if USE_XFORMS
    {"tmout_tips", SETV_INT, (void *) &tips_tmout, 0, NULL},
    {"show_tips", SETV_BOOL, (void *) &gflags, SHOW_TIPS, NULL},
#elif USE_GTK
    {"tmout_tips", SETV_INT, (void *) &tips_tmout, 0, &set_tips_tmout},
    {"show_tips", SETV_BOOL, (void *) &gflags, SHOW_TIPS, &tips_enable},
#endif
    {"tmout_userhost", SETV_INT, (void *) &uhost_timeout, 0, NULL},
    {"userinfo", SETV_STR, (void *) &userinfo, 0, NULL},
    {"verbose_client", SETV_BOOL, (void *) &gflags, VERBOSE_CLIENT, NULL},
    {"verbose_ctcp", SETV_BOOL, (void *) &gflags, VERBOSE_CTCP, NULL},
    {"update_ignore_display", SETV_BOOL, &sflags, sUPDATE_IGNORE_DISPLAY, 0},
    {"echo_input", SETV_BOOL, &sflags, sECHO_INPUT, 0},
#if _GUILE
    {"verbose_return", SETV_BOOL, &sflags, s_VERBOSE_RETURN, &verbose_return},
#endif
    {"user_update", SETV_BOOL, &sflags, sUPDATE_USER_DISPLAY, NULL},
    {"user_update_frequency", SETV_INT, (void *) &userupdate_frequency, 0, NULL},
  #if MUTABLE_IRC
    {"mutable_irc", SETV_BOOL, &sflags, sMUTABLE_IRC, NULL},
  #endif
    {0, 0, 0, 0, 0}
  };
  Bi_var *p = vars;
  SetVar v;

  setTree = NULL;
  while (p->name)
  {
    v.name = p->name;
    v.type = p->type;
    v.val=p->val;
    v.flag = p->flag;
    v.proc.func = p->func;
    insert_var(&setTree, &v);
    p++;
  }

}
static void done_setting(short w, SetVar * svar)
{
#if _GUILE
  if (svar->type & SET_SCM)
  {
    if (svar->proc.scm != -1)
    {
#define DAT_SIZE 64
      char data[DAT_SIZE + 1];
      Scm_cmd_arg args;
      SCM val;

      switch (svar->type & (~SET_SCM))
       {
         case SETV_BOOL:
           val = (gh_bool2scm((*((u_int *) svar->val) & svar->flag)));
           break;
         case SETV_CHAR:
           val = (gh_char2scm(*((char *) svar->val)));
           break;
         case SETV_INT:
           val = (gh_long2scm(*((int *) svar->val)));
           break;
         case SETV_STR:
           val = (gh_str02scm(*((char **) svar->val)));
           break;
         default:
           val = SCM_BOOL_F;
           break;
       }
      args.func = svar->proc.scm;
      args.args = gh_list(gh_str02scm(svar->name),
                          val,
                          gh_long2scm(w),
                          SCM_UNDEFINED);
      if (snprintf(data, DAT_SIZE,
                   "SET var %s", svar->name) == -1)
        data[DAT_SIZE] = 0;
      gh_catch(SCM_BOOL_T, &call_scm_command, &args,
               (scm_catch_handler_t) & exception_handler, (void *) &data);
    }
  }

  else
#endif
  if (svar->proc.func != NULL)
  {
#if _GUILE
    gh_defer_ints();
#endif
    (*(svar->proc.func)) (w, svar->val);
#if _GUILE
    gh_allow_ints();
#endif
  }
}
#define BOOL_ON 1
#define BOOL_OFF 2
#define BOOL_TOGGLE 3
#define set_bool_var(_svar, _value) do{\
if((_svar)->type & SET_SCM){ \
   if ((_value)==BOOL_OFF)  (_svar)->flag = 0;\
   else if ((_value)==BOOL_ON) (_svar)->flag = 1;\
   else (_svar)->flag = !(_svar)->flag;}\
else if ((_value)==BOOL_OFF) *((u_int *) (_svar)->val) &= (~(_svar)->flag);\
else if ((_value)==BOOL_ON)  *((u_int *) (_svar)->val) |= (_svar)->flag;\
else  *((u_int *) (_svar)->val) = \
		  (*((u_int *) (_svar)->val) & (_svar)->flag) ?\
		  *((int *) (_svar)->val) & ~((_svar)->flag) : \
		  *((int *) (_svar)->val) | (_svar)->flag; \
}while(0)

extern void set_variable(const char *args, Winstruct * win)
{

  static void list_vars(SetVar * svar, SPX_OBJ(brow));
  char *name = nextword(args, 1);

  if (*name == 0)
  {
    SPX_OBJ(browser);

    if (win)
    {
#if USE_XFORMS
      fl_freeze_form(win->chanwin->chanwin);
#else
      gtk_text_freeze(GTK_TEXT(win->chanwin->browser));
#endif
      browser = win->chanwin->browser;
    }
    else
    {
      browser = main_window->browser;
#if USE_XFORMS
      fl_freeze_form(main_window->main_form);
#else
      gtk_text_freeze(GTK_TEXT(main_window->browser));
#endif
    }
    spx_writeln(browser, "\n-Current settings-");
    list_vars(setTree, browser);
#if USE_XFORMS
    if (win)
      fl_unfreeze_form(win->chanwin->chanwin);
    else
      fl_unfreeze_form(main_window->main_form);
#else
    if (win)
      gtk_text_thaw(GTK_TEXT(win->chanwin->browser));
    else
      gtk_text_thaw(GTK_TEXT(main_window->browser));
#endif
  }
  else if (!strcasecmp(name, "-save"))
  {
#if _GUILE
    static void save_set_vars(SetVar *, FILE *);
    char *fname = nextword(args, 2);

    if (*fname)
    {
      FILE *fp = fopen(fname, "w");

      if (!fp)
        say2(0, win ? win - winstruct : -1, 1,
             "SET -save: %s : %s", fname, strerror(errno));
      else
      {
        time_t t = time(NULL);

        fprintf(fp, "#!\n" sula_NAME " " sula_VERSION "\n"
                "SET variables saved %sby %s on host %s.\n"
                "Use /load or (load) to restore.\n!#\n",
                ctime(&t), Name, host);
        fputs("(let((__vars \'(\n\n", fp);
        save_set_vars(setTree, fp);
        fputs("\n  )))\n"
              "  (for-each (lambda(var) (gs-set! (car var) (cadr var))) "
              "__vars))", fp);
        fclose(fp);
        if (gflags & VERBOSE_CLIENT && win)
          say2(0, win - winstruct, 1, "vars saved as %s", fname);
      }
      free(fname);
    }
    else
      say0("Usage: set -save <filename>",
           win ? win - winstruct : -1, 1);

#endif
    free(name);
    return;
  }
  else
  {
    SetVar *svar;

    svar = find_var(name);
    if (!svar)
    {
      say2(0, win ? win - winstruct : -1, 1,
           PROMPT "set: No such variable \"%s\"", name);
      if (gflags & BEEP_ERR)
        spx_bell(0);
    }
    else
    {
      char *val = nextword(args, 2);
      short to = win ? win - winstruct : -1;
      char stop = 0;

      switch (svar->type & (~SET_SCM))
       {
         case SETV_BOOL:
           {
             if (*val == 0)
             {
               say2(0, to, -1, PROMPT "%s currently set %s", svar->name,
                    *((u_int *) svar->val) & svar->flag ? "on" : "off");
               stop = 1;
               break;
             }
             LOWERCASE(val);

             if (*val == 'o' && val[1] == 'f' && val[2] == 'f' && val[3] == 0)
               stop = BOOL_OFF;
             else if (*val == 'o' && val[1] == 'n' && val[2] == 0)
               stop = BOOL_ON;
             else if (*val == 't')
               stop = BOOL_TOGGLE;
             else
             {
               if (gflags & BEEP_ERR)
                 spx_bell(0);
               say2(0, to, -1, PROMPT "set: value must be on, off, or toggle");
               stop = 1;
               break;
             }
             set_bool_var(svar, stop);
             stop = 0;
             if (gflags & VERBOSE_CLIENT)
               say2(0, to, -1, PROMPT "%s now set %s", svar->name,
                    *((u_int *) svar->val) & svar->flag ? "on" : "off");
             break;
           }
         case SETV_CHAR:
           {
             char *flag = (char *) svar->val;

             if (*val == 0 || sscanf(val, "%c", flag) < 1)
             {
               say2(0, to, -1, PROMPT "%s currently set to %c",
                    svar->name, *flag);
               stop = 1;
               break;
             }
             if (gflags & VERBOSE_CLIENT)
               say2(0, to, -1, PROMPT "%s now set to %c", svar->name,
                    *flag);
             break;
           }
         case SETV_INT:
           {
             int *flag = (int *) svar->val;

             if (!(*val) || sscanf(val, "%d", flag) < 1)
             {
               say2(0, to, -1, PROMPT "%s currently set to %d",
                    svar->name, *flag);
               stop = 1;
               break;
             }
             else if (gflags & VERBOSE_CLIENT)
               say2(0, to, -1, PROMPT "%s now set to %d", svar->name,
                    *flag);
             break;
           }

         case SETV_STR:
           {
             char **flag = (char **) svar->val;

             if (!(*val))
             {
               say2(0, to, -1, PROMPT "%s currently set to \"%s\"",
                    svar->name, *flag);
               stop = 1;
             }
             else
             {
               free(*flag);
               *flag = strdup(args + find_pos(args, 2));
               if (**flag == '"')
               {
                 size_t ll = strlen(*flag) - 1;

                 if (*(*flag + ll) == '"')
                 {              //  "hello", ""

                   *(*flag + ll) = 0;
                   memmove(*flag, *flag + 1, ll);
                 }
               }
               if (gflags & VERBOSE_CLIENT)
                 say2(0, to, -1, PROMPT "%s now set to \"%s\"",
                      svar->name, *flag);
             }
             break;
           }

         default:
           stop = 1;
           break;
       }
      if (!stop)
        done_setting(to, svar);
      free(val);
    }
    free(name);
  }
}

#if _GUILE
static void save_set_vars(SetVar * svar, FILE * fp)
{
  if (svar)
  {
    save_set_vars(svar->left, fp);
    switch (svar->type & (~SET_SCM))
     {
       case SETV_BOOL:
         fprintf(fp, "  (\"%s\"\t\t%s)\n",
                 svar->name,
                 *((u_int *) svar->val) & svar->flag ? "#t" : "#f");
         break;
       case SETV_CHAR:
         fprintf(fp, "  (\"%s\"\t\t#\\%c)\n",
                 svar->name,
                 *((char *) svar->val));
         break;
       case SETV_INT:
         fprintf(fp, "  (\"%s\"\t\t%d)\n",
                 svar->name, *((int *) svar->val));
         break;
       case SETV_STR:
         {
           char *buf = my_malloc(sizeof(char) *
                                 (strlen(*((char **) svar->val)) * 2 + 5));
           char *p = *((char **) svar->val);
           char *pbuf=buf;

           while (*p)
           {
             if (*p == '"' || *p == '\\')
               *pbuf++ = '\\';
             *pbuf++ = *p++;
           }
           *pbuf=0;
           fprintf(fp, "  (\"%s\"\t\t\"%s\")\n",
                   svar->name, buf);
           free(buf);
         }
         break;
       default:
         break;
     }
    save_set_vars(svar->right, fp);
  }
}
#endif

static void list_vars(SetVar * svar, SPX_OBJ(browser))
{
  if (svar)
  {
    char *buf;

    list_vars(svar->left, browser);
    buf = malloc(sizeof(char) * (strlen(svar->name) + 40));

#if USE_GTK
#define FFM "@$  "
#define FFM2 "@!$@C7@D4@."
#else
#define FFM " "
#define FFM2 ""
#endif
    switch (svar->type & (~SET_SCM))
     {
       case SETV_BOOL:
         {
           sprintf(buf, FFM "%s is " FFM2 " %s", svar->name,
                   *((u_int *) svar->val) & svar->flag ? "on" : "off");
           spx_writeln(browser, buf);
           break;
         }
       case SETV_CHAR:
         {
           sprintf(buf, FFM "%s is " FFM2 " %c",
                   svar->name, *((char *) svar->val));
           spx_writeln(browser, buf);
           break;
         }
       case SETV_INT:
         {
           sprintf(buf, FFM "%s is " FFM2 " %d",
                   svar->name, *((int *) svar->val));
           spx_writeln(browser, buf);
           break;
         }

       case SETV_STR:
         {
           char **flag = (char **) svar->val;

           free(buf);
           buf = my_malloc(sizeof(char) * (
                                            strlen(svar->name) +
                                            strlen(*flag) + 40));

           sprintf(buf, FFM "%s is " FFM2 " \"%s\"",
                   svar->name, *flag);
           spx_writeln(browser, buf);
           break;
         }
       default:
         break;
     }
    free(buf);
    list_vars(svar->right, browser);
  }
}

#if USE_GTK

static void add_var_to_form(SetVar * p)
{
  if (p)
  {
    char *s[2];

    add_var_to_form(p->left);
    s[0] = p->name;
    switch (p->type & (~SET_SCM))
     {
       case SETV_BOOL:
         s[1] = *((u_int *) p->val) & p->flag ? "on" : "off";
         (void) gtk_clist_append(GTK_CLIST(setup_tool->f_clist), s);
         break;
       case SETV_INT:
         {
           char tmp[12];

           sprintf(tmp, "%u", *((u_int *) p->val));
           s[1] = tmp;
           (void) gtk_clist_append(GTK_CLIST(setup_tool->n_clist), s);
         }
         break;
       case SETV_CHAR:
         {
           char tmp[2];

           tmp[0] = *((char *) p->val);
           tmp[1] = 0;
           s[1] = tmp;
           (void) gtk_clist_append(GTK_CLIST(setup_tool->s_clist), s);
           break;
         }
       case SETV_STR:
         s[1] = *((char **) p->val);
         (void) gtk_clist_append(GTK_CLIST(setup_tool->s_clist), s);
         break;
       default:
         s[0] = NULL;
         break;
     }
    add_var_to_form(p->right);
  }
}
void do_setup(void)
{
  Setup_tool *form = create_setup_tool();

  if (form)
  {
    gtk_clist_freeze(GTK_CLIST(setup_tool->s_clist));
    gtk_clist_freeze(GTK_CLIST(setup_tool->f_clist));
    gtk_clist_freeze(GTK_CLIST(setup_tool->n_clist));
    add_var_to_form(setTree);
    gtk_clist_thaw(GTK_CLIST(setup_tool->s_clist));
    gtk_clist_thaw(GTK_CLIST(setup_tool->f_clist));
    gtk_clist_thaw(GTK_CLIST(setup_tool->n_clist));
    gtk_widget_set_sensitive(setup_tool->f_clist, FALSE);
    gtk_widget_set_sensitive(setup_tool->n_clist, FALSE);
    gtk_widget_show(form->setup);
  }
}

void selection_made(GtkWidget * clist,
                    gint row,
                    gint column,
                    GdkEventButton * event,
                    gpointer data)
{
  gchar *var_name;
  SetVar *svar;

  gtk_clist_get_text(GTK_CLIST(clist), row, 0, &var_name);
  svar = find_var(var_name);
  assert(svar);

  switch ((long) data)
   {
     case 11:
       spx_set_input(setup_tool->s_entry,
                     (svar->type & (~SET_SCM)) == SETV_STR ?
                     *((char **) svar->val) : (char *) svar->val);
       break;
     case 21:
       SET_BUTTON(setup_tool->state,
                  *((u_int *) svar->val) & svar->flag);
       break;
     case 31:
       gtk_spin_button_set_value(GTK_SPIN_BUTTON(setup_tool->n_entry),
                                 *((u_int *) svar->val));
       break;
   }
}

void set_cb(SPX_OBJ(ob), SPX_DATA(data))
{
  GtkCList *clist;

  if ((long) data == 10)
    clist = GTK_CLIST(setup_tool->s_clist);
  else if ((long) data == 20)
    clist = GTK_CLIST(setup_tool->f_clist);
  else if ((long) data == 30)
    clist = GTK_CLIST(setup_tool->n_clist);
  else
    return;
  if (((long) data == 10 || (long) data == 20 || (long) data == 30))
  {
    if (clist->selection)
    {
      int row = GPOINTER_TO_INT(clist->selection->data);
      gchar *var_name;
      SetVar *svar;
      char *ss[2];

      gtk_clist_get_text(clist, row, 0, &var_name);
      svar = find_var(var_name);
      assert(svar);
      ss[0] = svar->name;
      switch ((long) data)
       {
         case 10:
           {
             char *s;

             assert(
                     ((svar->type & (~SET_SCM)) == SETV_STR) ||
                     ((svar->type & (~SET_SCM)) == SETV_CHAR));
             s = spx_get_input(setup_tool->s_entry);
             if ((svar->type & (~SET_SCM)) == SETV_STR)
             {
               free(*((char **) svar->val));
               *((char **) svar->val) = *s ? strdup(s) : calloc(0, sizeof(char));

               ss[1] = *((char **) svar->val);
             }
             else
             {
               char tmp[2];

               if (*s == 0)
                 return;
               sscanf(s, "%c", (char *) svar->val);
               tmp[0] = *((char *) svar->val);
               tmp[1] = 0;
               ss[1] = tmp;
             }
             //spx_set_input(setup_tool->s_entry, "");
           }
           break;
         case 20:
           puts("0");
           assert((svar->type & (~SET_SCM)) == SETV_BOOL);
           set_bool_var(svar,
                      BUTTON_IS_ON(setup_tool->state) ? BOOL_ON : BOOL_OFF);
           ss[1] = *((u_int *) svar->val) & svar->flag ? "on" : "off";
           break;
         default:
           {
             char tmp[12];

             puts("1");
             assert((svar->type & (~SET_SCM)) == SETV_INT);
             *((int *) svar->val) = gtk_spin_button_get_value_as_int(
                                      GTK_SPIN_BUTTON(setup_tool->n_entry));
             sprintf(tmp, "%d", *((u_int *) svar->val));
             ss[1] = tmp;
           }
           break;
       }                        /*swtich */
      gtk_clist_remove(clist, row);
      gtk_clist_insert(clist, row, ss);
      gtk_clist_select_row(clist, row, 0);
      done_setting(-1, svar);
    }
  }
}

#elif USE_XFORMS
static const char *counter_int_filter(FL_OBJECT * ob, double val, int prec)
{
  static char buf[32];

  sprintf(buf, "%d", (int) val);
  return buf;
}
static FD_strings *stringform;
static FD_flags *flagform;
static FD_numbers *numberform;

static void add_var_to_form(SetVar * p)
{
  if (p)
  {
    add_var_to_form(p->left);
    switch (p->type & (~SET_SCM))
     {
       case SETV_BOOL:
         fl_add_browser_line(flagform->browser, p->name);
         break;
       case SETV_INT:
         fl_add_browser_line(numberform->browser, p->name);
         break;
       case SETV_CHAR:
       case SETV_STR:
         fl_add_browser_line(stringform->browser, p->name);
         break;
       default:
         break;
     }
    add_var_to_form(p->right);
  }
}
static void make_folder(FD_setup * form)
{
  stringform = create_form_strings();
  flagform = create_form_flags();
  numberform = create_form_numbers();

  fl_hide_object(flagform->stat);
  add_var_to_form(setTree);
  numberform->input->u_ldata = (long) XC_xterm;

  fl_set_input_return(numberform->input, FL_RETURN_END);
  fl_set_object_prehandler(numberform->input, set_cursor);
  numberform->input->u_vdata = (void *) form->folder;
  fl_set_browser_fontsize(numberform->browser, FL_NORMAL_SIZE);
  fl_set_browser_fontstyle(numberform->browser, FL_TIMES_STYLE);
  fl_set_counter_step(numberform->counter, 1, 5);
  fl_set_counter_filter(numberform->counter, counter_int_filter);
#if 0
  flagform->input->u_ldata = (long) XC_xterm;
  flagform->input->u_vdata = (void *) form->folder;
  fl_set_input_return(flagform->input, FL_RETURN_END);
  fl_set_object_prehandler(flagform->input, set_cursor);
#endif
  flagform->status->u_vdata = (void *) form->folder;
  fl_set_browser_fontsize(flagform->browser, FL_NORMAL_SIZE);
  fl_set_browser_fontstyle(flagform->browser, FL_TIMES_STYLE);

  stringform->input->u_ldata = (long) XC_xterm;
  stringform->input->u_vdata = (void *) form->folder;
  fl_set_input_return(stringform->input, FL_RETURN_END);
  fl_set_object_prehandler(stringform->input, set_cursor);
  fl_set_browser_fontsize(stringform->browser, FL_NORMAL_SIZE);
  fl_set_browser_fontstyle(stringform->browser, FL_TIMES_STYLE);

  fl_addto_tabfolder(form->folder, "Strings", stringform->strings);
  fl_addto_tabfolder(form->folder, "Flags", flagform->flags);
  fl_addto_tabfolder(form->folder, "Numeral", numberform->numbers);
}
void do_setup(void)
{
  static FD_setup *form = 0;

  if (form)
    fl_raise_form(form->setup);
  else
  {
    form = create_form_setup();

    make_folder(form);
    fl_set_object_bw(form->folder, -2);
    form->done->u_ldata = (long) &form;
    fl_set_form_atclose(form->setup, dont_close_win, 0);
    fl_show_form(form->setup, FL_PLACE_GEOMETRY, FL_FULLBORDER,
                 sula_NAME sula_VERSION ": Setup options");
    fl_do_forms();
  }
}

void set_cb(SPX_OBJ(ob), SPX_DATA(data))
{
  static SetVar *svar = NULL;

  //static int i = -1;
  static int previous = -1;

  union
  {
    FD_strings *stringform;
    FD_flags *flagform;
    FD_numbers *numberform;
    FD_setup *setup;
  }
  u_form;

  if (data > 9 && data < 20)
    u_form.stringform = (FD_strings *) ob->form->fdui;
  else if (data > 19 && data < 30)
    u_form.flagform = (FD_flags *) ob->form->fdui;
  else if (data > 29 && data < 40)
    u_form.numberform = (FD_numbers *) ob->form->fdui;
  else if (data < 10)           /*
                                   if(data!=0) -->done 
                                 */
    u_form.setup = (FD_setup *) ob->form->fdui;
  else
    return;

  switch (data)
   {

/*
 *  (flag) light button                          
 */
     case 22:
       {

         if (svar == NULL)
           return;              //bug

         previous =
            fl_get_active_folder_number((FL_OBJECT *)
                                        u_form.flagform->status->u_vdata);
         set_bool_var(svar,
                 fl_get_button(u_form.flagform->stat) ? BOOL_ON : BOOL_OFF);

         fl_set_object_label(u_form.flagform->stat,
                        *((u_int *) svar->val) & svar->flag ? "on" : "off");
         fl_set_object_label(u_form.flagform->status,
         *((u_int *) svar->val) & svar->flag ? "now set on" : "now set off");
         done_setting(-1, svar);
         return;
       }
     case 31:
       {                        /*
                                   counter 
                                 */
         char buf[15];

         sprintf(buf, "%d", (int) fl_get_counter_value(ob));
         fl_set_input(u_form.numberform->input, buf);
         break;
       }
     case 32:                  /*
                                   numberform, ok 
                                 */
       fl_trigger_object(u_form.numberform->input);
       break;
     case 11:                  //   clear input 

       fl_set_input(u_form.stringform->input, "");
       break;
     case 0:                   /*   done */
       {
         if (stringform->strings->visible)
           fl_hide_form(stringform->strings);
         fl_free_form(stringform->strings);
         if (flagform->flags->visible)
           fl_hide_form(flagform->flags);
         fl_free_form(flagform->flags);
         if (numberform->numbers->visible)
           fl_hide_form(numberform->numbers);
         fl_free_form(numberform->numbers);
         fl_hide_form(u_form.setup->setup);
         fl_free_form(u_form.setup->setup);
         *((FD_setup **) ob->u_ldata) = 0;
         break;
       }
     default:
#if DEBUG
       fprintf(stderr, "[%s %d] --unknown--%ld\n", __FILE__, __LINE__, data);
#endif
       break;
/*----------------------------------------------
   browser selection                       
----------------------------------------------*/

     case 15:
     case 25:
     case 35:
       {
         const char *var;
         int n;

         n = fl_get_browser(ob);
         if (n < 1)
           return;

         var = fl_get_browser_line(ob, n);
         svar = find_var(var);
         assert(svar);          //impossible; BUG

         if (data == 25)
         {
           fl_hide_object(u_form.flagform->stat);
           previous = fl_get_active_folder_number((FL_OBJECT *) u_form.flagform->status->u_vdata);
         }
         else if (data == 15)
           previous = fl_get_active_folder_number((FL_OBJECT *) u_form.stringform->input->u_vdata);
         else
           previous = fl_get_active_folder_number((FL_OBJECT *) u_form.numberform->input->u_vdata);
         switch (svar->type & (~SET_SCM))
          {
            case SETV_BOOL:
              {

                fl_set_object_label(u_form.flagform->status, "on/off");
                fl_show_object(u_form.flagform->stat);
                fl_set_button(u_form.flagform->stat, *((u_int *) svar->val) & svar->flag);
                fl_set_object_label(u_form.flagform->stat,
                        *((u_int *) svar->val) & svar->flag ? "on" : "off");
                return;
              }
            case SETV_CHAR:
              {
                char buf[10];

                sprintf(buf, "%c", *((char *) svar->val));
                fl_set_input(u_form.stringform->input, buf);
                fl_set_object_label(u_form.stringform->status, "character");
                return;
              }
            case SETV_INT:
              {
                char buf[13];

                sprintf(buf, "%d", *((int *) svar->val));
                fl_set_input(u_form.numberform->input, buf);
                fl_set_object_label(u_form.numberform->status, "whole number");
                fl_set_counter_bounds(u_form.numberform->counter, 0, INT_MAX);
                fl_set_counter_value(u_form.numberform->counter, *((int *) svar->val));
                return;
              }
            case SETV_STR:
              {
                char **flag = (char **) svar->val;

                fl_set_input(u_form.stringform->input, *flag);
                fl_set_object_label(u_form.stringform->status, "string");
                return;
              }
            default:
              break;
          }                     //         switch 

         break;
       }                        // case 5 

/*
   input  line                             
 */
     case 10:
       //case 20:
     case 30:
       {
         const char *val;

         if (previous != fl_get_active_folder_number((FL_OBJECT *) ob->u_vdata))
         {
           fl_set_input(ob, "");
           svar = NULL;
         }
         if (svar == NULL)
           return;
         val = (char *) fl_get_input(ob);
         switch (svar->type & (~SET_SCM))
          {
            case SETV_CHAR:
              {
                char buf[20];
                char *flag;

                unspace(val);
                if (!*val)
                  break;
                flag = (char *) svar->val;	//   must be >0 

                sscanf(val, "%c", flag);
                sprintf(buf, "now set to %c", *flag);
                fl_set_object_label(u_form.stringform->status, buf);
                fl_set_input(ob, "");
                break;
              }
            case SETV_INT:
              {
                char buf[30];
                int *flag;

                unspace(val);
                if (!*val)
                  break;
                flag = (int *) svar->val;
                sscanf(val, "%d", flag);
                sprintf(buf, "now set to %d", *flag);
                fl_set_object_label(u_form.numberform->status, buf);
                fl_set_counter_bounds(u_form.numberform->counter, 0, INT_MAX);
                fl_set_counter_value(u_form.numberform->counter, *flag);
                fl_set_input(ob, "");
                break;
              }

            case SETV_STR:
              {
                char *buf;
                char **flag = (char **) svar->val;

                free(*flag);
                if (!*val)
                  *flag = calloc(0, sizeof(char));

                else
                  *flag = strdup(val);
                buf = malloc(sizeof(char) * (strlen(*flag) + 25));

                sprintf(buf, "now set to \"%s\"", *flag);
                fit_object_label(u_form.stringform->status, buf);
                fl_set_input(ob, "");
                free(buf);
                break;
              }
            default:
              break;
          }                     //   switch(svar->type)

         done_setting(-1, svar);
       }
   }
}
#endif
