/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/



/* 
 * sulahp.c     -gethostbyname with timeout
 * distributed as part of Sula Primerix (http://members.xoom.com/sprimerix)
 * 
 * Author: Tano Fotang, Feb 1998
 * (Contact: fotang@techie.com)
 * changes:
 * 30.05.98 + removed -s option
 * 25.10.98 + prepend program name to errors

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free 
Software Foundation; either version 2 of the License , or (at your option) 
any later version.
 
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.
 
You should have received a copy of the GNU General Public License along
with this program; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define MY_VERSION	"0.2a"


#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#ifndef INADDR_NONE
#define INADDR_NONE     0xffffffff
#endif

static jmp_buf env;
static void sig_alrm(int signo)
{
	longjmp(env, 1);
}
int  main(int argc, char **argv)
{
	int     n;
	char   *server = 0;
	unsigned timeout = 0;

	while ((n = getopt(argc, argv, "t:vh")) != EOF){
		switch (n) {
		    case 't':
			    timeout = atoi(optarg);
			    break;
		   case 'v':
		   	   fprintf(stderr,"%s\n",MY_VERSION);
			   exit(0);
		  case 'h':
		  	  fprintf(stderr,"Usage:\t%s [options] host\nOptions:\n\t"
			  	"\E[4m-t timeout\E[m	try for timeout seconds\n\t"
				"\E[4m-v\E[m 		print program version and exit successfully\n\t"
				"\E[4m-h\E[m		display this help text and exit with success\n",
				argv[0]),
			  exit(0);
		}
	}
	if(!(optind<argc))
		fprintf(stderr,"%s: missing hostname\n",argv[0]),exit(-1);
	else server=argv[optind];
	if (inet_addr(server) != INADDR_NONE)
		printf("%s",server);
	else{
		struct hostent *hp;
		if (timeout) {
			if (signal(SIGALRM, sig_alrm) == SIG_ERR)
				fprintf(stderr,"%s: %s\n",argv[0],strerror(errno)),
				exit(errno);
			if (setjmp(env) != 0)
				fprintf(stderr, "%s: time-out\n",argv[0]),exit(-2);
			alarm(timeout);
		}
		hp = gethostbyname(server);
		if (timeout)
			alarm(0);
		if (hp == NULL)
			{fprintf(stderr,"%s: ",argv[0]);
			herror("gethostbyname");exit(h_errno);}
		printf("%s", inet_ntoa(*((struct in_addr *) *hp->h_addr_list)));
	}
	return 0;
}
