/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
 * timer.c - create alarms and clocks
 * 
 * (C) 1998 Tano Fotang
 * 
 * This program is free software.
 * see the file COPYING for further information.
 */

#include "spx.h"
#include "timer.h"

Timer *aTimer=NULL;
short   timer_count=0;
#define TIMER_ALLOC 5

static void timer_alloc(void)
{
   int i;

   if (aTimer == NULL)
      aTimer = my_malloc(TIMER_ALLOC * sizeof(Timer));
   else
      aTimer = my_realloc(aTimer, (timer_count + TIMER_ALLOC) * sizeof(Timer));
   for (i = timer_count; i < timer_count + TIMER_ALLOC; i++)
      aTimer[i].type = -1;
   timer_count += TIMER_ALLOC;
}
int add_timer(Timer * t, void *data)
{
   register int i;

   if (aTimer == NULL)
      timer_alloc();
   do
   {
      for (i = 0; i < timer_count; i++)
	 if (aTimer[i].type == -1)
	 {
#if _GUILE
	    if (t->type == ALARM_SCM)
	       aTimer[i].cmd.scm = t->cmd.scm;
	    else
#endif
	       //if(t->type==ALARM_IN)
	       aTimer[i].cmd.cmd = strdup(t->cmd.cmd);
	    aTimer[i].type = t->type;
	    aTimer[i].flag = t->flag;
	    aTimer[i].ref = t->ref;
	    if (t->flag & TIMER_ALARM)
	       aTimer[i].expire.stop = time(NULL) + *((time_t *) data);
	    if (t->flag & TIMER_CLOCK)
	    {
	       aTimer[i].expire.date = (struct tm *) malloc(sizeof(struct tm));
	       memcpy(aTimer[i].expire.date, data, sizeof(struct tm));
	    }
	    return i;
	 }
      timer_alloc();
   }
   while (1);
}

void del_timer(int ref, char type, char flag)
{
   register int i;

   if (type == -1)
      return;
   for (i = 0; i < timer_count; i++)
      if (aTimer[i].ref == ref && aTimer[i].flag & flag && aTimer[i].type == type)
      {
	 if (aTimer[i].type == ALARM_IN)
	 {
	    free(aTimer[i].cmd.cmd);
	    aTimer[i].expire.stop = 0;
	 }
#if _GUILE
	 else if (aTimer[i].type == ALARM_SCM)
	    remove_func(aTimer[i].cmd.scm);
#endif
	 if (flag & TIMER_CLOCK)
	    free(aTimer[i].expire.date);
	 aTimer[i].type = -1;
      }
}
