/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/*
 *  user.c:     KICK, PART, JOIN, QUIT plus some user-specific procs
 *              declared in parser.h
 *  Author:     Tano Fotang, 1997
 */

#include "spx.h"
#include "nicks.h"
#include "nc.h"
#include "parser.h"
#include "mode.h"
#include "user.h"
#include "cmd.h"
#include "setting.h"
#include "ignore.h"
#include "hooks.h"
#include "server.h"
extern Winstruct *Win;
static int RemoveFromGlobalChanList(Server *, const char *);
extern int del_user(pChanUser * pp, const char *nick);
extern User *find_chanuser(Channel *ch,const char *nick);

void p_kick(void)
{
  char *sender,
      *kicker,
      *kicked,
      *channame,
      *reason;
  char *buf = NULL;
  int ll;

  sender = alloca(sizeof(char) * Len);
  reason = (char *) alloca(sizeof(char) * (Len));
  kicked = (char *) alloca(sizeof(char) * Len);
  channame = (char *) alloca(sizeof(char) * Len);

  *reason = 0;
  if (sscanf(Msg, "%*s KICK %s %s :%[^\n]\n", channame,
             kicked, reason) < 2)
    return;
  sscanf(Msg, "%s", sender);
  ll = strlen(sender) + 8;
  untilde(sender);
  kicker = (char *) alloca(sizeof(char) * ll);

  if (sscanf(sender, "%[^!]!%*s", kicker) < 1)
    strcpy(kicker, "<unknown>");

  if (!strcasecmp(Win->server->nick, kicked))
  {
    if (!ignored(sender, IG_MISC) &&
        !check_msg_hook(KICK, Win - winstruct,
                        "%s,%d %s %s %s %s",
                        Win->server->name,
                        Win->server->port,
                        sender, channame, kicked,
                        reason))
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("KICK", Msg, Win - winstruct, 1);
      else
      {
        char *login = (char *) alloca(sizeof(char) * ll);
        char *host = (char *) alloca(sizeof(char) * ll);

        if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) < 2)
        {
          strcpy(host, sender);
          strcpy(login, "<unknown>");
        }
        fmt_string = "%f%n%l%h%c%p$";
        buf = format_msg(fmt_you_kick, Win->server->name,
                         kicker, login, host, channame, reason);
        if (buf)
        {
          isay("KICK", buf, Win - winstruct, 1);
          free(buf);
        }
      }
    }
    buf = NULL;
    if (gflags & AUTO_REJOIN)
    {
      Channel *p = get_chan_byname(Win, channame);
      buf = (char *) malloc(sizeof(char) * (strlen(channame) + 128));

      sprintf(buf, "JOIN %s %s", channame, p && p->key ? p->key : "");
    }
    RemoveFromGlobalChanList(Win->server, channame);
    RemoveFromWinChanList(Win, channame);
    UpdateStatus(Win);
    if (buf)
    {
      process_cmd(buf, Win);
      free(buf);
    }
  }
  else
  {
    RemoveFromChanUsers(Win, channame, kicked);
    if (!ignored(sender, IG_MISC) &&
        !check_msg_hook(KICK, Win - winstruct,
                        "%s,%d %s %s %s %s",
                        Win->server->name,
                        Win->server->port,
                        sender, channame, kicked, reason))
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("KICK", Msg, Win - winstruct, 1);
      else
      {
        char *login = (char *) alloca(sizeof(char) * Len);
        char *host = (char *) alloca(sizeof(char) * Len);

        if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) < 2)
        {
          strcpy(host, sender);
          strcpy(login, "<unknown>");
        }
        fmt_string = "%f%n%l%h%c%p$";
        buf = format_msg(fmt_other_kick, kicked, kicker,
                         login, host, channame, reason);
        if (buf)
        {
          isay("KICK", buf, Win - winstruct, 1);
          free(buf);
        }
      }
    }

  }
}

void p_part(void)
{
  char *sender,
      *parted_nick,
      *chan;

  //int ll = strlen(Msg);
  int just_update = 1;

  sender = alloca(sizeof(char) * Len);

  sscanf(Msg, "%s", sender);
  untilde(sender);

  parted_nick = (char *) alloca(sizeof(char) * Len);

  if (sscanf(sender, "%[^!]!", parted_nick) < 1)
    return;
  chan = (char *) alloca(sizeof(char) * Len);

  if (sscanf(Msg, "%*s %*s %s", chan) < 1)
    return;
  if (!strcasecmp(parted_nick, Win->server->nick) ||
      !ignored(sender, IG_MISC))
    just_update = check_msg_hook(PART, Win - winstruct,
                                 "%s,%d %s %s",
                                 Win->server->name,
                                 Win->server->port,
                                 sender, chan);

  if (strcasecmp(parted_nick, Win->server->nick))
    RemoveFromChanUsers(Win, chan, parted_nick);
  else
  {
    RemoveFromGlobalChanList(Win->server, chan);
    RemoveFromWinChanList(Win, chan);
    UpdateStatus(Win);
  }
  if (just_update)
    return;
  if (gflags & SHOW_RAW_MSG)
  {
    isay0("MISC", Msg, Win - winstruct, 1);
    return;
  }
  if (strcasecmp(parted_nick, Win->server->nick))
  {
    char *buf,
        *login,
        *host;

    size_t ll = strlen(sender) + 8;
    login = (char *) alloca(sizeof(char) * ll);
    host = (char *) alloca(sizeof(char) * ll);

    *login = 0;
    *host = 0;
    if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) < 2)
    {
      if (*login == 0)
        strcpy(login, "<unknown>");
      if (*host == 0)
        strcpy(host, "<unknown>");
    }
    fmt_string = "%n%l%h%c$";
    buf = format_msg(fmt_other_part, parted_nick, login, host, chan);
    if (buf)
    {
      isay("MISC", buf, Win - winstruct, 1);
      free(buf);
    }
  }
  else
  {
    char *buf;

    fmt_string = "%f%c$";
    buf = format_msg(fmt_you_part, Win->server->name, chan);
    if (buf)
    {
      isay("MISC", buf, Win - winstruct, 1);
      free(buf);
    }
  }
}

void p_quit(void)
{
  char *sender,
      *nick;
  Channel *current;
  size_t ll;

  // ll = strlen(Msg);
  sender = alloca(sizeof(char) * Len);

  untilde(sender);

  sscanf(Msg, "%s", sender);
  ll = strlen(sender) + 8;
  nick = (char *) alloca(sizeof(char) * ll);

  sscanf(sender, "%[^!]!%*s", nick);

  current = Win->chanStart->right;
  while (current != Win->chanStart)
  {
    if (find_chanuser(current, nick))
      RemoveFromChanUsers(Win, current->name, nick);
    current = current->right;
  }
  if (!ignored(sender, IG_MISC))
  {
    char *reason;

    reason = (char *) alloca(sizeof(char) * (Len));

    if (sscanf(Msg, "%*s QUIT :%[^\n]\n", reason) < 1)
      *reason = 0;

    if (!check_msg_hook(QUIT, Win - winstruct, "%s,%d %s %s",
                        Win->server->name,
                        Win->server->port,
                        sender, reason))
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("QUIT", Msg, Win - winstruct, 1);
      else
      {
        char *buf;
        char *login,
            *host;
        login = (char *) alloca(sizeof(char) * ll);
        host = (char *) alloca(sizeof(char) * ll);

        *login = 0;
        *host = 0;
        if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) < 2)
        {
          if (*login == 0)
            strcpy(login, "<unknown>");
          if (*host == 0)
            strcpy(host, "<unknown>");
        }
        fmt_string = "%n%l%h%p$";
        buf = format_msg(fmt_signoff, nick, login, host, reason);
        if (buf)
        {
          isay("QUIT", buf, Win - winstruct, 1);
          free(buf);
        }
      }
    }
  }

}

static void addto_go(Winstruct *);
static int AddToGlobalChanList(Server * s, const char *chan);
static Channel *AddToWinChanList(Winstruct *, const char *channame);
static gChannel *search_gchanlist(const Server * s, const char *channame, int *found);

void p_join()
{
  char *sender,
      *joined_nick,
      *channel,
      *login,
      *host,
      *buf = NULL;
  size_t ll;

  channel = alloca(sizeof(char) * Len);

  if (sscanf(Msg, "%*s %*s :%s", channel) < 1)
    return;
  //   ircd 2.9.4 
  UNESCAPE(channel);
  if (*channel == 0)
    return;

  sender = malloc(sizeof(char) * (24 + Len));

  sscanf(Msg, "%s", sender);
  untilde(sender);
  ll = strlen(sender) + 8;
  joined_nick = (char *) alloca(sizeof(char) * ll);

  sscanf(sender, "%[^!]!", joined_nick);

  if (strcasecmp(joined_nick, Win->server->nick))
  {
    User *u = (User *) my_malloc(sizeof(User));
    int just_update;

    host = (char *) alloca(sizeof(char) * ll);
    login = (char *) alloca(sizeof(char) * ll);

    *host = *login = 0;

    if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) != 2)
    {
      if (*login == 0)
        strcpy(login, "<unknown>");
      if (*host == 0)
        strcpy(host, "<unknown>");
    }
    u->nick = joined_nick;
    u->address = (char *) malloc(sizeof(char) * (16 + ll));

    sprintf(u->address, "%s@%s", login, host);
    u->mode = "H";
    u->ircname = NULL;
    new_addto_chanusers(Win, channel, u);
    free(u->address);
    free(u);
    load_userlist(Win, channel, 1);
    just_update = check_msg_hook(JOIN, Win - winstruct,
                                 "%s,%d %s %s",
                                 Win->server->name,
                                 Win->server->port,
                                 sender, channel);
    if (!ignored(sender, IG_MISC) && !just_update)
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("MISC", Msg, Win - winstruct, 1);
      else
      {
        fmt_string = "%n%l%h%c$";
        buf = format_msg(fmt_other_join, joined_nick, login, host, channel);
        if (buf)
        {
          isay("MISC", buf, Win - winstruct, 1);
          free(buf);
        }
      }
    }
    free(sender);
  }
  else
  {
    if (X == 1)
      getwinbycmd(Win->server, "JOIN", channel, 1);	/* hasnt been removed yet */
    AddToGlobalChanList(Win->server, channel);
    Win->chanCur = AddToWinChanList(Win, channel);
    assert(get_chan_byname(Win, channel));
    Win->lastJoin->name = Win->chanCur->name;
    Win->lastJoin->key = Win->chanCur->key;

    addto_go(Win);

    buf = (char *) malloc(sizeof(char) * (strlen(channel) + 16));

    sprintf(buf, "WHO %s\n", channel);
    addto_cmd_sent(Win, "WHO_UPDATE", channel);
    sendto_server(Win, buf);
    sprintf(buf, "MODE %s\n", channel);
    sendto_server(Win, buf);
    free(buf);
    load_userlist(Win, Win->chanCur->name, 1);
    if (!TO_CHANNEL(Win))
      TRIGGER_OBJECT(Win->chanwin->r_channel);
    UpdateStatus(Win);
    if (!check_msg_hook(JOIN, Win - winstruct,
                        "%s,%d %s %s",
                        Win->server->name,
                        Win->server->port,
                        sender, channel))
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("MISC", Msg, Win - winstruct, 1);
      else
      {
        fmt_string = "%f%n%h%c$";
        buf = format_msg(fmt_you_join,
                         Win->server->name,
                         joined_nick,
                         sender, channel);
        if (buf)
        {
          isay("MISC", buf, Win - winstruct, 1);
          free(buf);
        }
      }
    }
    free(sender);
  }

}

void p_nick(void)
{

  char *sender,
      *nick,
      *newnick,
      *buf = NULL;
  Channel *current;

  //size_t ll;
  int just_update;

  newnick = (char *) alloca(sizeof(char) * Len);

  if (sscanf(Msg, "%*s NICK :%[^\n]\n", newnick) < 1)
    return;

  sender = alloca(sizeof(char) * Len);

  sscanf(Msg, "%s", sender);
  untilde(sender);
  nick = (char *) alloca(sizeof(char) * Len);

  sscanf(sender, "%[^!]!", nick);

  if (!strcasecmp(nick, Win->server->nick))
  {
    just_update = check_msg_hook(NICK, Win - winstruct,
                                 "%s,%d %s %s",
                                 Win->server->name,
                                 Win->server->port,
                                 sender, newnick);
    if (!just_update)
    {
      if (gflags & SHOW_RAW_MSG)
        isay0("MISC", Msg, Win - winstruct, 1);
      else
      {
        fmt_string = "%f%n%p$";
        buf = format_msg(fmt_you_nick, Win->server->name,
                         nick, newnick);
        if (buf)
        {
          isay("MISC", buf, Win - winstruct, 1);
          free(buf);
        }
      }
    }                           /*   if(!just_update)   */
    Win->server->nick = strdup(newnick);
    aNickList[Win->server->iNick].current =
       add_nick_to_list(Win->server->iNick, newnick);
    update_server_stuff(Win->server->fd);
    if (server_tool)
      redraw_server_entry(Win->server->g);
  }
  else if (!ignored(sender, IG_MISC) &&
           !check_msg_hook(NICK, Win - winstruct,
                           "%s,%d %s %s",
                           Win->server->name,
                           Win->server->port,
                           sender, newnick))
  {
    if (gflags & SHOW_RAW_MSG)
      isay0("MISC", Msg, Win - winstruct, 1);
    else
    {
      char *host,
          *login;
      int ll;

      ll = strlen(sender);
      host = (char *) alloca(sizeof(char) * ll);
      login = (char *) alloca(sizeof(char) * ll);

      *host = *login = 0;

      if (sscanf(sender, "%*[^!]!%[^@]@%s", login, host) != 2)
      {
        if (*login == 0)
          strcpy(login, "<unknown>");
        if (*host == 0)
          strcpy(host, "<unknown>");
      }
      fmt_string = "%n%l%h%p$";
      buf = format_msg(fmt_other_nick, nick, login, host, newnick);
      if (buf)
      {
        isay("MISC", buf, Win - winstruct, 1);
        free(buf);
      }
    }
  }
  current = Win->chanStart->right;
  while (current != Win->chanStart)
  {
    if (find_chanuser(current, nick))
      RenameChanUser(Win, current->name, nick, newnick);
    current = current->right;
  }
}

void load_userlist(Winstruct * win,
                   const char *channame,
                   int do_cur_chan)
{
  /* do_cur_chan: continue only if channame is same as choice text 
   * channame can be NULL
   */

  if (!win
#if USE_XFORMS
      || !win->chanwin->chanusers->u_vdata
#endif
     )
    return;
  if (win->chanStart == win->chanCur)
  {
#if USE_XFORMS
    fl_clear_browser(((FD_chanusers *) win->chanwin->chanusers->u_vdata)->browser);
#elif USE_GTK
    gtk_clist_clear(GTK_CLIST(win->chanwin->chanusers.clist));
#endif
  }
  else
  {
    User *u;
    Channel *chan;

#if USE_XFORMS
    char buf[256];
    FD_chanusers *f = (FD_chanusers *) win->chanwin->chanusers->u_vdata;
    char *channel = (char *) fl_get_choice_text(f->channel);

#elif USE_GTK
    char *s[4];
    char *channel;

    channel = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(win->chanwin->chanusers.channel)->entry));
    if (*channel == 0)
      channel = 0;
#endif
    chan = channame ? get_chan_byname(win, channame) : win->chanCur;
    if (!chan || (do_cur_chan && (!channel || strcasecmp(channel, channame))))
      return;
    u = chan->userStart;
#if USE_XFORMS
    fl_freeze_form(f->chanusers);
    fl_clear_browser(f->browser);
#elif USE_GTK
    gtk_clist_freeze(GTK_CLIST(win->chanwin->chanusers.clist));
    gtk_clist_clear(GTK_CLIST(win->chanwin->chanusers.clist));
#endif
    while (u != chan->userEnd)
    {
#if USE_XFORMS
      sprintf(buf, "@f%-*.*s %-4s %s (%s)", MaxNickLen + 2, MaxNickLen,
              u->nick, u->mode, u->address,
              u->ircname ? u->ircname : "(try update?)");
      fl_addto_browser(f->browser, buf);
#elif USE_GTK

      s[0] = u->nick;
      s[1] = u->mode;
      s[2] = u->address;
      s[3] = u->ircname ? u->ircname : "(try update?)";
      gtk_clist_append(GTK_CLIST(win->chanwin->chanusers.clist), s);
#endif
      u = u->next;
    }
#if USE_XFORMS
    fl_unfreeze_form(f->chanusers);
    fl_set_choice_text(f->channel, chan->name);
#elif USE_GTK
    gtk_clist_thaw(GTK_CLIST(win->chanwin->chanusers.clist));
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(win->chanwin->chanusers.channel)->entry),
                       chan->name);
#endif
  }
}
extern void recreate_chanusers_channels(Winstruct * win)
{
/*
   recreate choice items   
 */

#if USE_GTK
  GList *list = NULL;
#endif
#if USE_XFORMS
  if (win->chanwin->chanusers->u_vdata)
#endif
  {
    Channel *chan;

#if USE_XFORMS
    fl_clear_choice(((FD_chanusers *) win->chanwin->chanusers->u_vdata)->channel);
#elif USE_GTK
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(win->chanwin->chanusers.channel)->entry), "");
#endif
    chan = win->chanStart->left;
    while (chan != win->chanStart)
    {
#if USE_XFORMS
      fl_addto_choice(((FD_chanusers *) win->chanwin->chanusers->u_vdata)->channel,
                      chan->name);
#elif USE_GTK
      list = g_list_append(list, chan->name);
#endif
      chan = chan->left;
    }
#if USE_GTK
    if (list)
      gtk_combo_set_popdown_strings(GTK_COMBO(win->chanwin->chanusers.channel), list);
    else
      gtk_list_clear_items(GTK_LIST(GTK_COMBO(win->chanwin->chanusers.channel)->list),
                           0, -1);
#endif
  }
}

Channel *get_chan_byname(const Winstruct * win, const char *name)
{
  Channel *current;

  /*assert(name && win); */
  current = win->chanStart->right;
  while (current != win->chanStart)
  {
    if (!strcasecmp(current->name, name))
    {
      return current;
    }
    else
    {
      current = current->right;
    }
  }
  return NULL;

}


#if USE_GTK
extern void go_menu_cb(GtkWidget *, gpointer data);
#endif
void go_menu_setup(Winstruct * win)
/* rebuild Go menu */
{
  Go *q = win->goStart;

#if USE_XFORMS
  int p;

  if (win->chanwin->go_menu->u_ldata != -1)
    fl_freepup(win->chanwin->go_menu->u_ldata);
retry:
  p = fl_newpup(FL_ObjWin(win->chanwin->go_menu));
  if (p == -1)
  {
    inc_pup_max();
    goto retry;
  }
  fl_setpup_shadow(p, 0);

  fl_setpup_cursor(p, XC_right_ptr);
  fl_setpup_bw(p, -1);
#elif USE_GTK
  char *buf;

  q = win->goStart;
  q = win->goStart;
  while (q != win->goEnd)
  {
    buf = malloc(sizeof(char) * (5 + strlen(q->name)));

    sprintf(buf, "/Go/%s", q->name);
    gtk_item_factory_delete_item(win->chanwin->ifactory, buf);
    free(buf);
    q = q->next;
  }

#endif
  q = win->goStart;
  while (q != win->goEnd)
  {
#if USE_XFORMS
    fl_addtopup(p, q->name);
#elif USE_GTK
#warning <mi> is not freed when entry is removed. this is a memory leak.
    Go_menu_info *mi = my_malloc(sizeof(Go_menu_info));
    GtkItemFactoryEntry *f = g_malloc(sizeof(GtkItemFactoryEntry));

    mi->w = win - winstruct;
    mi->s = q->name;
    buf = malloc(sizeof(char) * (5 + strlen(q->name)));

    sprintf(buf, "/Go/%s", q->name);
    f->path = buf;
    f->accelerator = 0;
    f->callback = go_menu_cb;
    f->callback_action = (long) mi;
    f->item_type = 0;
    gtk_item_factory_create_item(win->chanwin->ifactory, f, 0, 1);
    free(buf);
#endif
    q = q->next;
  }
#if USE_XFORMS
  fl_set_menu_popup(win->chanwin->go_menu, p);
  win->chanwin->go_menu->u_ldata = p;
#endif
}

static void addto_go(Winstruct * win)
{
  Go *p;
  int gone;

#if USE_XFORMS
  gone = win->chanwin->status->u_ldata;
#elif USE_GTK
  gone = (int) gtk_object_get_data(GTK_OBJECT(win->chanwin->status), "gone");
#endif

  if (win->chanCur == win->chanStart)
    return;                     /* shldnt happen */
  p = win->goStart;
  while (p != win->goEnd)
    if (!strcasecmp(p->name, win->chanCur->name))
    {                           /*   raise it */
      Go *q;

      if (p == win->goStart || p == win->goStart->next)
        return;
      q = win->goStart->next;

      win->goStart->next = (Go *) my_malloc(sizeof(Go));
      win->goStart->next->name = strdup(win->chanCur->name);
      win->goStart->next->key = strdup2(win->chanCur->key);
      win->goStart->next->next = q;
      q = p->next;
      free(p->name);
      free(p->key);
      if (q == win->goEnd)
      {
        win->goEnd = p;
      }
      else
        *p = *q;

      free(q);

      go_menu_setup(win);
      return;
    }
    else
      p = p->next;
  if (gone + 1 > max_go)        /*  1 for #sula */
  {                             /*  remove last one in the list */
    Go *q = NULL;

    p = win->goStart->next;     /*skip sula */
    while (p != win->goEnd)
    {
      q = p;
      p = p->next;
    }
    if (q == NULL)
      return;
    q->next = p;
#if USE_GTK
    {
      char *buf = malloc(sizeof(char) * (5 + strlen(q->name)));

      sprintf(buf, "/Go/%s", q->name);
      gtk_item_factory_delete_item(win->chanwin->ifactory, buf);
      free(buf);
    }
#endif
    free(q->name);
    free(q->key);
    if (p == win->goEnd)
      win->goEnd = q;
    else
      *q = *p;
    free(p);
  }
  else
    gone++;
  p = win->goStart->next;
  win->goStart->next = (Go *) my_malloc(sizeof(Go));
  win->goStart->next->name = strdup(win->chanCur->name);
  win->goStart->next->key = strdup2(win->chanCur->key);
  win->goStart->next->next = p;
#if USE_XFORMS
  win->chanwin->status->u_ldata = (long) gone;
#elif USE_GTK
  gtk_object_set_data(GTK_OBJECT(win->chanwin->status), "gone", (gpointer) gone);
#endif
  go_menu_setup(win);
}

static int AddToGlobalChanList(Server * s, const char *channame)
{
/*
   add a channel to the global list of all channels
   Each server has an associated list of channels.    
 */

  gChannel *p,
      *q;
  int found;

  p = search_gchanlist(s, channame, &found);
  if (found)
    return 0;
  q = (gChannel *) my_malloc(sizeof(gChannel));
  if (p == chanEnd)
    chanEnd = q;
  else
    *q = *p;
  p->next = q;
  p->name = strdup(channame);
  p->server = strdup(s->name);
  p->port = s->port;
  return 0;
}
static gChannel *search_gchanlist(const Server * s, const char *channame, int *found)
{
/*
   search global channel list for a channel "channelname" which is on server
   s   
 */
  gChannel *p = chanStart;

  while (p != chanEnd)
    if (
         !strcasecmp(p->name, channame) &&
         !strcasecmp(p->server, s->name)
         &&
         s->port == p->port
       )
    {
      *found = 1;
      return p;
    }
    else
      p = p->next;

  *found = 0;
  return p;
}

static Channel *AddToWinChanList(Winstruct * win, const char *channame)
{
/*
   add a channel to the list of channels we're in on the window
   means we've just joined the channel   
 */
  Channel *p;

#if USE_GTK
  GtkWidget *list_item;
  GList *glist = NULL;
  GtkItemFactory *ifactory;
  GtkItemFactoryEntry *f;
  extern void chanwin_pup_cb(gpointer, guint, GtkWidget *);
  char *buf;
#endif
  p = (Channel *) my_malloc(sizeof(Channel));
  p->name = strdup(channame);
  p->modes = NULL;
  p->key = NULL;
  p->limit = 0;
  p->topic = NULL;
  p->flag = ch_DEFAULT_FLAG;
  p->userStart = p->userEnd = (User *) my_malloc(sizeof(User));
  /*for(i=0;i<UH_TABSIZE;i++)
    p->users[i]=NULL;*/
  /*memset(p->users, 0, sizeof(ChanUser *)*UH_TABSIZE);*/
  p->users=NULL;
  p->left = win->chanCur;
  p->right = win->chanCur->right;
  win->chanCur->right->left = p;
  win->chanCur->right = p;
#if USE_XFORMS
  if (win->chanwin->chanusers->u_vdata && win->chanStart != win->chanCur)
    fl_addto_choice(((FD_chanusers *) win->chanwin->chanusers->u_vdata)->channel,
                    channame);
#elif USE_GTK
  list_item = gtk_list_item_new_with_label(channame);
  glist = g_list_append(glist, list_item);
  gtk_widget_show(list_item);
  gtk_list_append_items(GTK_LIST(GTK_COMBO(win->chanwin->chanusers.channel)->list),
                        glist);
  hide_chanusers_channel(win, 0);
  ifactory = gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin), "popup");
  f = g_malloc(sizeof(GtkItemFactoryEntry));
  buf = malloc(sizeof(char) * (strlen(channame) + 9));

  sprintf(buf, "/Part/%s", channame);
  f->path = buf;
  f->accelerator = 0;
  f->callback = chanwin_pup_cb;
  f->callback_action = 101;
  f->item_type = 0;
  gtk_item_factory_create_item(ifactory, f, 0, 1);
  free(buf);
#endif
  return p;
}
#if 0
static int chanuser_hash( const char *nick)
{
 int i=0;
 char *s=strup(nick);
 register char *p;
 
 LOWERCASE(s);
 p=nick;
 while(*p)
   i= (*p) + i* (++p-s);
 free(s);
 return i%UH_TABSIZE
}
static User *find_chanuser(Channel *c, const char *nick)
{
   int i;
   ChanUser *u;

   i=chanuser_hash(nick);
   u=c->users[i];
   while(u && strcasecmp(u->user->nick, nick))
     u=u->next;
   return u? u->user : NULL;
}
static void add_user_to_htab(Channel *c, User *u)
{
 ChanUser *p;
 int i=chanuser_hash(u->nick);
 p= c->users[i];
 c->users[i]=my_malloc(sizeof(ChanUser));
 c->users[i].user=u;
 c->users[i].next=p;
}
static void remove_user_from_htab(Channel *c, User *u)
{
  int i=chanuser_hash(u->nick);
  ChanUser *cu=c->users[i];
  ChanUser *prev=NULL;
  while(cu){
    if(cu->user==u)
    {
       if(prev)
         prev->next=cu->next;
       free(cu);
       cu=NULL;
       break;
    }
    prev=cu;
    cu=cu->next;
 }
}
#endif

static int insert_user(pChanUser * pp, User *u);

int new_addto_chanusers(Winstruct * win,
                               const char *channame,
                               User * u)
{
  Channel *chan;
  User *q;

  assert(u && channame && win);
  chan = get_chan_byname(win, channame);
  if (chan == NULL) //server or client bug
    return -1;
  if(u->ircname==NULL)
      chan->flag |= ch_UPDATE_USERS;

  q=find_chanuser(chan, u->nick);
  if (q)
  {                             /*found; update just ircname */
    free(q->ircname);
    q->ircname = strdup2(u->ircname);
    free(q->mode);
    q->mode = strdup2(u->mode);
  }
  else{
  q = chan->userStart;
  chan->userStart = (User *) my_malloc(sizeof(User));
  chan->userStart->nick = strdup(u->nick);
  chan->userStart->address = strdup(u->address);
  chan->userStart->ircname = strdup2(u->ircname);
  chan->userStart->mode = strdup2(u->mode);
  chan->userStart->next = q;
  insert_user(&chan->users, chan->userStart);
  }
  return 0;
}

void RenameChanUser(Winstruct * win, const char *channame,
                    const char *sender,
                    const char *newnick)
{
  Channel *chan;
  User *p;

  chan = get_chan_byname(win, channame);
  if (chan == NULL)             /* something is wrong;
                                   there shld be a channel if someone left it */
    return;
  p = find_chanuser(chan, sender);
  if (!p)
    return;                     /* user not on the list.. bug somewhere */
  free(p->nick);
  p->nick = strdup(newnick);
  load_userlist(win, channame, 1);
}

/*
 * someone has left a channel: kick, quit, part
 * 
 */

extern void RemoveFromChanUsers(Winstruct * win,
 const char *channame,
  const char *sender)
{
  Channel *chan;
  User *p;

  assert(sender && channame && win);
  chan = get_chan_byname(win, channame);
  if (chan == NULL)
    return;
  p = find_chanuser(chan, sender);
  if(p)
    {
      User *q = p->next;

      del_user(&chan->users, p->nick);
      free(p->nick);
      free(p->address);
      free(p->ircname);
      if (q == chan->userEnd)
        chan->userEnd = p;
      else
      {
        del_user(&chan->users, q->nick);
        *p = *q;
        insert_user(&chan->users, p);
      }
      free(q);
      load_userlist(win, channame, 1);
      return;
    }
}

static int RemoveFromGlobalChanList(Server * s, const char *channame)
{
/*
   remove a channel from the global list because we're no longer in the
   channel   
 */
  gChannel *p,
      *q;
  int found;

  assert(s && channame);
  /*
     see  RemoveFromWinChanList() below 
   */
  p = search_gchanlist(s, channame, &found);
  if (!found)
    return 0;                   /*  a bug-- see  RemoveFromWinChanList() */
  assert(p != chanEnd);
  free(p->name);
  free(p->server);
  q = p->next;
  if (q == chanEnd)
    chanEnd = p;
  else
    *p = *q;
  free(q);
  return 0;
}

extern int RemoveFromWinChanList(Winstruct * win, const char *channame)
{
/*
   rm a channel from the list of channels we're in on the window.
   means we've been kicked out of channel or left or something..   
 */
  Channel *p;
  User *u,
      *v;

  p = get_chan_byname(win, channame);
  if (p == NULL)
  {
    /*  channel window disappeared before PART reply from server */
    if(debug>3)
       fprintf(stderr, PROMPT "was on %s?", channame);
    return 0;
  }
  else
  {
#if USE_GTK
    GtkItemFactory *ifactory;
    /*GtkItemFactoryEntry *f;*/
    extern void chanwin_pup_cb(gpointer, guint, GtkWidget *);
    char *buf;

    ifactory = gtk_object_get_data(GTK_OBJECT(win->chanwin->chanwin),
                                   "popup");

#endif
    assert(p != win->chanStart);
    if (win->lastPart->name)
      free(win->lastPart->name);
    win->lastPart->name = strdup(p->name);
    if (win->lastPart->key)
      free(win->lastPart->key);
    win->lastPart->key = p->key ? strdup(p->key) : NULL;
    free(p->name);
    if (p->modes)
      free(p->modes);
    if (p->topic)
      free(p->topic);
    if (p->key)
      free(p->key);
    u = p->userStart;
    while (u != p->userEnd)
    {
      del_user(&p->users, u->nick);
      free(u->nick);
      free(u->address);
      free(u->ircname);
      free(u->mode);
      v = u->next;
      if (v == p->userEnd)
        p->userEnd = u;
      else
        *u = *v;
      free(v);
    }
    free(u);
    p->left->right = p->right;
    p->right->left = p->left;
    if (p == win->chanCur)
      win->chanCur = p->left;   /*or use right if u are left-handed! */
    if (win->lastJoin->name == p->name)
    {
      if (p->left == win->chanStart)
        win->lastJoin->name = NULL;
      else
        win->lastJoin->name = p->left->name;
    }
    free(p);
    if (win->chanCur == win->chanStart)
      win->chanCur = win->chanStart->right;
    if (win->chanStart->right == win->chanStart)
    {
      fit_object_label(win->chanwin->WinStatusLine,
                       "-- no more channels --");
      TRIGGER_OBJECT(win->chanwin->r_echo);
#if USE_GTK
      hide_chanusers_channel(win, 1);
#endif
    }
#if USE_GTK
    buf = malloc(sizeof(char) * (strlen(channame) + 9));

    sprintf(buf, "/Part/%s", channame);
    gtk_item_factory_delete_item(ifactory, buf);
    free(buf);
#endif
  }
  recreate_chanusers_channels(win);
  load_userlist(win, NULL, 0);
  return 0;
}

static void user_left_rotate(pChanUser * pp)
{
  pChanUser p = *pp,
       r;

  *pp = r = p->right;
  p->right = r->left;
  r->left = p;
  p->bf--;
  if (r->bf > 0)
    p->bf -= r->bf;
  r->bf--;
  if (p->bf < 0)
    r->bf += p->bf;
}

static void user_right_rotate(pChanUser * pp)
{
  pChanUser p = *pp,
       l;

  *pp = l = p->left;
  p->left = l->right;
  l->right = p;
  p->bf++;
  if (l->bf < 0)
    p->bf -= l->bf;
  l->bf++;
  if (p->bf > 0)
    l->bf += p->bf;
}

User *find_chanuser(Channel *ch,const char *nick)
{
  int c;

  ChanUser * p=ch->users;
  while (p)
  {
    c = strcasecmp(nick, p->user->nick);
    if (c == 0)
      return p->user;
    else if (c < 0)
      p = p->left;
    else
      p = p->right;
  }
  return NULL;
}
static int insert_user(pChanUser * pp, User *u)
{
  int dH = 0;
  pChanUser p = *pp;

  if (p == NULL)
  {

    *pp = p = my_malloc(sizeof(ChanUser));
    p->user = u;
    p->bf = 0;
    p->left = p->right = NULL;
    dH = 1;
  }
  else
  {
    int tt = strcasecmp(u->nick, p->user->nick);

    if (tt > 0)
    {
      if (insert_user(&p->right, u))
      {
        p->bf++;
        if (p->bf == 1)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            user_right_rotate(&p->right);
          user_left_rotate(pp);
        }
      }
    }
    else if (tt < 0)
    {
      if (insert_user(&p->left, u))
      {
        p->bf--;
        if (p->bf == -1)
          dH = 1;
        else if (p->bf == -2)
        {
          if (p->left->bf == 1)
            user_left_rotate(&p->left);
          user_right_rotate(pp);
        }
      }
    }
  }
  return dH;
}

int del_user(pChanUser * pp, const char *nick)
{
  pChanUser p = *pp,
      *q;
  int dH = 0;
  int tt;

  if (!p)
    return 0;
  if ((tt = strcasecmp(nick, p->user->nick)) < 0)
  {
    if (del_user(&p->left, nick))
    {
      p->bf++;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == 2)
      {
        if (p->right->bf == -1)
          user_right_rotate(&p->right);
        user_left_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else if ((tt > 0))
  {
    if (del_user(&p->right, nick))
    {
      p->bf--;
      if (p->bf == 0)
        dH = 1;
      else if (p->bf == -2)
      {
        if (p->left->bf == 1)
          user_left_rotate(&p->left);
        user_right_rotate(pp);
        if (p->bf == 0)
          dH = 1;
      }
    }
  }
  else
  {
    if (p->right == NULL)
    {
      *pp = p->left;
      free(p);
      p = NULL;
      return 1;
    }
    else if (p->left == NULL)
    {
      *pp = p->right;
      free(p);
      p = NULL;
      return 1;
    }
    else
    {
      ChanUser *foo = my_malloc(sizeof(ChanUser));
      struct TChanUser *left,
          *right;

      memcpy((void *) foo, p, sizeof(ChanUser));

      q = &p->left;
      while ((*q)->right != NULL)
        q = &(*q)->right;

      left = p->left;
      right = p->right;
      memcpy((void *) p, (*q), sizeof(ChanUser));
      p->left = left;
      p->right = right;

      left = (*q)->left;
      right = (*q)->right;
      memcpy((void *) (*q), foo, sizeof(ChanUser));
      (*q)->left = left;
      (*q)->right = right;

      if (del_user(&p->left, foo->user->nick))
      {
        p->bf++;
        if (p->bf == 0)
          dH = 1;
        else if (p->bf == 2)
        {
          if (p->right->bf == -1)
            user_right_rotate(&p->right);
          user_left_rotate(pp);
          dH = 1;
        }
      }
      free(foo);
    }
  }
  return dH;
}

