/***************************************************
  This file is distributed as part of Sula PrimeriX
  (http://members.xoom.com/sprimerix).
****************************************************/


/* userhost.c       - the USERHOST command

   Author: Tano Fotang, 1999

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License , or
   (at your option) any later version.

 */

#include <fnmatch.h>
#include "spx.h"
#include "server.h"
#include "cmd.h"
#include "userhost.h"

/*
   THE USERHOST COMMAND 
 */
#define userhost_usage(w) \
do{  say( \
  "Usage: userhost <nickname> [<nickname> .. ] [-cmd <command>]",\
   (w),1);\
   return;}while(0)

Userhost_info *uh_start,
    *uh_end;
unsigned int uhost_timeout;

void userhost(char *args, int w)
{
  char *str = alloca(sizeof(char) * (strlen(args) + 12));
  Winstruct *win=w+winstruct;

  if (sscanf(args, "%*s %[^\n]", str) != 1)
    userhost_usage(w);
  else if(win->server->connecting){
      add_cmdoncon(CLI_CMD, args, win->server->name, win->server->port);
      return;
  }
  else
  {
    char *ptr;
    char *cmd,
        *nicks;

    cmd = NULL;
    ptr = strstr(str, " -");     /*  userhost nick nick -cmd ssssasa  */
    if (ptr)
    {
      char bla[5];
      int i = 0;

      *ptr = 0;
      ptr+=2;
      while (i < 4 && (bla[i++] = *ptr++));
      bla[i] = 0;
      if (strncasecmp(bla, "cmd", 3) || (bla[3] != ' ' && bla[3] != '\t'))
        userhost_usage(w);
      unspace(ptr);
      if (*ptr == 0)
        userhost_usage(w);
      cmd = ptr;
    }
    nicks = strdup(str);
    if (cmd)
    {
      int i = 0;
      Userhost_info *uh;

      ptr = nextword(nicks, i++);
      while (*ptr)
      {
        uh = uh_start;
        uh_start = malloc(sizeof(Userhost_info));
        uh_start->pattern = malloc(sizeof(char) * (strlen(nicks) +
                                           strlen(win->server->name) + 30));

        /*
           pattern := server,port sender nick + - usrname host 
         */
        sprintf(uh_start->pattern, "%s,%hu * %s *",
                win->server->name,
                win->server->port, ptr);
        uh_start->next = uh;
        uh_start->cmd = strdup(cmd);

        uh_start->t = time(NULL);
        free(ptr);
        ptr = nextword(nicks, i++);
      }
      free(ptr);
    }
    sprintf(str, "USERHOST %s\n", nicks);
    sendto_server(win, str);
    free(nicks);
  }
}

static void process_uhost(Userhost_info * uh,
                          const char *msg, short win)
{
  char *buf = expand_quote(uh->cmd, msg, win);

  if (buf)
  {
    if (*buf)
      new_process_cmd(buf, win);
    free(buf);
  }
}

static void rm_uhost(Userhost_info ** uh, Userhost_info ** end)
{
  Userhost_info *q = (*uh)->next;

  free((*uh)->cmd);
  free((*uh)->pattern);
  if (q == *end)
    *end = (*uh);
  else
    **(uh) = *q;
  free(q);
}
int check_userhost(int w, const char *str)
{
  if (uh_start == uh_end)
    return 0;
  else
  {
    char stop = 0;

    Userhost_info *p = uh_start;

    while (p != uh_end)
    {
      if (!fnmatch(p->pattern, str, FNM_PATHNAME | FNM_PERIOD))
      {
        process_uhost(p, str, w);
        rm_uhost(&p, &uh_end);
        stop = 1;
      }
      else
        p = p->next;
    }
    return stop;
  }
}
