;; Testing Notify procedures
;; create, occupy and destroy
(gs-echo "@itesting NOTIFY...")

(let((name_count 30)
  (group_count 10)
  (person "nick")
  (name "testing")
  (logging (gs-set? 'logging)))
  (gs-echo "Setting logging off")
  (gs-set! 'logging #f)
  (define (edit_groups how) ;; add or remove names froma group
    (define j 0)
    (while(< j group_count)
      (let((i 0))
        (while(< i name_count)
          (begin
            (define group-id (gs-notify-name->id (s-print name j)))
            (define nickname (s-print person i))
            (if(not(eqv? #f group-id))
              (if(eqv? 'add how)
                (gs-add-to-notify-group group-id nickname)
                (gs-delete-from-notify-group group-id nickname)))
            (set! i (+ i 1)))))
      (set! j (+ j 1))))
  (gs-exec "notify --list" -1) ;;(gs-list-notify-groups)
  (gs-echo (s-print "@iCreating " group_count " notify groups..."))
  (let((i 0))
    (while(< i group_count)
      (begin
        (gs-create-notify-group (s-print name i))
        (set! i (+ i 1)))))
  (gs-echo (s-print "@iInserting " name_count " nicks into each..."))
  (edit_groups 'add)
  (gs-exec "notify --list" -1)
;  (sleep 5)
  (gs-echo "@i--Removing all names..")
  (edit_groups 'remove)
  (gs-echo (s-print "@iRemoving " group_count " notify groups..."))
  (let((i 0))
    (while(< i group_count)
      (begin
        (gs-delete-notify-group (gs-notify-name->id (s-print name i)))
        (set! i (+ i 1)))))
  (gs-exec "notify --list" -1) ;;(gs-list-notify-groups)
  (gs-echo "@i -- all done (?)--")
  (gs-echo "Resetting logging status")
  (gs-set! 'logging (= 1 logging)))
        
      
    
      
              
              
