/*
  Distributed as part of Sula PrimeriX, http://members.xoom.com/sprimerix.

  8/1999.

*/

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdlib.h>
#include <guile/gh.h>

static char loaded = 0;
static SCM proc_strstr(SCM _s1, SCM _s2)
{
  /* return start position of _s2 in _s1 */
  int n;
  char *s1 = gh_scm2newstr(_s1, &n);
  char *s2;
  char *p;
  SCM ret = SCM_BOOL_F;

  s2 = gh_scm2newstr(_s2, &n);
  p = strstr(s1, s2);
  if (p)
    ret = gh_long2scm(p - s1);
  free(s1);
  free(s2);
  return ret;
}
void init_string_util()
{
  if (loaded)
    return;
  loaded = 1;
  gh_new_procedure("strstr", proc_strstr, 2, 0, 0);

}
void scm_init_string_util_module()
{
  scm_register_module_xxx("string util", init_string_util);
}
