/***************************************************************************
**    xIrcError.cpp  $Revision: 1.8 $ - $Name: xIrc-2-2p1 $ 
**    Dialog box to display error messages
**
**    Copyright (C) 1997 1998 Joseph Croft <joe@croftj.net>
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include "xIrcErrorBox.h"

static int dbg = 0;

xIrcErrorBox::xIrcErrorBox(xWidgetResInfo *pPRes, QWidget *pParent,
                           const char *pName, QObject *pReceiver, 
                           char *pSlot, xIrcMessage *pMsg) :
            xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("errordialog"), 
                                                QString("ErrorDialog")),
                    pParent, pName)
{  
   char buff[512];
   
   if (dbg) fprintf(stdout, "xIrcErrorBox::xIrcErrorBox():Enter\n\r");
   if (dbg) fflush(stdout);
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);

   rspCode = pMsg->rspCode;
   setCaption("Error");
//   setFont(QFont("helvetica", 12, QFont::Bold));
   pLabel = new QLabel(this);
   pLabel->setFont(font());
   pLabel->setAlignment(AlignCenter);
   pLabel->setFrameStyle(QFrame::Panel | QFrame::Raised);
   sprintf(buff, "%d : %s", pMsg->rspCode, 
           (const char *)pMsg->msgStr);
   pLabel->setText(buff);
   pLabel->adjustSize();
   if (dbg) fprintf(stdout, "xIrcErrorBox::xIrcErrorBox():Creating buttonframe\n\r");
   if (dbg) fflush(stdout);
   pButton = new xPshBtnFrame(wdtRes, this);
   pButton->setAlignment(xALIGN_Horz);
   pButton->setFrameStyle(QFrame::Panel | QFrame::Raised);
   if (dbg) fprintf(stdout, "xIrcErrorBox::xIrcErrorBox():Adding button to button frame\n\r");
   if (dbg) fflush(stdout);
   pButton->addButton("OK", 0);
   if (dbg) fprintf(stdout, "xIrcErrorBox::xIrcErrorBox():Adding button frame to frame\n\r");
   if (dbg) fflush(stdout);
   addWidget(pLabel);
   addWidget(pButton);
   setMargins(0, 0);
   setWidgetSpacing(0);
   if (dbg) fprintf(stdout, "xIrcErrorBox::xIrcErrorBox():Fitting frame\n\r");
   if (dbg) fflush(stdout);
   initFrame();
   connect(this, SIGNAL(acknowledged(int)), pReceiver, pSlot);
   connect(pButton, SIGNAL(clicked(int)), this, SLOT(buttonClicked()));
   if (dbg) fprintf(stdout, "xIrcErrorBox::xIrcErrorBox():Exit\n\r");
   if (dbg) fflush(stdout);
}

void xIrcErrorBox::buttonClicked()
{
   if (dbg) fprintf(stdout, "xIrcErrorBox::~xIrcErrorBox():Enter\n\r");
   if (dbg) fflush(stdout);
   emit acknowledged(rspCode);
   delete this;
};

#include "xIrcErrorBox.moc"
