/***************************************************************************
**    xIrcServerEdit.cpp  $Revision: 1.5 $ - $Name: xIrc-2-2p1 $ 
**    Server List Entry Edit Dialog
**
**    Copyright (C) 1997 1998 Joseph Croft <joe@croftj.net>
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <qstrlist.h>
#include "xIrcServerEdit.h"

static int dbg = 0;

xIrcServerEdit::xIrcServerEdit(xWidgetResInfo *pPRes, QWidget *pParent = NULL,
                                     const char *pName,
                                     xIrcServerEntry *entry = NULL) :
                   xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("serveredit"),
                                                              QString("ServerEdit")),
                           pParent, pName, TRUE)
{
   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Enter\n");
   if (dbg) fflush(stdout);

   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);
   setMargins(0, 0);
   setWidgetSpacing(0);

   pEntry = entry;   
   mainFrame->setAutoDelete(TRUE);
   setAlignment(xALIGN_Vert);

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Creating Frame\n");
   if (dbg) fflush(stdout);
   pFrame = new xFrame(wdtRes, this);
   pFrame->setAutoDelete(TRUE);
   pFrame->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pFrame->setAlignment(xALIGN_Vert);
   pFrame->setMargins(5, 5);
   pFrame->setWidgetSpacing(0);

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Creating Group Edit\n");
   if (dbg) fflush(stdout);
   pGroup = new xLineEdit(wdtRes, pFrame, "Group:");
   pGroup->setAlignment(xALIGN_Horz);
   pGroup->setEditWidth(15);
   pGroup->setMargins(0, 2);
   pGroup->setWidgetSpacing(0);
   pGroup->setText(entry->group());
   connect(pGroup, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   pFrame->addWidget(pGroup);

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Creating Country Edit\n");
   if (dbg) fflush(stdout);
   pCountry = new xLineEdit(wdtRes, pFrame, "Country:");
   pCountry->setAlignment(xALIGN_Horz);
   pCountry->setEditWidth(10);
   pCountry->setMargins(0, 2);
   pCountry->setWidgetSpacing(0);
   pCountry->setText(entry->country());
   connect(pCountry, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   pFrame->addWidget(pCountry);

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Creating State Edit\n");
   if (dbg) fflush(stdout);
   pState = new xLineEdit(wdtRes, pFrame, "State:");
   pState->setAlignment(xALIGN_Horz);
   pState->setEditWidth(10);
   pState->setMargins(0, 2);
   pState->setWidgetSpacing(0);
   pState->setText(entry->state());
   connect(pState, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   pFrame->addWidget(pState);

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Creating City Edit\n");
   if (dbg) fflush(stdout);
   pCity = new xLineEdit(wdtRes, pFrame, "City:");
   pCity->setAlignment(xALIGN_Horz);
   pCity->setEditWidth(25);
   pCity->setMargins(0, 2);
   pCity->setWidgetSpacing(0);
   pCity->setText(entry->city());
   connect(pCity, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   pFrame->addWidget(pCity);

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Creating Server Edit\n");
   if (dbg) fflush(stdout);
   pServer = new xLineEdit(wdtRes, pFrame, "Server:");
   pServer->setAlignment(xALIGN_Horz);
   pServer->setEditWidth(25);
   pServer->setMargins(0, 2);
   pServer->setWidgetSpacing(0);
   pServer->setText(entry->server());
   connect(pServer, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   pFrame->addWidget(pServer);

   pPort = new xLineEdit(wdtRes, pFrame, "Ports:");
   pPort->setAlignment(xALIGN_Horz);
   pPort->setEditWidth(25);
   pPort->setMargins(0, 2);
   pPort->setWidgetSpacing(0);
   pPort->setText(entry->ports());
   connect(pPort, SIGNAL(returnPressed()),
           this, SLOT(gotReturn()));
   pFrame->addWidget(pPort);

   pFrame->fitFrame();

   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Adding buttons\n");
   if (dbg) fflush(stdout);
   pButtons = new xPshBtnFrame(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->setAlignment(xALIGN_Horz);
   pButtons->addButton("Ok", Accepted);
   pButtons->addButton("Cancel", Rejected);
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(gotButton(int)));

   addWidget(pFrame);
   addWidget(pButtons);
   initFrame();
   if (dbg) fprintf(stdout, "xIrcServerEdit::xIrcServerEdit(): Enter\n");
   if (dbg) fflush(stdout);
}

xIrcServerEdit::~xIrcServerEdit()
{
}

void xIrcServerEdit::gotReturn()
{
   pEntry->setGroup(pGroup->text());
   pEntry->setCountry(pCountry->text());
   pEntry->setState(pState->text());
   pEntry->setCity(pCity->text());
   pEntry->setServer(pServer->text());
   pEntry->setPorts(pPort->text());
   done(Accepted);
}

void xIrcServerEdit::gotButton(int btn)
{
   switch (btn)
   {
      case Rejected:
         done(Rejected);
         break;

      case Accepted:
         gotReturn();
         break;
   }
}
#include "xIrcServerEdit.moc"
