package provide custom 1.63

proc set_command {myl wsock}  {
        global w
        global nick
       	do_custom_command $wsock $myl 
}
proc do_custom_command {wsock input} {

	global nick
	set found 0
	scan $input "%s" command
	set command [string tolower $command]
        set param [string range $input [string first $command $input] end ]
        set param [string trimleft $param $command]
        set param [string trimleft $param " "]

        set notfound [catch {do_$command $param $wsock} ]
	if $notfound {
		set found [do_command_alias $command $param]
        	if !$found { 
      			send_to_server $wsock ":$nick $command $param"
			
		}                                                                   
        }    	

}



proc do_command_alias {command param} {
	global aliaslist
	global nick
	global myuserhost
	global response

	set plist $param
	set command [string tolower $command]
	foreach com $aliaslist {
		set scom [lindex [split $com " "] 0]
		if ![string compare $scom $command] {
        		set com [string trim $com " " ]
			set com [join [lrange [split $com " "] 1 end] " " ]
        		set com [string trim $com " " ]

			set command $com
			action_exec $command $myuserhost "Alias" $plist
			return 1
		}

        }

	return 0

}


###################  IRC command descriptions follow

proc do_ignore {param wsock} {
# /ignore <hostmask> [,m|n|c|p]
	global ignore

	if [string compare $param ""] {

	set iglist [split $param ","]
	set iguser [lindex $iglist 0]
	set igtype [lindex $iglist 1]

	set x [string first "!" $iguser ]
	if $x==-1 { set iguser "$iguser*!*" }
	

	if ![string compare "" $igtype] {
		set igtype "cmnp"
	}

	set ignore [linsert $ignore end  "$iguser,$igtype" ]

	} else {
		foreach name $ignore {
			send_to_window server "Ignore: $name\n"
		}
	}
}


proc do_unignore {myl wsock} {

	global ignore
	set x [string first "!" $myl ]
	if $x==-1 { set myl "$myl*!*" }

	set thelist $ignore
	
	foreach name $ignore {
		set n [lindex [split $name ","] 0]
		if ![string compare $myl $n] {
			lremove $name
		}
	}	
	set ignore $thelist
}

proc do_alias {param wsock} {
	global aliaslist
	
	set alias [lindex [split $param " "] 0]

	if ![sNull $param] {
		set index [aliasindex $alias]
		if [expr $index >= 0] {
			set aliaslist [lreplace $aliaslist $index $index $param]
		} else {
			set aliaslist [linsert $aliaslist end $param]
		}

	} else {
		foreach alias $aliaslist {
			send_to_window server "Alias: $alias\n"
		}
	}
}


proc do_describe {param wsock} {
# /describe <nickname> <action>
	global nick

	if [string compare $param  ""] {

		scan $param "%s" to
		set param [string range $param [string first $to $param] end ]
        	set param [string trimleft $param $to]
        	set param [string trimleft $param " "]  
		
		send_to_window "server" "* To $to :$nick $param\n"
      		send_to_server $wsock ":$nick PRIVMSG $to :\001ACTION $param\001"

	}
	

}


proc do_kick {param wsock} {
# /kick #channel <user> [reason]


	global nick
	global response

	if [string compare $param  ""] {
		set parm [split $param " "]
		set parm1 [channel [lindex $parm 0] ]
		set parm2 [lindex $parm 1]

		set newlist [lrange $parm 2 end]
		set reason  [join $newlist " "]

		set output ":$nick KICK $parm1 $parm2 :$reason"
		send_to_server $wsock $output
	}


}


proc do_whois {param wsock} {


	send_to_server $wsock "WHOIS $param"

}
proc do_who {param wsock} {


	send_to_server $wsock "WHO $param"

}


proc do_server {param wsock} {
#/server <new server> [port]

	global nick
	global server
	global port
	global serveractive

	if [string compare $param ""] {
		
		set parm [split $param " "]
		set parm1 [lindex $parm 0]	
		set parm2 [lindex $parm 1]
		if [sNull $parm2] {
			set parm2 "6667"
		}

# Close server connection....
# Close all Channel windows but not Query windows
# Reconnect to new server 		
	if $serveractive {	
		send_to_server $wsock ":$nick QUIT :Changing Servers"
		close $wsock
		set serveractive 0
	}

		set list [.zipperserver.list get 0 end]	
		foreach chan $list {
			if ![string compare "#" [string index $chan 0] ] {
				destroy .zipperwin[winman $chan]
				remove_chan_list $chan
			}


		}

		set server $parm1
		set port   $parm2

		open_irc_connection

	}
}


proc do_quote {param wsock} {

	send_to_server $wsock "$param"

}

proc do_mode {param wsock } {
	global response

#	set parmlist [split $param " "]
#	set chan [channel [lindex $parmlist 0] ]
#	set mode [lindex $parmlist 1]
#	set who1 [lindex $parmlist 2]
#	set who2 [lindex $parmlist 3]
#	set who3 [lindex $parmlist 4]

	

#	send_to_server $wsock "MODE $chan $mode $who1 $who2 $who3"
	send_to_server $wsock "MODE $param"

}
proc do_topic {param wsock} {
global response
global nick

	  if [string compare $param  ""] {
                set parm [split $param " "]
                set parm1 [channel [lindex $parm 0] ]

                set newlist [lrange $parm 1 end]
                set reason  [join $newlist " "]


                set output ":$nick TOPIC $parm1 :$reason"
                send_to_server $wsock $output
        }       

}
proc do_names {param wsock} {

	set param [channel $param]	
	send_to_server $wsock "NAMES $param"

}


proc do_script {param wsock} {

	loadscript $param

}

proc do_save {param wsock} {
# /save <all|ctcp|events|alias|notify|ignore|channels|url|zipper>
 
	global rcdir
	global aliaslist
	global notify
	global eventlist
	global ctcp_message
	global channels
	global ignore
	global servers
	global userlist
	global urllist
	
	set ctcp 0
	set events 0
	set alias 0
	set noti 0
	set ign  0
	set chan 0
	set serv 0
	set usrs 0
	set url  0
	set zipper 0	
	
	if [string compare $param ""] {
		set param [string tolower $param]
		switch -exact $param {

		"all" 		{ set ctcp 1
				  set events 1
				  set alias 1
				  set noti 1
				  set ign  1
				  set chan 1
				  set serv 1
				  set usrs 1
				  set url 1
				  set zipper 1
				}
		"ctcp" 		{ set ctcp 1 }
		"events"	{ set events 1 }
		"alias"		{ set alias 1 }
		"notify"        { set noti 1 }
                "ignore"        { set ign 1 }
                "channels"      { set chan 1}
                "servers"       { set serv 1}
                "users"         { set usrs 1}
                "url"	        { set url 1}
                "zipper"        { set zipper 1}
                                          

		}	
		
		if $serv 	{ 
				set f [open "$rcdir/serverrc" w]	
				foreach item $servers {
					puts $f $item
				}
				close $f
				}
		if $chan 	{ 
				set f [open "$rcdir/channelsrc" w]	
				foreach item $channels {
					puts $f $item
				}
				close $f
				}
		if $ctcp 	{ 
				set f [open "$rcdir/ctcprc" w]	
				foreach item $ctcp_message {
					puts $f $item
				}
				close $f
				}
		if $events { 
				set f [open "$rcdir/eventsrc" w]	
				foreach item $eventlist {
					puts $f $item
				}
				close $f
		    	   }
		if $alias { 
				set f [open "$rcdir/aliasrc" w]	
				foreach item $aliaslist {
					puts $f $item
				}
				close $f
		    	   }
		if $noti { 
				set f [open "$rcdir/notifyrc" w]	
				foreach item $notify {
					puts $f $item
				}
				close $f
		    	   }
		if $ign { 
				set f [open "$rcdir/ignorerc" w]	
				foreach item $ignore {
					puts $f $item
				}
				close $f
			  }
		if $usrs { 
				set f [open "$rcdir/usersrc" w]	
				foreach item $userlist {
					puts $f $item
				}
				close $f
			  }
		if $url { 
				set f [open "$rcdir/urlrc" w]	
				foreach item $urllist {
					puts $f $item
				}
				close $f
			  }
		if $zipper {
				save_user_rc
			  }
	}


}


proc do_say {param wsock} {
# /say <#|#channel|nick> <message>
	global response
	
	if [string compare $param ""] {
		set parm [split $param " "]
		set parm1 [channel [lindex $parm 0] ]
		set parm2 [lrange $parm 1 end]
		fake_user_in "/msg $parm1 $parm2"
	}


}



#proc do_tclscript {param wsock} {
#/tclscript <scriptname> [plist]
#	set name [lindex [split $param] 0]
#	set plist [lrange $param 1 end]
#	set r [$name $plist]
#	fake_user_in "/echo $r"
#
#}

proc do_play {param wsock} {
#/play <Channel> <file> [rate]
	set chanl [channel [lindex [split $param] 0] ]
	set file [lindex [split $param] 1]
	set rate [lindex [split $param] 2]
	

}

proc do_source {param wsock} {

	source $param

}

proc do_exec {param wsock} {

#        set p(1) ""
#        set p(2) ""
#        set p(3) ""
#        set p(4) ""
#        set p(5) ""
#        set p(6) ""
#        set x 0
#        foreach parm $param {
#                incr x
#                set p($x) $parm
#        }
#  
#	set r [exec $p(1) $p(2) $p(3) $p(4) $p(5) $p(6) ]
	send_to_window server "[runpgm $param] \n"
}

proc do_ctcp {param wsock} {
#/ctcp <nick|#channel> <command string>
	global response
	
	if [string compare $param ""] {
		set parm [split $param " "]
		set parm1 [channel [lindex $parm 0] ]
		set parm2 [lindex $parm 1]		
		set parm2 [string toupper $parm2]
		
			
		set parm3 [lrange $parm 1 end]

		if ![string compare $parm2 "PING"] {
#get time in seconds top send for PING command
			set ztime [clock seconds] 
			fake_user_in "/msg $parm1 \001$parm2 $ztime\001"
				
		} else {
			fake_user_in "/msg $parm1 \001$parm3\001"
		}
	}

}


proc do_rctcp {param wsock} {
#/rctcp <nick> <reply string>
	global response
	if [string compare $param ""] {
		set parm [split $param " "]
		set parm1 [lindex $parm 0]	
			
		if ![string compare $parm1 "#"] {
			get_chan_name [focus]	
			set parm1 $response
		} 
	
		set parm2 [join [lrange $parm 1 end] " "]
			fake_user_in "/notice $parm1 \001$parm2\001"

	}

}

proc do_nick {param wsock} {


	send_to_server $wsock "NICK $param"
}

proc do_load {param wsock} {
# /load <all|ctcp|events|alias|notify|channels|users>

	global aliaslist
	global notify
#	global eventlist
	global ctcp_message
	global ignore
	global channels
	global servers
	global userlist

	set ctcp 0
	set events 0
	set alias 0
	set noti 0
	set ign 0
	set chan 0
	set serv 0	
	set usrs 0
	
	if [string compare $param ""] {
		set param [string tolower $param]
		switch -exact $param {

		"all" 		{ set ctcp 1
				  set events 1
				  set alias 1
				  set noti 1
				  set ign 1
				  set chan 1
				  set serv 1
				  set usrs 1
				}
		"ctcp" 		{ set ctcp 1 }
		"events"	{ set events 1 }
		"alias"		{ set alias 1 }
		"notify"        { set noti 1 } 
		"ignore"        { set ign 1 } 
		"channels"	{ set chan 1}
		"servers"	{ set serv 1}
		"users"		{ set usrs 1}

		}	
		
		if $ctcp 	{ init_ctcp_rec }
		if $serv 	{ init_servers }
		if $chan 	{ init_channels }
		if $events 	{ init_events }
		if $alias 	{ init_aliases }
		if $noti 	{ init_notify } 
		if $ign 	{ init_ignore } 
		if $usrs 	{ init_users } 

	}


}


proc do_tcl {param wsock} {

	set s [eval $param]

}


proc do_echo {param wsock} {
#/echo <message>

	send_to_window server "$param\n"
}

proc do_notify {param wsock} {
#/notify <nickname>
	global notify
	global esvrSock

	set newnotify ""	
	set remove 0
	if [string compare $param ""] {
		set sp [string tolower $param]
		foreach name $notify {
			if [string compare $sp [string tolower $name] ] {
				set newnotify [linsert $newnotify end $name]	
			} else {
				set remove 1
			}
					
		}
		if $remove { set notify $newnotify } else { set notify [linsert $notify end $param] }
	}
	send_to_server $esvrSock "ISON [join $notify " "] "

}

proc do_dcc {param wsock} {

	if [sNull $param] {
		fake_user_in "/echo usage: /dcc <chat|send> <nickname> [filename]"
		return
	}

	set type [string tolower [lindex [split $param " "] 0] ]
	set rest [lrange [split $param " "] 1 end]

	switch -exact -- $type {
		"chat" 	{do_chat $rest $wsock}
		"send"	{do_send $rest $wsock}
	}

}
proc do_send {param wsock} {
#/send <nickname> <filename>
	global ip
	global longip
	global nick
	global currdccdir
	global plat

	set dccbaseport [getport]
	set longip $ip
	encode_ip
	if [string compare $param ""] {

		set list [split $param]
		set target [lindex $list 0]
		set filename [lindex $list 1]
		if [sNull $filename] {
			set filename [choose_file "" $currdccdir "open"]
			if [sNull $filename] {
				return
			}
			set currdccdir [file dirname $filename]
		}
		if ![file exists $filename] {
			fake_user_in "/echo DCC Filename Does Not Exist--$filename"
			return
		}
		set filesize [file size $filename]
		if ![string compare $plat "unix"] {	
			exec dccsend.tcl 1 $target $filename $ip $dccbaseport $filesize "" &
		} else {
			exec wish dccsend.tcl 1 $target $filename $ip $dccbaseport $filesize " " &
		}
		fake_user_in "/ctcp $target DCC SEND [file tail $filename] $longip $dccbaseport $filesize"
		puts "/ctcp $target DCC SEND [file tail $filename] $longip $dccbaseport $filesize"
	}
}


proc do_chat {param wsock} {
#/chat <nickname>
	global ip
	global longip
	global nick

	set dccbaseport [getport]
	set longip $ip
	encode_ip
	if [string compare $param ""] {

		fake_user_in "/ctcp $param DCC CHAT chat $longip $dccbaseport"
		dccchat "start" $param 0 $dccbaseport
	}
}


proc do_disconnect {param wsock} {
	global serveractive


	# close all open channel windows
	set chanlist ""
	set chanlist [.zipperserver.list get 0 end]
	foreach item $chanlist {
		if [is_channel $item] {
			remove_chan_list $item
			destroy .zipperwin[winman $item]
		}

	}

	set serveractive 0
	close $wsock
	send_to_window server "Disconneted from server.\n"
	wm title .zipperserver "Zipper: Not Connected"
}

proc close_irc_connection {} {

	fake_user_in "/disconnect"
}
proc do_edit {param wsock} {
# /edit <all|ctcp|events|alias|notify>

	global rcdir
	global aliaslist
	global notify
	global eventlist
	global ctcp_message
	global userlist
	global ignore

	set ctcp 0
	set events 0
	set alias 0
	set noti 0
	set ign 0
	set usrs 0
	set strp 0	
	
	if [string compare $param ""] {
		set param [string tolower $param]
		switch -exact $param {

		"all" 		{ set ctcp 1
				  set events 1
				  set alias 1
				  set noti 1
				  set ign 1
				  set usrs 1
				  set strp 1
				}
		"ctcp" 		{ set ctcp 1 }
		"events"	{ set events 1 }
		"alias"		{ set alias 1 }
		"notify"        { set noti 1 } 
		"ignore"        { set ign 1 } 
		"users"      	{ set usrs 1 } 
		"startup"      	{ set strp 1 } 

		}	
		
		if $ctcp 	{ tked $rcdir/ctcprc
				  init_ctcp_rec }
		if $events 	{ tked $rcdir/eventsrc
			  	  init_events }
		if $alias 	{ tked "$rcdir/aliasrc"
				  init_aliases }
		if $noti 	{ tked $rcdir/notifyrc
				  init_notify } 
		if $ign 	{ tked $rcdir/ignorerc
				  init_ignore } 
		if $usrs 	{ tked $rcdir/usersrc
				  init_users } 
		if $strp 	{ tked $rcdir/startup.zipper }

	}


}

proc do_recycle {a b} {
#reload system files from disk
#used mainly by internal editing functions

#	fake_user_in "/echo Recycling System"

        init_user_rc
        init_ctcp_rec
        init_events
        init_aliases
        init_notify
        init_ignore
        init_channels
        init_servers
	init_stylecolors
	set_styles

}

proc do_query {myl wsock} {
        scan $myl "%s" w
	if ![string compare "" $w] {
	fake_user_in "/echo QUERY: No nickame given"
	return
	}
	set nw [string tolower $w]
        if ![string compare "dcc" [string range $nw 0 2] ] {
                wm deiconify .zipper$nw
                raise .zipper$nw
		focus .zipper$nw.entry

        } elseif [winfo exists ".zipperwin[winman $w]"] {
                wm deiconify .zipperwin[winman $w]
                raise .zipperwin[winman $w]
		focus .zipperwin[winman $w].entry
        } else {
          winmannew $w "$w" "priv" "0 $w"
          insert_chan_list [string tolower $w]
	  focus .zipperwin[winman $w].entry
          }

}
        
proc do_me {myl wsock} {

	do_action $myl $wsock
}             
proc do_action {myl wsock} {
	
	global actwin
	global chaninfo
	global chanrev
        global nick
	global actst
	global chef

	set win ".[lindex [split $actwin "."] 1]"
	set n $chaninfo($chanrev($win),nickchan)
	set type $chaninfo($chanrev($win),type)
	set sock $chaninfo($chanrev($win),socket)

	if $chef {
		set myl [exec chef.sh $myl]
	}
	if ![string compare $type "dcc"] {
		set win "dcc$sock"
        	send_to_window $win "$actst\* $nick $myl\n"
                send_to_dcc_server $sock "\001ACTION $myl\001"
	} else {
        	send_to_window $n "$actst\* $nick $myl\n"
        	send_to_server $sock ":$nick PRIVMSG $n :\001ACTION $myl\001"
        }


}

proc do_quit {myl wsock} {

        global nick
	closealllogs
        fake_user_in "/save all"
        set myl ":$nick QUIT :$myl"
        catch [ send_to_server $wsock $myl ]
        set eventLoop "done"
        destroy .
        exit
}
            

proc do_notice {myl wsock} {
        global nick
        scan $myl "%s" tonick
        set myl [string range $myl [string first $tonick $myl] end ]
        set myl [string trimleft $myl $tonick]
        set myl [string trimleft $myl " "]
        set myl ":$nick NOTICE $tonick :$myl"
        send_to_server $wsock $myl ;# send the data to the server^M
}


proc do_msg {myl wsock} {
        global nick
	global chef

        scan $myl "%s" tonick
        set myl [string range $myl [string first $tonick $myl] end ]
        set myl [string trimleft $myl $tonick]
        set myl [string trimleft $myl " "]

	if $chef { set myl [exec chef.sh $myl] 
	}

        if [string compare "\001" [string index $myl 0] ] {
        if [winfo exists .zipperwin[winman $tonick] ] {

                send_to_window $tonick "* $myl\n"

        } else {
                send_to_window "server" "** To: $tonick ** $myl\n"
        }
        }
        set myl ":$nick PRIVMSG $tonick :$myl"
        send_to_server $wsock $myl ;# send the data to the server^M
}

proc do_part {myl wsock} {
## Thanks to Tim Howe, Parting of a channel name mixed case does not always
## work.  The fix for this is located in util.tcl

	
	set myl [channel $myl]
	set myl ".zipperwin[winman $myl]"
	destroy $myl

#### When window is destroyed, kill_window is executed which takes care
#### of part channels and closing logs and that sort of thing

}

proc do_join {myl wsock} {

	set fr [string index $myl 0]
	if [string compare $fr "#"] {
		set myl "#$myl"
	}
        send_to_server $wsock "JOIN $myl" ;# send the data to the server^M
}
                                


proc do_list {myl wsock} {
# /list  match min max

	global listmatch

	set w ".zipperchannellist"
	
	if [winfo exists $w] {
		$w.channels.list delete 0 end
	}
	set listmatch $myl

	send_to_server $wsock "LIST"

}


proc do_set {myl wsock} {
# set <varname> <value>  -- sets a variable
# set 			 -- lists all variables
	global varlist

	if [sNull $myl] {
		foreach var $varlist {

			send_to_window server $var
		}
	} else {
	set var [lindex [split $myl " "] 0]
	set value [string trim [join [lrange [split $myl " "] 1 end] ]	" "]
	varset $var $value
	}

}
proc do_irccommand {myl wsock} {
	set multi [split $myl ";"]
	foreach l $multi {
		fake_user_in $l
	}
}


proc do_modify {in wsock} {
#/modify <servers|channels|notify|ctcp|events|users|ignore>
	
	set what [lindex [split $in " "] 0]
	
	switch -- $what {

	servers 	{modify_servers}
	channels 	{modify_channels}
	notify		{modify_notify}
	ctcp		{modify_ctcp}
	events		{modify_events}
	users		{modify_users}
	ignore		{modify_ignore}

	}

}


proc do_clone {l wsock} {
	global rcdir
	global allowsaverc

	set rc [lindex [split $l " "] 0]
	set as [lindex [split $l " "] 1]

	set dir $rcdir
	set als $allowsaverc

	if [string compare "" $rc] {set dir $rc}
	if [string compare "" $as] {set als $as}

	exec zipper $dir $als &

}



proc do_ban  {plist wsock} {
#/ban channel nick [type]
#where type is 1=nick ban only, 2=userhost ban, 3=host ban, 4=full site ban
global whoisvisible
global whoisuser

	set whoisuser ""
	set chan [lindex [split $plist " "] 0]
	set user [lindex [split $plist " "] 1]
	set type [lindex [split $plist " "] 2]

	if [sNull $chan] {
		return
	}
	if [sNull $user] {
		return
	}
	if [sNull $type] {
		set type "2"
	}
	set whoisvisible 0
	fake_user_in "/echo Looking up $user..."
	fake_user_in "/whois $user"
	tkwait variable whoisvisible
	if ![sNull $whoisuser] {
		set userhost [lindex [split $whoisuser "!"] 1]
		set host [lindex [split $whoisuser "@"] 1]
		set domain [join [lrange [split $whoisuser "."] 1 end] "."]
		switch $type {
			
			1	{fake_user_in "/mode $chan +b $user"}
			2	{fake_user_in "/mode $chan +b *!*$userhost"}
			3	{fake_user_in "/mode $chan +b *!*@*$host"}
			4	{fake_user_in "/mode $chan +b *!*@*$domain"}

		}
	}
}

proc do_chef {myl wsock} {
	global chef

	set onoff [lindex [split $myl " "] 0]

	if ![string compare $onoff "off"] {
		set chef 0 
		fake_user_in "/echo Encheferizer deactivated"
		return 
	}
	set chef 1
		fake_user_in "/echo Encheferizer activated"
	return



}

proc do_flood {myl wsock} {
	global flooddetectsecs
	global flooddetectlimit

	set lines [lindex [split $myl " "] 0]
	set secs [lindex [split $myl " "] 1]

	if [sNull $lines] {fake_user_in "/echo Flood Protection at $flooddetectlimit lines per $flooddetectsecs seconds." }	
	if [sNull $secs] {return}	
	
	set flooddetectlimit $lines
	set flooddetectsecs $secs

	fake_user_in "/echo Flood Protection Now at $lines lines per $secs seconds."
}


proc do_timer {myl wsock} {

	set ar [lindex [split $myl " "] 0]
	set num [lindex [split $myl " "] 1]
	set type [lindex [split $myl " "] 2]
	set interval [lindex [split $myl " "] 3]
	set action [join [lrange [split $myl " "] 4 end] " "]

	if [sNull $interval] {
		set interval 0
	}
	set time [clock seconds]
	set when [expr $time+$interval]

	if ![string compare $ar "add"] {
		add_timer $num "$type|$when|$interval|$action"
	} else {
		kill_timer $num
	}	
}


proc do_sound {myl wsock} {
# /sound sound [user/channel]
	global appdir
	global actwin

	set sf [lindex [split $myl " "] 0]
	set to [lindex [split $myl " "] 1]

	set wavdir [decodeappdir $sf $appdir]
	set sf [file join $wavdir $sf]
	if [sNull $to] {
			
		set to [get_chan_name $actwin]		
		if ![string compare $to "server"] {
			playsound [file join $wavdir $sf]
			return		
		}
	}
	fake_user_in "/ctcp $to SOUND $sf"
	playsound $sf	
}




