#!/bin/sh   
# the next line restarts using wish \
exec wish "$0" "$@" 


if ![string compare $tcl_platform(platform) "unix"] {
        set  installpath [exec where.tcl]
} else {
        tk_dialog .bgerror "NOTICE" "Multiplatform Support is Underway.\n
                             Some Functions May not be supported.\n
                             Package Index will have to be manually
                             Updated."  "info" 0 "Ok"
        set  installpath "CHANGE TO ZIPPER INSTALLED DIRECTORY"
}                                         

set auto_path "$auto_path $installpath"      

package require util 1.62

proc dotransfer {type host port file size } {
	global f
	global plat

	if ![string compare $plat "unix" ] {
		set f [open "|zdcc.tcl $type $host $port $file $size"]
	} else {
		set f [open "|tclsh zdcc.tcl $type $host $port $file $size"]
	}
	fileevent $f readable "handlemessage $f $size"

}


proc handlemessage {f size} {
	global per

	set l [gets $f]
	if [eof $f] {
		close $f
		return 
	}
	if ![string compare "DONE" [string range $l 0 3]] {
		destroy .
	}
	if ![string compare "XMSG" [string range $l 0 3]] {
		set input [string range $l 5 end]
		.dccxfer.msgs configure -text "$input : $per %"
		return 0
	}
	if ![string compare "XTRN" [string range $l 0 3]] {
		set input [string range $l 5 end]
		set per [expr int(double($input)/double($size)*100) ]
		setWidth $per 
		return 0
	}

}


proc createwin {name nick type} {
global f
global id
global event
wm withdraw .   
set w .dccxfer
catch {destroy $w}
toplevel $w
wm iconname $w "DCC:$name"
wm title $w "DCC:$name"
#positionWindow $w


label $w.stuff -text "$nick->$name" -width 40 -relief sunken
label $w.msgs -text "Waiting..." -width 40 -relief sunken
pack $w.stuff -side top
pack $w.msgs -side top
frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.close -text "X" -command { 	destroy .
					     	exit }
pack $w.buttons.close


frame $w.frame -borderwidth 10
pack $w.frame -side top -fill x

canvas $w.frame.canvas -width 250 -height 25 -bd 0 -highlightthickness 0
set id [$w.frame.canvas create rectangle 0 0 245 20 ]
set id [$w.frame.canvas create rectangle 0 0 1 1  -fill DeepSkyBlue3 ]
pack $w.frame.canvas -side top -expand yes -anchor s -fill x  -padx 15

#bind $w <Destroy> { destroy . ; exit }

}
proc setWidth {w} {
	global id
	set w [expr $w*2.45]	
	.dccxfer.frame.canvas coords $id 0 0 $w 20	
	update idletasks
}

proc error {msg} {
		.dccxfer.msgs configure -text "$msg"
}
proc bgerror {msg} {
		.dccxfer.msgs configure -text "$msg"
}



set type [lindex $argv 0]
set nick [lindex $argv 1]
set file [lindex $argv 2]
set host [lindex $argv 3]
set port [lindex $argv 4]
set size [lindex $argv 5]
set dccapplist [lindex $argv 6]

set event 0
set id ""
set per 0
if ![string compare "" $size] {
	set size 0
}
set byteorder $tcl_platform(byteOrder)
#puts $port
set f ""
set plat $tcl_platform(platform)
createwin $file $nick $type
dotransfer $type $host $port $file $size
tkwait window .dccxfer
catch {close $f}
if $type==0 {
	showfile $file $dccapplist
}
exit
