package provide fontman 1.63


proc newfont {} {

	font configure [.fm.names get active]  -family [.fm.listb get active] -size [.fm.size get] -weight [.fm.weight get active] -slant [.fm.slant get active]

}

proc fontman {} {

set families [list Courier Times Helvetica]
set weights [list normal bold]
set slants [list roman italic]

set fonts [font names]
if ![winfo exists .fm] {
toplevel .fm
wm title .fm "Font Manager"
label .fm.testl -text "Font Test Results" 
label .fm.test -text "AaBbCc  !#$%^&*  Hello" -font test
pack .fm.test -side bottom 
pack .fm.testl -side bottom 

listbox .fm.names -yscrollcommand ".fm.scroll set" -setgrid 1 -width 10 -height 4
scrollbar .fm.scroll -command ".fm.names yview"
pack .fm.names -side left
pack .fm.scroll -side left -fill y

button .fm.upd -text "Update" -command {newfont}
listbox .fm.listb -width 10 -height 4
pack .fm.listb -side left

label .fm.sizel -text "Size"
entry .fm.size -width 3

listbox .fm.slant -width 10 -height 4
pack .fm.slant -side left

listbox .fm.weight -width 10 -height 4
pack .fm.weight -side left


foreach item $fonts {
	.fm.names insert end $item
}
foreach item $families {
	.fm.listb insert end $item
}
foreach item $weights {
	.fm.weight insert end $item
}
foreach item $slants {
	.fm.slant insert end $item
}


pack .fm.upd -side bottom


pack .fm.sizel -side left
pack .fm.size -side left
}
}
