package provide inet 1.63

proc encodeip {ip} {

set lip 0
set c 0
set octetlist [split $ip "."]

foreach octet $octetlist {
	incr lip $octet
	incr c
	if $c<4 {
		set lip [expr $lip << 8 ]
	}

}
return [format "%u" $lip]

}


proc decodeip {lip} {

set nip 0

scan [format "%08x" $lip] "%2x%2x%2x%2x" ip4 ip3 ip2 ip1
return $ip4.$ip3.$ip2.$ip1

}

proc nop {} {
}

proc getport {} {
	set redo 1
	while {$redo} {		
		set testport [expr 1024+int(rand()*60000)]
		set redo [catch { set x [socket -server nop $testport] } ]
	}
	close $x
	return $testport
}

proc htonl {x} {
global byteorder
	if ![string compare "littleEndian" $byteorder ] {
		scan [format "%08x" $x] "%2x%2x%2x%2x" s4 s3 s2 s1 
		set s [expr $s1 << 24 | $s2 << 16 | $s3 << 8 | $s4 ]
		return $s
	} else {
		return $x
	}
}

proc ntohl {x} {
global byteorder

	if ![string compare "littleEndian" $byteorder ] {
		scan [format "%08x" $x] "%2x%2x%2x%2x" s4 s3 s2 s1 
		set s [expr $s1 << 24 | $s2 << 16 | $s3 << 8 | $s4 ]
		return $s

	} else {
		return $x
	}
}

