package provide server 1.63

proc do_command {orig command param} {
	

	set hostmask [get_userhost_from_hostmask $orig]

	if ![is_on_ignore $orig "cmnp" ] {
	if [update_flood_data $hostmask] {
		irc_event "FLOOD" "N/A" $orig "N/A"
	}
	}

        set thelist [split $param " "]
        set dest [lindex $thelist 0]


        switch -exact $command {

        "001"           -

        "002"           -

        "003"           -

        "004"           { rec_STARTUP $param }


        "303"           {rec_NOTIFY $orig $param}

        "311"           {rec_WHOISUSER $orig $param}
        "312"           {rec_WHOISSERVER $orig $param}
        "313"           {rec_WHOISOPERATOR $orig $param}
        "317"           {rec_WHOISIDLE $orig $param}
        "318"           {rec_WHOISENDOF $orig $param}
        "319"           {rec_WHOISCHANNELS $orig $param}

	"322"		{rec_LIST $orig $param}
        "324"           {rec_CHANMODE $orig $param}
	"329"		{rec_CHANNELDATE $orig $param}
        "332"           {rec_JOINTOPIC $orig $param}
	"333"		{rec_JOINTOPICBY $orig $param}
        "353"           {rec_CHANLIST $orig $param}

        "367"           {rec_BANLIST $orig $param $command}

        "377"           {rec_MOTD $orig $param}

        "433"           {rec_NICKINUSE }

        "DCC"           {rec_DCC $orig $param}

        "KICK"          {rec_KICK  $orig $param}

        "NICK"          {rec_NICK  $orig $param}

        "QUIT"          {rec_QUIT  $orig $param}

        "MODE"          { rec_MODE $orig $param}

        "JOIN"          { rec_JOIN $orig $param}

        "PART"          { rec_PART $orig $param}

        "PING"          { rec_PING $orig $param}                 

        "TOPIC"         {rec_TOPIC $orig $param}

        "NOTICE"        { rec_NOTICE $orig $param}

        "PRIVMSG"       { rec_PRIVMSG $orig $param}

        default         { rec_unknown $orig $command $param }
        }
}
    



proc read_sock {sock} {
global serveractive
if $serveractive {
  set l [gets $sock]
  if {[eof $sock]} {
        close $sock
        send_to_window server "IRC SERVER CONNECTION CLOSED!!\n\n"
#	.zipperserver.controls.connect configure -state normal
#        .zipperserver.controls.disconnect configure -state disabled
        send_to_window server "Disconneted from server.\n"
        wm title .zipperserver "Zipper: Not Connected"      
        close_irc_connection
	
  } else {
    grab_url $l
    handle_server_message $l
  }
}
}

proc handle_server_message {l} {
        global log
        global server
        global nick
	global currchan
        set orig ""
        set command ""

        if ![string compare ":" [string index $l 0] ] {
          scan $l "%s %s" orig command
          set orig [string trimleft $orig ":"]
        } else {
	  set orig $server
          scan $l "%s" command
        }
        set param [string range $l [string first $command $l] end ]
        set param [string trimleft $param $command]
        set param [string trimleft $param " :=@"]


#       set beforig $orig
#       set orig [string range $orig 0 [string first "!" $orig]]
#       set orig [string trimright $orig "!"]


#puts stdout $l
#puts $log $l
#flush $log
        do_command $orig $command $param


}                   

proc rec_NOTIFY {orig param} {
        global nick
	global notfst
	global actwin
	global isonlist
	global notifywindow

        set list [split [string trim [string range $param [string length $nick] end] " :"] ]
	set list [string tolower $list]

	set oldlist $isonlist
	set isonlist ""

	set list [lsort -command customsort $list]

	foreach name $oldlist {
		set name [string tolower $name]
		set x [lsearch -exact $list $name]
		if [expr $x<0] {
			send_to_window server "$notfst$name has left IRC"
			if [winfo exists $actwin] {
#				send_to_window [get_chan_name $actwin] "$notfst$name has left IRC"
			} 

		}

	}
        foreach name $list {
		set name [string tolower $name]
		set x [lsearch -exact $oldlist $name]
		if [expr $x<0] {
			send_to_window server "$notfst$name is on IRC"
			if [winfo exists $actwin] {
#				send_to_window [get_chan_name $actwin] "$notfst$name is on IRC"
			}	
		}
		irc_event "NOTIFY" "N/A" $name "N/A"
		lappend isonlist $name
        }
	if $notifywindow { update_notify $isonlist }
}


proc rec_NICKINUSE {} {

        global esvrSock
        global port
        global server
        global nick
        global altnick

         send_to_window server "Nickname <$nick> already in use \n\n"
         set nick $altnick
         wm title .zipperserver "Zipper: $nick on server $server port: $port"
         send_to_server $esvrSock "NICK $nick"
}


proc rec_CHANLIST {orig param} {
        extract_msg $param
        extract_msg $msg

        set win .zipperwin[winman $dest]
        if [ison $dest] {
                set names [split $msg]
                $win.list del 0 end
                set names [lsort -command customsort $names]

                foreach name $names {
                if [string compare "" $name] {
                $win.list insert end $name
                }       }
                send_to_window server "Users on $dest: $msg\n\n"
        } else {
                send_to_window server "Users on $dest: $msg\n\n"
        }

}    

proc rec_PRIVMSG {orig param} {
          global esvrSock
          global notify
          global server
          global nick
	  global actst

	  set longnick $orig
          get_shortnick $orig
          set frommsg "<$orig>"
          extract_msg $param
          if ![string compare [string tolower $dest] [string tolower $nick]] {
                rec_PERSONAL $orig $frommsg $msg $longnick $dest
          } elseif ![string compare $orig $server] {
            send_to_window server "$frommsg $msg\n\n"
          } else {
            if ![string compare "\x01" [string index $msg 0] ] {
		handle_ctcp $orig $msg $longnick $dest
		return
            }
        if [winfo exists ".zipperwin[winman $dest]"] {
            if [is_on_ignore $longnick "c" ] { return }
            send_to_window $dest "$frommsg $msg\n"
        } else {
            if [is_on_ignore $longnick "c" ] { return }
            send_to_window server "$dest/$frommsg $msg\n\n"

        }
            }

	irc_event CHANMSG $dest $longnick ""
}                          


proc rec_PERSONAL {orig frommsg msg longnick dest} {


        if [string compare "\x01" [string index $msg 0] ] {

        if [is_on_ignore $longnick "m" ] { return }

        if [winfo exists ".zipperwin[winman $orig]"] {
                send_to_window $orig "$frommsg $msg\n"
        } else {
          winmannew $orig "$orig" "priv" "1 $orig"
          insert_chan_list [string tolower $orig]
          send_to_window $orig "$frommsg $msg\n"
          set_chan_activity 1 $orig
          }
        } else {

                if [is_on_ignore $orig "p" ] { return }
                handle_ctcp $orig $msg $longnick $orig
        }
	irc_event PRIVMSG "" $longnick ""
}             




proc rec_NICK {orig param} {
        global esvrSock
        global notify
        global nick
        global server
        global port
	global modest
        set dest ""
        set msg ""


        get_shortnick $orig
        extract_msg $param
        send_to_window server "$modest$orig is now know as $dest\n\n"
        set chanlist [.zipperserver.list get 0 end]
        foreach channel $chanlist {
                set append ""
                set channel [string trimleft $channel "> "]
		if ![string compare [string tolower $channel] [string tolower $orig] ] {
			change_win_index $orig $dest
			wm title [winman2 $dest] "Private: $dest"
			wm iconname [winman2 $dest] "$dest"
			set ndest [string range $dest 0 10]
			.chanmenu.chanb1.w[winman $dest] configure -text $ndest -command "do_query $dest 0"
		}
		if [winfo exists .zipperwin[winman $channel].list ] {
                set nicklist [.zipperwin[winman $channel].list get 0 end]
                foreach nickname $nicklist {
                        if ![string compare [string tolower $orig] [string trimleft [string tolower $nickname] " @+" ] ] {
                                if ![string compare "@" [string range [string tolower $nickname] 0 0] ] {
                                        set append "@"
                                } elseif ![string compare "+" [string range [string tolower $nickname] 0 0] ] {
                                        set append "+"
                                }
                                send_to_window $channel "$modest\002$orig is now known as $dest\002\n"
                                remove_nick $channel $nickname
                                insert_nick $channel "$append$dest"
                        }
                }
		}
        }
        if [is_me $orig] {
                set nick $dest
                wm title .zipperserver "Zipper: $nick on server $server port: $port"
        }
	irc_event NICK All $dest NA


}                   


proc rec_QUIT {orig param} {
	global partst
        global esvrSock
        global notify
	set oldorig $orig
        get_shortnick $orig
        set param [string trimleft $param " :=@"]
        send_to_window server "$partst$orig has Quit IRC: $param\n\n"
        set chanlist [.zipperserver.list get 0 end]
        foreach channel $chanlist {
                set channel [string trimleft $channel "> "]
                if ![string match "DCC*" $channel] {
                if [winfo exists .zipperwin[winman $channel].list ] {
                set thelist [.zipperwin[winman $channel].list get 0 end]
                foreach nickname $thelist {
                        if ![string compare [string tolower $orig] [string tolower [string trimleft $nickname " >@+"] ] ] {
                                send_to_window $channel "$partst\002$orig has Quit IRC: $param\002\n"
                                remove_nick $channel $nickname
                        }
                }
                }
                }
        }
	irc_event QUIT All $oldorig NA

}
proc rec_JOIN {orig param} {
        global esvrSock
        global notify
        global joinst

        set plist [split $param " "]
        set chan [lindex $plist 0]
        set me $orig
        get_shortnick $orig
        set mme $orig
        set orig $me

        if [is_me $mme] {
        if [winfo exists .zipperwin[winman $chan]] {
                raise .zipperwin[winman $chan]
                focus .zipperwin[winman $chan].entry
                send_to_window $chan "$joinst\Now Talking on $chan\n"
        } else {
          winmannew $chan $chan "pub" "0 $chan"
          insert_chan_list $chan
          fake_user_in "/mode $chan"
          send_to_window $chan "Now Talking on $chan\n"
        }
        } else {
        insert_nick $chan $mme
        send_to_window $chan "$joinst\002[gfh $orig] has joined $chan\002\n"
	process_options $orig
        }
	irc_event  JOIN $chan $orig NA
}      


proc rec_PART {orig param} {
        global nick
        global esvrSock
        global notify
	global partst

        extract_msg $param
        get_shortnick $orig

        if ![is_me $orig] {
        send_to_window [string tolower $dest] "$partst\002$orig has left $dest \002\n"
        remove_nick [string tolower $dest] $orig
        } else {
        remove_chan_list $dest
        if [winfo exists .zipperwin[winman $dest]] {
		destroy .zipperwin[winman $dest]
	}
        }
	irc_event  PART $dest $orig NA
}

proc rec_NOTICE {orig param} {
        global esvrSock
        global notify
	global notcst
	global actwin

        if [is_on_ignore $orig "n" ] { return }
        extract_msg $param
        if [string compare "\001" [string index $msg 0] ] {
		set who [get_shortnick2 $orig]
#               send_to_window server "$notcst\--NOTICE from $orig $msg\--\n\n"
		send_to_window [get_chan_name $actwin] "$notcst\--NOTICE from $who $msg\--\n\n"
        } else {
                handle_ctcp_reply $orig $msg 
        }
}                 

proc rec_PING {orig param} {
        global nick
        global notify

        global esvrSock
        send_to_server $esvrSock "PONG :$param"
        send_to_server $esvrSock "ISON $notify"
}    



proc rec_KICK {orig param} {
	global kickst
	global nick
	global autorejoin
	scan $param "%s %s" chan target
        extract_msg $param
        get_shortnick $orig
        extract_msg $msg


        if ![is_me $target] {
        send_to_window [string tolower $chan] "$kickst$orig has kicked $target from $chan: ($msg)\n"
        remove_nick $chan $target
        } else {
		bind .zipperwin[winman $chan] <Destroy> {}
		destroy .zipperwin[winman $chan]
		kill_window .zipperwin[winman $chan]
		remove_chan_list $chan
		send_to_window server "You Were Kicked from $chan by $orig: ($msg)\n"
		if $autorejoin { fake_user_in "/join [string tolower $chan]" }
		}
	irc_event KICK $chan $orig $target
}

proc rec_MOTD {orig param} {
	global nick
	
	set param [string trim [string range $param [string length $nick] end] " :" ]
	send_to_window server "$param\n"

}

proc rec_unknown {orig command param} {
	
	set list [split $param " "]
	set list [lrange $list 1 end]
	set param [string trimleft [join $list " "] " @=:" ]
	send_to_window server "$command $param\n"

}


proc rec_STARTUP { param } {

	set param [string trimleft [string range $param [string first  ":" $param ] end] ":" ]
	send_to_window server "$param\n"

}

proc rec_WHOISUSER {orig param} {
	global whoisvisible
	global whoisuser
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set unick [lindex $list 0]
	set user [string trimleft [lindex $list 1] "~" ]
	set host [lindex $list 2]
	set realname [string range [join [lrange $list 4 end] ] 1 end]
	set whoisuser "$unick!$user@$host"

	if $whoisvisible {	
		send_to_window server "WHOIS for $unick:\n"
		send_to_window server "$unick: $user@$host\n"
		send_to_window server "$unick: $realname\n"
	}	
	
}
proc rec_WHOISSERVER {orig param} {
	global whoisvisible

	set list [split $param " "]

	set server [string trimleft [lindex $list 2] "~" ]
	set serverinfo [string trimleft [join [lrange $list 3 end] " "] ":"] 

	if $whoisvisible {	
		send_to_window server "[lindex $list 1]: Using $server, $serverinfo\n"
	}	

}
proc rec_WHOISOPERATOR {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set oper [string trimleft [lrange $list 1 end] ":"] 
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: is an IRC Operator. \n"
	}	

}
proc rec_WHOISIDLE {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set time [string trimleft [lindex $list 1] ]
	set signon [string trimleft [lindex $list 2] ]
	set serverinfo [string trimleft [lrange $list 2 end] ":"] 

	set time [secs_to_time $time]
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: Has been idle for $time.\n"
	}	

}
proc rec_WHOISENDOF {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set msg [string trimleft [lrange $list 1 end] ":"] 
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: $msg  \n"
	}	
	set whoisvisible 1

}
proc rec_WHOISCHANNELS {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set msg [string trim $msg " "]
	set list [split $msg " "]
	set msg [join [string trimleft [lrange $list 1 end] ":"]  " "]
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: $msg  \n"
	}	
	set whoisvisible 1
}


proc rec_JOINTOPIC {orig param} {
	set plist [split $param " "]
	set from  [lindex $plist 0]
	set chan  [lindex $plist 1]
	set win .zipperwin[winman $chan]
	set topic [string trimleft [join [lrange $plist 2 end] " "] ": "]
	if [winfo exists $win] {
		fake_user_in "/echo Topic for $chan: $topic"
		$win.labels.topic configure -text $topic
	}

}
proc rec_JOINTOPICBY {orig param} {
	set plist [split $param " "]
	set chan  [lindex $plist 1]
	set who  [lindex $plist 2]
	set when  [clock format [lindex $plist 3] ]

	fake_user_in "/echo Topic set by $who on $when"
	
}



proc rec_CHANMODE {orig param} {
	set plist [split $param " "]
	set from [lindex $plist 0]
	set chan  [lindex $plist 1]
	set modes [string trimleft [join [lrange $plist 2 end] " "] ":+ "]
	set win .zipperwin[winman $chan]

	if [winfo exists $win] {
		$win.labels.modes configure -state normal
		$win.labels.modes delete 0 end
		$win.labels.modes insert end $modes
		$win.labels.modes configure -state disabled
	}

}

proc rec_TOPIC {orig param} {


	set plist [split $param " "]
	set chan [lindex $plist 0]
	set topic [string trimleft [join [lrange $plist 1 end] " "] ": "]
	set win .zipperwin[winman $chan]
	set sorig [get_shortnick2 $orig]

	if [winfo exists $win] {
		$win.labels.topic configure -text $topic
		send_to_window $chan "\0033Topic changed by $sorig to: \002$topic\002"
	}
	irc_event TOPIC $chan $orig NA
}

proc rec_BANLIST {orig param command} {

	global bansvisible
	set w  .zipperbanlist

	if $bansvisible {
		send_to_window server "$param\n"
	}
	set chan [lindex [split $param " "] 1]
	if ![winfo exists $w] {
		create_banlist_window $chan
	} else {
		raise $w
		focus $w
	}
	set ban [lindex [split $param " "] 2]
	$w.bans.list insert end $ban
	

}


proc rec_LIST {orig param} {

	global listmatch

	set match [lindex [split $listmatch " "] 0]
	set min [lindex [split $listmatch " "] 1]
	set max [lindex [split $listmatch " "] 2]

	if [sNull $match] { set match "*" }
	if [sNull $min]   { set min 1 }	
	if [sNull $max]   { set max 999 }	
	set w .zipperchannellist
	if [winfo exists $w] {
		raise  $w
		focus $w
	} else {
		create_chanlist_window
	}
	set l1 [lindex [split $param " "] 1]
	set l2 [lindex [split $param " "] 2]
	set l3 [join [lrange [split $param " "] 3 end] ]
	
	if [expr $l2 <= $max] {
	if [expr $l2 >= $min] {
	if [string match $match $l1] {	
		$w.channels.list insert end "$l1\t\tUsers: $l2\t\tTopic: $l3"
	}}}
}


proc rec_CHANNELDATE {orig param} {
	set channel [lindex [split $param " "] 1]
	set inttime [lindex [split $param " "] 2]

	set time [clock format $inttime]
	fake_user_in "/echo $channel was created on $time."
}


proc rec_MODE {orig param} {

	global nick
	global modest


        set parmlist [split $param " "]
        set nickchan [lindex $parmlist 0]
        set mode [split [string trimleft [lindex $parmlist 1] ":" ]  ""]     
	set target [lindex $parmlist 2]


	if ![winfo exists [winman2 $nickchan] ] {
		return
	}
	
	if [sNull $target] {
		set target $nickchan
	}

	if ![string compare $nickchan $nick] {
		if ![string compare $target $nick] {
			rec_SETUSERMODE $nickchan $mode $parmlist
			return
		}
	} 

	if ![string compare $nickchan $target] {
		rec_SETCHANMODE $nickchan $mode $parmlist
		return
	}
	if [string match "*l*" [join $mode "" ] ] {
		rec_SETCHANMODE $nickchan $mode $parmlist
		return

	}
	if [string match "*k*" [join $mode "" ] ] {
		rec_SETCHANMODE $nickchan $mode $parmlist
		return

	}
	rec_SETCHANUSERMODE $orig $nickchan $mode $parmlist

}

proc rec_SETUSERMODE {nick mode parmlist} {
	global modest	
	set mode [join $mode ""]
	if ![sNull $mode] {
		send_to_window server "$modest\You have set your mode to $mode\n"
	}
}

proc rec_SETCHANMODE {chan mode parmlist} {
	global modest
	set mode [join $mode ""]
	if ![sNull $mode] {
		set_chan_mode $chan $mode
	}

}

proc rec_SETCHANUSERMODE {orig nickchan mode parmlist} {
	global nick
	global modest 

	set who(1) ""
        set who(1) "$nickchan:[lindex $parmlist 2]"
        set who(2) ""
        set who(2) "$nickchan:[lindex $parmlist 3]"
        set who(3) ""
        set who(3) "$nickchan:[lindex $parmlist 4]"
        set who(4) ""
        set who(4) "$nickchan:[lindex $parmlist 5]"
        set who(5) ""
        set who(5) "$nickchan:[lindex $parmlist 6]"
        set who(6) ""
        set who(6) "$nickchan:[lindex $parmlist 7]"
                                    

	set x 1
	set modechange "+"
	foreach item $mode {
		if [expr $item=="+" || $item=="-"] {
                        set modechange $item
                        set x 1
                        continue
                }         
		append who($x) ":$modechange$item"
                incr x       
	}



	set ml [list $who(1) $who(2) $who(3) $who(4) $who(5) $who(6) ]
        foreach user $ml {
                set f [split $user ":"]
                set nickchan [lindex $f 0]
                set target [lindex $f 1]
                set mode [lrange $f 2 end]

		if ![sNull $mode] {
			send_to_window $nickchan "$modest$orig sets mode $mode $target\n"
               		 foreach modex $mode {
                		set switch  [lindex [split $modex ""] 0]
                		set newmode [lindex [split $modex ""] 1]
                		switch -exact -- $modex {      
				
					+v      -
                			-v      -
                			+o      -
                			-o      {togglemode $switch $target $nickchan $newmode }
                			+b      {fake_user_in "/echo A ban was set on $target" }
                			-b      {fake_user_in "/echo A ban was removed on $target" }

                			default {}
                		}
                		switch -exact -- $modex {
                			+o      { irc_event OP $target $orig "$target" }
                			-o      { irc_event DEOP $target $orig "$target" }
                			+b      { irc_event BAN $target $orig "$target" }
                			-b      { irc_event UNBAN $target $orig "$target" }

                			default { irc_event MODE $target $orig $modex }

                		}                                                          

				
			}
		}            

	}
}




