package provide setup 1.62



proc init_setup_window {} {
	
        global version
        global shortnick
	global settingschanged
	
	set w ".zippersetup"	
	set i ".zippersetup.irc"
	set n ".zippersetup.network"
	set p ".zippersetup.programs"
	set m ".zippersetup.misc"
	set d ".zippersetup.dcc"
	
	toplevel $w
	toplevel $i
	toplevel $n
	toplevel $p
	toplevel $m
	toplevel $d

	wm withdraw $i
	wm withdraw $n
	wm withdraw $p
	wm withdraw $m
	wm withdraw $d

	wm protocol $i WM_DELETE_WINDOW "wm withdraw $i"
	wm protocol $n WM_DELETE_WINDOW "wm withdraw $n"
	wm protocol $p WM_DELETE_WINDOW "wm withdraw $p"
	wm protocol $m WM_DELETE_WINDOW "wm withdraw $m"
	wm protocol $d WM_DELETE_WINDOW "wm withdraw $d"


	wm iconname $i "ZipperSetup"
	set font ZipperN

	wm title $w "Zipper Setup Window"

	frame $w.buttons
	pack $w.buttons -side bottom

	button $w.buttons.save -text "Done" -command {set settingschanged 1; save_user_rc ; destroy_wins ; return}
	button $w.buttons.irc -text "IRC" -command {show_setup_win .zippersetup.irc}
	button $w.buttons.network -text "Network" -command {show_setup_win .zippersetup.network}
	button $w.buttons.prog -text "Programs" -command {show_setup_win .zippersetup.programs}
	button $w.buttons.misc -text "Misc" -command {show_setup_win .zippersetup.misc}
	button $w.buttons.dcc -text "DCC" -command {show_setup_win .zippersetup.dcc}
	button $w.buttons.quit -text "Cancel" -command {set settingschanged 0; destroy_wins ; return}
	pack $w.buttons.irc -side top
	pack $w.buttons.network -side top
	pack $w.buttons.prog -side top
	pack $w.buttons.misc -side top
	pack $w.buttons.dcc -side top
	pack $w.buttons.save $w.buttons.quit -side left 




#### Irc Server Setup
        global nick
        global altnick
        global username
        global realname
        global server
        global port    
	global serverpass

	frame $i.nick
	frame $i.altnick
	frame $i.user
	frame $i.real
	frame $i.server
	frame $i.port
	frame $i.sp

	pack $i.nick -side top
	pack $i.altnick -side top
	pack $i.user -side top
	pack $i.real -side top
	pack $i.server -side top
	pack $i.port -side top
	pack $i.sp -side top

	label $i.nick.nicklabel -text "Nickname" -width 12 -justify left
	label $i.altnick.altnicklabel -text "AltNickname" -width 12 -justify left
	label $i.user.userlabel -text "Username" -width 12 -justify left
	label $i.real.reallabel -text "Realname" -width 12 -justify left
	label $i.server.serverlabel -text "Server" -width 12  -justify left
	label $i.port.portlabel -text "Port"  -width 12 -justify left
	label $i.sp.splabel -text "Server Password"  -width 15 -justify left

	pack $i.nick.nicklabel -side left 
	pack $i.altnick.altnicklabel  -side left
	pack $i.user.userlabel -side left
	pack $i.real.reallabel  -side left
	pack $i.server.serverlabel  -side left
	pack $i.port.portlabel  -side left
	pack $i.sp.splabel  -side left


	entry $i.nick.nick  -bd 2 -relief sunken -width 10 -textvariable nick 
	entry $i.altnick.altnick  -bd 2 -relief sunken -width 10 -textvariable altnick 
	entry $i.user.user  -bd 2 -relief sunken -width 10 -textvariable username
	entry $i.real.real  -bd 2 -relief sunken -width 30 -textvariable realname 
	entry $i.server.server  -bd 2 -relief sunken -width 30 -textvariable server 
	entry $i.port.port  -bd 2 -relief sunken -width 30 -textvariable port
	entry $i.sp.sp  -bd 2 -relief sunken -width 10 -textvariable serverpass

	pack $i.nick.nick -side right
	pack $i.altnick.altnick -side right
	pack $i.user.user -side right
	pack $i.real.real -side right
	pack $i.port.port -side right
	pack $i.server.server -side right
	pack $i.sp.sp -side right


#### Network Setup
        global hostname


	frame $n.host
	pack $n.host -side top
	label $n.host.hostlabel -text "Hostname" -width 10 -justify left
	pack $n.host.hostlabel  -side left
	entry $n.host.host  -bd 2 -relief sunken -width 30 -textvariable hostname 
	pack $n.host.host -side right


#### Programs Setup
	global webbrowser
	global appdir
	global dccapplist

	frame $p.appdir
	frame $p.webb
	frame $p.apps

	pack $p.appdir -side top
	pack $p.webb -side top
	pack $p.apps -side top

	label $p.appdir.appdirlabel -text "App/Save Dirs." -width 14 -justify left
	label $p.webb.weblabel -text "Browser" -width 10 -justify left
	label $p.apps.appl -text "Applications" -width 20 -justify left

	pack $p.appdir.appdirlabel  -side left
	pack $p.webb.weblabel  -side left
	pack $p.apps.appl -side left

	entry $p.appdir.appdir  -bd 2 -relief sunken -width 30 -textvariable appdir
	entry $p.webb.browser  -bd 2 -relief sunken -width 20 -textvariable webbrowser
	entry $p.apps.appe  -bd 2 -relief sunken -width 30 -textvariable dccapplist

	pack $p.appdir.appdir -side right
	pack $p.webb.browser -side right
	pack $p.apps.appe -side right

#### Misc Setup
        global textfg textbg
        global autorejoin
	global logdir logchannels logmsg logdcc

	frame $m.fg
	frame $m.bg
	frame $m.autor
	frame $m.log
	frame $m.logc
	frame $m.logm
	frame $m.logd
	
	pack $m.fg -side top
	pack $m.bg -side top
	pack $m.autor -side top
	pack $m.log -side top
	pack $m.logc -side top
	pack $m.logm -side top
	pack $m.logd -side top

	label $m.fg.fglabel -text "Text Foreground"  -width 20 -justify left
	label $m.bg.bglabel -text "Text Background" -width 20 -justify left
	label $m.autor.arlabel -text "Auto Rejoin when kicked" -width 20 -justify left
	label $m.log.logdirl -text "Log Directory" -width 20 -justify left
	label $m.logc.logcl -text "Log Channels?" -width 20 -justify left
	label $m.logm.logml -text "Log Messages?" -width 20 -justify left
	label $m.logd.logdl -text "Log DCCs?" -width 20 -justify left

	pack $m.fg.fglabel  -side left
	pack $m.bg.bglabel  -side left
	pack $m.autor.arlabel  -side left
	pack $m.log.logdirl -side left
	pack $m.logc.logcl -side left
	pack $m.logm.logml -side left
	pack $m.logd.logdl -side left

	entry $m.fg.fg  -bd 2 -relief sunken -width 3 -textvariable textfg
	button $m.fg.fgb -text "..." -command {
			.zippersetup.misc.fg.fg delete 0 end
			.zippersetup.misc.fg.fg insert end [pick_color]
	}
	entry $m.bg.bg  -bd 2 -relief sunken -width 3 -textvariable textbg
	button $m.bg.bgb -text "..." -command {
			.zippersetup.misc.bg.bg delete 0 end
			.zippersetup.misc.bg.bg insert end [pick_color]
	}
	checkbutton $m.autor.autore  -bd 2 -relief sunken -width 3 -variable textbg
	entry $m.log.logdire -bd 2 -relief sunken -width 20 -textvariable logdir
	checkbutton $m.logc.lcb  -bd 2 -relief sunken -width 3 -variable logchannels
	checkbutton $m.logm.lmb  -bd 2 -relief sunken -width 3 -variable logmsg
	checkbutton $m.logd.ldb  -bd 2 -relief sunken -width 3 -variable logdcc



	pack $m.fg.fg -side left
	pack $m.fg.fgb -side right
	pack $m.bg.bg -side left
	pack $m.bg.bgb -side right
	pack $m.autor.autore -side right
	pack $m.log.logdire -side right
	pack $m.logc.lcb -side right
	pack $m.logm.lmb -side right
	pack $m.logd.ldb -side right

### DCC Setup
	global autoacceptchat
	global autoacceptsend
	global dccsavedir

	frame $d.autoc
	frame $d.autos
	frame $d.savdir

	pack $d.autoc -side top
	pack $d.autos -side top
	pack $d.savdir -side top

	label $d.autoc.autochat -text "Auto Accept DCC Chat" -width 20 -justify left
	label $d.autos.autosend -text "Auto Accept DCC Send" -width 20 -justify left
	label $d.savdir.savdirl -text "Default Save Directory" -width 25 -justify left

	pack $d.autoc.autochat -side left
	pack $d.autos.autosend -side left
	pack $d.savdir.savdirl -side left

	checkbutton $d.autoc.autochate  -bd 2 -relief sunken -width 3 -variable autoacceptchat
	checkbutton $d.autos.autosende  -bd 2 -relief sunken -width 3 -variable autoacceptsend
	entry $d.savdir.savdire  -bd 2 -relief sunken -width 30 -textvariable dccsavdir

	pack $d.autoc.autochate -side right
	pack $d.autos.autosende -side right
	pack $d.savdir.savdire -side right
}

proc destroy_wins {} {

	set w ".zippersetup"	
	set i ".zippersetup.irc"
	set n ".zippersetup.network"
	set p ".zippersetup.programs"
	set m ".zippersetup.misc"
	set d ".zippersetup.dcc"

	destroy $w
	destroy $i
	destroy $n
	destroy $p
	destroy $m
	destroy $d

}
proc show_setup_win {w} {

	set i ".zippersetup.irc"
	set n ".zippersetup.network"
	set p ".zippersetup.programs"
	set m ".zippersetup.misc"
	set d ".zippersetup.dcc"
	wm withdraw $i
	wm withdraw $n
	wm withdraw $p
	wm withdraw $m
	wm withdraw $d

	center $w 0 0
	wm deiconify $w
}

proc save_user_rc {} {
	global rcdir
        global nick
        global altnick
        global username
        global realname
        global hostname
        global autorejoin
        global shortnick
        global server
        global port    
	global textfg
	global textbg
	global notifywindow
	global appdir
	global webbrowser
	global autoacceptchat
	global autoacceptsend
	global dccsavdir
	global logdir
	global logchannels
	global logmsg
	global logdcc
	global serverpass
	global dccapplist

	set f [open $rcdir/zipperrc w]
	puts $f "nick $nick"
	puts $f "textfg $textfg"
	puts $f "textbg $textbg"
	puts $f "altnick $altnick"
	puts $f "username $username"
	puts $f "realname $realname"
	puts $f "hostname $hostname"
	puts $f "autorejoin $autorejoin"
	puts $f "shortnick $shortnick"
	puts $f "server $server"
	puts $f "port $port"
	puts $f "notifywindow $notifywindow"
	puts $f "appdir $appdir"
	puts $f "webbrowser $webbrowser"
	puts $f "autoacceptchat $autoacceptchat"
	puts $f "autoacceptsend $autoacceptsend"
	puts $f "dccsavdir $dccsavdir"
	puts $f "logdir $logdir"
	puts $f "logchannels $logchannels"
	puts $f "logmsg $logmsg"
	puts $f "logdcc $logdcc"
	puts $f "serverpass $serverpass"	
	puts $f "dccapplist $dccapplist"
	close $f
}
