package provide tked 1.0

# A script which will implement a decent text editor.
# Based on the tk4.2 widget demonstration files
# Editor is Copyright Ash Bowers 1997
# 

proc tked {filename} {
global tkedfile
global cutbuffer 

wm withdraw .
set w .tked
toplevel $w
wm iconname $w "text"
set tkedfile $filename
#set font  -*-fixed-medium-r-normal--*-120-*-*-*-*-*-* 
set font 8x13bold

set input ""
if [string compare $filename ""] {
	if [file exists $tkedfile] {
		set f [open $tkedfile r]
		seek $f 0 start
		set input [read -nonewline $f]
		close $f
	}

}  else {
	set tkedfile "Untitled"
}
wm title $w $tkedfile
set index 0.0
set start 0.0
set length 0
set about {
Zipper Editor
Copyright 1997
Ash Bowers

Thanks for using Zipper!
}


set cutbuffer ""
#set up menus

frame $w.menu -relief raised -bd 2
pack $w.menu -side top -fill x

set m $w.menu.file.m
menubutton $w.menu.file -text "File" -menu $m -underline 0
menu $m
$m add command -label "Save"    -command {doSave .tked.text $tkedfile}
$m add command -label "Save As..."    -command {doSaveAs .tked $tkedfile save}
$m add command -label "Save & Exit"    -command {doExit .tked.text $tkedfile}
$m add command -label "Just Exit"    -command {doCloseEditor}
pack $w.menu.file -side left

set m $w.menu.edit.m
menubutton $w.menu.edit -text "Edit" -menu $m -underline 0
menu $m
$m add command -label "Cut" -command {set cutbuffer [doCut .tked.text]}
$m add command -label "Copy" -command {set cutbuffer [doCopy .tked.text]}
$m add command -label "Paste" -command {doPaste $w.text $cutbuffer}
$m add separator
$m add command -label "Search/Replace..." -command {doSearch .tked.text}
#$m add separator
$m add command -label "Goto Line..." -command { doGoto .tked.text }
pack $w.menu.edit -side left

set m $w.menu.about.m
menubutton $w.menu.about -text "About" -menu $m -underline 0
menu $m
$m add command -label "Editor" -command {doAbout}
pack $w.menu.about -side right



#set up button bar

frame $w.buttons
text $w.text -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 \
	-height 30
scrollbar $w.scroll -command "$w.text yview"
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

$w.text insert 0.0 $input
set input ""


 
bind .tked <Control-KeyPress-q> {doExit $w.text $tkedfile}
bind .tked <Control-KeyPress-s> {doSave $w.text $tkedfile}
bind .tked <Control-KeyPress-o> {doOpen $w $tkedfile open}
bind .tked <Control-KeyPress-c> {set cutbuffer [doCopy .tked.text]}
bind .tked <Control-KeyPress-v> {doPaste $w.text $cutbuffer}
bind .tked <Destroy> {doCloseEditor}

proc doExit "xxx tkedfile" {

	set f [open $tkedfile w]
	set output [$xxx get 1.0 end]
	puts -nonewline $f $output
	close $f
	destroy .text
	fake_user_in "/recycle"	
	doCloseEditor
}

proc doCloseEditor {} {
 	
	destroy .tked
}


}
proc doSave "xxx tkedfile" {

	set f [open $tkedfile w]
	set output [$xxx get 1.0 end]
	puts -nonewline $f $output
	close $f
	fake_user_in "/recycle"	

}
proc doSaveAs {w ent operation} {
	
	global tkedfile
	set ent [fileDialog $w $ent $operation]
	set f [open $ent w]
	set output [$w.text get 1.0 end]
	puts -nonewline $f $output
	close $f
	wm title $w $ent
	set tkedfile ent
	return

}
proc doOpen {w ent operation} {

	global  tkedfile
	set tkedfile ent
	set tkedfile [fileDialog $w $tkedfile $operation]
	set f [open $tkedfile r]
	seek $f 0 start
	set input [read -nonewline $f]
	close $f
	$w.text delete 0.0 end
	$w.text insert 0.0 $input
	wm title $w $tkedfile

}

proc fileDialog {w ent operation} {
	
	
    #   Type names              Extension(s)    Mac File Type(s)
    #
    #---------------------------------------------------------
    set types {
        {"Text files"           {.txt .doc}     }
        {"Text files"           {}              TEXT}
        {"Tcl Scripts"          {.tcl}          TEXT}
        {"C Source Files"       {.c .h}         }
        {"All Source Files"     {.tcl .c .h}    }
        {"Image Files"          {.gif}          }
        {"Image Files"          {.jpeg .jpg}    }
        {"Image Files"          ""              {GIFF JPEG}}
        {"All files"            *}
    }
    if {$operation == "open"} {
        set tkedfile [tk_getOpenFile -filetypes $types -parent $w]
    } else {
        set tkedfile [tk_getSaveFile -filetypes $types -parent $w \
            -initialfile Untitled -defaultextension .txt]
    }
    if [string compare $tkedfile ""] {
	set ent $tkedfile
    }
    return $ent

}


proc doCut {w} {
	global cutbuffer
	set cutbuffer ""
	set select [$w tag ranges sel]
	if {$select != ""} {
		set cutbuffer [eval $w get $select]
		eval $w delete $select
	}

	return $cutbuffer
}    


proc doCopy {w} {
	global cutbuffer
	set cutbuffer ""
	set select [$w tag ranges sel]
	if {$select != ""} {
		set cutbuffer [eval $w get $select]
	}

	return $cutbuffer
}    


proc doPaste {w cutbuffer} {

	global cutbuffer

	if {$cutbuffer !=""} {
		$w insert insert $cutbuffer
	}


}     

proc doSearch {w} {
	global index
	global t
	
	set cur ""
	set t .search
	
	if [winfo exists $t] {
		raise $t
		focus $t
		return
	}

	
	toplevel $t
	wm withdraw $t

	wm iconname $t "search"
	wm title $t "Search/Replace"
	set font  -*-fixed-medium-r-normal--*-120-*-*-*-*-*-*
	
	
	frame $t.buttons
	pack $t.buttons -side bottom -fill x -pady 2m

	button $t.buttons.next -text "Next" -command {doSearchNext $w $t}
	button $t.buttons.last -text "Last" -command {doSearchLast $w $t}
	button $t.buttons.replace -text "Replace" -command {doReplace $w $t}
	button $t.buttons.close -text "Close" -command {doCloseSearch $w $t  }
	pack $t.buttons.next $t.buttons.last $t.buttons.replace $t.buttons.close -side left -expand 1
	label $t.label -text "Search for (regexp):" -anchor w
	entry $t.entry -bd 2 -relief sunken -width 40
	pack $t.label  $t.entry -side top -fill x -expand yes -ipady 2
 	
 	label $t.label2 -text "Replace With:" -anchor w
	entry $t.entry2 -bd 2 -relief sunken -width 40	
	pack $t.label2 $t.entry2  -side top -fill x -expand yes -ipady 2
 
 	
	
	
	update idletasks
 	
	wm deiconify $t
	focus $t.entry

	
}

proc doCloseSearch {w t} {
 
	$w.text tag delete search
	destroy .search
	
}
proc doSearchNext {w entry} {

	global index
	global start
	global length

	set string [$entry.entry get]
	
	if {$index == ""} { set index "0.0"}
	set start [$w.text search -forwards -regexp -count length $string $index]
	
	
	$w.text see $start
	
	
	$w.text tag add search $start "$start + $length chars"
		

	set index [$w.text index "$start + $length char"] 

	$w.text tag configure search -foreground red
	
	


}
proc doReplace {w t} {
	global start
	global length

	set replace [$t.entry2 get]

	if {$replace != ""} {
		
		$w.text delete $start "$start +$length chars"
		$w.text insert $start $replace

		return 
	}


}              
	
proc doGoto {w} {
	set t .goto
	
	if [winfo exists $t] {
		raise $t
		focus $t
		return
	}

	
	toplevel $t
	wm withdraw $t

	wm iconname $t "GotoLine"
	wm title $t "Goto Line"
	set font  -*-fixed-medium-r-normal--*-120-*-*-*-*-*-*
	
	frame $t.buttons
	pack $t.buttons -side bottom -fill x -pady 2m

	
	button $t.buttons.go -text "Go" -command {doAdjustLine $w.text}
	button $t.buttons.close -text "Close" -command {doCloseGoto $w.text}
	pack $t.buttons.go $t.buttons.close -side left -expand 1

	label $t.label -text "Goto Line Number:" -anchor w
	entry $t.entry -bd 2 -relief sunken -width 5
	pack $t.label  $t.entry -side top -fill x -expand yes -ipady 2
 	
	update idletasks
	wm deiconify $t
	focus $t.entry
	

}

proc doAdjustLine {w} {
	
	
	$w see "[.goto.entry get].0"
#	$w tag add gotoline "[.goto.entry get].0" "[.goto.entry get].0 lineend"
#	$w tag configure gotoline -foreground red	
	$w mark set insert [.goto.entry get].0	

	focus $w
}

proc doCloseGoto {w} {

	
	$w tag delete gotoline
	destroy .goto
}

proc doAbout {}  {
	global about
	tk_dialog .about "tkEditor" $about info 0 OK


}


