package provide winman 1.63
## Modifications Courtesy of Tim Howe
##	Control-Shift-B "bolding"
## 	Window Expansion to fit title 
## 	Underline fix
## 	Improved Topic changing


####
# winlist format:  channelname:windownumber
proc winman {channel} {
global chaninfo


        set channel [string tolower $channel]

 	set dccCheck [string compare [string range $channel 0 3 ] "dcc:" ]
        if !$dccCheck {
                set dnick [lindex [split $channel ":"] 1]
                set sock [get_dcc_sock_from_nick $dnick]
                set channel "dcc$sock"
        }
                           
        set nlist [array names chaninfo]
        if [expr [lsearch -exact $nlist "$channel,name"]==-1]  {
                return -1
        } else {
                return $chaninfo($channel,winnumber)
        }
  

}


proc winman2 {channel} {
	
                return .zipperwin[winman $channel]
       
 

}

proc winmanchan {act} {
global chanrev

	set act ".[lindex [split $act "."] 1]"
	return $chanrev($act)


}

proc winmannew {channel title type s} {
# s allows for variable parameters
# s[0] = minimize flag
# s[1] = nick
# s[2] = socket
global winlist
global winbase
global chaninfo
global chanrev
global esvrSock	
global logchannels
global logmsg
global logdcc

	set minflag [lindex [split $s " "] 0]
	set tnick [lindex [split $s " "] 1]
	set socket [lindex [split $s " "] 2]
	if [sNull $socket] { set socket $esvrSock }

	set channel [string tolower $channel]

	set refocus [focus]
	set num [winman $channel]

	if $num<0 {
		set winbase [expr $winbase+1]
		set num $winbase
		set winlist [linsert $winlist end "$channel:$winbase" ]
	} 
		

		set winname ".zipperwin$num"
		set index $channel
		set chaninfo($index,name) $winname
		set chaninfo($index,nickchan) $tnick
		set chaninfo($index,stat) "I"
		set chaninfo($index,history) ""
		set chaninfo($index,historyidx) 0
		set chaninfo($index,winnumber) $num
		set chaninfo($index,socket) $socket
		set chaninfo($index,logfile) ""
		set chanrev($winname) $index
		switch -exact -- $type {
		priv		{
				set chaninfo($index,logging) $logmsg
				set chaninfo($index,filedesc) 0
				set chaninfo($index,type) "priv"
				new_msg_window "win$num" "Private: $title" $minflag
				}
		pub		{
				set chaninfo($index,logging) $logchannels
				set chaninfo($index,filedesc) 0
				set chaninfo($index,type) "chan"
				new_window "win$num" "Channel: $title"
				}
		dcc		{
				set chaninfo($index,logging) $logdcc
				set chaninfo($index,filedesc) 0
				set chaninfo($index,type) "dcc"
				set chaninfo($index,name) ".zipperdcc$socket"
				set chanrev(.zipperdcc$socket) $index
				new_dcc_window $socket "DCC:$tnick" "$socket"
				}
		}
### Channel Logging code notes......
##	pub and priv channels need no adjustment
##	dcc channels index = socketname
##	need to adjust back to nick name
##
##	$logdir will contain directory to puts logs in
##
#######
	if $chaninfo($index,logging) {openlog $index}	


	focus $refocus
}

proc chan_menu {} {
	global installpath

	set w .chanmenu

	toplevel $w
	wm title $w "Channel Menu"
	wm iconname $w "Channel Menu"
	wm geometry $w =+10+10
	add_icon chanmenu $installpath/z_logosmall.gif $w

	frame $w.chanb1 -relief raised -bd 2
	frame $w.chanb2 -relief raised -bd 2
	frame $w.chanb3 -relief raised -bd 2
	pack $w.chanb3 -side bottom -fill x
	pack $w.chanb1 -side bottom -fill x
	pack $w.chanb2 -side bottom -fill x
	pack $w.chanb3 -side bottom -fill x

	wm protocol $w "WM_DELETE_WINDOW" {nop}

}
proc new_server {w name} {

global zipperservericon
global allowsaverc
global mirccolors
global textfg
global textbg
global defaultquit
global installpath
global serverfont
global actwin
global notifywindow
global serveractive

set w ".zipper$w"

toplevel $w
wm withdraw $w
add_icon server $installpath/z_logosmall.gif $w
if $allowsaverc {
	wm iconname $w "Zipper"
} else {
	wm iconname $w "Zipper Clone"
}


#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font $serverfont

wm title $w $name

#wm iconbitmap $w @$installpath/zippericon.xbm
set start 0.0
set length 0

set noti_gif [image create photo -file "$installpath/noti.gif"]
set notioff_gif [image create photo -file "$installpath/notioff.gif"]
set online_gif [image create photo -file "$installpath/online.gif"]
set offline_gif [image create photo -file "$installpath/offline.gif"]
set stopsign_gif [image create photo -file "$installpath/stopsign.gif"]
set setup_gif [image create photo -file "$installpath/setup.gif"]
set servers_gif [image create photo -file "$installpath/servers.gif"]
set chanicon_gif [image create photo -file "$installpath/chanicon.gif"]
set ctcps_gif [image create photo -file "$installpath/ctcps.gif"]
set notifylist_gif [image create photo -file "$installpath/notifylisticon.gif"]
set userlist_gif [image create photo -file "$installpath/userlist.gif"]
set events_gif [image create photo -file "$installpath/events.gif"]
set ignore_gif [image create photo -file "$installpath/ignore.gif"]
set urls_gif [image create photo -file "$installpath/urls.gif"]

frame $w.menu -relief raised -bd 2
frame $w.pushb -relief raised -bd 2
frame $w.misc -bd 2

label $w.misc.popuphelp  -font ZipperN -width 80 -anchor w

label $w.pushb.sep1 -relief sunken -bd 4
label $w.pushb.sep2 -relief sunken -bd 4
checkbutton $w.pushb.notifylist -offvalue 1 -onvalue 0 -indicatoron 0 -image $noti_gif -selectimage $notioff_gif   -variable notifywindow  -command {toggle_notify_win}
checkbutton $w.pushb.online     -indicatoron 0 -image $offline_gif -selectimage $online_gif -variable serveractive  -command {toggle_connection}
button $w.pushb.servers -image $servers_gif  -command {modify_servers}
button $w.pushb.channels -image $chanicon_gif  -command {modify_channels}
button $w.pushb.notifyl -image $notifylist_gif  -command {modify_notify}
button $w.pushb.ctcps -image $ctcps_gif  -command {modify_ctcps}
button $w.pushb.events -image $events_gif  -command {modify_events}
button $w.pushb.users -image $userlist_gif  -command {modify_users}
button $w.pushb.ignore -image $ignore_gif  -command {modify_ignore}
button $w.pushb.fonts -text Fonts  -command {fontman}
button $w.pushb.url -image $urls_gif  -command {urlman}
button $w.pushb.exit -image $stopsign_gif -command {fake_user_in "/quit $defaultquit"}
if $allowsaverc {
	button $w.pushb.setup -image $setup_gif -command { modify_setup }
} else {
	button $w.pushb.setup -image $setup_gif  -state disabled -command { modify_setup }
}

pack $w.menu -side top -fill x
pack $w.pushb -side top -fill x
pack $w.misc -side top -fill x

add_system_menus $w 

pack $w.pushb.online  -side left
pack $w.pushb.setup -side left
pack $w.pushb.notifylist  -side left
pack $w.pushb.sep1 -side left
pack $w.pushb.servers  -side left
pack $w.pushb.channels  -side left
pack $w.pushb.notifyl  -side left
pack $w.pushb.ctcps  -side left
pack $w.pushb.events  -side left
pack $w.pushb.users  -side left
pack $w.pushb.ignore  -side left
pack $w.pushb.sep2 -side left
pack $w.pushb.fonts  -side left
pack $w.pushb.url -side left
pack $w.pushb.exit -side right
pack $w.misc.popuphelp -side bottom

text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50 -foreground $mirccolors($textfg) -background $mirccolors($textbg)
scrollbar $w.scroll -command "$w.text yview"
listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 20 -font ZipperN
scrollbar $w.listscroll -command "$w.list yview"
entry $w.entry -bd 2 -relief sunken -width 30

pack $w.entry -side bottom -expand no -fill x
#pack $w.listscroll -side right -fill y
#pack $w.list -side right -fill y
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both 


bind $w      <Destroy> { fake_user_in "/quit $defaultquit" }
bind $w.pushb.online <Enter>  {.zipperserver.misc.popuphelp configure -text "Online/Offline Control" }
bind $w.pushb.online <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.setup <Enter>  {.zipperserver.misc.popuphelp configure -text "System Setup" }
bind $w.pushb.setup <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.notifylist <Enter>  {.zipperserver.misc.popuphelp configure -text "Toggle Notify Window" }
bind $w.pushb.notifylist <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.servers <Enter>  {.zipperserver.misc.popuphelp configure -text "Servers List Editor" }
bind $w.pushb.servers <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.channels <Enter>  {.zipperserver.misc.popuphelp configure -text "Channels List Editor" }
bind $w.pushb.channels <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.notifyl <Enter>  {.zipperserver.misc.popuphelp configure -text "Notify List Editor" }
bind $w.pushb.notifyl <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.ctcps <Enter>  {.zipperserver.misc.popuphelp configure -text "CTCPs Editor" }
bind $w.pushb.ctcps <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.events <Enter>  {.zipperserver.misc.popuphelp configure -text "Events Editor" }
bind $w.pushb.events <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.users <Enter>  {.zipperserver.misc.popuphelp configure -text "User List Editor" }
bind $w.pushb.users <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.ignore <Enter>  {.zipperserver.misc.popuphelp configure -text "Ignore List Editor" }
bind $w.pushb.ignore <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.url <Enter>  {.zipperserver.misc.popuphelp configure -text "URL List Editor" }
bind $w.pushb.url <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.pushb.exit <Enter>  {.zipperserver.misc.popuphelp configure -text "Exit Zipper" }
bind $w.pushb.exit <Leave>  {.zipperserver.misc.popuphelp configure -text "" }
bind $w.entry <KeyPress-Up>	{select_history [focus] -1}
bind $w.entry <KeyPress-Down>	{select_history [focus] 1}
bind $w.list  <Double-ButtonPress-1> {goto_window .zipperserver.list }
bind $w.entry <KeyPress-Return> {read_user_in $esvrSock [focus] }
bind $w.entry <Control-KeyPress-B> {[focus] insert end "\002"}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}
bind $w.entry <KeyPress-Escape>    {minimize [focus]  }
bind $w  <FocusIn> {set actwin ".zipperserver" }
focus $w.entry

update idletasks
center $w -100 -100
wm deiconify $w
focus $w.entry
#set_userlist_popup
set_popups
chan_menu
button .chanmenu.chanb1.server -width 9 -font ZipperN -text "Server" -command "raise .zipperserver; focus .zipperserver.entry" 
pack .chanmenu.chanb1.server -side top
}



proc new_window {w name} {
global mirccolors
global textfg
global textbg
global defaultquit
global actwin
global installpath
global channelfont
global chanrev

set w ".zipper$w"
toplevel $w
wm withdraw $w
wm iconname $w [lindex [split $name " "] 1]
set font $channelfont

wm title $w $name

set start 0.0
set length 0

frame $w.menu -relief raised -bd 2
pack $w.menu -side top -fill x

add_system_menus $w 

frame $w.labels
pack $w.labels -side top -fill x
frame $w.labels2
pack $w.labels2 -side top -fill x

set idx [string tolower $chanrev($w) ]
checkbutton $w.labels2.log -variable chaninfo($idx,logging) -text "Log" -command "toggle_logging $w"
pack $w.labels2.log -side left

button $w.labels2.inscol -text "Ins Color" -command { set c [pick_color]; $actwin insert end "\003$c" }
pack   $w.labels2.inscol -side left

text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50 -foreground $mirccolors($textfg) -background $mirccolors($textbg)
scrollbar $w.scroll -command "$w.text yview"
listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 12 -font ZipperN
scrollbar $w.listscroll -command "$w.list yview"
entry $w.entry -bd 2 -relief sunken -width 30
        label $w.labels.topict -text "Topic"
        label $w.labels.topic -bd 2 -relief sunken -width 50 -anchor w -font ZipperTopic
        entry $w.labels.modes -bd 2 -relief sunken -width 10
	$w.labels.modes configure -state disabled
        label $w.labels.modest -text "Modes"

        pack $w.labels.topict -side left 
        pack $w.labels.topic -side left -fill x -expand yes
        pack $w.labels.modes -side right
        pack $w.labels.modest -side right
pack $w.entry -side bottom -expand no -fill both
pack $w.listscroll -side right -fill y
pack $w.list -side right -fill y
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

center $w -50 -50
wm deiconify $w
focus $w.entry
bind $w.labels.topic <Double-ButtonPress-1> {
						set tpwinname $actwin
						set tpspot [string first . [string range $tpwinname 1 end]]
						set tpwin [string range $tpwinname 0 $tpspot]
						set topic [ask_user Topic "Enter New Topic\n\[[$tpwin.labels.topic cget -text]\]" ] 
						if ![sNull "$topic"] {
					     		set chan [winmanchan $actwin] 
							fake_user_in "/topic $chan $topic" 
						}
					     }

#wm protocol $w WM_ICONIFY_WINDOW "wm withdraw $w"
bind $w <Unmap> "wm withdraw $w"
bind $w.entry <KeyPress-Up>	{select_history [focus] -1}
bind $w.entry <KeyPress-Down>	{select_history [focus] 1}
bind $w.entry <Control-KeyPress-B> {[focus] insert end "\002"}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}
bind $w.list  <Double-ButtonPress-1> {goto_window  [focus] }
bind $w.list  <ButtonPress-3> { tk_popup .zipperserver.menu.userlistpopup [winfo pointerx [focus]] [winfo pointery [focus]] }
bind $w.text  <ButtonPress-3> { tk_popup .zipperserver.menu.channelpopup [winfo pointerx [focus]] [winfo pointery [focus]] }
bind $w.entry <KeyPress-Return> {read_user_in $esvrSock [focus] }
bind $w.entry <KeyPress-Escape>    {minimize [focus]  }
bind $w  <FocusIn> {update_chan_activity 0 [focus] }
bind $w.entry <Destroy> {kill_window $actwin}

}                           



proc new_msg_window {w name s} {
global mirccolors
global textfg
global textbg
global defaultquit
global actwin
global installpath
global queryfont
global chaninfo
global chanrev
global c

set w ".zipper$w"
toplevel $w

wm withdraw $w
wm iconname $w [lindex [split $name " "] 1]
#wm iconify $w
#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font $queryfont

wm title $w $name
wm iconbitmap $w @$installpath/zipperwinicon.xbm
#wm iconwindow $w @$installpath/zipperwinicon.xpm
set start 0.0
set length 0


frame $w.menu -relief raised -bd 2
pack $w.menu -side top -fill x

add_system_menus $w 

frame $w.labels
pack $w.labels -side top -fill x

set idx [string tolower $chanrev($w) ]
checkbutton $w.labels.log -variable chaninfo($idx,logging) -text "Log" -command "toggle_logging $w"
pack $w.labels.log -side left

button $w.labels.inscol -text "Ins Color" -command { set c [pick_color]; $actwin insert end "\003$c" }
pack   $w.labels.inscol -side left

text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50 -foreground $mirccolors($textfg) -background $mirccolors($textbg)
scrollbar $w.scroll -command "$w.text yview"
entry $w.entry -bd 2 -relief sunken -width 30
pack $w.entry -side bottom -expand no -fill both
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

center $w -50 -50
#wm iconify $w
focus $w.entry
if !$s {
	wm deiconify $w
}

bind $w <Unmap> "wm withdraw $w"
bind $w.entry <KeyPress-Up>	{select_history [focus] -1}
bind $w.entry <KeyPress-Down>	{select_history [focus] 1}
bind $w.entry <Control-KeyPress-B> {[focus] insert end "\002"}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}
bind $w.entry      <Destroy> {kill_window [focus]}
bind $w.text  <ButtonPress-3> { tk_popup .zipperserver.menu.querypopup [winfo pointerx [focus]] [winfo pointery [focus]] }
bind $w.entry <KeyPress-Return> {read_user_in $esvrSock [focus] }
bind $w.entry <KeyPress-Escape>    {minimize [focus]  }
bind $w       <FocusIn> {update_chan_activity 0 [focus] }
}                          


proc notify_window {} {

global notifywindow
global installpath

if !$notifywindow { return }

set w ".zippernotify"
toplevel $w
add_icon notify $installpath/z_logosmall.gif $w
wm iconname $w "Notify"
#wm iconbitmap $w @$installpath/zippericon.xbm

#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font ZipperN

wm title $w "Notify"
set start 0.0
set length 0

listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 10 -font ZipperN
scrollbar $w.listscroll -command "$w.list yview"
pack $w.list -side left -fill y
pack $w.listscroll -side right -fill y

bind .zippernotify.list  <Double-ButtonPress-1> {goto_window [focus] }
bind $w.list  <ButtonPress-3> { tk_popup .zipperserver.menu.notifypopup [winfo pointerx [focus]] [winfo pointery [focus]] }
bind $w.list <Destroy> {set notifywindow 0}
}                 

 

proc send_to_window { win text } {

    	global chaninfo 
	global response
        global ctag
	global mirccolors
	global textfg
	global textbg
	global actwin

	set refocus [focus]
	set taglist ""
	set tag ".tag$ctag"
	set code ""
	set boldcode "0"
	set invrcode "0"
	set undrcode "0"

	if [string match "dcc:*" $win] {
		set dnick [string range $win 4 end]
		set sock [get_dcc_sock_from_nick $dnick]
		set win dcc$sock
	}

	set win [string tolower $win]

	set striptext $text
	set text [string trimright $text "\n"]
	set text "$text\003$textfg,$textbg"

	set winname $win

	set logging $chaninfo($win,logging)
	set logfile $chaninfo($win,logfile)

	set win $chaninfo($win,name)
        if ![winfo exists $win] {
                set win ".zipperserver"
        }

        if ![is_active $winname ] {
              	 set_chan_activity 1 $winname
       	}
	

	$win.text configure -state normal

	set fg $textfg
	set bg $textbg
	switch -glob -- $text "*\[\002\003\007\017\026\037\]*" { 

		while { [regexp "^(\[^\002\003\007\017\026\037\]*)(\[\002\003\007\017\026\037\])(.*)$"  $text match m1 char text] } {   
			$win.text insert end $m1 $taglist
			set tag ".tag$ctag"
			incr ctag
		switch -- $char {
		\002 	{ 	switch -exact -- $boldcode {
					"0"	{set boldcode 1
						 set code "bold" }
					"1"	{set boldcode 0
						 set code "bdof" }
				}
			}
		\003 	{ 
	                    if [regexp {^([0-9][0-9]?)(,([0-9][0-9]?))?(.*)} $text m fg bl bg text] {
	                        switch -glob -- 0* $fg {set fg [string range $fg 1 end]}
				if [sNull $fg] {
					set fg $textfg
				}
       		                set fg [expr {$fg % 16}]
                        	switch -- {} $bg {} default {
                            	switch -glob -- 0* $bg {
                                	set bg [string range $bg 1 end]
                            	}
				if [sNull $bg] {
					set bg $textbg
				}
                            	set bg [expr {$bg % 16}]
                        	}	
                        } else {
				set fg $textfg
				set bg $textbg
			}
			set code "colr.$fg.$bg" 


			}
		\007    {bell }
		\017 	{lappend taglist $tag; continue}
		\026 	{ 	switch -exact -- $invrcode {
					"0"	{set invrcode 1
						 set code "invr" }
					"1"	{set invrcode 0
						 set code "ivof" }
				}
			}
 		\037    {       switch -exact -- $undrcode {
                                       "0"     {set undrcode 1
                                                set code "undr" }
                                       "1"     {set undrcode 0
                                                set code "unof" }
                               }
                       }
	

	
		}

		conftag $win $taglist


               	lappend taglist $code$tag
		}
	}

conftag $win $taglist
$win.text insert end "$text\n" $taglist
$win.text configure -state disabled
$win.text see end
focus $refocus
if $logging {add_to_log $logfile $striptext}
}

proc conftag {win taglist} {
	global mirccolors
	global textfg
	global textbg

		set fontbold  ZipperB
		set fontnorm  ZipperN
		foreach entry $taglist {	
		set t [string range $entry 0 3]
		switch -- $t {
		"bold"	{ $win.text tag configure $entry -font $fontbold }
		"bdof"	{ $win.text tag configure $entry -font $fontnorm }
		"undr"	{ $win.text tag configure $entry -underline 1 }
		"unof"	{ $win.text tag configure $entry -underline 0 }
		"invr" 	{ $win.text tag configure $entry -foreground $mirccolors($textbg) -background $mirccolors($textfg) }
		"ivof" 	{ $win.text tag configure $entry -foreground $mirccolors($textfg) -background $mirccolors($textbg) }
		
		"colr"  {
				set fg [lindex [split $entry "."] 1]	
				set bg [lindex [split $entry "."] 2]
       	                	$win.text tag configure $entry -foreground $mirccolors($fg)
				if ![string compare $bg ""] {set bg $textbg}
				$win.text tag configure $entry -background $mirccolors($bg)
			}
		}
		}
}
 

proc kill_window w {

        global esvrSock
	global defaultquit
	set w ".[lindex [split $w "."] 1]"
        if ![string compare $w ".zipperserver"] {
#               set eventLoop "Done"
# 		puts stdout "IRC Finished."
#               do_quit "$defaultquit" $esvrSock
        } else {
		set channel [get_chan_name $w]
		remove_chan_list $channel
		closelog $channel
		if [is_channel $channel] {
			send_to_server $esvrSock "PART $channel"
		}
	}

}

proc goto_window w {
        global nick
        set w [split $w "."]
        set w [lindex $w 1]

        set select [string trimleft [.$w.list get active] "> " ]
        set select [string trimleft $select " >+@"]

        if ![string compare "#" [string index $select 0] ] {
                if [winfo exists .zipperwin[winman $select] ] {
                        focus .zipperwin[winman $select].entry
                        raise .zipperwin[winman $select]
                        wm deiconify .zipperwin[winman $select]
			set currchan $select
                        return
                }
        } elseif ![string compare "DCC" [string range $select 0 2] ] {
                set target [string range $select 4 end]
                set response [get_dcc_sock_from_nick $target]
                wm deiconify .zipperdcc$response
                do_query "dcc$response" 0
                focus .zipperdcc$response.entry
		set currchan $select
                return

        } elseif ![sNull $select] { 

		if [winfo exists .zipperwin[winman $select] ] {
                        wm deiconify .zipperwin[winman [string trimleft $select "+@"] ]
                }
                do_query  $select 0
                focus .zipperwin[winman $select].entry
                set_chan_activity 0  $select
		set currchan $select
                return
        }
}

                                   


#proc unknown {name} {

#       puts stdout "Unknown Command Trapped: $name"

#}
#proc bgerror {msg} {

#global serveractive

###gracefully handle errors ie...do nothing about them yet
###puts stdout "Background error detected: $msg"


#	if [string match *sock* $msg] {
#		tk_dialog .bgerror "NETWORK ERROR!" "$msg"  "error" 0 "ok"
#		set serveractive 0			
#	} else {
#		tk_dialog .bgerror "APPLICATION ERROR!" $msg "error" 0 "ok"
#	}

#}                               
proc new_pers_notify {} {

	global installpath
        set w ".zipperpernotify"
        toplevel $w
	wm iconbitmap $w @$installpath/zippericon.xbm
        wm iconname $w "Customize Notify"
        set font ZipperN
	wm  withdraw $w
        wm title $w "Personal Notify List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 15 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 20

        frame $w.buttons
        button $w.buttons.add -text "Add" -command {notify_add}
        button $w.buttons.remove -text "Del" -command {notify_del}
        button $w.buttons.done -text "Done" -command {destroy .zipperpernotify}
        pack $w.buttons -side bottom


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons.add -side left
        pack $w.buttons.remove -side left
        pack $w.buttons.done -side left
	center $w -100 -100
	wm deiconify $w

}
                

 
proc new_pers_server {} {
	global installpath
        set w ".zipperperserv"
        toplevel $w
        wm iconname $w "Customize Server List"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal Servers List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 25 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 20 
	entry $w.box.port -bd 2 -relief sunken  -width 6 

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {server_add}
        button $w.buttons1.remove -text "Del" -command {server_del}
        button $w.buttons1.join -text "Connect" -command {server_connect}

        button $w.buttons2.done -text "Done" -command {server_done}


        pack $w.box.port -side bottom 
        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.join -side left
        pack $w.buttons2.done -side right


        bind $w.box.list <Double-ButtonPress-1> {server_connect; server_done }
}
              

proc new_pers_ignore {} {
	global ignoreindex
	global installpath
        set w ".zipperperig"
        toplevel $w
        wm iconname $w "Customize Ignore"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal Ignore List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 25 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 30

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {ignore_add}
        button $w.buttons1.remove -text "Del" -command {ignore_del}
        button $w.buttons1.update -text "Upd" -command {ignore_upd}
        button $w.buttons2.done -text "Done" -command {ignore_done}


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left

	bind $w.box.list <Double-ButtonPress-1>  { load_ignore_edit; set ignoreindex [.zipperperig.box.list index active] }
}                                       


proc new_pers_channel {} {
global mirccolors
global textfg
global textbg
global installpath
        set w ".zipperperchan"
        toplevel $w
        wm iconname $w "Customize Channels"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal Channels List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 40 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 45

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {channel_add}
        button $w.buttons1.remove -text "Del" -command {channel_del}
        button $w.buttons1.join -text "Join" -command {channel_join}

        button $w.buttons2.names -text "Names" -command {channel_names}
        button $w.buttons2.done -text "Done" -command {channel_done}


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.join -side left
        pack $w.buttons2.names -side left
        pack $w.buttons2.done -side left

        bind $w.box.list <Double-ButtonPress-1> { channel_join ; channel_done }
}                                         

                              
proc new_user_list {} {
	global userindex
	global installpath
        set w ".zipperusers"
        toplevel $w
        wm iconname $w "Customize User list"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal User List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 25 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
	entry $w.box.options -relief sunken -width 6
        entry $w.box.name -bd 2 -relief sunken  -width 30
        entry $w.box.level -bd 2 -relief sunken  -width 4
	

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {user_add}
        button $w.buttons1.remove -text "Del" -command {user_del}
        button $w.buttons1.update -text "Upd" -command {user_upd}
        button $w.buttons2.done -text "Done" -command {user_done}

	pack $w.box.options -side bottom
        pack $w.box.level -side bottom
        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left


	bind $w.box.list <Double-ButtonPress-1>  { load_user_edit; set userindex [.zipperusers.box.list index active] }
}                                       

proc new_event_list {} {
	global eventindex
	global installpath
        set w ".zipperevents"
        toplevel $w
        wm iconname $w "Customize Event list"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal Event List"

        frame $w.box 
        frame $w.f1
        frame $w.f2
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 90 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
	
        entry $w.f1.level -bd 2 -relief sunken  -width 5
        entry $w.f1.type -bd 2 -relief sunken  -width 5
        entry $w.f1.nick -bd 2 -relief sunken  -width 12
        entry $w.f1.channel -bd 2 -relief sunken  -width 15
        entry $w.f1.action -bd 2 -relief sunken  -width 30
        
	label $w.f2.level    -width 5 -text "Level"
        label $w.f2.type    -width 5 -text "Type"
        label $w.f2.nick   -width 12 -text "Nick"
        label $w.f2.channel    -width 15 -text "Channel"
        label $w.f2.action   -width 30 -text "Action"


        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom
	pack $w.f1 -side bottom
	pack $w.f2 -side bottom

        button $w.buttons1.add -text "Add" -command {event_add}
        button $w.buttons1.remove -text "Del" -command {event_del}
	button $w.buttons1.update -text "Upd" -command {event_upd}

        button $w.buttons2.done -text "Done" -command {event_done}

        pack $w.f2.level -side left -fill x
        pack $w.f2.type -side left -fill x
        pack $w.f2.nick -side left -fill x
        pack $w.f2.channel -side left -fill x
        pack $w.f2.action -side left -fill x

        pack $w.f1.level -side left -fill x
        pack $w.f1.type -side left -fill x
        pack $w.f1.nick -side left -fill x
        pack $w.f1.channel -side left -fill x
        pack $w.f1.action -side left -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left


	bind $w.box.list <Double-ButtonPress-1>  { load_event_edit; set eventindex [.zipperevents.box.list index active] }
}




proc set_userlist_popup {} {
global userpopups
global rcdir

set userpopups ""
set m .zipperserver.menu.userlistpopup
set m .zipperserver.menu.notifypopup
set m .zipperserver.menu.channelpopup
menu $m
#menu $m delete 2 end

	 set f [open $rcdir/popuprc r]

        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
		
		if ![string compare [lindex [split $l " "] 0]  "-"] {
			$m add separator
			set userpopups [linsert $userpopups end " "]
			$m add  command -label [string trimleft $l "-"] -foreground red 
			set userpopups [linsert $userpopups end " "]
			$m add separator
			set userpopups [linsert $userpopups end " "]


		} else {
		set lab [lrange [split $l " "] 0 0 ]
		set com [join [lrange [split $l " "] 1 end] " "]
		set userpopups [linsert $userpopups end $com]
		$m add command -label $lab -command {do_menu_command [focus] [ .zipperserver.menu.userlistpopup index active] }
		}
        }            

}                 



proc choose_file {file dir operation} {


    #   Type names              Extension(s)    Mac File Type(s)
    #
    #---------------------------------------------------------
    set types {
        {"All files"            *}
        {"Text files"           {.txt .doc}     }
        {"Text files"           {}              TEXT}
        {"Tcl Scripts"          {.tcl}          TEXT}
        {"C Source Files"       {.c .h}         }
        {"All Source Files"     {.tcl .c .h}    }
        {"Image Files"          {.gif}          }
        {"Image Files"          {.jpeg .jpg}    }
        {"Image Files"          ""              {GIFF JPEG}}
    }
    if {$operation == "open"} {
        set file [tk_getOpenFile -initialdir $dir -filetypes $types -parent .zipperserver -title "Select File"]
    } else {
        set file [tk_getSaveFile -initialdir $dir -filetypes $types -parent .zipperserver -title "Save As..." \
            -initialfile $file ]
    }
    return $file

}


proc create_chanlist_window {} {
	set w ".zipperchannellist"
        toplevel $w
        wm iconname $w "Channels List"
        wm title $w "Channels List"
        set font ZipperN

	frame $w.channels
	frame $w.buttons

	pack $w.buttons -side bottom
	pack $w.channels -side top

	listbox $w.channels.list -width 40 -font ZipperN
	button $w.buttons.done -text "Done" -command { destroy .zipperchannellist }
	scrollbar $w.channels.listscroll -command "$w.channels.list yview"
		
	pack $w.channels.list -side left
	pack $w.channels.listscroll -side right -fill y
	pack $w.buttons.done -side bottom

	bind $w.channels.list  <Double-ButtonPress-1> {join_channel_from_list }

}                

proc new_ctcp_list {} {
	global ctcpindex
	global installpath
        set w ".zipperctcps"
        toplevel $w
        wm iconname $w "Customize CTCP list"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal CTCP List"

        frame $w.box 
        frame $w.f1
        frame $w.f2
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 90 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
	
        entry $w.f1.level -bd 2 -relief sunken  -width 5
        entry $w.f1.type -bd 2 -relief sunken  -width 9
        entry $w.f1.nick -bd 2 -relief sunken  -width 12
        entry $w.f1.channel -bd 2 -relief sunken  -width 15
        entry $w.f1.action -bd 2 -relief sunken  -width 30
        
	label $w.f2.level    -width 5 -text "Level"
        label $w.f2.type    -width 9 -text "Type"
        label $w.f2.nick   -width 12 -text "Nick"
        label $w.f2.channel   -width 15 -text "Channel"
        label $w.f2.action   -width 30 -text "Action"


        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom
	pack $w.f1 -side bottom
	pack $w.f2 -side bottom

        button $w.buttons1.add -text "Add" -command {ctcp_add}
        button $w.buttons1.remove -text "Del" -command {ctcp_del}
	button $w.buttons1.update -text "Upd" -command {ctcp_upd}
        button $w.buttons2.done -text "Done" -command {ctcp_done}

        pack $w.f2.level -side left -fill x
        pack $w.f2.type -side left -fill x
        pack $w.f2.nick -side left -fill x
        pack $w.f2.channel -side left -fill x
        pack $w.f2.action -side left -fill x

        pack $w.f1.level -side left -fill x
        pack $w.f1.type -side left -fill x
        pack $w.f1.nick -side left -fill x
        pack $w.f1.channel -side left -fill x
        pack $w.f1.action -side left -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left


	bind $w.box.list <Double-ButtonPress-1>  { load_ctcp_edit; set ctcpindex [.zipperctcps.box.list index active] }
}
proc create_banlist_window {chan} {
	global installpath
	set w ".zipperbanlist"
        toplevel $w
	grab $w
        wm iconname $w "Channel Ban List"
	wm iconbitmap $w @$installpath/zippericon.xbm
        wm title $w "Ban List"
        set font ZipperN

	frame $w.bans
	frame $w.buttons

	pack $w.buttons -side bottom
	pack $w.bans -side top
	label $w.bans.channel -width 40 -text $chan
	listbox $w.bans.list -width 40 -font ZipperN
	button $w.buttons.done -text "Done" -command { destroy .zipperbanlist }
	button $w.buttons.unban -text "Unban" -command { unban_button }
	scrollbar $w.bans.listscroll -command "$w.bans.list yview"
		
	pack $w.bans.channel -side top
	pack $w.bans.list -side left
	pack $w.bans.listscroll -side right -fill y
	pack $w.buttons.unban -side left
	pack $w.buttons.done -side bottom


}                

proc ask_user {title text} {
	global response
	global installpath
	set value ""
	set w ".askuser"
        toplevel $w
        wm iconname $w "$title"
	wm iconbitmap $w @$installpath/zippericon.xbm
        wm title $w "$title"
	button $w.ok -text "OK" -command {set response [.askuser.entry get]; destroy .askuser} 
#	label $w.label -width 40 -text $text
	message $w.label -width 3i -justify center -text $text
	entry $w.entry -width 40 -relief sunken

	pack $w.ok -side bottom
	pack $w.entry -expand yes -fill x -side bottom
	pack $w.label -expand yes -fill both -side top


	bind $w.entry <KeyPress-Return> {set response "[.askuser.entry get]"; destroy .askuser}

	focus .askuser.entry	
	tkwait window .askuser
	set value $response
	return $value
}


proc add_system_menus {w} {
global installpath
global giftype

if $giftype<9 {
	set pic [image create photo -file "$installpath/z_logosmall.gif"]
} else {
	set pic [image create photo -file "$installpath/z.gif"]
}

label $w.menu.pic  -height 20 -image $pic
pack $w.menu.pic -side left

set m $w.menu.file.m
menubutton $w.menu.file -text "File" -menu $m
menu $m -tearoff no
$m add command -label "Setup" -command { modify_setup }
$m add separator
$m add command -label "Connect" -command { open_irc_connection}
$m add command -label "Disconnect" -command { close_irc_connection}
$m add separator
$m add command -label "Exit" -command {fake_user_in "/quit $defaultquit" }

pack $w.menu.file -side left

set m $w.menu.edit.m
menubutton $w.menu.edit -text "Edit" -menu $m
menu $m -tearoff no
$m add command -label "Aliases..." -command { fake_user_in "/edit alias" }
$m add command -label "CTCP..." -command { fake_user_in "/edit ctcp" }
$m add command -label "Events..." -command { fake_user_in "/edit events" }
$m add command -label "Ignore..." -command { fake_user_in "/edit ignore" }
$m add command -label "Notify..." -command { fake_user_in "/edit notify" }
$m add command -label "Users..." -command { fake_user_in "/edit users" }
$m add command -label "Startup..." -command { fake_user_in "/edit startup" }
$m add separator
$m add command -label "Add/Del Channel..." -command { modify_channels }
$m add command -label "Add/Del CTCP..." -command { modify_ctcps }
$m add command -label "Add/Del Event..." -command { modify_events }
$m add command -label "Add/Del Server..." -command { modify_servers }
$m add command -label "Add/Del User..." -command { modify_users }

pack $w.menu.edit -side left
                                                                     

set m $w.menu.about.m
menubutton $w.menu.about -text "About" -menu $m
menu $m -tearoff no

pack $w.menu.about -side right
$m add command -label "Zipper!" -command { do_about }
$m add separator
$m add command -label "README" -command { exec tkview $installpath/README & }
$m add command -label "CHANGES" -command { exec tkview $installpath/CHANGES & }
$m add command -label "FEATURES" -command { exec tkview $installpath/FEATURES & }
}



proc do_about {} {
splash
}


proc splash {} {
	global installpath
	global giftype
	global version

	set w ".splash"
	toplevel $w -background blue
	wm overrideredirect $w 1

	if $giftype<9 {
		set pic [image create photo -file "$installpath/zipperlogo.gif"]
		label $w.text1 -text "Zipper! Version $version" -background blue -foreground white
	} else {
		$w configure -background brown
		set pic [image create photo -file "$installpath/zbig.gif"]
		label $w.text1 -text "Zipper! Version $version" -background brown -foreground gold
		label $w.text3 -text "Z compliments of Dan :)" -background brown -foreground gold
		label $w.text2 -text "Copyright 1998 by Ash Bowers" -background brown -foreground gold
		pack $w.text3 -side bottom
		pack $w.text2 -side bottom
	}

#	set tcltklogo_gif [image create photo -file "$installpath/tcltklogo.gif"]
#	label $w.tcl   -image $tcltklogo_gif
	
	label $w.pic   -image $pic
	pack $w.pic
#	pack $w.tcl -side right
	pack $w.text1 -side bottom
	center $w 0 0 
	after 10000 {destroy .splash}

}
proc new_pers_url {} {
	global urlindex
	global installpath
        set w ".zipperurl"
        toplevel $w
        wm iconname $w "Customize URLs"
	wm iconbitmap $w @$installpath/zippericon.xbm
        set font ZipperN

        wm title $w "Personal URL List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 50 -font ZipperN
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 30

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {url_add}
        button $w.buttons1.remove -text "Del" -command {url_del}
#        button $w.buttons1.update -text "Upd" -command {url_upd}
        button $w.buttons2.done -text "Done" -command {url_done}


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
#        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left

	bind $w.box.list <Double-ButtonPress-1>  { launch_url [.zipperurl.box.list get active] }
}

proc add_icon {win ic w} {
	set tl ".iconwin$win"

	if [winfo exists $tl] {return}
	toplevel $tl -bg blue
	wm withdraw $tl
	image create photo "icon_4_$win" -file $ic
	label $tl.icon -image "icon_4_$win" -width 32 -height 32 -bd 0 -bg blue
	pack $tl.icon -ipadx 2 -ipady 2
	update idletasks
	wm geometry $tl [winfo reqwidth $tl]x[winfo reqheight $tl] 
	wm protocol $tl WM_DELETE_WINDOW "$tl delete"

	wm iconwindow $w $tl
	
}                                       
