#!/bin/sh
# the next line restarts using wish \
exec tclsh "$0" "$@"                        


set  installpath [exec where.tcl]
set auto_path "$auto_path $installpath" 
package require inet 1.02

proc dcc_send {port file host} {
global s_sock
	puts "PORT:$port"
	set s_sock [socket -server "transmit $file" $port]

}

proc transmit {file sock addr port} {
global s_sock
	close $s_sock

	set totlen 0
	fconfigure $sock -blocking on -buffering full -buffersize 2048 -translation binary
	puts "XMSG:Transferring...\n"
	if ![file exists $file] {
		puts "XMSG:File Not Found!"
		exit
	}
	set fl [file size $file]	
	set r 0
	set f [open $file "r"]
	fconfigure $f -blocking on -buffering full -buffersize 1024 -translation binary
	while ![eof $f] {
		set l [read $f 1024]
		set len [string length $l]
		set totlen [expr $totlen+$len]
		puts "XTRN:$totlen"
		puts -nonewline $sock $l
		flush $sock
		while $totlen!=$r {
			set rlen [read $sock 4]
			binary scan $rlen I r
			puts "XMSG:$r bytes Acknowledged"
		}
	}
	close $f
	close $sock
	
	puts "XMSG:Transfer Complete\n"
	puts "DONE:Transfer Complete\n"
	set done 1
	exit

}

proc dcc_get {host port file size} {


	set error [catch { set sock [socket $host $port] } ]
	
	if $error {
		puts "XMSG:Cannot Connect to remote host"
		exit
	}


	fconfigure $sock -blocking off -buffering none -buffersize 4096 -translation binary
	puts "XMSG:Transferring...\n"
	set f [open $file "w"]

	set totlen 0
	
	while ![eof $sock] {
		set l [read $sock 4096]
		puts -nonewline $f $l
		set len [string length $l]
		set totlen [expr $totlen+$len]
		puts "XTRN:$totlen"
		puts "XMSG:Received: $totlen"
		set x [htonl $totlen]	
		set x [binary format i $x]
		puts -nonewline $sock $x
		flush $sock
		if $totlen==$size {break}
	}
	close $sock
	close $f
	if $totlen==$size {
		puts "DONE:Transfer Complete\n"
	} else {
		puts "XMSG:$totlen--Transfer Incomplete!"
	}	
	exit


}

proc error {msg} {
	puts "XMSG:$msg"
}
proc bgerror {msg} {
	puts "XMSG:$msg"
}


### MAIN
set s_sock ""
set done ""

if $argc<2 { exit }

set type [lindex $argv 0]
set port [lindex $argv 2]
set size [lindex $argv 4]
set byteorder $tcl_platform(byteOrder)

if $type==0 {
	dcc_get [lindex $argv 1] $port [lindex $argv 3] $size
} else {
	dcc_send $port [lindex $argv 3] [lindex $argv 1]
}
vwait done
exit
