#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/Sound.tcl,v $
# $Date: 1996/09/06 09:15:32 $
# $Revision: 1.17.1.10 $
#
if [string match {7.[67]} [info tclversion]] {
#
proc sendSound {net nk} {
    global SoundDir zircon
    if ![info exists SoundDir($net)] {
	if [file exists [file join $zircon(prefdir) sounds]] {
	    set SoundDir($net) $zircon(prefdir)/sounds
	} {
	    set SoundDir($net) [file join $zircon(lib) sounds]
	}
    }
    doSendSound $net $nk [tk_getOpenFile -defaultextension wav \
      -filetypes {{{Wav format sound files} {.\[wW\]\[aA\]\[vV\]}}} \
      -initialdir $SoundDir($net)]
}
#
} {
#
proc sendSound {net nk} {
    global ztrans SoundDir zircon
    set msg "Play sound file for $nk"
    if ![info exists SoundDir($net)] {
	if [file exists [file join $zircon(prefdir) sounds]] {
	    set SoundDir($net) $zircon(prefdir)/sounds
	} {
	    set SoundDir($net) [file join $zircon(lib) sounds]
	}
    }
    tkwait window [mkFileBox {} SoundDir($net) {.*\.[wW][aA][vV]} \
	$ztrans(sound) $msg {} \
	"$ztrans(send) {doSendSound $net $nk}" "$ztrans(dismiss) {}"]
}
#
}
#
proc handleSound {net usr param} {
    global zircon
    if ![string match {} $zircon(wavplayer)] {
	set dirs [split $zircon(wavpath) :]
	lappend dirs [file join $zircon(prefdir) sounds] \
	  [file join $zircon(lib) sounds]
	set fl [lindex $param 1]
	if [string match {} [file extension $fl]] { append fl .wav }
	foreach x $dirs {
	    if [file exists [file join $x $fl]] {set fl "[file join $x $fl]" ; break }
	}
	if [catch {exec $zircon(wavplayer) $fl &} msg] {
	}
    }
}
#
proc doSendSound {net nk fl} {
    if ![string match {} $fl] {
	$net CTCP SOUND $nk "$fl <$fl>"
	handleSound $net [$net nickname] "SOUND $fl"
    }
}
#
proc addSoundMenu {net menu chid} {
    global zircon ztrans
    if ![string match {} $zircon(wavplayer)] {
	$menu add cascade -label $ztrans(sound) -menu $menu.sound
	menu $menu.sound -postcommand "buildSMenu $net $menu.sound $chid"
	catch {$menu.sound configure  -tearoffcommand "retitle {Sounds for [$chid name]}"}
    }
}
#
proc buildSMenu {net menu chid} {
    global zircon
    $menu delete 0 end
    set ptn {*.[wW][aA][vV]}
    set wavs {}
    set dirs [split $zircon(wavpath) :]
    lappend dirs [file join $zircon(prefdir) sounds] \
      [file join $zircon(lib) sounds]
    foreach x $dirs {
	if ![string match {} [set wvs [glob -nocomplain [file join $x $ptn]]]] {
	    foreach y $wvs { lappend wavs [file tail $y] }
	}
    }
    if [string match {} $wavs] {
	foreach y [glob -nocomplain $ptn] { lappend wavs [file tail $y] }
    }
    $menu add command -label {Other file} -command "sendSound $net {[$chid name]}"
    $menu add separator
    foreach x [lsort $wavs] {
	$menu add command -label [file tail [file rootname $x]] \
	  -command "doSendSound $net {[$chid name]} {$x}"
    }
}
