#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/dbgsrv.tcl,v $
# $Date: 1996/09/16 10:29:10 $
# $Revision: 1.17.1.2 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1996 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
if [string match {7.[567]} [info tclversion]] {
#
set zircsrv {}
#
proc DebugServer {w} {
    global zircsrv zircon
    if [catch {socket -server acceptIRC 6667} zircsrv] {
	return 0
    }
    $w configure -state disabled
    set ctl [toplevel .@dbgsrv -class Zircon]
    wm title $ctl "Zircon Dummy Server"
    wm resizable $ctl 1 1
    set f [frame $ctl.btn]
    button $f.stop -text Stop -command "DSClose $w $ctl" -width 8
    button $f.close -text Close -width 8 -command {
	catch {close $zircsin}
	set zircsin {}
	.@dbgsrv.entry configure -state disabled
    }
    pack $f.stop $f.close -expand 1 -side left
    pack $f -fill x
    pack [frame $ctl.l1 -background $zircon(sepColor) -borderwidth 2] -fill x -pady 4
    pack [set f [frame $ctl.resp]] -fill x
    pack [menubutton $f.cnct -text Connect -menu $f.cnct.menu] -side left -expand 1
    set m [menu $f.cnct.menu]
    $m add command -label Accept -command "DSAccept $ctl.txt"
    $m add command -label Unavailable -command "DSUnavailable $ctl.txt ztest"
    pack [menubutton $f.join -text Join -menu $f.join.menu] -side left -expand 1
    set m [menu $f.join.menu]
    $m add command -label Join -command "DSJoin1 $ctl.txt #ztest ztest"
    $m add command -label Join1 -command "DSJoin2 $ctl.txt #ztest ztest1"
    $m add command -label Unavailable -command "DSUnavailable $ctl.txt #ztest"
    pack [frame $ctl.l2 -background $zircon(sepColor) -borderwidth 2]\
       -fill x -pady 4
    set f [frame $ctl.txt]
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 0 -weight 1
    scrollbar $f.vs -command "$f.txt yview"
    scrollbar $f.hs -command "$f.txt xview" -orient horizontal
    text $f.txt -xscrollcommand "$f.hs set" -yscrollcommand "$f.vs set" \
      -wrap none
    $f.txt tag configure out -foreground red
    $f.txt tag configure in -foreground blue
    grid $f.txt -row 0 -column 0 -sticky nsew
    grid $f.vs -column 1 -row 0 -sticky ns
    grid $f.hs -column 0 -row 1 -sticky ew
    pack $f -expand 1 -fill both
    emacsEntry $ctl.entry -relief sunken -state disabled
    pack $ctl.entry -fill x
    bind $ctl.entry <Return> "DSPut $f \[%W get\] ; %W delete 0 end"
    return 1
}
#
proc DSPut {w txt} {
    global zircsin
    if ![string match :* $txt] { set txt ":[info hostname] $txt" }
    puts $zircsin $txt
    $w.txt insert end <$txt out "\n"
    $w.txt see end
}
#
proc DSClose {w ctl} {
    global zircsrv zircsin
    catch {close $zircsrv}
    catch {close $zircsin}
    set zircsrv {}
    destroy $ctl
    $w configure -state normal
}
#
proc acceptIRC {s x y} {
    global zircsin
    set zircsin $s
    .@dbgsrv.txt.txt insert end "*** request from $x $y" in "\n"
    .@dbgsrv.txt.txt see end
    fileevent $zircsin readable "dbgSIN $s"
    fconfigure $s -blocking 0 -translation {lf lf} -buffering line
    .@dbgsrv.entry configure -state normal
}
#
proc dbgSIN {sock} {
    if [eof $sock] {
	close $sock
	.@dbgsrv.txt.txt insert end {**** Connection closed} in "\n"
    } {
	set line [gets $sock]
	.@dbgsrv.txt.txt insert end >$line in "\n"
    }
   .@dbgsrv.txt.txt see end
}
#
proc DSAccept {w} {
    set h [info hostname]
    set v 1.1
    DSPut $w {001 ztest :Welcome to the Zircon Test Harness ztest}
    DSPut $w "002 ztest :Your host is $h, running version $v"
    DSPut $w {003 ztest :This server was created sometime}
    DSPut $w "004 ztest $h $v oiwsg biklmnopstv"
    DSPut $w {251 ztest :There are 2707 users and 358 invisible on 27 servers}
    DSPut $w {252 ztest 14 :operator(s) online}
    DSPut $w {253 ztest 2 :unknown connection(s)}
    DSPut $w {254 ztest 994 :channels formed}
    DSPut $w {255 ztest :I have 1 clients and 0 servers}
    DSPut $w "375 ztest :- $h Message of the Day - "
    DSPut $w {372 ztest :- Welcome to the zircon test harness}
    DSPut $w {372 ztest :- Rules:}
    DSPut $w {376 ztest :End of /MOTD command.}
}
#
proc DSUnavailable {w nk} {
     DSPut $w "437 ztest $nk :temporarily unavailable"
}
#
proc DSJoin1 {w chn nk} {
    DSPut $w ":$nk!nlfm@catless.ncl.ac.uk JOIN :$chn"
    DSPut $w "353 $nk = $chn :@$nk"
    DSPut $w "353 $nk = $chn :@user1 nick1 nick2 nick3 nick4 nick5 nick6"
    DSPut $w "353 $nk = $chn :@user2 user3 user4 user5 user6 user7 user8"
    DSPut $w "366 $nk $chn :End of /NAMES list."
}
#
proc DSJoin2 {w chn nk} {
    DSPut $w ":$nk!nlfm@catless.ncl.ac.uk JOIN :$chn"
    DSPut $w "353 $nk = $chn :@$nk fred1 fred2 fred3"
    DSPut $w "353 $nk = $chn :@user2 user3 user4 user5 user6 user7 user8"
    DSPut $w "366 $nk $chn :End of /NAMES list."
}
#
} {
#
proc DebugServer {} { }
#
}
