#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/dcc.tcl,v $
# $Date: 1996/09/06 10:24:35 $
# $Revision: 1.17.1.29 $
#
proc DCCSend {usr file} {
    if [string match {} $file] return
    if [file exists $file] {
	if ![file readable $file] {
	    tellError {File error} "Cannot read file \"$file\"."
	    return
	}
	set net [$usr net]
	set file [glob $file]
	set xfile [file tail $file]
	global zircon
	upvar #0 Offer$net Offer
	if [catch {set fd [open "|$zircon(lib)/dccsend $file 00 $usr" r]}] {
	    tellError {Prog error} "Cannot run DCC helper program dccsend. Check your installation"
	    return
	}
	gets $fd port
	if ![info exists Offer($usr)] { $usr ref }
	lappend Offer($usr) [list [lindex $port 1] $file $fd]
	$net CTCP DCC [$usr name] \
	  "SEND $xfile [ipPack [ipAddress]] [lindex $port 0] [file size $file]"
	fileevent $fd readable "handleInfo $net $fd"
	if [winfo exists .@dls$net] { buildDCCList $net }
    } {
	tellError {File error} "File \"$file\" does not exist."
    }
}
#
proc doDCC {cmd nk} {
    if {![string match {} $nk] && ![string match {[#&]*} $nk]} {[User :: make $nk] dcc $cmd}
}
#
proc closeChat {cht who conn} {
    catch {clearHandler $conn ; close $conn}
    catch {uplevel #0 unset $conn}
    if ![string match {} [info proc $cht]] {
	$cht addText $who "*** $who has closed the connection"
    }
}
#
proc dccChat {mode conn} {
    upvar #0 $conn chdata
    set who [$chdata(who) name]
    set cht $chdata(obj)
    switch $mode {
    r   {
	    if {[catch {gets $conn} buffer] || 
	      ([string match {} $buffer] && [eof $conn])} {
		closeChat $cht $who $conn
	    } {
		regsub -all "\r" $buffer {} buffer
		if [regexp "(\[^\001\]*)\001(\[^\001\]*)\001(\[^\001\]*)" \
		  $buffer sub a cp b] {
		    set ctcp [split $cp]
		    set value [handleCTCP [$cht net] \
		      [lindex $ctcp 0] $cht Chat [$cht caller] {} {} "$cp"]
		    if [string match {} $value] return
		    set buffer "${a}${value}$b"
		}
		$cht addText $who "=$who= $buffer"
	    }
	}
    e   {  [$chData(who) net] errmsg "Error on DCC Chat connection with $who" }
    }
}

proc handleInfo {net conn} {
    if {[catch {gets $conn} msg] || ([string match {} $msg] && [eof $conn])} {
	catch {close $conn}
    } {
	global ztrans
	upvar #0 Offer$net Offer Send$net Send Get$net Get
	if [$net monitorIn] {zIn "! $msg"}
	set sp [split $msg { }]
	set who [lindex $sp 5]
	set pid [lindex $sp 0]
	set msg [join [lreplace [lrange $sp 1 end] 4 4 [$who name]]]
	switch -glob -- $msg {
	{DCC Get conn*} {
		set x [lsearch $Get($who) "$pid *"]
		if [winfo exists .@dls$net] { buildDCCList $net }
		dccWindow $conn $who Get [lindex [lindex $Get($who) $x] 1]
		return
	    }
	{DCC Send acc*} { return }
	{DCC Send conn*} {
		set x [lsearch $Offer($who) "$pid *"]
		if ![info exists Send($who)] {$who ref}
		lappend Send($who) [set cd [lindex $Offer($who) $x]]
		listdel Offer($who) $x
		if [string match {} $Offer($who)] { unset Offer($who) ; $who deref }
		if [winfo exists .@dls$net] { buildDCCList $net }
		dccWindow $conn $who Send [lindex $cd 1]
		return
	    }
	{DCC Get prog*} -
	{DCC Send prog*} {
		catch {dccProgress $conn [lindex $sp 6] [lindex $sp 7] \
		  [lindex $sp 8] [lindex $sp 9]}
		return
	    }
	{DCC Send*} -
	{DCCError Send*} {
		set x [lsearch $Send($who) "$pid *"]
		listdel Send($who) $x
		if [string match {} $Send($who)] { unset Send($who) ; $who deref} 
		if [winfo exists .@dls$net] { buildDCCList $net}
		if ![winfo exists .@$conn] {
		    $net inform $msg 
		} {
		catch {destroy .@$conn.meter .@$conn.txt .@$conn.txt2}
		if [winfo exists .@$conn.done] {
		    .@$conn.done configure -text $msg
		} {
		    pack [label .@$conn.done -text $msg] \
		      -before .@$conn.cancel -padx 10 -pady 10
		}
		.@$conn.cancel configure -text $ztrans(dismiss) \
		  -command "destroy .@$conn"
		}
		return
	    }
	{DCCError Get*} -
	{DCC Get*} {
		set x [lsearch $Get($who) "$pid *"]
		listdel Get($who) $x
		if [string match {} $Get($who)] { unset Get($who) ; $who deref}
		if [winfo exists .@dls$net] { buildDCCList $net }
		if ![winfo exists .@$conn] {
		    $net inform $msg
		} {
		catch {destroy .@$conn.meter .@$conn.txt .@$conn.txt2}
		if [winfo exists .@$conn.done] {
		    .@$conn.done configure -text $msg
		} {
		    pack [label .@$conn.done -text $msg] \
		      -before .@$conn.cancel -padx 10 -pady 10
		}
		.@$conn.cancel configure -text $ztrans(dismiss) \
		  -command "destroy .@$conn"
		}
		return
	    }
	default {
		set msg "WEIRD ERROR : $msg"
	    }
	}
	mkInfoBox DCCINFO .@dcc$conn {DCC Info} $msg
    }
}
#
proc doGetDCC {net wh usr addr port leng args} {
    if [string match {} $args] return
    if [catch {set host [dectonet $addr]}] return
    if ![string compare Chat $wh] {
	if [catch {connect $host $port} sok] {
	    $net display {} "*** Cannot connect to host $host ($sok)"
	    return 0
	}
	catch {chatBuffer $sok}
	upvar #0 $sok chdata
	set chdata(who) $usr
	[set chdata(obj) [set this [Chat [$usr name] -caller $usr]]] show
	$this addUser $chdata(who) 0 0
	$this configure -sock $sok
	handler $sok re dccChat
    } {
	if {[file exists [set file [lindex $args 0]]] && 
	  ![file writable $file]} {
	    mkDialog {} .@fe {File error} "Cannot write file $file." \
	      {} {Dismiss {}}
	    return 0
	}
	global zircon
	upvar #0 Get$net Get
	set file [file dirname $file]/[file tail $file]
	if [$net monitorOut] { zOut "! dccget $host $port $file 00 $usr $leng" }
	if [catch {open "|$zircon(lib)/dccget $host $port $file \
	  00 $usr $leng" r} fd] {
	    tellError {Prog error} "Cannot run DCC helper program dccget - $fd. Check your installation"
	    return 0
	} {
	    gets $fd pid
	    fileevent $fd readable "handleInfo $net $fd"
	    if ![info exist Get($usr)] {$usr ref}
	    lappend Get($usr) [list $pid $file $fd]
	}
    }
    return 1
}
#
proc dccPick {net win y} {
    global DCCList ztrans
    notIdle {}
    if [string match {} [set t [$win curselection]]] { set t [$win nearest $y] }
    set rt {}
    foreach x $t {
	lappend calls [lindex $DCCList($net) $x]
	lappend rt $x
    }
    $win delete [lindex $t 0] [lindex $t end]
    foreach l $calls {
	set usr [lindex $l 1]
	set addr [lindex $l 2]
	set port [lindex $l 3]
	set fln [lindex $l 4]
	set leng [lindex $l 5]
	switch [set op [lindex $l 0]] {
	Send {handleSend $net $fln $usr $addr $port $leng }
	default { doGetDCC $net $op $usr $addr $port {} {} }
	}
    }
    foreach x $rt {
	[lindex [lindex $DCCList($net) $x] 1] deref
	listdel DCCList($net) $x
    }
    if [string match {} $DCCList($net)] { destroy .@drq$net }
}
#
proc dccDel {net win} {
    notIdle {}
    if ![string match {} [set t [$win curselection]]] {
	global DCCList
	$win delete [lindex $t 0] [lindex $t end]
	foreach x $t {
	    [lindex [lindex $DCCList($net) $t] 1] deref
	    listdel DCCList($net) $t
	}
	if [string match {} $DCCList($net)] { destroy .@drq$net }
    }
}
#
proc addDCCRequest {net op usr fln addr port leng} {
     global DCCList
     if ![winfo exists [set w .@drq$net]] {
	set DCCList($net) {}
	toplevel $w -class Zircon
	wm title $w {Incoming DCC Requests}
	makeLB $w.lb -setgrid 1 -width 40 -height 8 
	pack $w.lb
	bind $w.lb.l <Double-Button-1> "dccPick $net %W %y ; break"
	bind $w.lb.l <Delete> "dccDel  $net %W ; break"
	bind $w.lb.l <BackSpace> [bind %W <Delete>]
	bind $w.lb.l <Control-h> [bind %W <Delete>]
	bind $w.lb <Any-Enter> {focus %W.l ; notIdle {} ; break}
     }
     $w.lb.l insert end "[$usr name] : $op $fln"
     popup $w
     lappend DCCList($net) [list $op $usr $addr $port $fln $leng]
     $usr ref
}
#
if [string match {7.[67]} [info tclversion]] {
proc handleSend {net fln usr addr port leng} {
    global ztrans GetDir zFileTypes
    if [catch {set dir $GetDir($net)}] { set GetDir($net) [set dir [pwd]] }
    set msg "DCC Send request ($fln) from [$usr name]"
    doGetDCC $net Get $usr $addr $port $leng \
      [tk_getSaveFile -initialdir $dir -initialfile $fln -filetypes $zFileTypes]
}
} {
proc handleSend {net fln usr addr port leng} {
    global ztrans GetDir
    set msg "DCC Send request ($fln) from [$usr name]"
    tkwait window [mkFileBox {} GetDir($net) .* "DCC Send $fln" $msg $fln \
      "$ztrans(accept) {doGetDCC $net Get $usr $addr $port $leng}" \
      "$ztrans(reject) {}"]
}
}
#
proc handleDCC {net usr param prefix} {
    set pars [split $param]
    set addr [lindex $pars 3]
    set port [lindex $pars 4]
    switch -exact -- [lindex $pars 1] {
    SEND {
	    if [string match ".*" [set fln [lindex $pars 2]]] {
		set fln _[string range $fln 1 end]
	    }
	    set leng [lindex $pars 5]
	    foreach x [$net autoget] {
		if [regexp $x $prefix] {
		    handleSend $net $fln $usr $addr $port $leng
		    return
		}
	    }
	    addDCCRequest $net Send $usr $fln $addr $port $leng
	}  
    CHAT {
	    foreach x [$net autochat] {
		if [regexp $x [string range $prefix 1 end]] {
		    doGetDCC $net Chat $usr $addr $port {} {}
		    return
		}
	    }
	    addDCCRequest $net Chat $usr {} $addr $port {}
	}
    }
}
#
proc ipPack {ip} {
    set val 0
    foreach x [split $ip "."] {	set val [expr {($val << 8) + $x}] }
    return [format %u $val]
}
#
proc dectonet {dec} {
    if {[string length $dec] == 10 && [set first [string index $dec 0]] > 1} {
	switch -exact -- $first {
	    2 {set overflow "0 148 53 119"}
	    3 {set overflow "0 94 208 178"}
	    4 {set overflow "0 40 107 238"}
	}
	set dec [string range $dec 1 end]
    } else {
	set overflow {0 0 0 0}
    }   

    scan [format "%08x" $dec] "%2x%2x%2x%2x" net(3) net(2) net(1) net(0)

    for {set part 0; set carry 0} {$part < 4} {incr part} {
	set sum [expr {$net($part) + [lindex $overflow $part] + $carry}]
	set internet($part) [expr {$sum % 256}]
	set carry [expr {$sum / 256}]
    }

    return "$internet(3).$internet(2).$internet(1).$internet(0)"
}
#
proc killDel {arr usr file} {
    upvar #0 $arr gs
    set i 0
    if ![info exists gs($usr)] return
    foreach p $gs($usr) {
	if ![string compare [lindex $p 1] $file] {
	    catch {exec kill -9 [lindex $p 0]} msg
	    listdel gs($usr) $i
	    if [string match {} $gs($usr)] {
		unset gs($usr)
		$usr deref
	    }
	    set conn [lindex $p 2]
	    catch {fileevent $conn readable {}}
	    catch {close $conn}
	    return
	}
	incr i
    }
}
#
proc dccClose {win} {
    foreach t [$win curselection] {
	set x [split [$win get $t]]
	set usr [User :: find [set who [lindex $x 2]]]
	set file [lindex $x 4]
	switch -glob -- $x {
	{Call -*} {$usr unChat }
	{Call from*} { }
	Chat* {catch {[Chat :: find $who] leave}}
	Get* -
	Send* -
	Offer* {
		set net [$usr net]
		set arr [lindex $x 0]
		upvar #0 $arr$net av
		foreach f $av($usr) {
		    if ![string compare $file [lindex $f 1]] {
			killDel $arr$net $usr $file
			break
		    }
		}
	    }
	Request* { }
	}
    }
    foreach t [$win curselection] { $win delete $t }
}
#
proc buildDCCList {net args} {
    global ztrans
    set w .@dls$net
    if [winfo exists $w] {
	popup $w
	if [string match {} $args] { $w.dcc.l delete 0 end }
    } {
	toplevel $w -class Zircon -relief raised -borderwidth 2
	wm title $w {DCC Connections}
	wm protocol $w WM_DELETE_WINDOW "destroy $w"
	makeLB $w.dcc -setgrid 1
	frame $w.btn
	button $w.btn.ok -text $ztrans(dismiss) -command "destroy $w" -relief raised
	button $w.btn.close -text $ztrans(close) -relief raised \
	  -command "dccClose $w.dcc.l"
	pack $w.btn.ok $w.btn.close -side left -expand 1 -fill x
	pack $w.dcc -fill both
	pack $w.btn -fill x
    }
    upvar #0 Offer$net Offer Send$net Send Get$net Get AChat$net AChat
    foreach nn [array names AChat] {
	$w.dcc.l insert end "$ztrans(call) - [$nn name]"
    }
    foreach nn [$net chats] {
	if [string compare *default* [set nm [$nn name]]] {
	    $w.dcc.l insert end "$ztrans(chat) - $nm"
	}
    }
    foreach arr {Offer Send Get} {
	foreach nn [array names $arr] {
	   foreach fl [set ${arr}($nn)] {
		$w.dcc.l insert end "[trans $arr] - [$nn name] : [lindex $fl 1]"
	   }
	}
    }
}
#
proc usersDCC {net cmd} {
    global ztrans
    switch $cmd {
    List -
    Close { buildDCCList $net }
    default {
	    mkEntryBox .@$cmd $cmd "Enter user name for DCC $cmd:" \
	      "{$ztrans(user) {}}" \
	      "$ztrans(ok) {doDCC [string toupper $cmd]}" "$ztrans(cancel) {}"
	}
    }
}
#
proc dccWindow {conn usr array file} {
    global ztrans
    if [winfo exists [set w .@$conn]] return
    toplevel $w -class Zircon
    if ![string compare $array Send] {
	wm title $w "DCC send $file to [$usr name]"
    } {
	wm title $w "DCC get $file from [$usr name]"
    }
    wm protocol $w WM_DELETE_WINDOW {}
    frame $w.meter -relief raised
    scale $w.meter.slide -from 0 -to 100 -tickinterval 20 \
       -state disabled -length 200 -orient horizontal
    pack $w.meter.slide -padx 10 -pady 5 -fill x
    pack $w.meter -fill x 
    frame $w.txt
    pack [label $w.txt.bytes -text {0 bytes transferred}] -padx 10 -side left
    pack [label $w.txt.pcnt -text {0% complete}] -side left -padx 10
    frame $w.txt2
#    pack [label $w.txt2.left -text {}]
    pack $w.txt $w.txt2 -fill x -pady 5
    button $w.cancel -text $ztrans(cancel) \
      -command "killDel $array[$usr net] $usr {$file} ; destroy .@$conn"
    pack $w.cancel -fill x
}
#
proc dccProgress {conn bytes pcnt min sec} {
    set w .@$conn
    $w.txt.bytes configure -text "$bytes bytes transferred."
    $w.txt.pcnt configure -text "$pcnt% complete"
#    $w.txt2.left configure -text "${min}m ${sec}s remaining"
    $w.meter.slide configure -state normal
    $w.meter.slide set $pcnt
    $w.meter.slide configure -state disabled
    update idletasks
}
