#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/debug.tcl,v $
# $Date: 1996/09/16 10:29:14 $
# $Revision: 1.17.1.17 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
proc zshow {line} {
    if [winfo exists .@dbgctl] {
	global zscr
	set w .@dbgctl.bdydbg.txt
	$w configure -state normal
	$w insert end ">> $line\n"
	$w configure -state disabled
	if $zscr(dbg) { $w see end }
	update idletasks
    }
}
#
proc zKill {} { exit }
#
proc zWClear {txt} {
    $txt configure -state normal
    $txt delete 1.0 end
    $txt configure -state disabled
}
#
proc zDbgHist {inc ent} {
    global DBGPos
    $ent delete 0 end
    set rng [.@dbgctl.bdydbg.txt tag ranges input]
    set foo [lindex $rng $DBGPos]
    if ![string compare $DBGPos end] {
	if [string match {} $foo] return
	set DBGPos [expr [llength $rng] - 1]
    }
    incr DBGPos $inc
    if {$DBGPos <= 0} { set DBGPos end }
    if {$DBGPos >= [llength $rng]} { set DBGPos 1 }
    set idx [lindex [split $foo .] 0]
    $ent insert insert [.@dbgctl.bdydbg.txt get $idx.2 "$idx.0 lineend"]
}
#
proc zDbgDo {} {
    global DBGPos zscr
    set w .@dbgctl.bdydbg
    set cmd [$w.entry get]
    catch {uplevel #0 $cmd} msg
    $w.txt configure -state normal
    $w.txt insert end {% }
    $w.txt insert end $cmd input
    $w.txt insert end "\n"
     if ![string match {} $msg] { $w.txt insert end "$msg\n" output }
    $w.txt configure -state disabled
    if $zscr(dbg) { $w.txt see end }
    $w.entry delete 0 end
    set DBGPos end
}
#
proc zError {msg cmd prefix param rest} {
    global errorInfo tk_patchLevel zircon tcl_platform
    set file [file join $zircon(tmp) zirc[pid]]
    set foo [open $file a]
    puts $foo "------Error: zircon $zircon(version) $zircon(patchlevel) tcl [info patchlevel] tk $tk_patchLevel [version]"
    catch {puts $foo [array get tcl_platform]}
    puts $foo "Message: $msg"
    puts $foo "Processing: $prefix $cmd $rest :$param"
    puts $foo $errorInfo
    close $foo
    set msg  "Zircon has detected an internal error \"$msg\" when processing\
      \"$cmd\" from \"$prefix\" ($param $rest). The stack trace has\
      been saved in file \"$file\". Please send this information to\
      zircon@catless.ncl.ac.uk."
    if [string match {7.[67]} [info tclversion]] {
	tk_messageBox -icon error -title {Internal Error} -message $msg -type ok
    } {
	mkInfoBox ZERROR .@zrun {Internal Error} $msg
    }
}
#
proc tkerror {err} { zError $err INTERNAL {} {} {} }
#
proc bgerror {err} { zError $err INTERNAL {} {} {} }
#
proc zIn {line} {
    global current zscr DBStamp
    set net $current(net)
    if ![$net monitorIn] return
    set w .@dbgctl.bdy$net
    $w.txt configure -state normal
    if $DBStamp($net) { $w.txt insert end [clock format [clock seconds]] }
    $w.txt insert end ">$line" input "\n"
    $w.txt configure -state disabled
    if $zscr($net) { $w.txt see end }
    update idletasks
}
#
proc zOut {line} {
    global current zscr DBStamp
    set net $current(net)
    if ![$net monitorOut] return
    set w .@dbgctl.bdy$net
    $w.txt configure -state normal
    if $DBStamp($net) { $w.txt insert end [clock format [clock seconds]] }
    $w.txt insert end "<$line" output "\n"
    $w.txt configure -state disabled
    if $zscr($net) { $w.txt see end }
    update idletasks
}
#
proc zDump {file} {
    set fd [open $file w]
    foreach _x [lsort [info globals]] {
	global $_x
	if [string match auto_* $_x] continue
	if [array exists $_x] {
	    foreach _v [lsort [array names $_x]] {
		puts $fd "${_x}($_v) : {[set ${_x}($_v)]}"
	    }
	} {
	    puts $fd "$_x : {[set $_x]}"
	}
    }
    close $fd
}
#
proc dbg_net_send {this op args} {
    upvar #0 $this ndata
    if ![string match {} $ndata(sock)] {
	set msg $op
	if ![string match {} [set last :[lindex $args end]]] {
	    if ![catch {set foo [lreplace $args end end]}] {
		append msg " $foo $last"
	    }
	}
	zOut $msg
	if [catch {ircsend $ndata(sock) $msg}] { $this close }
    }
}
#
proc dbg_net_qSend {this op args} {
    upvar #0 $this ndata
    set msg "$op [join $args]"
    zOut $msg
    if [catch {ircsend $ndata(sock) $msg}] { $this close }
}
#
proc dbg_net_q1Send {this op} {
    upvar #0 $this ndata
    zOut $op
    if [catch {ircsend $ndata(sock) $op}] { $this close }
}
#
proc dbg_connect {host port} {
    zOut "**** Connecting to $host:$port"
    if [catch {nrm_connect $host $port} msg] {
	if $monitorOut { zOut "**** Connect error - $msg" }
	error $msg
    }
    return $msg
}
#
proc zDCSave {net txt} {
    global ztrans $net
    mkFileBox .@sdb$net ${net}(sdbg) .* {Save Log} \
      "File:" {} "$ztrans(append) {zSOpen $net $txt a}"\
      "$ztrans(save) {zSOpen $net $txt w}" "$ztrans(cancel) {}"
}
#
proc zSOpen {net txt mode file} {
    if [string match {} $file] {return 0}
    if [string compare [file path $file] absolute] {
	set file [file join [pwd] $file]
    }
    if [catch {open $file $mode} fd] {
	$net errmsg "Cannot open file $file : $fd"
	return 0
    }
    puts $fd [$txt get 1.0 end]
    close $fd
}
#
proc zCtlQuit {} { destroy .@dbgctl }
#
proc zDBGRet {net} {
    if [winfo exists .@dbgctl] {
	set ctl .@dbgctl.exp$net
	$ctl.ttl.title configure -text "Trace of [$net host]" 
    }
}
#
proc zDBGCsw {ctl net title tr ent} {
    global zcr zDIOff
    set f [frame $ctl.exp$net]
    set zcr($f) 1
    pack [frame $f.ttl -borderwidth 0] -fill x
    pack [button $f.ttl.ctl -image $zDIOff -command "zDBExp $ctl $net"] -side left
    pack [label $f.ttl.title -text $title] -fill x \
      -side left -padx 10
    set f [frame $ctl.bdy$net -borderwidth 0]
    zDBRegion $f $tr $net $ent
    pack $ctl.exp$net -fill x
}
#
proc zDBIn {net} {
    if [$net monitorIn] {
	.@dbgctl.bdy$net.f3.tracein configure -text "Show In"
	set x 0
    } {
	.@dbgctl.bdy$net.f3.tracein configure -text "Hide In"
	set x 1
    }
    $net configure -monitorIn $x
}
#
proc zDBOut {net} {
    if [$net monitorOut] {
	.@dbgctl.bdy$net.f3.traceout configure -text "Show Out"
	set x 0
    } {
	.@dbgctl.bdy$net.f3.traceout configure -text "Hide Out"
	set x 1
    }
    $net configure -monitorOut $x
}
#
proc zDBStamp {net} {
    global DBStamp
    if $DBStamp($net) {
	.@dbgctl.bdy$net.f3.tstamp configure -text {Timestamp}
	set x 0
    } {
	.@dbgctl.bdy$net.f3.tstamp configure -text {No Time}
	set x 1
    }
    set DBStamp($net) $x
}
#
proc zNScroll {net} {
    global zscr ztrans
    if $zscr($net) {
	set zscr($net) 0
	.@dbgctl.bdy$net.f3.noscroll configure -text $ztrans(scroll)
    } {
	set zscr($net) 1
	.@dbgctl.bdy$net.f3.noscroll configure -text {No Scroll}
    }
}
#
if [string match {7.[567]} [info tclversion]] {
#
proc zDBGControl {} {
    global ztrans zscr znetList zircon zlayout
    if [winfo exists .@dbgctl] { popup .@dbgctl ; return }
    toplevel [set ctl .@dbgctl] -class Zircon
    wm title $ctl "Zircon Debugger"
    wm resizable $ctl 1 1
    set f [frame $ctl.btn]
    button $f.close -text $ztrans(dismiss) -command zCtlQuit -width 8
    button $f.dump -text $ztrans(dump) -width 8 -command "zDump /tmp/zircon.dump"
    button $f.kill -text $ztrans(kill) -width 8 -command  zKill
    button $f.srv -text $ztrans(server) -width 8 -command "DebugServer $f.srv"
    pack $f.close $f.dump $f.kill $f.srv -expand 1 -side left
    pack $f -fill x
    pack [frame $ctl.l1 -background $zircon(sepColor) -borderwidth 2] -fill x -pady 4
    zDBGCsw $ctl dbg {Command Interpreter} 0 1
    foreach x $znetList {
	pack [frame $ctl.l$x -background $zircon(sepColor) -borderwidth 2] -fill x -pady 4
	zDBGCsw $ctl $x "Trace of [$x host]" 1 0
    }
    catch {wm geometry $ctl $zlayout(default,debug)}
    foreach x [info procs dbg_*] {
	set n [string range $x 4 end]
	rename $n nrm_$n
	rename $x $n
    }
    bind $ctl <Destroy> {
	foreach x [info procs nrm_*] {
	    set n [string range $x 4 end]
	    rename $n dbg_$n
	    rename $x $n
	}
	catch {uplevel #0 unset zscr}
    }
}
#
proc zDBRegion {f tr net ent} {
    global ztrans zscr
    set zscr($net) 1
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight
    grid [frame $f.f3 -borderwidth 0] -column 2 -rowspan 2 -row 0 -sticky ns
    zDBGText $f
    if $tr {
	set x Show
	if [$net monitorIn] { set x Hide }
	button $f.f3.tracein -text "$x In" -width 8 \
	  -command "zDBIn $net" -foreground red
	set x Show
	if [$net monitorOut] { set x Hide }
	button $f.f3.traceout -text "$x Out" -width 8 \
	  -command "zDBOut $net" -foreground blue
	button $f.f3.tstamp -text "Timestamp" -width 8 -command "zDBStamp $net"
	uplevel #0 set DBStamp($net) 0
	pack $f.f3.tracein $f.f3.traceout $f.f3.tstamp
    }
    button $f.f3.save -text $ztrans(save) -width 8 -command "zDCSave $net $f.txt"
    button $f.f3.clear -text $ztrans(clear) -width 8 -command "zWClear $f.txt"
    button $f.f3.noscroll -text {No Scroll} -width 8 -command "zNScroll $net"
    pack $f.f3.save $f.f3.clear $f.f3.noscroll
    if $ent {
	emacsEntry $f.entry -relief sunken
	grid $f.entry -row 2 -columnspan 3 -column 0 -sticky ew
	bind $f.entry <Return> zDbgDo
	bind $f.entry <Control-p> "zDbgHist 2 %W"
	bind $f.entry <Up> [bind $f.entry <Control-p>]
	bind $f.entry <Control-n> "zDbgHist -2 %W"
	bind $f.entry <Down> [bind $f.entry <Control-n>]
	bind $f <Enter> "focus $f.entry"
    }
}
#
proc zDBGText {f} {
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 0 -weight 1
    scrollbar $f.vs -command "$f.txt yview"
    scrollbar $f.hs -command "$f.txt xview" -orient horizontal
    text $f.txt -yscrollcommand "$f.vs set" -xscrollcommand "$f.hs set" \
      -state disabled -takefocus 0 -height 10 -width 40
    bindtags $f.txt ROText
    $f.txt tag configure input -foreground red
    $f.txt tag configure output -foreground blue
    grid $f.txt -row 0 -column 0 -sticky nsew
    grid $f.vs -row 0 -column 1 -sticky ns
    grid $f.hs -row 1 -column 0 -sticky ew
}
#
proc zDBExp {ctl net} {
    global zDIOff zDIOn
    set w $ctl.exp$net
    if [string compare [$w.ttl.ctl cget -image] $zDIOff] {
	$w.ttl.ctl configure -image $zDIOff
	pack forget $ctl.bdy$net
    } {
	$w.ttl.ctl configure -image $zDIOn
	pack $ctl.bdy$net -fill both -expand 1 -after $ctl.exp$net
    }
}
#
} {
#
proc zDBGControl {} {
    tellInfo {Debugging} {You must run tcl7.5/tk4.1 or later to use the debugger}
}
#
}
