#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/errors.tcl,v $
# $Date: 1996/09/16 11:59:16 $
# $Revision: 1.17.1.9 $
#
proc irc401 {net prefix param pargs} {
    if [regexp -nocase {^zirconbot$} [set chan [lindex $pargs 1]]] return
    if [[set this [Message :: find $chan]] active] {
	$this addText @ERROR "*** $chan is not on IRC"
    } {
	$net errmsg "$param - $chan"
    }
    if [string compare nil [set usr [User :: find $chan]]] {
	upvar #0 Offer$net Offer
	catch {
	    foreach v $Offer($usr) { killDel Offer$net $usr [lindex $v 1] }
	} msg
    }
}

proc irc404 {net prefix param pargs} {
    if [[set this [Channel :: find [set chan [lindex $pargs 1]]]] active] {
	$this addText @ERROR "*** $param"
    } {
	$net errmsg "Cannot send to channel $chan"
    }
}

proc irc406 {net prefix param pargs} {
    global whois
    set whois($net,err) [lindex $pargs 1]
}

proc resetNick {net} {
    entrySet [[$net control] window].nSFrm.nickname.entry [$net nickname]
}

proc irc432 {net prefix param pargs} {
    resetNick $net
    tellError {Nickname Error} "[lindex $pargs 1] : $param"
}
#
proc irc433 {net prefix param pargs} {
    cantUseNick $net $prefix $param $pargs {in use}
}
#
proc irc437 {net prefix param pargs} {
    if ![string match {[#&+]*} [set nm [lindex $pargs 1]]] {
	cantUseNick $net $prefix $param $pargs {temporarily unavailable}
    } {
	tellError {Channel Error} "$nm : $param"
    }
}
#
proc tryNick {net nk} {
    $net NICK $nk
    $net configure -nickname $nk
}
#
proc cantUseNick {net prefix param pargs msg} {
    set unk [lindex $pargs 1]
    if [$net startup] {
	global user ztrans
	$net fast
	set nk $user
	foreach x [$net nicks] {
	    if [string compare $param $x] { set nk $x ; break }
	}
	mkDialog SERROR {} {Nick in use} \
	  "The nickname \"$unk\" is $msg. Try another." \
	  [list [list $ztrans(nickname) $nk [$net nicks]]] \
	  "$ztrans(ok) {tryNick $net}" "$ztrans(cancel) {$net close}"
    } {
	resetNick $net
	tellError {Nickname Error} "$unk : $param"
    }
}
#
proc irc442 {net prefix param pargs} {
    if [[set ch [Channel :: find [set nm [lindex $pargs 1]]]] active] {
	$ch delete
    } {
	tellError {Channel Error} "$nm $param [lindex $pargs 2]"
    }
}

proc irc443 {net prefix param pargs} {
    set who [lindex $pargs 1]
    if [[set ch [Channel :: find [set cn [lindex $pargs 2]]]] active] {
	$ch addText @ERROR "*** $who $param $cn"
    } {
	tellError {Invite Error} "$who $param $cn"
    }
}

proc irc471 {net prefix param pargs} {
    global ztrans
    set chn [Channel :: find [set chan [lindex $pargs 1]]]
    if [tk_dialog .@f$net {Channel Full} "Channel ${chan} is full!" \
      error 0 OK {Try Again}] {$chn sendJoin}
}

proc irc473 {net prefix param pargs} {
    if [[set ch [Channel :: find [lindex $pargs 1]]] active] {
	$ch addText @ERROR "*** \007Channel is invitation only!"
    } {
	tellError {Invitation Only} "Channel [lindex $pargs 1] is invitation only!"
    }
}
#
proc irc474 {net prefix param pargs} {
    if [[set ch [Channel :: find [lindex $pargs 1]]] active] {
	$ch flag disabled
	$ch addText @ERROR "*** \007You are banned from this channel!"
    } {
	tellError Banned "You are banned from channel [lindex $pargs 1]!"
    }
}

proc irc475 {net prefix param pargs} {
    global ztrans
    if {[[set chn [Channel :: find [set chan [lindex $pargs 1]]]] key] == {}} {
	mkEntryBox .@key$net $ztrans(key) "Enter key for channel $chan:" \
	  "{$ztrans(key) {}}" "$ztrans(join) {$chn sendJoin}" \
	  "$ztrans(cancel) {}"
    } {
	mkDialog {} .@key$net "Bad Key" \
	  "Bad key for channel $chan!" [list [list Key [$chn key]]] \
	  "{Try Again} {$chn sendJoin}" "$ztrans(cancel) {}"
    }
}



