#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/servers.tcl,v $
# $Date: 1996/08/28 08:06:40 $
# $Revision: 1.17.1.11 $
#
#
#  Server Operations
#
proc sendStats {net srv param var win} {
    global $var
    if ![string match {} $param] {
	set val $param
    } {
	set val [set ${var}($win)]
    }
    $net STATS $val $srv
    unset ${var}($win)
}
#
proc serverCmd {net cmd} {
    global zircon ztrans
    set srv [[set hst [$net hostid]] host]
    set def "(Default host is $srv)"
    switch $cmd {
    Oper {
	    set opStuff [$hst oper]
	    set nk [lindex $opStuff 0]
	    set pw [lindex $opStuff 1]
	    mkEntryBox .@oper Oper {Enter name and password:} \
	      "{Name [expr {$nk == {} ? [[$net myid] name] : $nk}]} \
	      {$ztrans(password) $pw}" "$ztrans(ok) {$net OPER}" \
	      "$ztrans(cancel) {}"
	}
    Rehash -
    Restart {
    	    set ucmd [string toupper $cmd]
	    mkDialog $ucmd .@$cmd $cmd "Really $cmd $srv?" \
	      {} "$ztrans(ok) {$net q1Send $ucmd}" "$ztrans(cancel) {}"
	}
    Stats {
	    if [string match 2.9* [$net sVersion]] {
		set ops {c d h k i l L m o t u y z}
		set dfl d
	    } {
		set ops {c h k i l L m o t u y z}
		set dfl c
	    }
	    mkRadioBox .@Stats Stats "Enter Stats parameters $def:" \
	    $ops $dfl "{$ztrans(server) {}} {$ztrans(parameter) {}}" \
	    "$ztrans(ok) {sendStats $net}" "$ztrans(cancel) {}"
	}
    Links {
	    global linksInfo
	    set linksInfo($net) {}
	    mkEntryBox {} Links "Enter Links parameters $def:" \
	      "{$ztrans(server) {}} {Mask {}}" \
	      "$ztrans(ok) {$net LINKS}" "$ztrans(cancel) {}"
	}
    Connect {
	    mkEntryBox {} Connect "Enter Connect parameters $def:" \
	      "{$ztrans(server) {}} {$ztrans(port) {}} {Remote {}}" \
	      "$ztrans(ok) {$net CONNECT}" "$ztrans(cancel) {}"
	}
    Info {
	    global infoInfo
	    set infoInfo($net) {}
	    mkEntryBox {} Info "Enter Server name $def:" \
	      "{$ztrans(server) {}}" "$ztrans(ok) {$net nsend INFO}" \
	      "$ztrans(cancel) {}"
	}
    Squit {
	    mkEntryBox {} Squit "Enter Server name :" \
	      "{$ztrans(server) {}}" "$ztrans(ok) {doSquit $net}" \
	      "$ztrans(cancel) {}"
	}
    Trace {
	    mkEntryBox {} Trace "Enter server name $def:" \
	      "{$ztrans(server) {}}" "$ztrans(ok) {$net nsend TRACE}" \
	      "$ztrans(cancel) {}"
	}
    Motd {
	    mkEntryBox {} MOTD "Enter server name $def:" \
	      "{Server {}}" "$ztrans(ok) {$net nsend MOTD}" \
	      "$ztrans(cancel) {}"
	}
    default {
	    set ucmd [string toupper $cmd]
	    mkEntryBox {} $cmd "Enter server pattern $def:" \
	      "{$ztrans(server) {}}" \
	      "$ztrans(ok) {$net nsend $ucmd}" "$ztrans(cancel) {}"
	}
    }
}
#
proc doSquit {net srv} {
    if ![string match {} $srv] {
	global ztrans
	set w .@[newName squit]
	mkDialog SQUIT $w Squit "Really Squit server \"$srv\"?" \
	  {} "$ztrans(ok) {$net qSend SQUIT :$srv}" "$ztrans(cancel) {}"
	tkwait window $w ;# This seems to be needed...
    }
}
#
proc kill {net who} {
    global ztrans
    mkDialog {} .@[newName kill] Kill "Really kill $who?" \
      "{$ztrans(message) {}}" "$ztrans(ok) {doKill $net $who}" \
      "$ztrans(cancel) {}"
}
#
proc doKill {net nk msg} {if ![string match {} $nk] { $net KILL $nk $msg }}
#
proc userKill {net} {
    global ztrans
    mkEntryBox {} "Kill" {Enter user name and message:} \
      "{$ztrans(user) {}} {$ztrans(message) {}}" \
      "$ztrans(ok) {doKill $net}" "$ztrans(cancel) {}"
}
#
proc irc200 {net prefix param pargs} {
    tracewin t $net $prefix $param $pargs [lindex $pargs 3]
}
proc irc201 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc202 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc203 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc204 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc205 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc206 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc207 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc208 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc209 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc210 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc261 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }
proc irc262 {net prefix param pargs} { tracewin t $net $prefix $param $pargs }

#
proc irc211 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc212 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc213 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc214 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc215 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc216 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc217 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc218 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc219 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc241 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc242 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc243 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc244 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc245 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc246 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc248 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
proc irc249 {net prefix param pargs} { tracewin s $net $prefix $param $pargs }
#
proc tracewin {op net prefix param pargs args} {
    set prefix [string range $prefix 1 end]
    if ![string match {} $args] {
	set tsite [lindex $args 0]
    } {
	set tsite $prefix
    }
    switch -exact -- $op {
    t	{ set var twin ; set type Trace}
    s	{ set var swin ; set type Stats}
    }
    upvar #0 $var wstat
    if ![info exists wstat($tsite)] {
	global ztrans
	set w [toplevel .@[newName trace] -class Zircon]
	wm resizable $w 1 1
	wm protocol $w WM_DELETE_WINDOW "destroy $w ; unset ${var}($tsite)"
	wm title $w "$type for $tsite"
	set f [frame $w.f1]
	scrollbar $f.vs -command "$f.txt yview"
        text $f.txt -yscrollcommand "$f.vs set" -width 80 -height 10 \
	  -takefocus 0
	bindtags $f.txt ROText
	pack $f.vs -side right -fill y
	pack $f.txt -fill both -expand 1 -side left
	pack $f -fill both -expand 1
	pack [frame $w.f2] -fill x
	pack [button $w.f2.xit -text Dismiss -command "destroy $w ; \
	   unset ${var}($tsite)" -width 10] -expand 1 -side left
	pack [button $w.f2.trc -text [trans $type] \
	  -command "$net qSend $type :$tsite" \
	  -width 10] -expand 1 -side left
	$f.txt insert end "[getDate]\n"
	set wstat($tsite) $w
    } {
	set w $wstat($tsite)
    }
    $w.f1.txt insert end "$prefix :   "
    foreach a [lrange $pargs 1 end] {
	if ![string match {} $a] {$w.f1.txt insert end " $a"}
    }
    if ![string match {} $param] {$w.f1.txt insert end " $param"}
    $w.f1.txt insert end "\n"
}
#
proc irc219 {net prefix param pargs} { }
#
proc irc364 {net prefix param pargs} {
    global linksInfo
    append linksInfo($net) "[lindex $pargs 1] [lindex $pargs 2] ${param}\n"
}
#
proc irc365 {net prefix param pargs} {
    global linksInfo
    if ![info exists linksInfo($net)] { set linksInfo($net) {No Links} }
    set w .@[newName links]
    mkInfoBox LINKS $w "[string range $prefix 1 end] Links [getDate]" $linksInfo($net)
    unset linksInfo($net)
}
#
proc irc371 {net prefix param pargs} {
    global infoInfo
    append infoInfo($net) "${param}\n"
}
#
proc irc374 {net prefix param pargs} {
    global infoInfo
    set w .@[newName info]
    mkInfoBox INFO $w "[string range $prefix 1 end] Info [getDate]" $infoInfo($net)
    unset infoInfo($net)
}
