/* kppp_logger.cpp
*
*	Copyright (C) Erik Ljungstrm (insight@metalab.unc.edu) 2002-01-09 SWEDEN
*	 
*	The main code, starts and ends logging dependent on wheter pppdead (see pppdead.cpp)
*	has been executed. Also handles the managing of the log(s) and such things.
*   
*	See the file CREDITS to see other people somehow involved in this program.
*
*	QOTR (Quote of the release)
*
*	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*	*		"I know not with what weapons World War III will be fought, but World *
*	*		War IV will be fought with sticks and stones."			      *
*	*				-- Albert Einstein	         		      *
*	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*/

#include "general.h"
#include "kppp_logger.h"


void readlog ();
void dellog ();
void restore_log ();
void savelog (bool ow);
void Usage (char *progname);

char *wdir= getenv("HOME");
string workingDir = wdir, online = workingDir + "/.kppp_logger/online.log", onlineSave = workingDir + "/.kppp_logger/online.log.save" ;
string totalOnline = workingDir + "/.kppp_logger/total.log";
int
main (int argc, char *argv[]) 
{
  /*if (getuid () != 0)   OLD STUFF
    {
      sound ();
      leave (error,
	     "You must be root in order to use kppp_logger. Please get uid 0 and try again..",
	     no_files_open);
    }
 */

		if (wdir == 0){
				cerr << "Your HOME variable is not set. Try export HOME=/home/yourhome" << endl;
				exit(error);
		}
					
  if (argc != 2)
    {
      cout << "kppp_logger: Invalid option " << argv[1] << endl;
      leave (error, "Usage: kppp_logger [--help] [option]", no_files_open);
    }

  /*
    The -c and --connect option shouldn't be used by the end user.
    Only called direclty from kppp_logger
   */
  if (strcmp (argv[1], "-c") == 0) 
    dial ();
  else if (strcmp (argv[1], "--contact") == 0)
    leave (clean, "Comments/Bug reports/questions is warmly welcomed to insight@metalab.unc.edu", no_files_open);
   else if (strcmp (argv[1], "-ss") == 0)
    {
      savelog (overwrite);
    }
  else if (strcmp (argv[1], "-v") == 0)
    leave (clean, version, no_files_open);
  else if (strcmp (argv[1], "--restore") == 0)
    restore_log ();
  else if (strcmp (argv[1], "--version") == 0)
    leave (clean, version, no_files_open);
	else if (strcmp(argv[1], "--total")==0)
			totOnline();
  else if (strcmp (argv[1], "-r") == 0)
    readlog ();
  else if (strcmp (argv[1], "-s") == 0)
    savelog (keep);
  else if (strcmp (argv[1], "-h") == 0)
	  Usage (argv[0]);
  else if (strcmp (argv[1], "-d") == 0)
    dellog ();
  else if (strcmp (argv[1], "--author") == 0)
    leave (clean, "kppp_logger is written and maintained by \n\tErik Ljungstrm", no_files_open);
  else if (strcmp (argv[1], "--help") == 0)
    Usage (argv[0]);
  else
    {
	  cout << "kppp_logger: Invalid option " << argv[1] << endl;
      leave (clean, "Usage:  [--help] [option]", no_files_open);
    }
  /* In order to be entirelty correct, main must return an integer. */
  return (clean);
}

void sound ()
{
  cout << "\a\a";
}




void
dellog ()
{
  if (e.filex (online_log, true) == FILE_MISSING)
    {
      sound ();
      leave (error, "There was nothing to remove.", no_files_open);
    }
  else
    {
        /* 
        Is a warning apporpriate here ? I'm split minded here,
        warnings concerning this kind of stuff is quite 
        Windowsish.. but removing the log is a serious thing.
        Mail me with comments/suggestions.
      */
      const char *apa = online.c_str();
			remove (apa);
      leave (clean, "Removed online.log", no_files_open);
    }
}		




/* Heavy error handler, huh? */
int
errorhandler (char *reason)
{
  sound ();
	// Sorry all non GNU users :/
  fcloseall ();
  cin.clear ();
  cout << reason << endl;
  exit (error);
  return (clean);

}

void
restore_log ()
{
  if (e.filex (online_save, false) == FILE_MISSING)
    {
      sound ();
				/* I know this is lazy, but converting strings into chars just for this purpose
				 * feels a bit too classy in parity to the purpose.. */
			cerr << "Could not find " << onlineSave << endl;
      leave (error, "void", no_files_open);
    }
        if (e.filex (online_log, false) == FILE_EXISTS)
					remove (online.c_str());
      char records;
      ofstream WriteTo (online.c_str(), ios::app);
      ifstream ReadFrom (onlineSave.c_str(), ios::binary);
      while (ReadFrom.read ((char *) &records, sizeof (char)))
					WriteTo << records;
					leave (clean, "online.log restored from online.log.save", files_open);
  
}

void
leave (int excode, char lmsg[], bool ofile)
{

  if (!strstr (lmsg, "void"))
    cout << lmsg << endl;

  if (ofile == files_open)
    {
      fcloseall ();
      exit (excode);
    }
  else
    exit (excode);
}				/* Leave */

/* p00f */
