/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __3WAY_HPP__
#define __3WAY_HPP__

#include <string.h>

#include "globals.hpp"
#include "block.hpp"

#define THREEWAYROUNDS 11

class SCL_API C3WayKey : public CBlockKey
{
	public:
		enum { KEYSIZE = 12 };

	public:
		C3WayKey();
		C3WayKey(const C3WayKey &);
		C3WayKey(Word, Word, Word);
		C3WayKey(const Byte *, Word = KEYSIZE);
		virtual ~C3WayKey();

	public:
		Word GetMaster(Word i) const { return wMaster[i]; };
		Word GetKey(Word i) const { return wKey[i]; };

	public:
		virtual Word GetKeySize() { return KEYSIZE; };

	private:
		void MakeKeys();

	private:
		Word wMaster[6];
		Word wKey[THREEWAYROUNDS * 2 + 2];
};

class SCL_API C3WayBlock : public CBlockObject
{
	public:
		enum { BLOCKSIZE = 12 };

	public:
		C3WayBlock();
		C3WayBlock(const C3WayBlock &);
		C3WayBlock(Word, Word, Word);
		C3WayBlock(const Byte *, Word = BLOCKSIZE);
		virtual ~C3WayBlock();

	public:
		virtual void Encrypt(const CBlockKey &cKey) { Encrypt((const C3WayKey &)cKey); };
		virtual void Decrypt(const CBlockKey &cKey) { Decrypt((const C3WayKey &)cKey); };
		virtual void SetData(const Byte *, Word = BLOCKSIZE);
		virtual Byte *GetData();
		virtual Word GetBlockSize() { return BLOCKSIZE; };

	public:
		void Encrypt(const C3WayKey &);
		void Decrypt(const C3WayKey &);
		void SetData(Word, Word, Word);
		Word GetData(Word);

	private:
		void Crypt(const C3WayKey &, bool);
	
	private:
		Word wData[3];
		Word wResult[3];
};

#endif // __3WAY_HPP__
